# Build Intructions for ParaView Async

## Initialize repository
```
git clone git@gitlab.kitware.com:async/paraview.git
cd paraview
git submodule update --init --recursive
cd -
```

## Setup mochi-thallium

### Setup spack
```
git clone https://github.com/spack/spack.git
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
```

### Mochi-thallium
```
git clone https://github.com/mochi-hpc/mochi-spack-packages.git
spack repo add mochi-spack-packages
spack install mochi-thallium@develop^libfabric fabrics=tcp,rxm,sockets
```
If there are issues with `libfabric` on other platforms try with `fabrics=sockets`.

## Setup FFMPEG
Chances are you may already have ffmpeg installed on your system.
If you don't, download binary tarballs from https://www.ffmpeg.org/download.html
and set `FFMPEG_ROOT` to the extracted ffmpeg root.

### Ubuntu:
```
sudo apt install libavformat-dev libavcodec-dev libavutil-dev libswscale-dev libswresample-dev libvpx-dev
```

### Hardware Acceleration on linux:

**You need root access for this step. Without this step, vaapi encoder will fail to initialize.**
1. Make sure you have an intel integrated graphics card with `intel-media-va-driver` and `libva2` installed. You can get these from the distro package manager.
2. Go to vtkPVView.cxx, in the `vtkPVView::vtkInternals` class, change the Encoder member type to use `vtkFFMPEGVaapiEncoder` instead of `vtkFFMPEGSoftwareEncoder`.
3. Configure intel driver for hardware encoding.
    Why this is needed? See [1](https://www.intel.com/content/www/us/en/support/articles/000089952/software/iot-software.html) and [2](https://01.org/linuxgraphics/downloads/firmware)
    ```bash
    $ echo 'options i915 enable_guc=2' | sudo tee -a /etc/modprobe.d/i915.conf
    $ sudo update-initramfs -u
    ```
    Reboot after updating the kernel image.


## Build
```
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
spack load mochi-thallium

cmake -G Ninja \
    -S ./paraview \
    -B ./build \
    -D PARAVIEW_BUILD_TESTING=WANT \
    -D PARAVIEW_USE_PYTHON=ON
```

### Extras

For python support add `-DPARAVIEW_USE_PYTHON=ON ` .

For raytracing [get](https://github.com/ospray/ospray/releases/tag/v2.9.0) ospray binaries and set
`-DPARAVIEW_ENABLE_RAYTRACING=ON` and  `-Dospray_DIR` to the appropriate location. For Linux  it
is  `-Dospray_DIR="<extracted location>/ospray-2.9.0.x86_64.linux/lib/cmake/ospray-2.9.0"`.
When running any application utilizing raytracing you may need to update the library path. For Linux:
`export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:<extracted location>/ospray-2.9.0.x86_64.linux/lib/`
