/*=========================================================================

  Program:   ParaView
  Module:    vtkSMProperty.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef vtkSMPropertyTypes_h
#define vtkSMPropertyTypes_h
#include "vtkRemotingServerManagerCoreModule.h"

#include <string>

class VTKREMOTINGSERVERMANAGERCORE_EXPORT vtkSMPropertyTypes
{
public:
  enum PropertyTypes
  {
    INVALID,
    INT,
    DOUBLE,
    ID_TYPE,
    STRING,
    PROXY,
    INPUT
  };
  //---------------------------------------------------------------------------
  static int GetPropertyType(const std::string& className)
  {
    if (className == "vtkSMIntVectorProperty")
    {
      return INT;
    }
    if (className == "vtkSMDoubleVectorProperty")
    {
      return DOUBLE;
    }
    if (className == "vtkSMIdTypeVectorProperty")
    {
      return ID_TYPE;
    }
    if (className == "vtkSMStringVectorProperty")
    {
      return STRING;
    }
    if (className == "vtkSMProxyProperty")
    {
      return PROXY;
    }
    if (className == "vtkSMInputProperty")
    {
      return INPUT;
    }

    return INVALID;
  }
};

#endif
