import asyncio
from timeit import default_timer as timer
import vtk

import paraview.modules.vtkRemotingPythonAsyncCore as asyncCore
import parat.utils
import paraview.servermanager as sm


async def main():
    await sm.initialize()

    s = sm.sources.SphereSource()
    s.ThetaResolution = 800
    s.PhiResolution = 800
    s.UpdateVTKObjects()

    print(sm.sources.getDocumentation("SphereSource"))

    # test that ProxyDefinition iterator works
    print(sm.sources.__dir__())

    shrink = sm.filters.ShrinkFilter(Input=sm.OutputPort(s, 0))
    shrink.UpdateVTKObjects()

    await shrink.UpdatePipeline()

    # if eveything works Sphere arrays should be passed throught the output
    poindata = shrink.GetPointDataInformation()
    assert poindata.values()
    assert "Normals" == poindata.values()[0].GetName()

    # example of a view
    # ------------------
    rep = sm.rendering.GeometryRepresentation()
    rep.Input = [shrink]
    rep.UpdateVTKObjects()

    # create a view
    rv = sm.CreateRenderView()
    rv.Representations = [rep]
    rv.UpdateVTKObjects()

    await rv.Update()

    renderWindow = rv.GetRenderWindow()
    iren = vtk.vtkRenderWindowInteractor()
    iren.SetRenderWindow(renderWindow)
    iren.Initialize()
    while not iren.GetDone():
        iren.ProcessEvents()
        await asyncio.sleep(0)
    sm.finalize()

asyncio.run(main())
