# Build Intructions for ParaView Async

## Initialize repository
```
git clone git@gitlab.kitware.com:async/paraview.git
cd paraview
git submodule update --init --recursive
cd -
```

## Setup mochi-thallium

### Setup spack
```
git clone https://github.com/spack/spack.git
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
```

### Mochi-thallium
```
git clone https://github.com/mochi-hpc/mochi-spack-packages.git
spack repo add mochi-spack-packages
spack install mochi-thallium@develop^libfabric fabrics=tcp,rxm,sockets
```
If there are issues with `libfabric` on other platforms try with `fabrics=sockets`.

## Build
```
export SPACK_ROOT=$PWD/spack
. ./spack/share/spack/setup-env.sh
spack load mochi-thallium

mkdir build
cmake -GNinja \
-DPARAVIEW_BUILD_TESTING=WANT \
-S ./paraview
-B ./build
```

### Extras

For python support add `-DPARAVIEW_USE_PYTHON=ON ` .

For raytracing [get](https://github.com/ospray/ospray/releases/tag/v2.9.0) ospray binaries and set
`-DPARAVIEW_ENABLE_RAYTRACING=ON` and  `-Dospray_DIR` to the appropriate location. For Linux  it
is  `-Dospray_DIR="<extracted location>/ospray-2.9.0.x86_64.linux/lib/cmake/ospray-2.9.0"`.
When running any application utilizing raytracing you may need to update the library path. For Linux:
`export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:<extracted location>/ospray-2.9.0.x86_64.linux/lib/`
