/*=========================================================================

  Program: ParaView
  Module:  SimpleQtAppMainWindow.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include <QMainWindow>

#include <memory> // for std::unique_ptr
class SimpleQtAppMainWindow : public QMainWindow
{
  Q_OBJECT;

public:
  SimpleQtAppMainWindow();
  ~SimpleQtAppMainWindow();

  void connect(const QString& url);

protected:
  ///@{
  /**
   * Overridden to save/restore window layout
   */
  void showEvent(QShowEvent* evt) override;
  void closeEvent(QCloseEvent* evt) override;
  ///@}

private:
  Q_DISABLE_COPY(SimpleQtAppMainWindow);

  class QInternals;
  std::unique_ptr<QInternals> Internals;
};
