import asyncio

from parat.services import ParaT, PipelineBuilder, PropertyManager
import vtk
import sys


async def main():
    App = ParaT()
    session = await App.initialize()

    builder = PipelineBuilder(session)

    wavelet = await builder.CreateProxy("sources", "RTAnalyticSource")

    contour = await builder.CreateProxy("filters", "Contour", Input=wavelet)

    pmanager = PropertyManager()
    # See all the available properties
    print(pmanager.GetValues(contour))

    pmanager.SetValues(
        contour,
        ContourValues=[
            37.35310363769531,
            63.961517333984375,
            90.56993103027344,
            117.1783447265625,
            143.78675842285156,
            170.39517211914062,
            197.0035858154297,
            223.61199951171875,
            250.2204132080078,
            276.8288269042969,
        ],
        SelectInputScalars=["", "", "", "", "RTData"],
        force_push=True,
    )

    view = await builder.CreateProxy("views", "RenderView")
    await builder.CreateRepresentation(contour, 0, view, "GeometryRepresentation")

    await pmanager.Update(view)
    view.ResetCameraUsingVisiblePropBounds()

    if "-I" in sys.argv:
        iren = vtk.vtkRenderWindowInteractor()
        iren.SetRenderWindow(view.GetRenderWindow())
        iren.Initialize()
        while not iren.GetDone():
            iren.ProcessEvents()
            await asyncio.sleep(0.01)
    else:
        for i in range(5):
            view.GetCamera().Azimuth(10)
            view.StillRender()
            await asyncio.sleep(0.1)


asyncio.run(main())
