
/*=========================================================================

  Program:   ParaView
  Module:    vtkSMViewProxyInternals.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkSMViewProxyInternals_h
#define vtkSMViewProxyInternals_h

#include <vtkBMPWriter.h>
#include <vtkBoundingBox.h>
#include <vtkCompressedVideoPacket.h>
#include <vtkOpenGLVideoFrame.h>
#include <vtkRenderWindow.h>
#include <vtkRenderer.h>
#include <vtkTextRepresentation.h>
#include <vtkVideoDecoder.h>
#include <vtkWEBMWriter.h>

#include <string>
#include <thread>

#include "vtk_rxcpp.h" // for rxcpp
// clang-format off
// ideally, we include rx-lite.hpp here.
#include VTK_REMOTING_RXCPP(rx.hpp)
// clang-format on

class vtkSMViewProxyInternals
{
public:
  const std::thread::id OwnerTID{ std::this_thread::get_id() };

  // The client window will have two layers.
  // Base layer contains the primary renderer that simply
  // draws the image we receive from the render service.
  // The second layer has two 2D renderers that display
  // interesting performance metrics as a key-value pair.
  // Two separate 2D renderers are used for a neat table-like appearance.
  //@{
  vtkSmartPointer<vtkRenderWindow> RenderWindow;
  vtkSmartPointer<vtkRenderer> Renderer;
  vtkSmartPointer<vtkTextRepresentation> AnnotationKeys;
  vtkSmartPointer<vtkTextRepresentation> AnnotationValues;
  vtkSmartPointer<vtkRenderer> Renderer2DForKeys;
  vtkSmartPointer<vtkRenderer> Renderer2DForValues;
  //@}

  // Use decoder when the render service is using a video codec and
  // the client wants the view to decode the bitstream.
  //@{
  bool NeedsVideoDecoder = false;
  vtkSmartPointer<vtkCompressedVideoPacket> CompressedFrame;
  vtkSmartPointer<vtkVideoDecoder> Decoder;
  vtkNew<vtkOpenGLVideoFrame> RawFrame;
  //@}

  // Stream the view output as bmp or webm, depends on render service codec type.
  //@{
  vtkNew<vtkWEBMWriter> WebmWriter;
  vtkNew<vtkBMPWriter> BitmapWriter;
  rxcpp::subjects::subject<vtkSmartPointer<vtkCompressedVideoPacket>> OutputStream;
  //@}

  // helps updating the server side camera.
  //@{
  vtkMTimeType LastCameraMTime{ 0 };
  bool InDrawOverlay{ false };
  //@}

  // keep track of the raytracing information so we can request for the next rendering pass
  //@{
  bool UsingRayTracing{ false };
  uint64_t RenderingPass{ 0 };
  uint64_t TotalRenderingPasses{ 0 };
  //@}

  // Keeps the render window interactor observers.
  //@{
  std::vector<unsigned long> InteractorObserverIds;
  unsigned long RenderWindowObserverId{ 0 };
  //@}

  vtkBoundingBox VisiblePropBounds;
  std::string DefaultRepresentationName;
};

#endif // vtkSMViewProxyInternals_h
// VTK-HeaderTest-Exclude: vtkSMViewProxyInternals.h
