
/*=========================================================================

  Program:   ParaView
  Module:    vtkPythonContextHelper.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkPythonContextHelper
 * @brief
 *
 */

#ifndef vtkPythonContextHelper_h
#define vtkPythonContextHelper_h

#include "vtkPython.h" // include first

#include "vtkObject.h"
#include "vtkRemotingPythonAsyncCoreModule.h" // for exports

#include <memory>

class vtkSMProxy;

class VTKREMOTINGPYTHONASYNCCORE_EXPORT vtkPythonContextHelper : public vtkObject
{
public:
  static vtkPythonContextHelper* New();
  vtkTypeMacro(vtkPythonContextHelper, vtkObject);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  void SetProxy(vtkSMProxy* proxy);

  PyObject* NewIterator();

  void Unsubscribe();

protected:
  vtkPythonContextHelper();
  ~vtkPythonContextHelper() override;

private:
  vtkPythonContextHelper(const vtkPythonContextHelper&) = delete;
  void operator=(const vtkPythonContextHelper&) = delete;

  class vtkInternals;
  std::unique_ptr<vtkInternals> Internals;
};
#endif
