import asyncio

from parat.pythonApplication import *
from parat.pipelineBuilder import *
from parat.propertyManager import *
import vtk


async def main():
    App = PythonApplication()
    session = await App.initialize()

    builder = PipelineBuilder(session)

    sphere = await builder.CreateSource(
        "sources", "SphereSource", ThetaResolution=80, Radius=2
    )
    shrink = await builder.CreateFilter(
        "filters", "ShrinkFilter", Input=sphere, ShrinkFactor=0.3
    )

    pmanager = PropertyManager()
    pmanager.SetPropertyValue(sphere, "Radius", 3)
    pmanager.SetPropertyValue(sphere, "Center", [1, 2, 3])
    pmanager.SetPropertyValue(sphere, "EndPhi", 90)

    await asyncio.sleep(0.1)

    view = await builder.CreateView("views", "RenderView")

    representation = await builder.CreateRepresentation(
        shrink, 0, view, "GeometryRepresentation"
    )

    await pmanager.Update(view)
    view.ResetCameraUsingVisiblePropBounds()

    iren = vtk.vtkRenderWindowInteractor()
    iren.SetRenderWindow(view.GetRenderWindow())
    iren.Initialize()
    while not iren.GetDone():
        iren.ProcessEvents()
        await asyncio.sleep(0.01)
        if iren.GetKeyCode() == "s":
            pmanager.SetVisibility(representation, view, True)
        if iren.GetKeyCode() == "h":
            pmanager.SetVisibility(representation, view, False)

    status = await builder.DeleteProxy(shrink)
    assert status == True

    await App.finalize()


asyncio.run(main())
