import asyncio

from parat.pythonApplication import *
from parat.pipelineBuilder import *
from parat.propertyManager import *


async def main():
    App = PythonApplication()
    session = await App.initialize()

    builder = PipelineBuilder(session)

    sphere = await builder.CreateSource(
        "sources", "SphereSource", ThetaResolution=80, Radius=2
    )
    shrink = await builder.CreateFilter(
        "filters", "ShrinkFilter", Input=sphere, ShrinkFactor=0.3
    )

    pmanager = PropertyManager()
    pmanager.SetPropertyValue(sphere, "Radius", 5)
    pmanager.SetPropertyValue(sphere, "Center", [1, 2, 3])
    pmanager.SetPropertyValue(sphere, "Center", (3, 4, 5))
    pmanager.SetProperties(sphere, {"StartPhi": 10, "EndPhi": 90, "PhiResolution": 80})

    assert pmanager.GetPropertyValue(sphere, "Center") == [3, 4, 5]
    assert pmanager.GetPropertyValue(sphere, "StartPhi") == 10

    await asyncio.sleep(0.1)

    status = await builder.DeleteProxy(sphere)
    assert status == False, "Cannot delete a proxy that has depedencies"

    status = await builder.DeleteProxy(shrink)
    assert status == True, "Could not delete shrink proxy"
    status = await builder.DeleteProxy(sphere)
    assert status == True, "Could not delete sphere source"

    await App.finalize()


asyncio.run(main())
