/*************************************************************************
 *                                                                       *
 * Vega FEM Simulation Library Version 4.0                               *
 *                                                                       *
 * "objMesh" library , Copyright (C) 2007 CMU, 2009 MIT, 2018 USC        *
 * All rights reserved.                                                  *
 *                                                                       *
 * Code authors: Yijing Li, Jernej Barbic                                *
 * http://www.jernejbarbic.com/vega                                      *
 *                                                                       *
 * Research: Jernej Barbic, Hongyi Xu, Yijing Li,                        *
 *           Danyong Zhao, Bohan Wang,                                   *
 *           Fun Shing Sin, Daniel Schroeder,                            *
 *           Doug L. James, Jovan Popovic                                *
 *                                                                       *
 * Funding: National Science Foundation, Link Foundation,                *
 *          Singapore-MIT GAMBIT Game Lab,                               *
 *          Zumberge Research and Innovation Fund at USC,                *
 *          Sloan Foundation, Okawa Foundation,                          *
 *          USC Annenberg Foundation                                     *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of the BSD-style license that is            *
 * included with this library in the file LICENSE.txt                    *
 *                                                                       *
 * This library is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the file     *
 * LICENSE.TXT for more details.                                         *
 *                                                                       *
 *************************************************************************/

#ifndef CREATEOBJMESH_H
#define CREATEOBJMESH_H

#include "objMesh.h"

namespace vega 
{

// create a cylinder without cap, centered at origin and axis at y-direction
// subdivisionAxis: #cut on the circle
// subdivisionHeight: #subdivision on the height direction
ObjMesh createCylinderWallObjMesh(double radius, double height, int subdivisionAxis, int subdivisionHeight);

// create a cylinder mesh centered at origin and axis at y-direction
ObjMesh createCylinderObjMesh(double radius, double height, int subdivisionAxis, int subdivisionHeight);

ObjMesh createBoundingBoxObjMesh(Vec3d bmin, Vec3d bmax);


} // namespace vega

#endif
