// #ifdef VEGA_USE_CGAL_HEADER

#include "er.h"
namespace vega
{
template <typename ER_>
// double ER_toDouble(const ER & er);
double ER_toDouble(const ER_ & er)
{
  // following code from libigl
  // FORCE evaluation of the exact type otherwise interval might be huge.
  const auto cgal = er.exact();
  const auto interval = CGAL::to_interval(cgal);
  double d = interval.first;
  do
  {
    const double next = nextafter(d, interval.second);
    if (CGAL::abs(cgal-d) < CGAL::abs(cgal-next))
      break;
    d = next;
  } while (d < interval.second);
  return d;
}
}
// #endif
