/***
 * @file FalconCLIBase.h
 * @brief Utility class for common operations (device opening, firmware loading, etc...) needed in command line interface examples
 * @author Kyle Machulis (kyle@nonpolynomial.com)
 * @copyright (c) 2007-2009 Nonpolynomial Labs/Kyle Machulis
 * @license BSD License
 *
 * Project info at http://libnifalcon.sourceforge.net/
 *
 */

#ifndef FALCONCLIBASE_H
#define FALCONCLIBASE_H

#include <boost/program_options.hpp>
#include <boost/shared_ptr.hpp>
#include "falcon/core/FalconDevice.h"
#include "falcon/core/FalconLogger.h"

namespace libnifalcon
{
	class FalconCLIBase
	{
	protected:
		boost::shared_ptr<FalconDevice> m_falconDevice;
		boost::program_options::options_description m_progOptions;
		boost::program_options::variables_map m_varMap;
		virtual void addOptions(int value);
		virtual bool parseOptions(int argc, char** argv);
		void outputProgramOptions();
		bool calibrateDevice();
		bool m_displayCalibrationMessage;
	public:
		FalconCLIBase();
		~FalconCLIBase()
		{
		}

		enum {
			DEVICE_OPTIONS = 0x1,
			COMM_OPTIONS = 0x2,
			FIRMWARE_OPTIONS = 0x4
		};
	private:
		DECLARE_LOGGER();


	};
}
#endif
