#!/usr/bin/env python

import sys, os, string, re, time

if len(sys.argv) == 3:
    name = sys.argv[1]
else:
    print 'Usage: bin2h [input file] [output file]'

bin_file = open(sys.argv[1], "rb")
out_file = open(sys.argv[2], "w")

out_file.write("/*\n")
out_file.write(" *\n")
out_file.write(" * Generated by %s\n" % sys.argv[0])
out_file.write(" * on %s\n" % time.ctime(time.time()))
out_file.write(" *\n")
out_file.write(" */\n")
    
t = name
t = re.sub('\..*$', '', t)
t = re.sub('[^a-zA-Z_0-9]', '_', t)
if re.search('^[^a-zA-Z_]', t):
    t = '_' + t
out_file.write('unsigned char %s[] = {' % t)


byte_count = 0
while 1:
    c = bin_file.read(1)
    if not c:
        break
    if (byte_count % 8) == 0:
        out_file.write('\n\t')
    out_file.write('0x%02x,' % ord(c))
    byte_count = byte_count + 1
bin_file.close()
out_file.write('\n};\n')
out_file.write('unsigned int %s_size = %d;\n' % (t, byte_count))
out_file.close()


sys.exit(0)
