namespace gli{
namespace detail
{
	enum
	{
		CAP_COMPRESSED_BIT = (1 << 0),
		CAP_COLORSPACE_SRGB_BIT = (1 << 1),
		CAP_NORMALIZED_BIT = (1 << 2),
		CAP_SCALED_BIT = (1 << 3),
		CAP_UNSIGNED_BIT = (1 << 4),
		CAP_SIGNED_BIT = (1 << 5),
		CAP_INTEGER_BIT = (1 << 6),
		CAP_FLOAT_BIT = (1 << 7),
		CAP_DEPTH_BIT = (1 << 8),
		CAP_STENCIL_BIT = (1 << 9),
		CAP_SWIZZLE_BIT = (1 << 10),
		CAP_LUMINANCE_ALPHA_BIT = (1 << 11),
		CAP_PACKED8_BIT = (1 << 12),
		CAP_PACKED16_BIT = (1 << 13),
		CAP_PACKED32_BIT = (1 << 14),
		CAP_DDS_GLI_EXT_BIT = (1 << 15)
	};

	struct formatInfo
	{
		std::uint8_t BlockSize;
		glm::u8vec3 BlockExtent;
		std::uint8_t Component;
		swizzles Swizzles;
		std::uint16_t Flags;
	};

	inline formatInfo const & get_format_info(format Format)
	{
		GLI_ASSERT(Format >= FORMAT_FIRST && Format <= FORMAT_LAST);

		static formatInfo const Table[] =
		{
			{  1, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_PACKED8_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_R4G4_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGBA4_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},								//FORMAT_BGRA4_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_R5G6B5_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_B5G6R5_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB5A1_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},								//FORMAT_BGR5A1_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_ALPHA, SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE), CAP_PACKED16_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_A1RGB5_UNORM,

			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},														//FORMAT_R8_UNORM,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},														//FORMAT_R8_SNORM,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_R8_USCALED,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},										//FORMAT_R8_SSCALED,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},															//FORMAT_R8_UINT,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},															//FORMAT_R8_SINT,
			{  1, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_R8_SRGB,

			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},														//FORMAT_RG8_UNORM,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},														//FORMAT_RG8_SNORM,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RG8_USCALED,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},										//FORMAT_RG8_SSCALED,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},														//FORMAT_RG8_UINT,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},															//FORMAT_RG8_SINT,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RG8_SRGB,

			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_RGB8_UNORM,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB8_SNORM,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB8_USCALED,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},										//FORMAT_RGB8_SSCALED,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB8_UINT,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB8_SINT,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB8_SRGB,

			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_BGR8_UNORM,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_BGR8_SNORM,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_BGR8_USCALED,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_BGR8_SSCALED,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_BGR8_UINT,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_BGR8_SINT,
			{  3, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},	//FORMAT_BGR8_SRGB,

			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},													//FORMAT_RGBA8_UNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},														//FORMAT_RGBA8_SNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA8_USCALED,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA8_SSCALED,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},														//FORMAT_RGBA8_UINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT},														//FORMAT_RGBA8_SINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT},							//FORMAT_RGBA8_SRGB,

			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT},									//FORMAT_BGRA8_UNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_BGRA8_SNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_BGRA8_USCALED,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},					//FORMAT_BGRA8_SSCALED,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_BGRA8_UINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_BGRA8_SINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_SWIZZLE_BIT},		//FORMAT_BGRA8_SRGB,

			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},	//FORMAT_RGBA8_UNORM_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA8_SNORM_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA8_USCALED_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGBA8_SSCALED_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA8_UINT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGBA8_SINT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_SWIZZLE_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},	//FORMAT_RGBA8_SRGB_PACK32,

			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT},										//FORMAT_RGB10A2_UNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},					//FORMAT_RGB10A2_SNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},						//FORMAT_RGB10A2_USCALE,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},						//FORMAT_RGB10A2_SSCALE,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT},											//FORMAT_RGB10A2_UINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_DDS_GLI_EXT_BIT},						//FORMAT_RGB10A2_SINT,

			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},	//FORMAT_BGR10A2_UNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_BGR10A2_SNORM,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_BGR10A2_USCALE,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_BGR10A2_SSCALE,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_BGR10A2_UINT,
			{  4, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_PACKED32_BIT | CAP_SWIZZLE_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_BGR10A2_SINT,

			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_R16_UNORM_PACK16,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},									//FORMAT_R16_SNORM_PACK16,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_R16_USCALE,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},					//FORMAT_R16_SSCALE,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},										//FORMAT_R16_UINT_PACK16,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},										//FORMAT_R16_SINT_PACK16,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT},											//FORMAT_R16_SFLOAT_PACK16,

			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RG16_UNORM_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},									//FORMAT_RG16_SNORM_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_RG16_USCALE,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},					//FORMAT_RG16_SSCALE,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RG16_UINT_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},										//FORMAT_RG16_SINT_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT},										//FORMAT_RG16_SFLOAT_PACK16,

			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB16_UNORM_PACK16,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB16_SNORM_PACK16,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB16_USCALE,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB16_SSCALE,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB16_UINT_PACK16,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB16_SINT_PACK16,
			{  6, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB16_SFLOAT_PACK16,

			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},	//FORMAT_RGBA16_UNORM_PACK16,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},		//FORMAT_RGBA16_SNORM_PACK16,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA16_USCALE,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_SCALED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGBA16_SSCALE,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA16_UINT_PACK16,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT},		//FORMAT_RGBA16_SINT_PACK16,
			{  8, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_FLOAT_BIT | CAP_SIGNED_BIT},			//FORMAT_RGBA16_SFLOAT_PACK16,

			{  4, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},			//FORMAT_R32_UINT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},			//FORMAT_R32_SINT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT},				//FORMAT_R32_SFLOAT_PACK32,

			{  8, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RG32_UINT_PACK32,
			{  8, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},			//FORMAT_RG32_SINT_PACK32,
			{  8, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT},			//FORMAT_RG32_SFLOAT_PACK32,

			{ 12, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGB32_UINT_PACK32,
			{ 12, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT},			//FORMAT_RGB32_SINT_PACK32,
			{ 12, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT},			//FORMAT_RGB32_SFLOAT_PACK32,

			{ 16, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA32_UINT_PACK32,
			{ 16, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT},		//FORMAT_RGBA32_SINT_PACK32,
			{ 16, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_FLOAT_BIT | CAP_SIGNED_BIT},			//FORMAT_RGBA32_SFLOAT_PACK32,

			{  8, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_R64_UINT_PACK64,
			{  8, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_R64_SINT_PACK64,
			{  8, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},				//FORMAT_R64_SFLOAT_PACK64,

			{ 16, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RG64_UINT_PACK64,
			{ 16, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RG64_SINT_PACK64,
			{ 16, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RG64_SFLOAT_PACK64,

			{ 24, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB64_UINT_PACK64,
			{ 24, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB64_SINT_PACK64,
			{ 24, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_FLOAT_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB64_SFLOAT_PACK64,

			{ 32, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA64_UINT_PACK64,
			{ 32, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_INTEGER_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA64_SINT_PACK64,
			{ 32, glm::u8vec3(1, 1, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_FLOAT_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGBA64_SFLOAT_PACK64,

			{  4, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_PACKED32_BIT | CAP_FLOAT_BIT | CAP_SIGNED_BIT},		//FORMAT_RG11B10_UFLOAT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_PACKED32_BIT | CAP_FLOAT_BIT | CAP_UNSIGNED_BIT},	//FORMAT_RGB9E5_UFLOAT_PACK32,

			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_INTEGER_BIT},						//FORMAT_D16_UNORM_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_INTEGER_BIT | CAP_DDS_GLI_EXT_BIT},						//FORMAT_D24_UNORM_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_FLOAT_BIT},						//FORMAT_D32_UFLOAT_PACK32,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_STENCIL_BIT | CAP_DDS_GLI_EXT_BIT},						//FORMAT_S8_UNORM_PACK8,
			{  3, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_INTEGER_BIT | CAP_STENCIL_BIT | CAP_DDS_GLI_EXT_BIT},	//FORMAT_D16_UNORM_S8_UINT_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_INTEGER_BIT | CAP_STENCIL_BIT},	//FORMAT_D24_UNORM_S8_UINT_PACK32,
			{  5, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_DEPTH_BIT | CAP_FLOAT_BIT | CAP_STENCIL_BIT},		//FORMAT_D32_SFLOAT_S8_UINT_PACK64,

			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_DXT1_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB_DXT1_SRGB_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_DXT1_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_DXT1_SRGB_BLOCK8,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_DXT3_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_DXT3_SRGB_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_DXT5_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_DXT5_SRGB_BLOCK16,
			{  8, glm::u8vec3(4, 4, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},										//FORMAT_R_ATI1N_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},										//FORMAT_R_ATI1N_SNORM_BLOCK8,
			{ 16, glm::u8vec3(4, 4, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},										//FORMAT_RG_ATI2N_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_SIGNED_BIT},										//FORMAT_RG_ATI2N_SNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_FLOAT_BIT | CAP_UNSIGNED_BIT},											//FORMAT_RGB_BP_UFLOAT_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_FLOAT_BIT | CAP_SIGNED_BIT},											//FORMAT_RGB_BP_SFLOAT_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_BP_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},			//FORMAT_RGBA_BP_SRGB_BLOCK16,

			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_ETC2_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGB_ETC2_SRGB_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_ETC2_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_ETC2_SRGB_BLOCK8,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_ETC2_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_ETC2_SRGB_BLOCK16,
			{  8, glm::u8vec3(4, 4, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_R_EAC_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_R_EAC_SNORM_BLOCK8,
			{ 16, glm::u8vec3(4, 4, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RG_EAC_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_SIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RG_EAC_SNORM_BLOCK16,

			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_4X4_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_4X4_SRGB_BLOCK16,
			{ 16, glm::u8vec3(5, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_5X4_UNORM_BLOCK16,
			{ 16, glm::u8vec3(5, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_5X4_SRGB_BLOCK16,
			{ 16, glm::u8vec3(5, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_5X5_UNORM_BLOCK16,
			{ 16, glm::u8vec3(5, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_5X5_SRGB_BLOCK16,
			{ 16, glm::u8vec3(6, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_6X5_UNORM_BLOCK16,
			{ 16, glm::u8vec3(6, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_6X5_SRGB_BLOCK16,
			{ 16, glm::u8vec3(6, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_6X6_UNORM_BLOCK16,
			{ 16, glm::u8vec3(6, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_6X6_SRGB_BLOCK16,
			{ 16, glm::u8vec3(8, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_8X5_UNORM_BLOCK16,
			{ 16, glm::u8vec3(8, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_8X5_SRGB_BLOCK16,
			{ 16, glm::u8vec3(8, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_8X6_UNORM_BLOCK16,
			{ 16, glm::u8vec3(8, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_8X6_SRGB_BLOCK16,
			{ 16, glm::u8vec3(8, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_8X8_UNORM_BLOCK16,
			{ 16, glm::u8vec3(8, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_8X8_SRGB_BLOCK16,
			{ 16, glm::u8vec3(10, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_10X5_UNORM_BLOCK16,
			{ 16, glm::u8vec3(10, 5, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_10X5_SRGB_BLOCK16,
			{ 16, glm::u8vec3(10, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_10X6_UNORM_BLOCK16,
			{ 16, glm::u8vec3(10, 6, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_10X6_SRGB_BLOCK16,
			{ 16, glm::u8vec3(10, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},									//FORMAT_RGBA_ASTC_10X8_UNORM_BLOCK16,
			{ 16, glm::u8vec3(10, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_10X8_SRGB_BLOCK16,
			{ 16, glm::u8vec3(10, 10, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},								//FORMAT_RGBA_ASTC_10X10_UNORM_BLOCK16,
			{ 16, glm::u8vec3(10, 10, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_10X10_SRGB_BLOCK16,
			{ 16, glm::u8vec3(12, 10, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},								//FORMAT_RGBA_ASTC_12X10_UNORM_BLOCK16,
			{ 16, glm::u8vec3(12, 10, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_12X10_SRGB_BLOCK16,
			{ 16, glm::u8vec3(12, 12, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},								//FORMAT_RGBA_ASTC_12X12_UNORM_BLOCK16,
			{ 16, glm::u8vec3(12, 12, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT},		//FORMAT_RGBA_ASTC_12X12_SRGB_BLOCK16,

			{ 32, glm::u8vec3(8, 8, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_PVRTC1_8X8_UNORM_BLOCK32,
			{ 32, glm::u8vec3(8, 8, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB_PVRTC1_8X8_SRGB_BLOCK32,
			{ 32, glm::u8vec3(16, 8, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_PVRTC1_16X8_UNORM_BLOCK32,
			{ 32, glm::u8vec3(16, 8, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},			//FORMAT_RGB_PVRTC1_16X8_SRGB_BLOCK32,
			{ 32, glm::u8vec3(8, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_PVRTC1_8X8_UNORM_BLOCK32,
			{ 32, glm::u8vec3(8, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_PVRTC1_8X8_SRGB_BLOCK32,
			{ 32, glm::u8vec3(16, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_PVRTC1_16X8_UNORM_BLOCK32,
			{ 32, glm::u8vec3(16, 8, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_PVRTC1_16X8_SRGB_BLOCK32,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_PVRTC2_4X4_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_PVRTC2_4X4_SRGB_BLOCK8,
			{  8, glm::u8vec3(8, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_PVRTC2_8X4_UNORM_BLOCK8,
			{  8, glm::u8vec3(8, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_COLORSPACE_SRGB_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},		//FORMAT_RGBA_PVRTC2_8X4_SRGB_BLOCK8,

			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_ETC_UNORM_BLOCK8,
			{  8, glm::u8vec3(4, 4, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGB_ATC_UNORM_BLOCK8,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_ATCA_UNORM_BLOCK16,
			{ 16, glm::u8vec3(4, 4, 1), 4, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ALPHA), CAP_COMPRESSED_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},									//FORMAT_RGBA_ATCI_UNORM_BLOCK16,

			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_L8_UNORM_PACK8,
			{  1, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_RED), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_A8_UNORM_PACK8,
			{  2, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_GREEN), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_LA8_UNORM_PACK8,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_L16_UNORM_PACK16,
			{  2, glm::u8vec3(1, 1, 1), 1, swizzles(SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_RED), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_A16_UNORM_PACK16,
			{  4, glm::u8vec3(1, 1, 1), 2, swizzles(SWIZZLE_RED, SWIZZLE_ZERO, SWIZZLE_ZERO, SWIZZLE_GREEN), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_LUMINANCE_ALPHA_BIT | CAP_DDS_GLI_EXT_BIT},								//FORMAT_LA16_UNORM_PACK16,

			{  4, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT},										//FORMAT_BGR8_UNORM_PACK32,
			{  4, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_BLUE, SWIZZLE_GREEN, SWIZZLE_RED, SWIZZLE_ONE), CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_SWIZZLE_BIT | CAP_COLORSPACE_SRGB_BIT},				//FORMAT_BGR8_SRGB_PACK32,

			{  1, glm::u8vec3(1, 1, 1), 3, swizzles(SWIZZLE_RED, SWIZZLE_GREEN, SWIZZLE_BLUE, SWIZZLE_ONE), CAP_PACKED8_BIT | CAP_NORMALIZED_BIT | CAP_UNSIGNED_BIT | CAP_DDS_GLI_EXT_BIT},										//FORMAT_RG3B2_UNORM_PACK8,
		};

		GLM_STATIC_ASSERT(sizeof(Table) / sizeof(Table[0]) == FORMAT_COUNT, "GLI error: format descriptor list doesn't match number of supported formats");
		GLI_ASSERT(Format != static_cast<format>(FORMAT_INVALID));

		return Table[Format - FORMAT_FIRST];
	};

	inline std::uint32_t bits_per_pixel(format Format)
	{
		detail::formatInfo const & Info = detail::get_format_info(Format);

		return Info.BlockSize * 8 / (Info.BlockExtent.x * Info.BlockExtent.y * Info.BlockExtent.z);
	}
}//namespace detail

	inline bool is_compressed(format Format)
	{
		return detail::get_format_info(Format).Flags & detail::CAP_COMPRESSED_BIT ? true : false;
	}

	inline bool is_srgb(format Format)
	{
		return detail::get_format_info(Format).Flags & detail::CAP_COLORSPACE_SRGB_BIT ? true : false;
	}

	inline size_t block_size(format Format)
	{
		return detail::get_format_info(Format).BlockSize;
	}

	inline ivec3 block_extent(format Format)
	{
		return gli::ivec3(detail::get_format_info(Format).BlockExtent);
	}

	inline size_t component_count(format Format)
	{
		return detail::get_format_info(Format).Component;
	}
}//namespace gli
