//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2019 NVIDIA Corporation. All rights reserved.
#ifndef SAMPLE_BASE_INPUT_EVENT_IDS_H
#define SAMPLE_BASE_INPUT_EVENT_IDS_H

#include <SampleFrameworkInputEventIds.h>

// InputEvents used by SampleBase
enum SampleBaseInputEventIds
{
	SAMPLE_BASE_FIRST = NUM_SAMPLE_FRAMEWORK_INPUT_EVENT_IDS,

	PICKUP ,

	SPAWN_DEBUG_OBJECT ,

	PAUSE_SAMPLE ,
	STEP_ONE_FRAME ,
	TOGGLE_VISUALIZATION ,
	DECREASE_DEBUG_RENDER_SCALE ,
	INCREASE_DEBUG_RENDER_SCALE ,
	HIDE_GRAPHICS ,
	WIREFRAME ,	
	TOGGLE_PVD_CONNECTION ,
	SHOW_HELP ,
	SHOW_DESCRIPTION ,
	SHOW_EXTENDED_HELP ,
	VARIABLE_TIMESTEP,
	DELETE_PICKED,

	QUIT,
	MENU_VISUALIZATIONS,
	MENU_SAMPLES,

	MENU_ESCAPE,
	MENU_UP,
	MENU_DOWN,
	MENU_LEFT,
	MENU_RIGHT,
	MENU_SELECT,

	MENU_QUICK_UP,
	MENU_QUICK_DOWN,
	MENU_QUICK_LEFT,
	MENU_QUICK_RIGHT,

	MOUSE_LOOK_BUTTON,

	CONSOLE_OPEN,
	CONSOLE_ESCAPE,
	CONSOLE_BACKSPACE,
	CONSOLE_ENTER,
	CONSOLE_SCROLL_UP,
	CONSOLE_SCROLL_DOWN,
	CONSOLE_LIST_COMMAND_UP,
	CONSOLE_LIST_COMMAND_DOWN,

	NEXT_PAGE,
	PREVIOUS_PAGE,

	RUN_NEXT_SAMPLE,
	RUN_PREVIOUS_SAMPLE,

	PROFILE_ONLY_PVD,

	NUM_SAMPLE_BASE_INPUT_EVENT_IDS, 
};

#endif
