//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2019 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#define THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON

#define PX_PROPERTY_INFO_NAME PxExtensionsPropertyInfoName
	static PxU32ToName g_physx__PxJointActorIndex__EnumConversion[] = {
		{ "eACTOR0", static_cast<PxU32>( physx::PxJointActorIndex::eACTOR0 ) },
		{ "eACTOR1", static_cast<PxU32>( physx::PxJointActorIndex::eACTOR1 ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxJointActorIndex::Enum > { PxEnumTraits() : NameConversion( g_physx__PxJointActorIndex__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxJoint;
	struct PxJointGeneratedValues
	{
		PxRigidActor * Actors[2];
		PxTransform LocalPose[physx::PxJointActorIndex::COUNT];
		PxTransform RelativeTransform;
		PxVec3 RelativeLinearVelocity;
		PxVec3 RelativeAngularVelocity;
		PxReal BreakForce[2];
		PxConstraintFlags ConstraintFlags;
		PxReal InvMassScale0;
		PxReal InvInertiaScale0;
		PxReal InvMassScale1;
		PxReal InvInertiaScale1;
		PxConstraint * Constraint;
		const char * Name;
		PxScene * Scene;
		void * UserData;
		  PxJointGeneratedValues( const PxJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, Actors, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, LocalPose, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, RelativeTransform, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, RelativeLinearVelocity, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, RelativeAngularVelocity, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, BreakForce, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, ConstraintFlags, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, InvMassScale0, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, InvInertiaScale0, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, InvMassScale1, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, InvInertiaScale1, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, Constraint, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, Name, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, Scene, PxJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJoint, UserData, PxJointGeneratedValues)
	struct PxJointGeneratedInfo

	{
		static const char* getClassName() { return "PxJoint"; }
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_Actors, PxJoint, PxRigidActor * > Actors;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_LocalPose, PxJoint, PxJointActorIndex::Enum, PxTransform > LocalPose;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_RelativeTransform, PxJoint, PxTransform > RelativeTransform;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_RelativeLinearVelocity, PxJoint, PxVec3 > RelativeLinearVelocity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_RelativeAngularVelocity, PxJoint, PxVec3 > RelativeAngularVelocity;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_BreakForce, PxJoint, PxReal > BreakForce;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_ConstraintFlags, PxJoint, PxConstraintFlags, PxConstraintFlags > ConstraintFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_InvMassScale0, PxJoint, PxReal, PxReal > InvMassScale0;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_InvInertiaScale0, PxJoint, PxReal, PxReal > InvInertiaScale0;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_InvMassScale1, PxJoint, PxReal, PxReal > InvMassScale1;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_InvInertiaScale1, PxJoint, PxReal, PxReal > InvInertiaScale1;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_Constraint, PxJoint, PxConstraint * > Constraint;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_Name, PxJoint, const char *, const char * > Name;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_Scene, PxJoint, PxScene * > Scene;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJoint_UserData, PxJoint, void *, void * > UserData;

		 PxJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Actors, inStartIndex + 0 );; 
			inOperator( LocalPose, inStartIndex + 1 );; 
			inOperator( RelativeTransform, inStartIndex + 2 );; 
			inOperator( RelativeLinearVelocity, inStartIndex + 3 );; 
			inOperator( RelativeAngularVelocity, inStartIndex + 4 );; 
			inOperator( BreakForce, inStartIndex + 5 );; 
			inOperator( ConstraintFlags, inStartIndex + 6 );; 
			inOperator( InvMassScale0, inStartIndex + 7 );; 
			inOperator( InvInertiaScale0, inStartIndex + 8 );; 
			inOperator( InvMassScale1, inStartIndex + 9 );; 
			inOperator( InvInertiaScale1, inStartIndex + 10 );; 
			inOperator( Constraint, inStartIndex + 11 );; 
			inOperator( Name, inStartIndex + 12 );; 
			inOperator( Scene, inStartIndex + 13 );; 
			inOperator( UserData, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJoint>
	{ 
		PxJointGeneratedInfo Info;
		const PxJointGeneratedInfo* getInfo() { return &Info; }
	};

	class PxContactJoint;
	struct PxContactJointGeneratedValues
		: PxJointGeneratedValues	{
		PxVec3 Contact;
		PxVec3 ContactNormal;
		PxReal Penetration;
		PxReal Resititution;
		PxReal BounceThreshold;
		const char * ConcreteTypeName;
		  PxContactJointGeneratedValues( const PxContactJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, Contact, PxContactJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, ContactNormal, PxContactJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, Penetration, PxContactJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, Resititution, PxContactJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, BounceThreshold, PxContactJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxContactJoint, ConcreteTypeName, PxContactJointGeneratedValues)
	struct PxContactJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxContactJoint"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_Contact, PxContactJoint, const PxVec3 &, PxVec3 > Contact;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_ContactNormal, PxContactJoint, const PxVec3 &, PxVec3 > ContactNormal;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_Penetration, PxContactJoint, const PxReal, PxReal > Penetration;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_Resititution, PxContactJoint, const PxReal, PxReal > Resititution;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_BounceThreshold, PxContactJoint, const PxReal, PxReal > BounceThreshold;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxContactJoint_ConcreteTypeName, PxContactJoint, const char * > ConcreteTypeName;

		 PxContactJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxContactJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 6; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Contact, inStartIndex + 0 );; 
			inOperator( ContactNormal, inStartIndex + 1 );; 
			inOperator( Penetration, inStartIndex + 2 );; 
			inOperator( Resititution, inStartIndex + 3 );; 
			inOperator( BounceThreshold, inStartIndex + 4 );; 
			inOperator( ConcreteTypeName, inStartIndex + 5 );; 
			return 6 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxContactJoint>
	{ 
		PxContactJointGeneratedInfo Info;
		const PxContactJointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxD6Axis__EnumConversion[] = {
		{ "eX", static_cast<PxU32>( physx::PxD6Axis::eX ) },
		{ "eY", static_cast<PxU32>( physx::PxD6Axis::eY ) },
		{ "eZ", static_cast<PxU32>( physx::PxD6Axis::eZ ) },
		{ "eTWIST", static_cast<PxU32>( physx::PxD6Axis::eTWIST ) },
		{ "eSWING1", static_cast<PxU32>( physx::PxD6Axis::eSWING1 ) },
		{ "eSWING2", static_cast<PxU32>( physx::PxD6Axis::eSWING2 ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxD6Axis::Enum > { PxEnumTraits() : NameConversion( g_physx__PxD6Axis__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxD6Motion__EnumConversion[] = {
		{ "eLOCKED", static_cast<PxU32>( physx::PxD6Motion::eLOCKED ) },
		{ "eLIMITED", static_cast<PxU32>( physx::PxD6Motion::eLIMITED ) },
		{ "eFREE", static_cast<PxU32>( physx::PxD6Motion::eFREE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxD6Motion::Enum > { PxEnumTraits() : NameConversion( g_physx__PxD6Motion__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxD6Drive__EnumConversion[] = {
		{ "eX", static_cast<PxU32>( physx::PxD6Drive::eX ) },
		{ "eY", static_cast<PxU32>( physx::PxD6Drive::eY ) },
		{ "eZ", static_cast<PxU32>( physx::PxD6Drive::eZ ) },
		{ "eSWING", static_cast<PxU32>( physx::PxD6Drive::eSWING ) },
		{ "eTWIST", static_cast<PxU32>( physx::PxD6Drive::eTWIST ) },
		{ "eSLERP", static_cast<PxU32>( physx::PxD6Drive::eSLERP ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxD6Drive::Enum > { PxEnumTraits() : NameConversion( g_physx__PxD6Drive__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxD6Joint;
	struct PxD6JointGeneratedValues
		: PxJointGeneratedValues	{
		PxD6Motion::Enum Motion[physx::PxD6Axis::eCOUNT];
		PxReal TwistAngle;
		PxReal Twist;
		PxReal SwingYAngle;
		PxReal SwingZAngle;
		PxJointLinearLimit DistanceLimit;
		PxJointLinearLimit LinearLimit;
		PxJointAngularLimitPair TwistLimit;
		PxJointLimitCone SwingLimit;
		PxJointLimitPyramid PyramidSwingLimit;
		PxD6JointDrive Drive[physx::PxD6Drive::eCOUNT];
		PxTransform DrivePosition;
		PxReal ProjectionLinearTolerance;
		PxReal ProjectionAngularTolerance;
		const char * ConcreteTypeName;
		  PxD6JointGeneratedValues( const PxD6Joint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, Motion, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, TwistAngle, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, Twist, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, SwingYAngle, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, SwingZAngle, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, DistanceLimit, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, LinearLimit, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, TwistLimit, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, SwingLimit, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, PyramidSwingLimit, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, Drive, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, DrivePosition, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, ProjectionLinearTolerance, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, ProjectionAngularTolerance, PxD6JointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6Joint, ConcreteTypeName, PxD6JointGeneratedValues)
	struct PxD6JointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxD6Joint"; }
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_Motion, PxD6Joint, PxD6Axis::Enum, PxD6Motion::Enum > Motion;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_TwistAngle, PxD6Joint, PxReal > TwistAngle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_Twist, PxD6Joint, PxReal > Twist;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_SwingYAngle, PxD6Joint, PxReal > SwingYAngle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_SwingZAngle, PxD6Joint, PxReal > SwingZAngle;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_DistanceLimit, PxD6Joint, const PxJointLinearLimit &, PxJointLinearLimit > DistanceLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_LinearLimit, PxD6Joint, const PxJointLinearLimit &, PxJointLinearLimit > LinearLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_TwistLimit, PxD6Joint, const PxJointAngularLimitPair &, PxJointAngularLimitPair > TwistLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_SwingLimit, PxD6Joint, const PxJointLimitCone &, PxJointLimitCone > SwingLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_PyramidSwingLimit, PxD6Joint, const PxJointLimitPyramid &, PxJointLimitPyramid > PyramidSwingLimit;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_Drive, PxD6Joint, PxD6Drive::Enum, PxD6JointDrive > Drive;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_DrivePosition, PxD6Joint, const PxTransform &, PxTransform > DrivePosition;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_ProjectionLinearTolerance, PxD6Joint, PxReal, PxReal > ProjectionLinearTolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_ProjectionAngularTolerance, PxD6Joint, PxReal, PxReal > ProjectionAngularTolerance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6Joint_ConcreteTypeName, PxD6Joint, const char * > ConcreteTypeName;

		 PxD6JointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxD6Joint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Motion, inStartIndex + 0 );; 
			inOperator( TwistAngle, inStartIndex + 1 );; 
			inOperator( Twist, inStartIndex + 2 );; 
			inOperator( SwingYAngle, inStartIndex + 3 );; 
			inOperator( SwingZAngle, inStartIndex + 4 );; 
			inOperator( DistanceLimit, inStartIndex + 5 );; 
			inOperator( LinearLimit, inStartIndex + 6 );; 
			inOperator( TwistLimit, inStartIndex + 7 );; 
			inOperator( SwingLimit, inStartIndex + 8 );; 
			inOperator( PyramidSwingLimit, inStartIndex + 9 );; 
			inOperator( Drive, inStartIndex + 10 );; 
			inOperator( DrivePosition, inStartIndex + 11 );; 
			inOperator( ProjectionLinearTolerance, inStartIndex + 12 );; 
			inOperator( ProjectionAngularTolerance, inStartIndex + 13 );; 
			inOperator( ConcreteTypeName, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxD6Joint>
	{ 
		PxD6JointGeneratedInfo Info;
		const PxD6JointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxDistanceJointFlag__EnumConversion[] = {
		{ "eMAX_DISTANCE_ENABLED", static_cast<PxU32>( physx::PxDistanceJointFlag::eMAX_DISTANCE_ENABLED ) },
		{ "eMIN_DISTANCE_ENABLED", static_cast<PxU32>( physx::PxDistanceJointFlag::eMIN_DISTANCE_ENABLED ) },
		{ "eSPRING_ENABLED", static_cast<PxU32>( physx::PxDistanceJointFlag::eSPRING_ENABLED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxDistanceJointFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxDistanceJointFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxDistanceJoint;
	struct PxDistanceJointGeneratedValues
		: PxJointGeneratedValues	{
		PxReal Distance;
		PxReal MinDistance;
		PxReal MaxDistance;
		PxReal Tolerance;
		PxReal Stiffness;
		PxReal Damping;
		PxDistanceJointFlags DistanceJointFlags;
		const char * ConcreteTypeName;
		  PxDistanceJointGeneratedValues( const PxDistanceJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, Distance, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, MinDistance, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, MaxDistance, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, Tolerance, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, Stiffness, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, Damping, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, DistanceJointFlags, PxDistanceJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxDistanceJoint, ConcreteTypeName, PxDistanceJointGeneratedValues)
	struct PxDistanceJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxDistanceJoint"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_Distance, PxDistanceJoint, PxReal > Distance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_MinDistance, PxDistanceJoint, PxReal, PxReal > MinDistance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_MaxDistance, PxDistanceJoint, PxReal, PxReal > MaxDistance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_Tolerance, PxDistanceJoint, PxReal, PxReal > Tolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_Stiffness, PxDistanceJoint, PxReal, PxReal > Stiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_Damping, PxDistanceJoint, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_DistanceJointFlags, PxDistanceJoint, PxDistanceJointFlags, PxDistanceJointFlags > DistanceJointFlags;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxDistanceJoint_ConcreteTypeName, PxDistanceJoint, const char * > ConcreteTypeName;

		 PxDistanceJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxDistanceJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Distance, inStartIndex + 0 );; 
			inOperator( MinDistance, inStartIndex + 1 );; 
			inOperator( MaxDistance, inStartIndex + 2 );; 
			inOperator( Tolerance, inStartIndex + 3 );; 
			inOperator( Stiffness, inStartIndex + 4 );; 
			inOperator( Damping, inStartIndex + 5 );; 
			inOperator( DistanceJointFlags, inStartIndex + 6 );; 
			inOperator( ConcreteTypeName, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxDistanceJoint>
	{ 
		PxDistanceJointGeneratedInfo Info;
		const PxDistanceJointGeneratedInfo* getInfo() { return &Info; }
	};

	class PxFixedJoint;
	struct PxFixedJointGeneratedValues
		: PxJointGeneratedValues	{
		PxReal ProjectionLinearTolerance;
		PxReal ProjectionAngularTolerance;
		const char * ConcreteTypeName;
		  PxFixedJointGeneratedValues( const PxFixedJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxFixedJoint, ProjectionLinearTolerance, PxFixedJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxFixedJoint, ProjectionAngularTolerance, PxFixedJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxFixedJoint, ConcreteTypeName, PxFixedJointGeneratedValues)
	struct PxFixedJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxFixedJoint"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxFixedJoint_ProjectionLinearTolerance, PxFixedJoint, PxReal, PxReal > ProjectionLinearTolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxFixedJoint_ProjectionAngularTolerance, PxFixedJoint, PxReal, PxReal > ProjectionAngularTolerance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxFixedJoint_ConcreteTypeName, PxFixedJoint, const char * > ConcreteTypeName;

		 PxFixedJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxFixedJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ProjectionLinearTolerance, inStartIndex + 0 );; 
			inOperator( ProjectionAngularTolerance, inStartIndex + 1 );; 
			inOperator( ConcreteTypeName, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxFixedJoint>
	{ 
		PxFixedJointGeneratedInfo Info;
		const PxFixedJointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxPrismaticJointFlag__EnumConversion[] = {
		{ "eLIMIT_ENABLED", static_cast<PxU32>( physx::PxPrismaticJointFlag::eLIMIT_ENABLED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxPrismaticJointFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxPrismaticJointFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxPrismaticJoint;
	struct PxPrismaticJointGeneratedValues
		: PxJointGeneratedValues	{
		PxReal Position;
		PxReal Velocity;
		PxJointLinearLimitPair Limit;
		PxPrismaticJointFlags PrismaticJointFlags;
		PxReal ProjectionLinearTolerance;
		PxReal ProjectionAngularTolerance;
		const char * ConcreteTypeName;
		  PxPrismaticJointGeneratedValues( const PxPrismaticJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, Position, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, Velocity, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, Limit, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, PrismaticJointFlags, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, ProjectionLinearTolerance, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, ProjectionAngularTolerance, PxPrismaticJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPrismaticJoint, ConcreteTypeName, PxPrismaticJointGeneratedValues)
	struct PxPrismaticJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxPrismaticJoint"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_Position, PxPrismaticJoint, PxReal > Position;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_Velocity, PxPrismaticJoint, PxReal > Velocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_Limit, PxPrismaticJoint, const PxJointLinearLimitPair &, PxJointLinearLimitPair > Limit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_PrismaticJointFlags, PxPrismaticJoint, PxPrismaticJointFlags, PxPrismaticJointFlags > PrismaticJointFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_ProjectionLinearTolerance, PxPrismaticJoint, PxReal, PxReal > ProjectionLinearTolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_ProjectionAngularTolerance, PxPrismaticJoint, PxReal, PxReal > ProjectionAngularTolerance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPrismaticJoint_ConcreteTypeName, PxPrismaticJoint, const char * > ConcreteTypeName;

		 PxPrismaticJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPrismaticJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Position, inStartIndex + 0 );; 
			inOperator( Velocity, inStartIndex + 1 );; 
			inOperator( Limit, inStartIndex + 2 );; 
			inOperator( PrismaticJointFlags, inStartIndex + 3 );; 
			inOperator( ProjectionLinearTolerance, inStartIndex + 4 );; 
			inOperator( ProjectionAngularTolerance, inStartIndex + 5 );; 
			inOperator( ConcreteTypeName, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPrismaticJoint>
	{ 
		PxPrismaticJointGeneratedInfo Info;
		const PxPrismaticJointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxRevoluteJointFlag__EnumConversion[] = {
		{ "eLIMIT_ENABLED", static_cast<PxU32>( physx::PxRevoluteJointFlag::eLIMIT_ENABLED ) },
		{ "eDRIVE_ENABLED", static_cast<PxU32>( physx::PxRevoluteJointFlag::eDRIVE_ENABLED ) },
		{ "eDRIVE_FREESPIN", static_cast<PxU32>( physx::PxRevoluteJointFlag::eDRIVE_FREESPIN ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxRevoluteJointFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxRevoluteJointFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxRevoluteJoint;
	struct PxRevoluteJointGeneratedValues
		: PxJointGeneratedValues	{
		PxReal Angle;
		PxReal Velocity;
		PxJointAngularLimitPair Limit;
		PxReal DriveVelocity;
		PxReal DriveForceLimit;
		PxReal DriveGearRatio;
		PxRevoluteJointFlags RevoluteJointFlags;
		PxReal ProjectionLinearTolerance;
		PxReal ProjectionAngularTolerance;
		const char * ConcreteTypeName;
		  PxRevoluteJointGeneratedValues( const PxRevoluteJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, Angle, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, Velocity, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, Limit, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, DriveVelocity, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, DriveForceLimit, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, DriveGearRatio, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, RevoluteJointFlags, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, ProjectionLinearTolerance, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, ProjectionAngularTolerance, PxRevoluteJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRevoluteJoint, ConcreteTypeName, PxRevoluteJointGeneratedValues)
	struct PxRevoluteJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxRevoluteJoint"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_Angle, PxRevoluteJoint, PxReal > Angle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_Velocity, PxRevoluteJoint, PxReal > Velocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_Limit, PxRevoluteJoint, const PxJointAngularLimitPair &, PxJointAngularLimitPair > Limit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_DriveVelocity, PxRevoluteJoint, PxReal, PxReal > DriveVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_DriveForceLimit, PxRevoluteJoint, PxReal, PxReal > DriveForceLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_DriveGearRatio, PxRevoluteJoint, PxReal, PxReal > DriveGearRatio;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_RevoluteJointFlags, PxRevoluteJoint, PxRevoluteJointFlags, PxRevoluteJointFlags > RevoluteJointFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_ProjectionLinearTolerance, PxRevoluteJoint, PxReal, PxReal > ProjectionLinearTolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_ProjectionAngularTolerance, PxRevoluteJoint, PxReal, PxReal > ProjectionAngularTolerance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRevoluteJoint_ConcreteTypeName, PxRevoluteJoint, const char * > ConcreteTypeName;

		 PxRevoluteJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRevoluteJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 10; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Angle, inStartIndex + 0 );; 
			inOperator( Velocity, inStartIndex + 1 );; 
			inOperator( Limit, inStartIndex + 2 );; 
			inOperator( DriveVelocity, inStartIndex + 3 );; 
			inOperator( DriveForceLimit, inStartIndex + 4 );; 
			inOperator( DriveGearRatio, inStartIndex + 5 );; 
			inOperator( RevoluteJointFlags, inStartIndex + 6 );; 
			inOperator( ProjectionLinearTolerance, inStartIndex + 7 );; 
			inOperator( ProjectionAngularTolerance, inStartIndex + 8 );; 
			inOperator( ConcreteTypeName, inStartIndex + 9 );; 
			return 10 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRevoluteJoint>
	{ 
		PxRevoluteJointGeneratedInfo Info;
		const PxRevoluteJointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSphericalJointFlag__EnumConversion[] = {
		{ "eLIMIT_ENABLED", static_cast<PxU32>( physx::PxSphericalJointFlag::eLIMIT_ENABLED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSphericalJointFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSphericalJointFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSphericalJoint;
	struct PxSphericalJointGeneratedValues
		: PxJointGeneratedValues	{
		PxJointLimitCone LimitCone;
		PxReal SwingYAngle;
		PxReal SwingZAngle;
		PxSphericalJointFlags SphericalJointFlags;
		PxReal ProjectionLinearTolerance;
		const char * ConcreteTypeName;
		  PxSphericalJointGeneratedValues( const PxSphericalJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, LimitCone, PxSphericalJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, SwingYAngle, PxSphericalJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, SwingZAngle, PxSphericalJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, SphericalJointFlags, PxSphericalJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, ProjectionLinearTolerance, PxSphericalJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphericalJoint, ConcreteTypeName, PxSphericalJointGeneratedValues)
	struct PxSphericalJointGeneratedInfo
		: PxJointGeneratedInfo
	{
		static const char* getClassName() { return "PxSphericalJoint"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_LimitCone, PxSphericalJoint, const PxJointLimitCone &, PxJointLimitCone > LimitCone;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_SwingYAngle, PxSphericalJoint, PxReal > SwingYAngle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_SwingZAngle, PxSphericalJoint, PxReal > SwingZAngle;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_SphericalJointFlags, PxSphericalJoint, PxSphericalJointFlags, PxSphericalJointFlags > SphericalJointFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_ProjectionLinearTolerance, PxSphericalJoint, PxReal, PxReal > ProjectionLinearTolerance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphericalJoint_ConcreteTypeName, PxSphericalJoint, const char * > ConcreteTypeName;

		 PxSphericalJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSphericalJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 6; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( LimitCone, inStartIndex + 0 );; 
			inOperator( SwingYAngle, inStartIndex + 1 );; 
			inOperator( SwingZAngle, inStartIndex + 2 );; 
			inOperator( SphericalJointFlags, inStartIndex + 3 );; 
			inOperator( ProjectionLinearTolerance, inStartIndex + 4 );; 
			inOperator( ConcreteTypeName, inStartIndex + 5 );; 
			return 6 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSphericalJoint>
	{ 
		PxSphericalJointGeneratedInfo Info;
		const PxSphericalJointGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointLimitParameters;
	struct PxJointLimitParametersGeneratedValues
	{
		PxReal Restitution;
		PxReal BounceThreshold;
		PxReal Stiffness;
		PxReal Damping;
		PxReal ContactDistance;
		  PxJointLimitParametersGeneratedValues( const PxJointLimitParameters* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitParameters, Restitution, PxJointLimitParametersGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitParameters, BounceThreshold, PxJointLimitParametersGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitParameters, Stiffness, PxJointLimitParametersGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitParameters, Damping, PxJointLimitParametersGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitParameters, ContactDistance, PxJointLimitParametersGeneratedValues)
	struct PxJointLimitParametersGeneratedInfo

	{
		static const char* getClassName() { return "PxJointLimitParameters"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitParameters_Restitution, PxJointLimitParameters, PxReal, PxReal > Restitution;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitParameters_BounceThreshold, PxJointLimitParameters, PxReal, PxReal > BounceThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitParameters_Stiffness, PxJointLimitParameters, PxReal, PxReal > Stiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitParameters_Damping, PxJointLimitParameters, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitParameters_ContactDistance, PxJointLimitParameters, PxReal, PxReal > ContactDistance;

		 PxJointLimitParametersGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointLimitParameters*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Restitution, inStartIndex + 0 );; 
			inOperator( BounceThreshold, inStartIndex + 1 );; 
			inOperator( Stiffness, inStartIndex + 2 );; 
			inOperator( Damping, inStartIndex + 3 );; 
			inOperator( ContactDistance, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointLimitParameters>
	{ 
		PxJointLimitParametersGeneratedInfo Info;
		const PxJointLimitParametersGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointLinearLimit;
	struct PxJointLinearLimitGeneratedValues
		: PxJointLimitParametersGeneratedValues	{
		PxReal Value;
		  PxJointLinearLimitGeneratedValues( const PxJointLinearLimit* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLinearLimit, Value, PxJointLinearLimitGeneratedValues)
	struct PxJointLinearLimitGeneratedInfo
		: PxJointLimitParametersGeneratedInfo
	{
		static const char* getClassName() { return "PxJointLinearLimit"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLinearLimit_Value, PxJointLinearLimit, PxReal, PxReal > Value;

		 PxJointLinearLimitGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointLinearLimit*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointLimitParametersGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointLimitParametersGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Value, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointLinearLimit>
	{ 
		PxJointLinearLimitGeneratedInfo Info;
		const PxJointLinearLimitGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointLinearLimitPair;
	struct PxJointLinearLimitPairGeneratedValues
		: PxJointLimitParametersGeneratedValues	{
		PxReal Upper;
		PxReal Lower;
		  PxJointLinearLimitPairGeneratedValues( const PxJointLinearLimitPair* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLinearLimitPair, Upper, PxJointLinearLimitPairGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLinearLimitPair, Lower, PxJointLinearLimitPairGeneratedValues)
	struct PxJointLinearLimitPairGeneratedInfo
		: PxJointLimitParametersGeneratedInfo
	{
		static const char* getClassName() { return "PxJointLinearLimitPair"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLinearLimitPair_Upper, PxJointLinearLimitPair, PxReal, PxReal > Upper;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLinearLimitPair_Lower, PxJointLinearLimitPair, PxReal, PxReal > Lower;

		 PxJointLinearLimitPairGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointLinearLimitPair*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointLimitParametersGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointLimitParametersGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Upper, inStartIndex + 0 );; 
			inOperator( Lower, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointLinearLimitPair>
	{ 
		PxJointLinearLimitPairGeneratedInfo Info;
		const PxJointLinearLimitPairGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointAngularLimitPair;
	struct PxJointAngularLimitPairGeneratedValues
		: PxJointLimitParametersGeneratedValues	{
		PxReal Upper;
		PxReal Lower;
		  PxJointAngularLimitPairGeneratedValues( const PxJointAngularLimitPair* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointAngularLimitPair, Upper, PxJointAngularLimitPairGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointAngularLimitPair, Lower, PxJointAngularLimitPairGeneratedValues)
	struct PxJointAngularLimitPairGeneratedInfo
		: PxJointLimitParametersGeneratedInfo
	{
		static const char* getClassName() { return "PxJointAngularLimitPair"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointAngularLimitPair_Upper, PxJointAngularLimitPair, PxReal, PxReal > Upper;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointAngularLimitPair_Lower, PxJointAngularLimitPair, PxReal, PxReal > Lower;

		 PxJointAngularLimitPairGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointAngularLimitPair*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointLimitParametersGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointLimitParametersGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Upper, inStartIndex + 0 );; 
			inOperator( Lower, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointAngularLimitPair>
	{ 
		PxJointAngularLimitPairGeneratedInfo Info;
		const PxJointAngularLimitPairGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointLimitCone;
	struct PxJointLimitConeGeneratedValues
		: PxJointLimitParametersGeneratedValues	{
		PxReal YAngle;
		PxReal ZAngle;
		  PxJointLimitConeGeneratedValues( const PxJointLimitCone* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitCone, YAngle, PxJointLimitConeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitCone, ZAngle, PxJointLimitConeGeneratedValues)
	struct PxJointLimitConeGeneratedInfo
		: PxJointLimitParametersGeneratedInfo
	{
		static const char* getClassName() { return "PxJointLimitCone"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitCone_YAngle, PxJointLimitCone, PxReal, PxReal > YAngle;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitCone_ZAngle, PxJointLimitCone, PxReal, PxReal > ZAngle;

		 PxJointLimitConeGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointLimitCone*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointLimitParametersGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointLimitParametersGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( YAngle, inStartIndex + 0 );; 
			inOperator( ZAngle, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointLimitCone>
	{ 
		PxJointLimitConeGeneratedInfo Info;
		const PxJointLimitConeGeneratedInfo* getInfo() { return &Info; }
	};

	class PxJointLimitPyramid;
	struct PxJointLimitPyramidGeneratedValues
		: PxJointLimitParametersGeneratedValues	{
		PxReal YAngleMin;
		PxReal YAngleMax;
		PxReal ZAngleMin;
		PxReal ZAngleMax;
		  PxJointLimitPyramidGeneratedValues( const PxJointLimitPyramid* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitPyramid, YAngleMin, PxJointLimitPyramidGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitPyramid, YAngleMax, PxJointLimitPyramidGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitPyramid, ZAngleMin, PxJointLimitPyramidGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxJointLimitPyramid, ZAngleMax, PxJointLimitPyramidGeneratedValues)
	struct PxJointLimitPyramidGeneratedInfo
		: PxJointLimitParametersGeneratedInfo
	{
		static const char* getClassName() { return "PxJointLimitPyramid"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitPyramid_YAngleMin, PxJointLimitPyramid, PxReal, PxReal > YAngleMin;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitPyramid_YAngleMax, PxJointLimitPyramid, PxReal, PxReal > YAngleMax;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitPyramid_ZAngleMin, PxJointLimitPyramid, PxReal, PxReal > ZAngleMin;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxJointLimitPyramid_ZAngleMax, PxJointLimitPyramid, PxReal, PxReal > ZAngleMax;

		 PxJointLimitPyramidGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxJointLimitPyramid*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxJointLimitParametersGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxJointLimitParametersGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxJointLimitParametersGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( YAngleMin, inStartIndex + 0 );; 
			inOperator( YAngleMax, inStartIndex + 1 );; 
			inOperator( ZAngleMin, inStartIndex + 2 );; 
			inOperator( ZAngleMax, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxJointLimitPyramid>
	{ 
		PxJointLimitPyramidGeneratedInfo Info;
		const PxJointLimitPyramidGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSpring;
	struct PxSpringGeneratedValues
	{
		PxReal Stiffness;
		PxReal Damping;
		  PxSpringGeneratedValues( const PxSpring* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSpring, Stiffness, PxSpringGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSpring, Damping, PxSpringGeneratedValues)
	struct PxSpringGeneratedInfo

	{
		static const char* getClassName() { return "PxSpring"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSpring_Stiffness, PxSpring, PxReal, PxReal > Stiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSpring_Damping, PxSpring, PxReal, PxReal > Damping;

		 PxSpringGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSpring*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Stiffness, inStartIndex + 0 );; 
			inOperator( Damping, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSpring>
	{ 
		PxSpringGeneratedInfo Info;
		const PxSpringGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxD6JointDriveFlag__EnumConversion[] = {
		{ "eACCELERATION", static_cast<PxU32>( physx::PxD6JointDriveFlag::eACCELERATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxD6JointDriveFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxD6JointDriveFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxD6JointDrive;
	struct PxD6JointDriveGeneratedValues
		: PxSpringGeneratedValues	{
		PxReal ForceLimit;
		PxD6JointDriveFlags Flags;
		  PxD6JointDriveGeneratedValues( const PxD6JointDrive* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6JointDrive, ForceLimit, PxD6JointDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxD6JointDrive, Flags, PxD6JointDriveGeneratedValues)
	struct PxD6JointDriveGeneratedInfo
		: PxSpringGeneratedInfo
	{
		static const char* getClassName() { return "PxD6JointDrive"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6JointDrive_ForceLimit, PxD6JointDrive, PxReal, PxReal > ForceLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxD6JointDrive_Flags, PxD6JointDrive, PxD6JointDriveFlags, PxD6JointDriveFlags > Flags;

		 PxD6JointDriveGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxD6JointDrive*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxSpringGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxSpringGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxSpringGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxSpringGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ForceLimit, inStartIndex + 0 );; 
			inOperator( Flags, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxD6JointDrive>
	{ 
		PxD6JointDriveGeneratedInfo Info;
		const PxD6JointDriveGeneratedInfo* getInfo() { return &Info; }
	};



#undef THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON
#undef PX_PROPERTY_INFO_NAME
