//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2018 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#include "PxVehicleMetaDataObjects.h"
#include "PxMetaDataCppPrefix.h"
#include "PxVehicleSuspWheelTire4.h"
using namespace physx;
inline PxVec3 getPxVehicleChassisDataMMOI( const PxVehicleChassisData* inOwner ) { return inOwner->mMOI; }
inline void setPxVehicleChassisDataMMOI( PxVehicleChassisData* inOwner, PxVec3 inData) { inOwner->mMOI = inData; }
inline PxReal getPxVehicleChassisDataMMass( const PxVehicleChassisData* inOwner ) { return inOwner->mMass; }
inline void setPxVehicleChassisDataMMass( PxVehicleChassisData* inOwner, PxReal inData) { inOwner->mMass = inData; }
inline PxVec3 getPxVehicleChassisDataMCMOffset( const PxVehicleChassisData* inOwner ) { return inOwner->mCMOffset; }
inline void setPxVehicleChassisDataMCMOffset( PxVehicleChassisData* inOwner, PxVec3 inData) { inOwner->mCMOffset = inData; }
 PxVehicleChassisDataGeneratedInfo::PxVehicleChassisDataGeneratedInfo()
	: MMOI( "MMOI", setPxVehicleChassisDataMMOI, getPxVehicleChassisDataMMOI )
	, MMass( "MMass", setPxVehicleChassisDataMMass, getPxVehicleChassisDataMMass )
	, MCMOffset( "MCMOffset", setPxVehicleChassisDataMCMOffset, getPxVehicleChassisDataMCMOffset )
{}
 PxVehicleChassisDataGeneratedValues::PxVehicleChassisDataGeneratedValues( const PxVehicleChassisData* inSource )
		:MMOI( inSource->mMOI )
		,MMass( inSource->mMass )
		,MCMOffset( inSource->mCMOffset )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleEngineData_RecipMOI( const PxVehicleEngineData* inObj ) { return inObj->getRecipMOI(); }
PxReal getPxVehicleEngineData_RecipMaxOmega( const PxVehicleEngineData* inObj ) { return inObj->getRecipMaxOmega(); }
inline PxReal getPxVehicleEngineDataMMOI( const PxVehicleEngineData* inOwner ) { return inOwner->mMOI; }
inline void setPxVehicleEngineDataMMOI( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mMOI = inData; }
inline PxReal getPxVehicleEngineDataMPeakTorque( const PxVehicleEngineData* inOwner ) { return inOwner->mPeakTorque; }
inline void setPxVehicleEngineDataMPeakTorque( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mPeakTorque = inData; }
inline PxReal getPxVehicleEngineDataMMaxOmega( const PxVehicleEngineData* inOwner ) { return inOwner->mMaxOmega; }
inline void setPxVehicleEngineDataMMaxOmega( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mMaxOmega = inData; }
inline PxReal getPxVehicleEngineDataMDampingRateFullThrottle( const PxVehicleEngineData* inOwner ) { return inOwner->mDampingRateFullThrottle; }
inline void setPxVehicleEngineDataMDampingRateFullThrottle( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mDampingRateFullThrottle = inData; }
inline PxReal getPxVehicleEngineDataMDampingRateZeroThrottleClutchEngaged( const PxVehicleEngineData* inOwner ) { return inOwner->mDampingRateZeroThrottleClutchEngaged; }
inline void setPxVehicleEngineDataMDampingRateZeroThrottleClutchEngaged( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mDampingRateZeroThrottleClutchEngaged = inData; }
inline PxReal getPxVehicleEngineDataMDampingRateZeroThrottleClutchDisengaged( const PxVehicleEngineData* inOwner ) { return inOwner->mDampingRateZeroThrottleClutchDisengaged; }
inline void setPxVehicleEngineDataMDampingRateZeroThrottleClutchDisengaged( PxVehicleEngineData* inOwner, PxReal inData) { inOwner->mDampingRateZeroThrottleClutchDisengaged = inData; }
 PxVehicleEngineDataGeneratedInfo::PxVehicleEngineDataGeneratedInfo()
	: RecipMOI( "RecipMOI", getPxVehicleEngineData_RecipMOI)
	, RecipMaxOmega( "RecipMaxOmega", getPxVehicleEngineData_RecipMaxOmega)
	, MMOI( "MMOI", setPxVehicleEngineDataMMOI, getPxVehicleEngineDataMMOI )
	, MPeakTorque( "MPeakTorque", setPxVehicleEngineDataMPeakTorque, getPxVehicleEngineDataMPeakTorque )
	, MMaxOmega( "MMaxOmega", setPxVehicleEngineDataMMaxOmega, getPxVehicleEngineDataMMaxOmega )
	, MDampingRateFullThrottle( "MDampingRateFullThrottle", setPxVehicleEngineDataMDampingRateFullThrottle, getPxVehicleEngineDataMDampingRateFullThrottle )
	, MDampingRateZeroThrottleClutchEngaged( "MDampingRateZeroThrottleClutchEngaged", setPxVehicleEngineDataMDampingRateZeroThrottleClutchEngaged, getPxVehicleEngineDataMDampingRateZeroThrottleClutchEngaged )
	, MDampingRateZeroThrottleClutchDisengaged( "MDampingRateZeroThrottleClutchDisengaged", setPxVehicleEngineDataMDampingRateZeroThrottleClutchDisengaged, getPxVehicleEngineDataMDampingRateZeroThrottleClutchDisengaged )
{}
 PxVehicleEngineDataGeneratedValues::PxVehicleEngineDataGeneratedValues( const PxVehicleEngineData* inSource )
		:RecipMOI( getPxVehicleEngineData_RecipMOI( inSource ) )
		,RecipMaxOmega( getPxVehicleEngineData_RecipMaxOmega( inSource ) )
		,MMOI( inSource->mMOI )
		,MPeakTorque( inSource->mPeakTorque )
		,MMaxOmega( inSource->mMaxOmega )
		,MDampingRateFullThrottle( inSource->mDampingRateFullThrottle )
		,MDampingRateZeroThrottleClutchEngaged( inSource->mDampingRateZeroThrottleClutchEngaged )
		,MDampingRateZeroThrottleClutchDisengaged( inSource->mDampingRateZeroThrottleClutchDisengaged )
{
	PX_UNUSED(inSource);
}
void setPxVehicleGearsData_GearRatio( PxVehicleGearsData* inObj, PxVehicleGearsData::Enum inIndex, PxReal inArg ){ inObj->setGearRatio( inIndex, inArg ); }
PxReal getPxVehicleGearsData_GearRatio( const PxVehicleGearsData* inObj, PxVehicleGearsData::Enum inIndex ) { return inObj->getGearRatio( inIndex ); }
inline PxReal getPxVehicleGearsDataMFinalRatio( const PxVehicleGearsData* inOwner ) { return inOwner->mFinalRatio; }
inline void setPxVehicleGearsDataMFinalRatio( PxVehicleGearsData* inOwner, PxReal inData) { inOwner->mFinalRatio = inData; }
inline PxU32 getPxVehicleGearsDataMNbRatios( const PxVehicleGearsData* inOwner ) { return inOwner->mNbRatios; }
inline void setPxVehicleGearsDataMNbRatios( PxVehicleGearsData* inOwner, PxU32 inData) { inOwner->mNbRatios = inData; }
inline PxReal getPxVehicleGearsDataMSwitchTime( const PxVehicleGearsData* inOwner ) { return inOwner->mSwitchTime; }
inline void setPxVehicleGearsDataMSwitchTime( PxVehicleGearsData* inOwner, PxReal inData) { inOwner->mSwitchTime = inData; }
 PxVehicleGearsDataGeneratedInfo::PxVehicleGearsDataGeneratedInfo()
	: GearRatio( "GearRatio", setPxVehicleGearsData_GearRatio, getPxVehicleGearsData_GearRatio)
	, MFinalRatio( "MFinalRatio", setPxVehicleGearsDataMFinalRatio, getPxVehicleGearsDataMFinalRatio )
	, MNbRatios( "MNbRatios", setPxVehicleGearsDataMNbRatios, getPxVehicleGearsDataMNbRatios )
	, MSwitchTime( "MSwitchTime", setPxVehicleGearsDataMSwitchTime, getPxVehicleGearsDataMSwitchTime )
{}
 PxVehicleGearsDataGeneratedValues::PxVehicleGearsDataGeneratedValues( const PxVehicleGearsData* inSource )
		:MFinalRatio( inSource->mFinalRatio )
		,MNbRatios( inSource->mNbRatios )
		,MSwitchTime( inSource->mSwitchTime )
{
	PX_UNUSED(inSource);
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxVehicleGearsData::eGEARSRATIO_COUNT ); ++idx )
		GearRatio[idx] = getPxVehicleGearsData_GearRatio( inSource, static_cast< PxVehicleGearsData::Enum >( idx ) );
}
void setPxVehicleAutoBoxData_Latency( PxVehicleAutoBoxData* inObj, const PxReal inArg){ inObj->setLatency( inArg ); }
PxReal getPxVehicleAutoBoxData_Latency( const PxVehicleAutoBoxData* inObj ) { return inObj->getLatency(); }
void setPxVehicleAutoBoxData_UpRatios( PxVehicleAutoBoxData* inObj, PxVehicleGearsData::Enum inIndex, PxReal inArg ){ inObj->setUpRatios( inIndex, inArg ); }
PxReal getPxVehicleAutoBoxData_UpRatios( const PxVehicleAutoBoxData* inObj, PxVehicleGearsData::Enum inIndex ) { return inObj->getUpRatios( inIndex ); }
void setPxVehicleAutoBoxData_DownRatios( PxVehicleAutoBoxData* inObj, PxVehicleGearsData::Enum inIndex, PxReal inArg ){ inObj->setDownRatios( inIndex, inArg ); }
PxReal getPxVehicleAutoBoxData_DownRatios( const PxVehicleAutoBoxData* inObj, PxVehicleGearsData::Enum inIndex ) { return inObj->getDownRatios( inIndex ); }
 PxVehicleAutoBoxDataGeneratedInfo::PxVehicleAutoBoxDataGeneratedInfo()
	: Latency( "Latency", setPxVehicleAutoBoxData_Latency, getPxVehicleAutoBoxData_Latency)
	, UpRatios( "UpRatios", setPxVehicleAutoBoxData_UpRatios, getPxVehicleAutoBoxData_UpRatios)
	, DownRatios( "DownRatios", setPxVehicleAutoBoxData_DownRatios, getPxVehicleAutoBoxData_DownRatios)
{}
 PxVehicleAutoBoxDataGeneratedValues::PxVehicleAutoBoxDataGeneratedValues( const PxVehicleAutoBoxData* inSource )
		:Latency( getPxVehicleAutoBoxData_Latency( inSource ) )
{
	PX_UNUSED(inSource);
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxVehicleGearsData::eGEARSRATIO_COUNT ); ++idx )
		UpRatios[idx] = getPxVehicleAutoBoxData_UpRatios( inSource, static_cast< PxVehicleGearsData::Enum >( idx ) );
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxVehicleGearsData::eGEARSRATIO_COUNT ); ++idx )
		DownRatios[idx] = getPxVehicleAutoBoxData_DownRatios( inSource, static_cast< PxVehicleGearsData::Enum >( idx ) );
}
inline PxReal getPxVehicleDifferential4WDataMFrontRearSplit( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mFrontRearSplit; }
inline void setPxVehicleDifferential4WDataMFrontRearSplit( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mFrontRearSplit = inData; }
inline PxReal getPxVehicleDifferential4WDataMFrontLeftRightSplit( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mFrontLeftRightSplit; }
inline void setPxVehicleDifferential4WDataMFrontLeftRightSplit( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mFrontLeftRightSplit = inData; }
inline PxReal getPxVehicleDifferential4WDataMRearLeftRightSplit( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mRearLeftRightSplit; }
inline void setPxVehicleDifferential4WDataMRearLeftRightSplit( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mRearLeftRightSplit = inData; }
inline PxReal getPxVehicleDifferential4WDataMCentreBias( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mCentreBias; }
inline void setPxVehicleDifferential4WDataMCentreBias( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mCentreBias = inData; }
inline PxReal getPxVehicleDifferential4WDataMFrontBias( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mFrontBias; }
inline void setPxVehicleDifferential4WDataMFrontBias( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mFrontBias = inData; }
inline PxReal getPxVehicleDifferential4WDataMRearBias( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mRearBias; }
inline void setPxVehicleDifferential4WDataMRearBias( PxVehicleDifferential4WData* inOwner, PxReal inData) { inOwner->mRearBias = inData; }
inline PxVehicleDifferential4WData::Enum getPxVehicleDifferential4WDataMType( const PxVehicleDifferential4WData* inOwner ) { return inOwner->mType; }
inline void setPxVehicleDifferential4WDataMType( PxVehicleDifferential4WData* inOwner, PxVehicleDifferential4WData::Enum inData) { inOwner->mType = inData; }
 PxVehicleDifferential4WDataGeneratedInfo::PxVehicleDifferential4WDataGeneratedInfo()
	: MFrontRearSplit( "MFrontRearSplit", setPxVehicleDifferential4WDataMFrontRearSplit, getPxVehicleDifferential4WDataMFrontRearSplit )
	, MFrontLeftRightSplit( "MFrontLeftRightSplit", setPxVehicleDifferential4WDataMFrontLeftRightSplit, getPxVehicleDifferential4WDataMFrontLeftRightSplit )
	, MRearLeftRightSplit( "MRearLeftRightSplit", setPxVehicleDifferential4WDataMRearLeftRightSplit, getPxVehicleDifferential4WDataMRearLeftRightSplit )
	, MCentreBias( "MCentreBias", setPxVehicleDifferential4WDataMCentreBias, getPxVehicleDifferential4WDataMCentreBias )
	, MFrontBias( "MFrontBias", setPxVehicleDifferential4WDataMFrontBias, getPxVehicleDifferential4WDataMFrontBias )
	, MRearBias( "MRearBias", setPxVehicleDifferential4WDataMRearBias, getPxVehicleDifferential4WDataMRearBias )
	, MType( "MType", setPxVehicleDifferential4WDataMType, getPxVehicleDifferential4WDataMType )
{}
 PxVehicleDifferential4WDataGeneratedValues::PxVehicleDifferential4WDataGeneratedValues( const PxVehicleDifferential4WData* inSource )
		:MFrontRearSplit( inSource->mFrontRearSplit )
		,MFrontLeftRightSplit( inSource->mFrontLeftRightSplit )
		,MRearLeftRightSplit( inSource->mRearLeftRightSplit )
		,MCentreBias( inSource->mCentreBias )
		,MFrontBias( inSource->mFrontBias )
		,MRearBias( inSource->mRearBias )
		,MType( inSource->mType )
{
	PX_UNUSED(inSource);
}
void setPxVehicleDifferentialNWData_DrivenWheelStatus( PxVehicleDifferentialNWData* inObj, PxU32 inArg){ inObj->setDrivenWheelStatus( inArg ); }
PxU32 getPxVehicleDifferentialNWData_DrivenWheelStatus( const PxVehicleDifferentialNWData* inObj ) { return inObj->getDrivenWheelStatus(); }
 PxVehicleDifferentialNWDataGeneratedInfo::PxVehicleDifferentialNWDataGeneratedInfo()
	: DrivenWheelStatus( "DrivenWheelStatus", setPxVehicleDifferentialNWData_DrivenWheelStatus, getPxVehicleDifferentialNWData_DrivenWheelStatus)
{}
 PxVehicleDifferentialNWDataGeneratedValues::PxVehicleDifferentialNWDataGeneratedValues( const PxVehicleDifferentialNWData* inSource )
		:DrivenWheelStatus( getPxVehicleDifferentialNWData_DrivenWheelStatus( inSource ) )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxVehicleAckermannGeometryDataMAccuracy( const PxVehicleAckermannGeometryData* inOwner ) { return inOwner->mAccuracy; }
inline void setPxVehicleAckermannGeometryDataMAccuracy( PxVehicleAckermannGeometryData* inOwner, PxReal inData) { inOwner->mAccuracy = inData; }
inline PxReal getPxVehicleAckermannGeometryDataMFrontWidth( const PxVehicleAckermannGeometryData* inOwner ) { return inOwner->mFrontWidth; }
inline void setPxVehicleAckermannGeometryDataMFrontWidth( PxVehicleAckermannGeometryData* inOwner, PxReal inData) { inOwner->mFrontWidth = inData; }
inline PxReal getPxVehicleAckermannGeometryDataMRearWidth( const PxVehicleAckermannGeometryData* inOwner ) { return inOwner->mRearWidth; }
inline void setPxVehicleAckermannGeometryDataMRearWidth( PxVehicleAckermannGeometryData* inOwner, PxReal inData) { inOwner->mRearWidth = inData; }
inline PxReal getPxVehicleAckermannGeometryDataMAxleSeparation( const PxVehicleAckermannGeometryData* inOwner ) { return inOwner->mAxleSeparation; }
inline void setPxVehicleAckermannGeometryDataMAxleSeparation( PxVehicleAckermannGeometryData* inOwner, PxReal inData) { inOwner->mAxleSeparation = inData; }
 PxVehicleAckermannGeometryDataGeneratedInfo::PxVehicleAckermannGeometryDataGeneratedInfo()
	: MAccuracy( "MAccuracy", setPxVehicleAckermannGeometryDataMAccuracy, getPxVehicleAckermannGeometryDataMAccuracy )
	, MFrontWidth( "MFrontWidth", setPxVehicleAckermannGeometryDataMFrontWidth, getPxVehicleAckermannGeometryDataMFrontWidth )
	, MRearWidth( "MRearWidth", setPxVehicleAckermannGeometryDataMRearWidth, getPxVehicleAckermannGeometryDataMRearWidth )
	, MAxleSeparation( "MAxleSeparation", setPxVehicleAckermannGeometryDataMAxleSeparation, getPxVehicleAckermannGeometryDataMAxleSeparation )
{}
 PxVehicleAckermannGeometryDataGeneratedValues::PxVehicleAckermannGeometryDataGeneratedValues( const PxVehicleAckermannGeometryData* inSource )
		:MAccuracy( inSource->mAccuracy )
		,MFrontWidth( inSource->mFrontWidth )
		,MRearWidth( inSource->mRearWidth )
		,MAxleSeparation( inSource->mAxleSeparation )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxVehicleClutchDataMStrength( const PxVehicleClutchData* inOwner ) { return inOwner->mStrength; }
inline void setPxVehicleClutchDataMStrength( PxVehicleClutchData* inOwner, PxReal inData) { inOwner->mStrength = inData; }
inline PxVehicleClutchAccuracyMode::Enum getPxVehicleClutchDataMAccuracyMode( const PxVehicleClutchData* inOwner ) { return inOwner->mAccuracyMode; }
inline void setPxVehicleClutchDataMAccuracyMode( PxVehicleClutchData* inOwner, PxVehicleClutchAccuracyMode::Enum inData) { inOwner->mAccuracyMode = inData; }
inline PxU32 getPxVehicleClutchDataMEstimateIterations( const PxVehicleClutchData* inOwner ) { return inOwner->mEstimateIterations; }
inline void setPxVehicleClutchDataMEstimateIterations( PxVehicleClutchData* inOwner, PxU32 inData) { inOwner->mEstimateIterations = inData; }
 PxVehicleClutchDataGeneratedInfo::PxVehicleClutchDataGeneratedInfo()
	: MStrength( "MStrength", setPxVehicleClutchDataMStrength, getPxVehicleClutchDataMStrength )
	, MAccuracyMode( "MAccuracyMode", setPxVehicleClutchDataMAccuracyMode, getPxVehicleClutchDataMAccuracyMode )
	, MEstimateIterations( "MEstimateIterations", setPxVehicleClutchDataMEstimateIterations, getPxVehicleClutchDataMEstimateIterations )
{}
 PxVehicleClutchDataGeneratedValues::PxVehicleClutchDataGeneratedValues( const PxVehicleClutchData* inSource )
		:MStrength( inSource->mStrength )
		,MAccuracyMode( inSource->mAccuracyMode )
		,MEstimateIterations( inSource->mEstimateIterations )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleTireLoadFilterData_Denominator( const PxVehicleTireLoadFilterData* inObj ) { return inObj->getDenominator(); }
inline PxReal getPxVehicleTireLoadFilterDataMMinNormalisedLoad( const PxVehicleTireLoadFilterData* inOwner ) { return inOwner->mMinNormalisedLoad; }
inline void setPxVehicleTireLoadFilterDataMMinNormalisedLoad( PxVehicleTireLoadFilterData* inOwner, PxReal inData) { inOwner->mMinNormalisedLoad = inData; }
inline PxReal getPxVehicleTireLoadFilterDataMMinFilteredNormalisedLoad( const PxVehicleTireLoadFilterData* inOwner ) { return inOwner->mMinFilteredNormalisedLoad; }
inline void setPxVehicleTireLoadFilterDataMMinFilteredNormalisedLoad( PxVehicleTireLoadFilterData* inOwner, PxReal inData) { inOwner->mMinFilteredNormalisedLoad = inData; }
inline PxReal getPxVehicleTireLoadFilterDataMMaxNormalisedLoad( const PxVehicleTireLoadFilterData* inOwner ) { return inOwner->mMaxNormalisedLoad; }
inline void setPxVehicleTireLoadFilterDataMMaxNormalisedLoad( PxVehicleTireLoadFilterData* inOwner, PxReal inData) { inOwner->mMaxNormalisedLoad = inData; }
inline PxReal getPxVehicleTireLoadFilterDataMMaxFilteredNormalisedLoad( const PxVehicleTireLoadFilterData* inOwner ) { return inOwner->mMaxFilteredNormalisedLoad; }
inline void setPxVehicleTireLoadFilterDataMMaxFilteredNormalisedLoad( PxVehicleTireLoadFilterData* inOwner, PxReal inData) { inOwner->mMaxFilteredNormalisedLoad = inData; }
 PxVehicleTireLoadFilterDataGeneratedInfo::PxVehicleTireLoadFilterDataGeneratedInfo()
	: Denominator( "Denominator", getPxVehicleTireLoadFilterData_Denominator)
	, MMinNormalisedLoad( "MMinNormalisedLoad", setPxVehicleTireLoadFilterDataMMinNormalisedLoad, getPxVehicleTireLoadFilterDataMMinNormalisedLoad )
	, MMinFilteredNormalisedLoad( "MMinFilteredNormalisedLoad", setPxVehicleTireLoadFilterDataMMinFilteredNormalisedLoad, getPxVehicleTireLoadFilterDataMMinFilteredNormalisedLoad )
	, MMaxNormalisedLoad( "MMaxNormalisedLoad", setPxVehicleTireLoadFilterDataMMaxNormalisedLoad, getPxVehicleTireLoadFilterDataMMaxNormalisedLoad )
	, MMaxFilteredNormalisedLoad( "MMaxFilteredNormalisedLoad", setPxVehicleTireLoadFilterDataMMaxFilteredNormalisedLoad, getPxVehicleTireLoadFilterDataMMaxFilteredNormalisedLoad )
{}
 PxVehicleTireLoadFilterDataGeneratedValues::PxVehicleTireLoadFilterDataGeneratedValues( const PxVehicleTireLoadFilterData* inSource )
		:Denominator( getPxVehicleTireLoadFilterData_Denominator( inSource ) )
		,MMinNormalisedLoad( inSource->mMinNormalisedLoad )
		,MMinFilteredNormalisedLoad( inSource->mMinFilteredNormalisedLoad )
		,MMaxNormalisedLoad( inSource->mMaxNormalisedLoad )
		,MMaxFilteredNormalisedLoad( inSource->mMaxFilteredNormalisedLoad )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleWheelData_RecipRadius( const PxVehicleWheelData* inObj ) { return inObj->getRecipRadius(); }
PxReal getPxVehicleWheelData_RecipMOI( const PxVehicleWheelData* inObj ) { return inObj->getRecipMOI(); }
inline PxReal getPxVehicleWheelDataMRadius( const PxVehicleWheelData* inOwner ) { return inOwner->mRadius; }
inline void setPxVehicleWheelDataMRadius( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mRadius = inData; }
inline PxReal getPxVehicleWheelDataMWidth( const PxVehicleWheelData* inOwner ) { return inOwner->mWidth; }
inline void setPxVehicleWheelDataMWidth( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mWidth = inData; }
inline PxReal getPxVehicleWheelDataMMass( const PxVehicleWheelData* inOwner ) { return inOwner->mMass; }
inline void setPxVehicleWheelDataMMass( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mMass = inData; }
inline PxReal getPxVehicleWheelDataMMOI( const PxVehicleWheelData* inOwner ) { return inOwner->mMOI; }
inline void setPxVehicleWheelDataMMOI( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mMOI = inData; }
inline PxReal getPxVehicleWheelDataMDampingRate( const PxVehicleWheelData* inOwner ) { return inOwner->mDampingRate; }
inline void setPxVehicleWheelDataMDampingRate( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mDampingRate = inData; }
inline PxReal getPxVehicleWheelDataMMaxBrakeTorque( const PxVehicleWheelData* inOwner ) { return inOwner->mMaxBrakeTorque; }
inline void setPxVehicleWheelDataMMaxBrakeTorque( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mMaxBrakeTorque = inData; }
inline PxReal getPxVehicleWheelDataMMaxHandBrakeTorque( const PxVehicleWheelData* inOwner ) { return inOwner->mMaxHandBrakeTorque; }
inline void setPxVehicleWheelDataMMaxHandBrakeTorque( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mMaxHandBrakeTorque = inData; }
inline PxReal getPxVehicleWheelDataMMaxSteer( const PxVehicleWheelData* inOwner ) { return inOwner->mMaxSteer; }
inline void setPxVehicleWheelDataMMaxSteer( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mMaxSteer = inData; }
inline PxReal getPxVehicleWheelDataMToeAngle( const PxVehicleWheelData* inOwner ) { return inOwner->mToeAngle; }
inline void setPxVehicleWheelDataMToeAngle( PxVehicleWheelData* inOwner, PxReal inData) { inOwner->mToeAngle = inData; }
 PxVehicleWheelDataGeneratedInfo::PxVehicleWheelDataGeneratedInfo()
	: RecipRadius( "RecipRadius", getPxVehicleWheelData_RecipRadius)
	, RecipMOI( "RecipMOI", getPxVehicleWheelData_RecipMOI)
	, MRadius( "MRadius", setPxVehicleWheelDataMRadius, getPxVehicleWheelDataMRadius )
	, MWidth( "MWidth", setPxVehicleWheelDataMWidth, getPxVehicleWheelDataMWidth )
	, MMass( "MMass", setPxVehicleWheelDataMMass, getPxVehicleWheelDataMMass )
	, MMOI( "MMOI", setPxVehicleWheelDataMMOI, getPxVehicleWheelDataMMOI )
	, MDampingRate( "MDampingRate", setPxVehicleWheelDataMDampingRate, getPxVehicleWheelDataMDampingRate )
	, MMaxBrakeTorque( "MMaxBrakeTorque", setPxVehicleWheelDataMMaxBrakeTorque, getPxVehicleWheelDataMMaxBrakeTorque )
	, MMaxHandBrakeTorque( "MMaxHandBrakeTorque", setPxVehicleWheelDataMMaxHandBrakeTorque, getPxVehicleWheelDataMMaxHandBrakeTorque )
	, MMaxSteer( "MMaxSteer", setPxVehicleWheelDataMMaxSteer, getPxVehicleWheelDataMMaxSteer )
	, MToeAngle( "MToeAngle", setPxVehicleWheelDataMToeAngle, getPxVehicleWheelDataMToeAngle )
{}
 PxVehicleWheelDataGeneratedValues::PxVehicleWheelDataGeneratedValues( const PxVehicleWheelData* inSource )
		:RecipRadius( getPxVehicleWheelData_RecipRadius( inSource ) )
		,RecipMOI( getPxVehicleWheelData_RecipMOI( inSource ) )
		,MRadius( inSource->mRadius )
		,MWidth( inSource->mWidth )
		,MMass( inSource->mMass )
		,MMOI( inSource->mMOI )
		,MDampingRate( inSource->mDampingRate )
		,MMaxBrakeTorque( inSource->mMaxBrakeTorque )
		,MMaxHandBrakeTorque( inSource->mMaxHandBrakeTorque )
		,MMaxSteer( inSource->mMaxSteer )
		,MToeAngle( inSource->mToeAngle )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleSuspensionData_RecipMaxCompression( const PxVehicleSuspensionData* inObj ) { return inObj->getRecipMaxCompression(); }
PxReal getPxVehicleSuspensionData_RecipMaxDroop( const PxVehicleSuspensionData* inObj ) { return inObj->getRecipMaxDroop(); }
void setPxVehicleSuspensionData_MassAndPreserveNaturalFrequency( PxVehicleSuspensionData* inObj, const PxReal inArg){ inObj->setMassAndPreserveNaturalFrequency( inArg ); }
inline PxReal getPxVehicleSuspensionDataMSpringStrength( const PxVehicleSuspensionData* inOwner ) { return inOwner->mSpringStrength; }
inline void setPxVehicleSuspensionDataMSpringStrength( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mSpringStrength = inData; }
inline PxReal getPxVehicleSuspensionDataMSpringDamperRate( const PxVehicleSuspensionData* inOwner ) { return inOwner->mSpringDamperRate; }
inline void setPxVehicleSuspensionDataMSpringDamperRate( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mSpringDamperRate = inData; }
inline PxReal getPxVehicleSuspensionDataMMaxCompression( const PxVehicleSuspensionData* inOwner ) { return inOwner->mMaxCompression; }
inline void setPxVehicleSuspensionDataMMaxCompression( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mMaxCompression = inData; }
inline PxReal getPxVehicleSuspensionDataMMaxDroop( const PxVehicleSuspensionData* inOwner ) { return inOwner->mMaxDroop; }
inline void setPxVehicleSuspensionDataMMaxDroop( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mMaxDroop = inData; }
inline PxReal getPxVehicleSuspensionDataMSprungMass( const PxVehicleSuspensionData* inOwner ) { return inOwner->mSprungMass; }
inline void setPxVehicleSuspensionDataMSprungMass( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mSprungMass = inData; }
inline PxReal getPxVehicleSuspensionDataMCamberAtRest( const PxVehicleSuspensionData* inOwner ) { return inOwner->mCamberAtRest; }
inline void setPxVehicleSuspensionDataMCamberAtRest( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mCamberAtRest = inData; }
inline PxReal getPxVehicleSuspensionDataMCamberAtMaxCompression( const PxVehicleSuspensionData* inOwner ) { return inOwner->mCamberAtMaxCompression; }
inline void setPxVehicleSuspensionDataMCamberAtMaxCompression( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mCamberAtMaxCompression = inData; }
inline PxReal getPxVehicleSuspensionDataMCamberAtMaxDroop( const PxVehicleSuspensionData* inOwner ) { return inOwner->mCamberAtMaxDroop; }
inline void setPxVehicleSuspensionDataMCamberAtMaxDroop( PxVehicleSuspensionData* inOwner, PxReal inData) { inOwner->mCamberAtMaxDroop = inData; }
 PxVehicleSuspensionDataGeneratedInfo::PxVehicleSuspensionDataGeneratedInfo()
	: RecipMaxCompression( "RecipMaxCompression", getPxVehicleSuspensionData_RecipMaxCompression)
	, RecipMaxDroop( "RecipMaxDroop", getPxVehicleSuspensionData_RecipMaxDroop)
	, MassAndPreserveNaturalFrequency( "MassAndPreserveNaturalFrequency", setPxVehicleSuspensionData_MassAndPreserveNaturalFrequency)
	, MSpringStrength( "MSpringStrength", setPxVehicleSuspensionDataMSpringStrength, getPxVehicleSuspensionDataMSpringStrength )
	, MSpringDamperRate( "MSpringDamperRate", setPxVehicleSuspensionDataMSpringDamperRate, getPxVehicleSuspensionDataMSpringDamperRate )
	, MMaxCompression( "MMaxCompression", setPxVehicleSuspensionDataMMaxCompression, getPxVehicleSuspensionDataMMaxCompression )
	, MMaxDroop( "MMaxDroop", setPxVehicleSuspensionDataMMaxDroop, getPxVehicleSuspensionDataMMaxDroop )
	, MSprungMass( "MSprungMass", setPxVehicleSuspensionDataMSprungMass, getPxVehicleSuspensionDataMSprungMass )
	, MCamberAtRest( "MCamberAtRest", setPxVehicleSuspensionDataMCamberAtRest, getPxVehicleSuspensionDataMCamberAtRest )
	, MCamberAtMaxCompression( "MCamberAtMaxCompression", setPxVehicleSuspensionDataMCamberAtMaxCompression, getPxVehicleSuspensionDataMCamberAtMaxCompression )
	, MCamberAtMaxDroop( "MCamberAtMaxDroop", setPxVehicleSuspensionDataMCamberAtMaxDroop, getPxVehicleSuspensionDataMCamberAtMaxDroop )
{}
 PxVehicleSuspensionDataGeneratedValues::PxVehicleSuspensionDataGeneratedValues( const PxVehicleSuspensionData* inSource )
		:RecipMaxCompression( getPxVehicleSuspensionData_RecipMaxCompression( inSource ) )
		,RecipMaxDroop( getPxVehicleSuspensionData_RecipMaxDroop( inSource ) )
		,MSpringStrength( inSource->mSpringStrength )
		,MSpringDamperRate( inSource->mSpringDamperRate )
		,MMaxCompression( inSource->mMaxCompression )
		,MMaxDroop( inSource->mMaxDroop )
		,MSprungMass( inSource->mSprungMass )
		,MCamberAtRest( inSource->mCamberAtRest )
		,MCamberAtMaxCompression( inSource->mCamberAtMaxCompression )
		,MCamberAtMaxDroop( inSource->mCamberAtMaxDroop )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxVehicleAntiRollBarDataMWheel0( const PxVehicleAntiRollBarData* inOwner ) { return inOwner->mWheel0; }
inline void setPxVehicleAntiRollBarDataMWheel0( PxVehicleAntiRollBarData* inOwner, PxU32 inData) { inOwner->mWheel0 = inData; }
inline PxU32 getPxVehicleAntiRollBarDataMWheel1( const PxVehicleAntiRollBarData* inOwner ) { return inOwner->mWheel1; }
inline void setPxVehicleAntiRollBarDataMWheel1( PxVehicleAntiRollBarData* inOwner, PxU32 inData) { inOwner->mWheel1 = inData; }
inline PxF32 getPxVehicleAntiRollBarDataMStiffness( const PxVehicleAntiRollBarData* inOwner ) { return inOwner->mStiffness; }
inline void setPxVehicleAntiRollBarDataMStiffness( PxVehicleAntiRollBarData* inOwner, PxF32 inData) { inOwner->mStiffness = inData; }
 PxVehicleAntiRollBarDataGeneratedInfo::PxVehicleAntiRollBarDataGeneratedInfo()
	: MWheel0( "MWheel0", setPxVehicleAntiRollBarDataMWheel0, getPxVehicleAntiRollBarDataMWheel0 )
	, MWheel1( "MWheel1", setPxVehicleAntiRollBarDataMWheel1, getPxVehicleAntiRollBarDataMWheel1 )
	, MStiffness( "MStiffness", setPxVehicleAntiRollBarDataMStiffness, getPxVehicleAntiRollBarDataMStiffness )
{}
 PxVehicleAntiRollBarDataGeneratedValues::PxVehicleAntiRollBarDataGeneratedValues( const PxVehicleAntiRollBarData* inSource )
		:MWheel0( inSource->mWheel0 )
		,MWheel1( inSource->mWheel1 )
		,MStiffness( inSource->mStiffness )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleTireData_RecipLongitudinalStiffnessPerUnitGravity( const PxVehicleTireData* inObj ) { return inObj->getRecipLongitudinalStiffnessPerUnitGravity(); }
PxReal getPxVehicleTireData_FrictionVsSlipGraphRecipx1Minusx0( const PxVehicleTireData* inObj ) { return inObj->getFrictionVsSlipGraphRecipx1Minusx0(); }
PxReal getPxVehicleTireData_FrictionVsSlipGraphRecipx2Minusx1( const PxVehicleTireData* inObj ) { return inObj->getFrictionVsSlipGraphRecipx2Minusx1(); }
inline PxReal getPxVehicleTireDataMLatStiffX( const PxVehicleTireData* inOwner ) { return inOwner->mLatStiffX; }
inline void setPxVehicleTireDataMLatStiffX( PxVehicleTireData* inOwner, PxReal inData) { inOwner->mLatStiffX = inData; }
inline PxReal getPxVehicleTireDataMLatStiffY( const PxVehicleTireData* inOwner ) { return inOwner->mLatStiffY; }
inline void setPxVehicleTireDataMLatStiffY( PxVehicleTireData* inOwner, PxReal inData) { inOwner->mLatStiffY = inData; }
inline PxReal getPxVehicleTireDataMLongitudinalStiffnessPerUnitGravity( const PxVehicleTireData* inOwner ) { return inOwner->mLongitudinalStiffnessPerUnitGravity; }
inline void setPxVehicleTireDataMLongitudinalStiffnessPerUnitGravity( PxVehicleTireData* inOwner, PxReal inData) { inOwner->mLongitudinalStiffnessPerUnitGravity = inData; }
inline PxReal getPxVehicleTireDataMCamberStiffnessPerUnitGravity( const PxVehicleTireData* inOwner ) { return inOwner->mCamberStiffnessPerUnitGravity; }
inline void setPxVehicleTireDataMCamberStiffnessPerUnitGravity( PxVehicleTireData* inOwner, PxReal inData) { inOwner->mCamberStiffnessPerUnitGravity = inData; }
inline PxU32 getPxVehicleTireDataMType( const PxVehicleTireData* inOwner ) { return inOwner->mType; }
inline void setPxVehicleTireDataMType( PxVehicleTireData* inOwner, PxU32 inData) { inOwner->mType = inData; }
 PxVehicleTireDataGeneratedInfo::PxVehicleTireDataGeneratedInfo()
	: RecipLongitudinalStiffnessPerUnitGravity( "RecipLongitudinalStiffnessPerUnitGravity", getPxVehicleTireData_RecipLongitudinalStiffnessPerUnitGravity)
	, FrictionVsSlipGraphRecipx1Minusx0( "FrictionVsSlipGraphRecipx1Minusx0", getPxVehicleTireData_FrictionVsSlipGraphRecipx1Minusx0)
	, FrictionVsSlipGraphRecipx2Minusx1( "FrictionVsSlipGraphRecipx2Minusx1", getPxVehicleTireData_FrictionVsSlipGraphRecipx2Minusx1)
	, MLatStiffX( "MLatStiffX", setPxVehicleTireDataMLatStiffX, getPxVehicleTireDataMLatStiffX )
	, MLatStiffY( "MLatStiffY", setPxVehicleTireDataMLatStiffY, getPxVehicleTireDataMLatStiffY )
	, MLongitudinalStiffnessPerUnitGravity( "MLongitudinalStiffnessPerUnitGravity", setPxVehicleTireDataMLongitudinalStiffnessPerUnitGravity, getPxVehicleTireDataMLongitudinalStiffnessPerUnitGravity )
	, MCamberStiffnessPerUnitGravity( "MCamberStiffnessPerUnitGravity", setPxVehicleTireDataMCamberStiffnessPerUnitGravity, getPxVehicleTireDataMCamberStiffnessPerUnitGravity )
	, MType( "MType", setPxVehicleTireDataMType, getPxVehicleTireDataMType )
{}
 PxVehicleTireDataGeneratedValues::PxVehicleTireDataGeneratedValues( const PxVehicleTireData* inSource )
		:RecipLongitudinalStiffnessPerUnitGravity( getPxVehicleTireData_RecipLongitudinalStiffnessPerUnitGravity( inSource ) )
		,FrictionVsSlipGraphRecipx1Minusx0( getPxVehicleTireData_FrictionVsSlipGraphRecipx1Minusx0( inSource ) )
		,FrictionVsSlipGraphRecipx2Minusx1( getPxVehicleTireData_FrictionVsSlipGraphRecipx2Minusx1( inSource ) )
		,MLatStiffX( inSource->mLatStiffX )
		,MLatStiffY( inSource->mLatStiffY )
		,MLongitudinalStiffnessPerUnitGravity( inSource->mLongitudinalStiffnessPerUnitGravity )
		,MCamberStiffnessPerUnitGravity( inSource->mCamberStiffnessPerUnitGravity )
		,MType( inSource->mType )
{
	PX_UNUSED(inSource);
	PxMemCopy( MFrictionVsSlipGraph, inSource->mFrictionVsSlipGraph, sizeof( MFrictionVsSlipGraph ) );
}
const PxReal * getPxVehicleWheels4SimData_TireRestLoadsArray( const PxVehicleWheels4SimData* inObj ) { return inObj->getTireRestLoadsArray(); }
const PxReal * getPxVehicleWheels4SimData_RecipTireRestLoadsArray( const PxVehicleWheels4SimData* inObj ) { return inObj->getRecipTireRestLoadsArray(); }
 PxVehicleWheels4SimDataGeneratedInfo::PxVehicleWheels4SimDataGeneratedInfo()
	: TireRestLoadsArray( "TireRestLoadsArray", getPxVehicleWheels4SimData_TireRestLoadsArray)
	, RecipTireRestLoadsArray( "RecipTireRestLoadsArray", getPxVehicleWheels4SimData_RecipTireRestLoadsArray)
{}
 PxVehicleWheels4SimDataGeneratedValues::PxVehicleWheels4SimDataGeneratedValues( const PxVehicleWheels4SimData* inSource )
		:TireRestLoadsArray( getPxVehicleWheels4SimData_TireRestLoadsArray( inSource ) )
		,RecipTireRestLoadsArray( getPxVehicleWheels4SimData_RecipTireRestLoadsArray( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxVehicleWheelsSimData_ChassisMass( PxVehicleWheelsSimData* inObj, const PxF32 inArg){ inObj->setChassisMass( inArg ); }
PxVehicleSuspensionData getPxVehicleWheelsSimData_SuspensionData( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getSuspensionData( index ); }
PxU32 getNbPxVehicleWheelsSimData_SuspensionData( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbSuspensionData(  ); }
void setPxVehicleWheelsSimData_SuspensionData( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVehicleSuspensionData inValue ){ inObj->setSuspensionData( inIndex, inValue ); }
PxVehicleWheelData getPxVehicleWheelsSimData_WheelData( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getWheelData( index ); }
PxU32 getNbPxVehicleWheelsSimData_WheelData( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbWheelData(  ); }
void setPxVehicleWheelsSimData_WheelData( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVehicleWheelData inValue ){ inObj->setWheelData( inIndex, inValue ); }
PxVehicleTireData getPxVehicleWheelsSimData_TireData( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getTireData( index ); }
PxU32 getNbPxVehicleWheelsSimData_TireData( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbTireData(  ); }
void setPxVehicleWheelsSimData_TireData( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVehicleTireData inValue ){ inObj->setTireData( inIndex, inValue ); }
PxVec3 getPxVehicleWheelsSimData_SuspTravelDirection( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getSuspTravelDirection( index ); }
PxU32 getNbPxVehicleWheelsSimData_SuspTravelDirection( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbSuspTravelDirection(  ); }
void setPxVehicleWheelsSimData_SuspTravelDirection( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVec3 inValue ){ inObj->setSuspTravelDirection( inIndex, inValue ); }
PxVec3 getPxVehicleWheelsSimData_SuspForceAppPointOffset( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getSuspForceAppPointOffset( index ); }
PxU32 getNbPxVehicleWheelsSimData_SuspForceAppPointOffset( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbSuspForceAppPointOffset(  ); }
void setPxVehicleWheelsSimData_SuspForceAppPointOffset( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVec3 inValue ){ inObj->setSuspForceAppPointOffset( inIndex, inValue ); }
PxVec3 getPxVehicleWheelsSimData_TireForceAppPointOffset( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getTireForceAppPointOffset( index ); }
PxU32 getNbPxVehicleWheelsSimData_TireForceAppPointOffset( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbTireForceAppPointOffset(  ); }
void setPxVehicleWheelsSimData_TireForceAppPointOffset( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVec3 inValue ){ inObj->setTireForceAppPointOffset( inIndex, inValue ); }
PxVec3 getPxVehicleWheelsSimData_WheelCentreOffset( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getWheelCentreOffset( index ); }
PxU32 getNbPxVehicleWheelsSimData_WheelCentreOffset( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbWheelCentreOffset(  ); }
void setPxVehicleWheelsSimData_WheelCentreOffset( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVec3 inValue ){ inObj->setWheelCentreOffset( inIndex, inValue ); }
PxI32 getPxVehicleWheelsSimData_WheelShapeMapping( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getWheelShapeMapping( index ); }
PxU32 getNbPxVehicleWheelsSimData_WheelShapeMapping( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbWheelShapeMapping(  ); }
void setPxVehicleWheelsSimData_WheelShapeMapping( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxI32 inValue ){ inObj->setWheelShapeMapping( inIndex, inValue ); }
PxFilterData getPxVehicleWheelsSimData_SceneQueryFilterData( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getSceneQueryFilterData( index ); }
PxU32 getNbPxVehicleWheelsSimData_SceneQueryFilterData( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbSceneQueryFilterData(  ); }
void setPxVehicleWheelsSimData_SceneQueryFilterData( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxFilterData inValue ){ inObj->setSceneQueryFilterData( inIndex, inValue ); }
PxVehicleAntiRollBarData getPxVehicleWheelsSimData_AntiRollBarData( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getAntiRollBarData( index ); }
PxU32 getNbPxVehicleWheelsSimData_AntiRollBarData( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbAntiRollBarData(  ); }
void setPxVehicleWheelsSimData_AntiRollBarData( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, PxVehicleAntiRollBarData inValue ){ inObj->setAntiRollBarData( inIndex, inValue ); }
void setPxVehicleWheelsSimData_TireLoadFilterData( PxVehicleWheelsSimData* inObj, const PxVehicleTireLoadFilterData & inArg){ inObj->setTireLoadFilterData( inArg ); }
PxVehicleTireLoadFilterData getPxVehicleWheelsSimData_TireLoadFilterData( const PxVehicleWheelsSimData* inObj ) { return inObj->getTireLoadFilterData(); }
void setPxVehicleWheelsSimData_MinLongSlipDenominator( PxVehicleWheelsSimData* inObj, const PxReal inArg){ inObj->setMinLongSlipDenominator( inArg ); }
PxF32 getPxVehicleWheelsSimData_MinLongSlipDenominator( const PxVehicleWheelsSimData* inObj ) { return inObj->getMinLongSlipDenominator(); }
void setPxVehicleWheelsSimData_ThresholdLongSpeed( PxVehicleWheelsSimData* inObj, const PxF32 inArg){ inObj->setThresholdLongSpeed( inArg ); }
PxF32 getPxVehicleWheelsSimData_ThresholdLongSpeed( const PxVehicleWheelsSimData* inObj ) { return inObj->getThresholdLongSpeed(); }
void setPxVehicleWheelsSimData_LowForwardSpeedSubStepCount( PxVehicleWheelsSimData* inObj, const PxU32 inArg){ inObj->setLowForwardSpeedSubStepCount( inArg ); }
PxU32 getPxVehicleWheelsSimData_LowForwardSpeedSubStepCount( const PxVehicleWheelsSimData* inObj ) { return inObj->getLowForwardSpeedSubStepCount(); }
void setPxVehicleWheelsSimData_HighForwardSpeedSubStepCount( PxVehicleWheelsSimData* inObj, const PxU32 inArg){ inObj->setHighForwardSpeedSubStepCount( inArg ); }
PxU32 getPxVehicleWheelsSimData_HighForwardSpeedSubStepCount( const PxVehicleWheelsSimData* inObj ) { return inObj->getHighForwardSpeedSubStepCount(); }
_Bool getPxVehicleWheelsSimData_WheelEnabledState( const PxVehicleWheelsSimData* inObj, const PxU32 index ) { return inObj->getWheelEnabledState( index ); }
PxU32 getNbPxVehicleWheelsSimData_WheelEnabledState( const PxVehicleWheelsSimData* inObj ) { return inObj->getNbWheelEnabledState(  ); }
void setPxVehicleWheelsSimData_WheelEnabledState( PxVehicleWheelsSimData* inObj, const PxU32 inIndex, _Bool inValue ){ inObj->setWheelEnabledState( inIndex, inValue ); }
 PxVehicleWheelsSimDataGeneratedInfo::PxVehicleWheelsSimDataGeneratedInfo()
	: ChassisMass( "ChassisMass", setPxVehicleWheelsSimData_ChassisMass)
	, SuspensionData( "SuspensionData", getPxVehicleWheelsSimData_SuspensionData, getNbPxVehicleWheelsSimData_SuspensionData, setPxVehicleWheelsSimData_SuspensionData )
	, WheelData( "WheelData", getPxVehicleWheelsSimData_WheelData, getNbPxVehicleWheelsSimData_WheelData, setPxVehicleWheelsSimData_WheelData )
	, TireData( "TireData", getPxVehicleWheelsSimData_TireData, getNbPxVehicleWheelsSimData_TireData, setPxVehicleWheelsSimData_TireData )
	, SuspTravelDirection( "SuspTravelDirection", getPxVehicleWheelsSimData_SuspTravelDirection, getNbPxVehicleWheelsSimData_SuspTravelDirection, setPxVehicleWheelsSimData_SuspTravelDirection )
	, SuspForceAppPointOffset( "SuspForceAppPointOffset", getPxVehicleWheelsSimData_SuspForceAppPointOffset, getNbPxVehicleWheelsSimData_SuspForceAppPointOffset, setPxVehicleWheelsSimData_SuspForceAppPointOffset )
	, TireForceAppPointOffset( "TireForceAppPointOffset", getPxVehicleWheelsSimData_TireForceAppPointOffset, getNbPxVehicleWheelsSimData_TireForceAppPointOffset, setPxVehicleWheelsSimData_TireForceAppPointOffset )
	, WheelCentreOffset( "WheelCentreOffset", getPxVehicleWheelsSimData_WheelCentreOffset, getNbPxVehicleWheelsSimData_WheelCentreOffset, setPxVehicleWheelsSimData_WheelCentreOffset )
	, WheelShapeMapping( "WheelShapeMapping", getPxVehicleWheelsSimData_WheelShapeMapping, getNbPxVehicleWheelsSimData_WheelShapeMapping, setPxVehicleWheelsSimData_WheelShapeMapping )
	, SceneQueryFilterData( "SceneQueryFilterData", getPxVehicleWheelsSimData_SceneQueryFilterData, getNbPxVehicleWheelsSimData_SceneQueryFilterData, setPxVehicleWheelsSimData_SceneQueryFilterData )
	, AntiRollBarData( "AntiRollBarData", getPxVehicleWheelsSimData_AntiRollBarData, getNbPxVehicleWheelsSimData_AntiRollBarData, setPxVehicleWheelsSimData_AntiRollBarData )
	, TireLoadFilterData( "TireLoadFilterData", setPxVehicleWheelsSimData_TireLoadFilterData, getPxVehicleWheelsSimData_TireLoadFilterData)
	, MinLongSlipDenominator( "MinLongSlipDenominator", setPxVehicleWheelsSimData_MinLongSlipDenominator, getPxVehicleWheelsSimData_MinLongSlipDenominator)
	, ThresholdLongSpeed( "ThresholdLongSpeed", setPxVehicleWheelsSimData_ThresholdLongSpeed, getPxVehicleWheelsSimData_ThresholdLongSpeed)
	, LowForwardSpeedSubStepCount( "LowForwardSpeedSubStepCount", setPxVehicleWheelsSimData_LowForwardSpeedSubStepCount, getPxVehicleWheelsSimData_LowForwardSpeedSubStepCount)
	, HighForwardSpeedSubStepCount( "HighForwardSpeedSubStepCount", setPxVehicleWheelsSimData_HighForwardSpeedSubStepCount, getPxVehicleWheelsSimData_HighForwardSpeedSubStepCount)
	, WheelEnabledState( "WheelEnabledState", getPxVehicleWheelsSimData_WheelEnabledState, getNbPxVehicleWheelsSimData_WheelEnabledState, setPxVehicleWheelsSimData_WheelEnabledState )
{}
 PxVehicleWheelsSimDataGeneratedValues::PxVehicleWheelsSimDataGeneratedValues( const PxVehicleWheelsSimData* inSource )
		:TireLoadFilterData( getPxVehicleWheelsSimData_TireLoadFilterData( inSource ) )
		,MinLongSlipDenominator( getPxVehicleWheelsSimData_MinLongSlipDenominator( inSource ) )
		,ThresholdLongSpeed( getPxVehicleWheelsSimData_ThresholdLongSpeed( inSource ) )
		,LowForwardSpeedSubStepCount( getPxVehicleWheelsSimData_LowForwardSpeedSubStepCount( inSource ) )
		,HighForwardSpeedSubStepCount( getPxVehicleWheelsSimData_HighForwardSpeedSubStepCount( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxVehicleWheelsDynData_TireForceShaderFunction( PxVehicleWheelsDynData* inObj, PxVehicleComputeTireForce inArg){ inObj->setTireForceShaderFunction( inArg ); }
PxReal getPxVehicleWheelsDynData_WheelRotationSpeed( const PxVehicleWheelsDynData* inObj, const PxU32 index ) { return inObj->getWheelRotationSpeed( index ); }
PxU32 getNbPxVehicleWheelsDynData_WheelRotationSpeed( const PxVehicleWheelsDynData* inObj ) { return inObj->getNbWheelRotationSpeed(  ); }
void setPxVehicleWheelsDynData_WheelRotationSpeed( PxVehicleWheelsDynData* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setWheelRotationSpeed( inIndex, inValue ); }
PxReal getPxVehicleWheelsDynData_WheelRotationAngle( const PxVehicleWheelsDynData* inObj, const PxU32 index ) { return inObj->getWheelRotationAngle( index ); }
PxU32 getNbPxVehicleWheelsDynData_WheelRotationAngle( const PxVehicleWheelsDynData* inObj ) { return inObj->getNbWheelRotationAngle(  ); }
void setPxVehicleWheelsDynData_WheelRotationAngle( PxVehicleWheelsDynData* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setWheelRotationAngle( inIndex, inValue ); }
PxVehicleWheels4DynData * getPxVehicleWheelsDynData_Wheel4DynData( const PxVehicleWheelsDynData* inObj ) { return inObj->getWheel4DynData(); }
 PxVehicleWheelsDynDataGeneratedInfo::PxVehicleWheelsDynDataGeneratedInfo()
	: TireForceShaderFunction( "TireForceShaderFunction", setPxVehicleWheelsDynData_TireForceShaderFunction)
	, WheelRotationSpeed( "WheelRotationSpeed", getPxVehicleWheelsDynData_WheelRotationSpeed, getNbPxVehicleWheelsDynData_WheelRotationSpeed, setPxVehicleWheelsDynData_WheelRotationSpeed )
	, WheelRotationAngle( "WheelRotationAngle", getPxVehicleWheelsDynData_WheelRotationAngle, getNbPxVehicleWheelsDynData_WheelRotationAngle, setPxVehicleWheelsDynData_WheelRotationAngle )
	, Wheel4DynData( "Wheel4DynData", getPxVehicleWheelsDynData_Wheel4DynData)
{}
 PxVehicleWheelsDynDataGeneratedValues::PxVehicleWheelsDynDataGeneratedValues( const PxVehicleWheelsDynData* inSource )
		:Wheel4DynData( getPxVehicleWheelsDynData_Wheel4DynData( inSource ) )
{
	PX_UNUSED(inSource);
}
PxU32 getPxVehicleWheels_VehicleType( const PxVehicleWheels* inObj ) { return inObj->getVehicleType(); }
const PxRigidDynamic * getPxVehicleWheels_RigidDynamicActor( const PxVehicleWheels* inObj ) { return inObj->getRigidDynamicActor(); }
const char * getPxVehicleWheels_ConcreteTypeName( const PxVehicleWheels* inObj ) { return inObj->getConcreteTypeName(); }
inline PxVehicleWheelsSimData getPxVehicleWheelsMWheelsSimData( const PxVehicleWheels* inOwner ) { return inOwner->mWheelsSimData; }
inline void setPxVehicleWheelsMWheelsSimData( PxVehicleWheels* inOwner, PxVehicleWheelsSimData inData) { inOwner->mWheelsSimData = inData; }
inline PxVehicleWheelsDynData getPxVehicleWheelsMWheelsDynData( const PxVehicleWheels* inOwner ) { return inOwner->mWheelsDynData; }
inline void setPxVehicleWheelsMWheelsDynData( PxVehicleWheels* inOwner, PxVehicleWheelsDynData inData) { inOwner->mWheelsDynData = inData; }
 PxVehicleWheelsGeneratedInfo::PxVehicleWheelsGeneratedInfo()
	: VehicleType( "VehicleType", getPxVehicleWheels_VehicleType)
	, RigidDynamicActor( "RigidDynamicActor", getPxVehicleWheels_RigidDynamicActor)
	, ConcreteTypeName( "ConcreteTypeName", getPxVehicleWheels_ConcreteTypeName)
	, MWheelsSimData( "MWheelsSimData", setPxVehicleWheelsMWheelsSimData, getPxVehicleWheelsMWheelsSimData )
	, MWheelsDynData( "MWheelsDynData", setPxVehicleWheelsMWheelsDynData, getPxVehicleWheelsMWheelsDynData )
{}
 PxVehicleWheelsGeneratedValues::PxVehicleWheelsGeneratedValues( const PxVehicleWheels* inSource )
		:VehicleType( getPxVehicleWheels_VehicleType( inSource ) )
		,RigidDynamicActor( getPxVehicleWheels_RigidDynamicActor( inSource ) )
		,ConcreteTypeName( getPxVehicleWheels_ConcreteTypeName( inSource ) )
		,MWheelsSimData( inSource->mWheelsSimData )
		,MWheelsDynData( inSource->mWheelsDynData )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleDriveDynData_AnalogInput( const PxVehicleDriveDynData* inObj, const PxU32 index ) { return inObj->getAnalogInput( index ); }
PxU32 getNbPxVehicleDriveDynData_AnalogInput( const PxVehicleDriveDynData* inObj ) { return inObj->getNbAnalogInput(  ); }
void setPxVehicleDriveDynData_AnalogInput( PxVehicleDriveDynData* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setAnalogInput( inIndex, inValue ); }
void setPxVehicleDriveDynData_GearUp( PxVehicleDriveDynData* inObj, const _Bool inArg){ inObj->setGearUp( inArg ); }
_Bool getPxVehicleDriveDynData_GearUp( const PxVehicleDriveDynData* inObj ) { return inObj->getGearUp(); }
void setPxVehicleDriveDynData_GearDown( PxVehicleDriveDynData* inObj, const _Bool inArg){ inObj->setGearDown( inArg ); }
_Bool getPxVehicleDriveDynData_GearDown( const PxVehicleDriveDynData* inObj ) { return inObj->getGearDown(); }
void setPxVehicleDriveDynData_UseAutoGears( PxVehicleDriveDynData* inObj, const _Bool inArg){ inObj->setUseAutoGears( inArg ); }
_Bool getPxVehicleDriveDynData_UseAutoGears( const PxVehicleDriveDynData* inObj ) { return inObj->getUseAutoGears(); }
void setPxVehicleDriveDynData_CurrentGear( PxVehicleDriveDynData* inObj, PxU32 inArg){ inObj->setCurrentGear( inArg ); }
PxU32 getPxVehicleDriveDynData_CurrentGear( const PxVehicleDriveDynData* inObj ) { return inObj->getCurrentGear(); }
void setPxVehicleDriveDynData_TargetGear( PxVehicleDriveDynData* inObj, PxU32 inArg){ inObj->setTargetGear( inArg ); }
PxU32 getPxVehicleDriveDynData_TargetGear( const PxVehicleDriveDynData* inObj ) { return inObj->getTargetGear(); }
void setPxVehicleDriveDynData_EngineRotationSpeed( PxVehicleDriveDynData* inObj, const PxF32 inArg){ inObj->setEngineRotationSpeed( inArg ); }
PxReal getPxVehicleDriveDynData_EngineRotationSpeed( const PxVehicleDriveDynData* inObj ) { return inObj->getEngineRotationSpeed(); }
void setPxVehicleDriveDynData_GearChange( PxVehicleDriveDynData* inObj, const PxU32 inArg){ inObj->setGearChange( inArg ); }
PxU32 getPxVehicleDriveDynData_GearChange( const PxVehicleDriveDynData* inObj ) { return inObj->getGearChange(); }
void setPxVehicleDriveDynData_GearSwitchTime( PxVehicleDriveDynData* inObj, const PxReal inArg){ inObj->setGearSwitchTime( inArg ); }
PxReal getPxVehicleDriveDynData_GearSwitchTime( const PxVehicleDriveDynData* inObj ) { return inObj->getGearSwitchTime(); }
void setPxVehicleDriveDynData_AutoBoxSwitchTime( PxVehicleDriveDynData* inObj, const PxReal inArg){ inObj->setAutoBoxSwitchTime( inArg ); }
PxReal getPxVehicleDriveDynData_AutoBoxSwitchTime( const PxVehicleDriveDynData* inObj ) { return inObj->getAutoBoxSwitchTime(); }
inline _Bool getPxVehicleDriveDynDataMUseAutoGears( const PxVehicleDriveDynData* inOwner ) { return inOwner->mUseAutoGears; }
inline void setPxVehicleDriveDynDataMUseAutoGears( PxVehicleDriveDynData* inOwner, _Bool inData) { inOwner->mUseAutoGears = inData; }
inline _Bool getPxVehicleDriveDynDataMGearUpPressed( const PxVehicleDriveDynData* inOwner ) { return inOwner->mGearUpPressed; }
inline void setPxVehicleDriveDynDataMGearUpPressed( PxVehicleDriveDynData* inOwner, _Bool inData) { inOwner->mGearUpPressed = inData; }
inline _Bool getPxVehicleDriveDynDataMGearDownPressed( const PxVehicleDriveDynData* inOwner ) { return inOwner->mGearDownPressed; }
inline void setPxVehicleDriveDynDataMGearDownPressed( PxVehicleDriveDynData* inOwner, _Bool inData) { inOwner->mGearDownPressed = inData; }
inline PxU32 getPxVehicleDriveDynDataMCurrentGear( const PxVehicleDriveDynData* inOwner ) { return inOwner->mCurrentGear; }
inline void setPxVehicleDriveDynDataMCurrentGear( PxVehicleDriveDynData* inOwner, PxU32 inData) { inOwner->mCurrentGear = inData; }
inline PxU32 getPxVehicleDriveDynDataMTargetGear( const PxVehicleDriveDynData* inOwner ) { return inOwner->mTargetGear; }
inline void setPxVehicleDriveDynDataMTargetGear( PxVehicleDriveDynData* inOwner, PxU32 inData) { inOwner->mTargetGear = inData; }
inline PxReal getPxVehicleDriveDynDataMEnginespeed( const PxVehicleDriveDynData* inOwner ) { return inOwner->mEnginespeed; }
inline void setPxVehicleDriveDynDataMEnginespeed( PxVehicleDriveDynData* inOwner, PxReal inData) { inOwner->mEnginespeed = inData; }
inline PxReal getPxVehicleDriveDynDataMGearSwitchTime( const PxVehicleDriveDynData* inOwner ) { return inOwner->mGearSwitchTime; }
inline void setPxVehicleDriveDynDataMGearSwitchTime( PxVehicleDriveDynData* inOwner, PxReal inData) { inOwner->mGearSwitchTime = inData; }
inline PxReal getPxVehicleDriveDynDataMAutoBoxSwitchTime( const PxVehicleDriveDynData* inOwner ) { return inOwner->mAutoBoxSwitchTime; }
inline void setPxVehicleDriveDynDataMAutoBoxSwitchTime( PxVehicleDriveDynData* inOwner, PxReal inData) { inOwner->mAutoBoxSwitchTime = inData; }
 PxVehicleDriveDynDataGeneratedInfo::PxVehicleDriveDynDataGeneratedInfo()
	: AnalogInput( "AnalogInput", getPxVehicleDriveDynData_AnalogInput, getNbPxVehicleDriveDynData_AnalogInput, setPxVehicleDriveDynData_AnalogInput )
	, GearUp( "GearUp", setPxVehicleDriveDynData_GearUp, getPxVehicleDriveDynData_GearUp)
	, GearDown( "GearDown", setPxVehicleDriveDynData_GearDown, getPxVehicleDriveDynData_GearDown)
	, UseAutoGears( "UseAutoGears", setPxVehicleDriveDynData_UseAutoGears, getPxVehicleDriveDynData_UseAutoGears)
	, CurrentGear( "CurrentGear", setPxVehicleDriveDynData_CurrentGear, getPxVehicleDriveDynData_CurrentGear)
	, TargetGear( "TargetGear", setPxVehicleDriveDynData_TargetGear, getPxVehicleDriveDynData_TargetGear)
	, EngineRotationSpeed( "EngineRotationSpeed", setPxVehicleDriveDynData_EngineRotationSpeed, getPxVehicleDriveDynData_EngineRotationSpeed)
	, GearChange( "GearChange", setPxVehicleDriveDynData_GearChange, getPxVehicleDriveDynData_GearChange)
	, GearSwitchTime( "GearSwitchTime", setPxVehicleDriveDynData_GearSwitchTime, getPxVehicleDriveDynData_GearSwitchTime)
	, AutoBoxSwitchTime( "AutoBoxSwitchTime", setPxVehicleDriveDynData_AutoBoxSwitchTime, getPxVehicleDriveDynData_AutoBoxSwitchTime)
	, MUseAutoGears( "MUseAutoGears", setPxVehicleDriveDynDataMUseAutoGears, getPxVehicleDriveDynDataMUseAutoGears )
	, MGearUpPressed( "MGearUpPressed", setPxVehicleDriveDynDataMGearUpPressed, getPxVehicleDriveDynDataMGearUpPressed )
	, MGearDownPressed( "MGearDownPressed", setPxVehicleDriveDynDataMGearDownPressed, getPxVehicleDriveDynDataMGearDownPressed )
	, MCurrentGear( "MCurrentGear", setPxVehicleDriveDynDataMCurrentGear, getPxVehicleDriveDynDataMCurrentGear )
	, MTargetGear( "MTargetGear", setPxVehicleDriveDynDataMTargetGear, getPxVehicleDriveDynDataMTargetGear )
	, MEnginespeed( "MEnginespeed", setPxVehicleDriveDynDataMEnginespeed, getPxVehicleDriveDynDataMEnginespeed )
	, MGearSwitchTime( "MGearSwitchTime", setPxVehicleDriveDynDataMGearSwitchTime, getPxVehicleDriveDynDataMGearSwitchTime )
	, MAutoBoxSwitchTime( "MAutoBoxSwitchTime", setPxVehicleDriveDynDataMAutoBoxSwitchTime, getPxVehicleDriveDynDataMAutoBoxSwitchTime )
{}
 PxVehicleDriveDynDataGeneratedValues::PxVehicleDriveDynDataGeneratedValues( const PxVehicleDriveDynData* inSource )
		:GearUp( getPxVehicleDriveDynData_GearUp( inSource ) )
		,GearDown( getPxVehicleDriveDynData_GearDown( inSource ) )
		,UseAutoGears( getPxVehicleDriveDynData_UseAutoGears( inSource ) )
		,CurrentGear( getPxVehicleDriveDynData_CurrentGear( inSource ) )
		,TargetGear( getPxVehicleDriveDynData_TargetGear( inSource ) )
		,EngineRotationSpeed( getPxVehicleDriveDynData_EngineRotationSpeed( inSource ) )
		,GearChange( getPxVehicleDriveDynData_GearChange( inSource ) )
		,GearSwitchTime( getPxVehicleDriveDynData_GearSwitchTime( inSource ) )
		,AutoBoxSwitchTime( getPxVehicleDriveDynData_AutoBoxSwitchTime( inSource ) )
		,MUseAutoGears( inSource->mUseAutoGears )
		,MGearUpPressed( inSource->mGearUpPressed )
		,MGearDownPressed( inSource->mGearDownPressed )
		,MCurrentGear( inSource->mCurrentGear )
		,MTargetGear( inSource->mTargetGear )
		,MEnginespeed( inSource->mEnginespeed )
		,MGearSwitchTime( inSource->mGearSwitchTime )
		,MAutoBoxSwitchTime( inSource->mAutoBoxSwitchTime )
{
	PX_UNUSED(inSource);
}
void setPxVehicleDriveSimData_EngineData( PxVehicleDriveSimData* inObj, const PxVehicleEngineData & inArg){ inObj->setEngineData( inArg ); }
PxVehicleEngineData getPxVehicleDriveSimData_EngineData( const PxVehicleDriveSimData* inObj ) { return inObj->getEngineData(); }
void setPxVehicleDriveSimData_GearsData( PxVehicleDriveSimData* inObj, const PxVehicleGearsData & inArg){ inObj->setGearsData( inArg ); }
PxVehicleGearsData getPxVehicleDriveSimData_GearsData( const PxVehicleDriveSimData* inObj ) { return inObj->getGearsData(); }
void setPxVehicleDriveSimData_ClutchData( PxVehicleDriveSimData* inObj, const PxVehicleClutchData & inArg){ inObj->setClutchData( inArg ); }
PxVehicleClutchData getPxVehicleDriveSimData_ClutchData( const PxVehicleDriveSimData* inObj ) { return inObj->getClutchData(); }
void setPxVehicleDriveSimData_AutoBoxData( PxVehicleDriveSimData* inObj, const PxVehicleAutoBoxData & inArg){ inObj->setAutoBoxData( inArg ); }
PxVehicleAutoBoxData getPxVehicleDriveSimData_AutoBoxData( const PxVehicleDriveSimData* inObj ) { return inObj->getAutoBoxData(); }
 PxVehicleDriveSimDataGeneratedInfo::PxVehicleDriveSimDataGeneratedInfo()
	: EngineData( "EngineData", setPxVehicleDriveSimData_EngineData, getPxVehicleDriveSimData_EngineData)
	, GearsData( "GearsData", setPxVehicleDriveSimData_GearsData, getPxVehicleDriveSimData_GearsData)
	, ClutchData( "ClutchData", setPxVehicleDriveSimData_ClutchData, getPxVehicleDriveSimData_ClutchData)
	, AutoBoxData( "AutoBoxData", setPxVehicleDriveSimData_AutoBoxData, getPxVehicleDriveSimData_AutoBoxData)
{}
 PxVehicleDriveSimDataGeneratedValues::PxVehicleDriveSimDataGeneratedValues( const PxVehicleDriveSimData* inSource )
		:EngineData( getPxVehicleDriveSimData_EngineData( inSource ) )
		,GearsData( getPxVehicleDriveSimData_GearsData( inSource ) )
		,ClutchData( getPxVehicleDriveSimData_ClutchData( inSource ) )
		,AutoBoxData( getPxVehicleDriveSimData_AutoBoxData( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxVehicleDriveSimData4W_DiffData( PxVehicleDriveSimData4W* inObj, const PxVehicleDifferential4WData & inArg){ inObj->setDiffData( inArg ); }
PxVehicleDifferential4WData getPxVehicleDriveSimData4W_DiffData( const PxVehicleDriveSimData4W* inObj ) { return inObj->getDiffData(); }
void setPxVehicleDriveSimData4W_AckermannGeometryData( PxVehicleDriveSimData4W* inObj, const PxVehicleAckermannGeometryData & inArg){ inObj->setAckermannGeometryData( inArg ); }
PxVehicleAckermannGeometryData getPxVehicleDriveSimData4W_AckermannGeometryData( const PxVehicleDriveSimData4W* inObj ) { return inObj->getAckermannGeometryData(); }
 PxVehicleDriveSimData4WGeneratedInfo::PxVehicleDriveSimData4WGeneratedInfo()
	: DiffData( "DiffData", setPxVehicleDriveSimData4W_DiffData, getPxVehicleDriveSimData4W_DiffData)
	, AckermannGeometryData( "AckermannGeometryData", setPxVehicleDriveSimData4W_AckermannGeometryData, getPxVehicleDriveSimData4W_AckermannGeometryData)
{}
 PxVehicleDriveSimData4WGeneratedValues::PxVehicleDriveSimData4WGeneratedValues( const PxVehicleDriveSimData4W* inSource )
		:PxVehicleDriveSimDataGeneratedValues( inSource )
		,DiffData( getPxVehicleDriveSimData4W_DiffData( inSource ) )
		,AckermannGeometryData( getPxVehicleDriveSimData4W_AckermannGeometryData( inSource ) )
{
	PX_UNUSED(inSource);
}
const char * getPxVehicleDrive_ConcreteTypeName( const PxVehicleDrive* inObj ) { return inObj->getConcreteTypeName(); }
inline PxVehicleDriveDynData getPxVehicleDriveMDriveDynData( const PxVehicleDrive* inOwner ) { return inOwner->mDriveDynData; }
inline void setPxVehicleDriveMDriveDynData( PxVehicleDrive* inOwner, PxVehicleDriveDynData inData) { inOwner->mDriveDynData = inData; }
 PxVehicleDriveGeneratedInfo::PxVehicleDriveGeneratedInfo()
	: ConcreteTypeName( "ConcreteTypeName", getPxVehicleDrive_ConcreteTypeName)
	, MDriveDynData( "MDriveDynData", setPxVehicleDriveMDriveDynData, getPxVehicleDriveMDriveDynData )
{}
 PxVehicleDriveGeneratedValues::PxVehicleDriveGeneratedValues( const PxVehicleDrive* inSource )
		:PxVehicleWheelsGeneratedValues( inSource )
		,ConcreteTypeName( getPxVehicleDrive_ConcreteTypeName( inSource ) )
		,MDriveDynData( inSource->mDriveDynData )
{
	PX_UNUSED(inSource);
}
const char * getPxVehicleDrive4W_ConcreteTypeName( const PxVehicleDrive4W* inObj ) { return inObj->getConcreteTypeName(); }
inline PxVehicleDriveSimData4W getPxVehicleDrive4WMDriveSimData( const PxVehicleDrive4W* inOwner ) { return inOwner->mDriveSimData; }
inline void setPxVehicleDrive4WMDriveSimData( PxVehicleDrive4W* inOwner, PxVehicleDriveSimData4W inData) { inOwner->mDriveSimData = inData; }
 PxVehicleDrive4WGeneratedInfo::PxVehicleDrive4WGeneratedInfo()
	: ConcreteTypeName( "ConcreteTypeName", getPxVehicleDrive4W_ConcreteTypeName)
	, MDriveSimData( "MDriveSimData", setPxVehicleDrive4WMDriveSimData, getPxVehicleDrive4WMDriveSimData )
{}
 PxVehicleDrive4WGeneratedValues::PxVehicleDrive4WGeneratedValues( const PxVehicleDrive4W* inSource )
		:PxVehicleDriveGeneratedValues( inSource )
		,ConcreteTypeName( getPxVehicleDrive4W_ConcreteTypeName( inSource ) )
		,MDriveSimData( inSource->mDriveSimData )
{
	PX_UNUSED(inSource);
}
void setPxVehicleDriveTank_DriveModel( PxVehicleDriveTank* inObj, const PxVehicleDriveTankControlModel::Enum inArg){ inObj->setDriveModel( inArg ); }
PxVehicleDriveTankControlModel::Enum getPxVehicleDriveTank_DriveModel( const PxVehicleDriveTank* inObj ) { return inObj->getDriveModel(); }
const char * getPxVehicleDriveTank_ConcreteTypeName( const PxVehicleDriveTank* inObj ) { return inObj->getConcreteTypeName(); }
inline PxVehicleDriveSimData getPxVehicleDriveTankMDriveSimData( const PxVehicleDriveTank* inOwner ) { return inOwner->mDriveSimData; }
inline void setPxVehicleDriveTankMDriveSimData( PxVehicleDriveTank* inOwner, PxVehicleDriveSimData inData) { inOwner->mDriveSimData = inData; }
 PxVehicleDriveTankGeneratedInfo::PxVehicleDriveTankGeneratedInfo()
	: DriveModel( "DriveModel", setPxVehicleDriveTank_DriveModel, getPxVehicleDriveTank_DriveModel)
	, ConcreteTypeName( "ConcreteTypeName", getPxVehicleDriveTank_ConcreteTypeName)
	, MDriveSimData( "MDriveSimData", setPxVehicleDriveTankMDriveSimData, getPxVehicleDriveTankMDriveSimData )
{}
 PxVehicleDriveTankGeneratedValues::PxVehicleDriveTankGeneratedValues( const PxVehicleDriveTank* inSource )
		:PxVehicleDriveGeneratedValues( inSource )
		,DriveModel( getPxVehicleDriveTank_DriveModel( inSource ) )
		,ConcreteTypeName( getPxVehicleDriveTank_ConcreteTypeName( inSource ) )
		,MDriveSimData( inSource->mDriveSimData )
{
	PX_UNUSED(inSource);
}
void setPxVehicleDriveSimDataNW_DiffData( PxVehicleDriveSimDataNW* inObj, const PxVehicleDifferentialNWData & inArg){ inObj->setDiffData( inArg ); }
PxVehicleDifferentialNWData getPxVehicleDriveSimDataNW_DiffData( const PxVehicleDriveSimDataNW* inObj ) { return inObj->getDiffData(); }
 PxVehicleDriveSimDataNWGeneratedInfo::PxVehicleDriveSimDataNWGeneratedInfo()
	: DiffData( "DiffData", setPxVehicleDriveSimDataNW_DiffData, getPxVehicleDriveSimDataNW_DiffData)
{}
 PxVehicleDriveSimDataNWGeneratedValues::PxVehicleDriveSimDataNWGeneratedValues( const PxVehicleDriveSimDataNW* inSource )
		:PxVehicleDriveSimDataGeneratedValues( inSource )
		,DiffData( getPxVehicleDriveSimDataNW_DiffData( inSource ) )
{
	PX_UNUSED(inSource);
}
const char * getPxVehicleDriveNW_ConcreteTypeName( const PxVehicleDriveNW* inObj ) { return inObj->getConcreteTypeName(); }
inline PxVehicleDriveSimDataNW getPxVehicleDriveNWMDriveSimData( const PxVehicleDriveNW* inOwner ) { return inOwner->mDriveSimData; }
inline void setPxVehicleDriveNWMDriveSimData( PxVehicleDriveNW* inOwner, PxVehicleDriveSimDataNW inData) { inOwner->mDriveSimData = inData; }
 PxVehicleDriveNWGeneratedInfo::PxVehicleDriveNWGeneratedInfo()
	: ConcreteTypeName( "ConcreteTypeName", getPxVehicleDriveNW_ConcreteTypeName)
	, MDriveSimData( "MDriveSimData", setPxVehicleDriveNWMDriveSimData, getPxVehicleDriveNWMDriveSimData )
{}
 PxVehicleDriveNWGeneratedValues::PxVehicleDriveNWGeneratedValues( const PxVehicleDriveNW* inSource )
		:PxVehicleDriveGeneratedValues( inSource )
		,ConcreteTypeName( getPxVehicleDriveNW_ConcreteTypeName( inSource ) )
		,MDriveSimData( inSource->mDriveSimData )
{
	PX_UNUSED(inSource);
}
PxReal getPxVehicleNoDrive_BrakeTorque( const PxVehicleNoDrive* inObj, const PxU32 index ) { return inObj->getBrakeTorque( index ); }
PxU32 getNbPxVehicleNoDrive_BrakeTorque( const PxVehicleNoDrive* inObj ) { return inObj->getNbBrakeTorque(  ); }
void setPxVehicleNoDrive_BrakeTorque( PxVehicleNoDrive* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setBrakeTorque( inIndex, inValue ); }
PxReal getPxVehicleNoDrive_DriveTorque( const PxVehicleNoDrive* inObj, const PxU32 index ) { return inObj->getDriveTorque( index ); }
PxU32 getNbPxVehicleNoDrive_DriveTorque( const PxVehicleNoDrive* inObj ) { return inObj->getNbDriveTorque(  ); }
void setPxVehicleNoDrive_DriveTorque( PxVehicleNoDrive* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setDriveTorque( inIndex, inValue ); }
PxReal getPxVehicleNoDrive_SteerAngle( const PxVehicleNoDrive* inObj, const PxU32 index ) { return inObj->getSteerAngle( index ); }
PxU32 getNbPxVehicleNoDrive_SteerAngle( const PxVehicleNoDrive* inObj ) { return inObj->getNbSteerAngle(  ); }
void setPxVehicleNoDrive_SteerAngle( PxVehicleNoDrive* inObj, const PxU32 inIndex, PxReal inValue ){ inObj->setSteerAngle( inIndex, inValue ); }
const char * getPxVehicleNoDrive_ConcreteTypeName( const PxVehicleNoDrive* inObj ) { return inObj->getConcreteTypeName(); }
 PxVehicleNoDriveGeneratedInfo::PxVehicleNoDriveGeneratedInfo()
	: BrakeTorque( "BrakeTorque", getPxVehicleNoDrive_BrakeTorque, getNbPxVehicleNoDrive_BrakeTorque, setPxVehicleNoDrive_BrakeTorque )
	, DriveTorque( "DriveTorque", getPxVehicleNoDrive_DriveTorque, getNbPxVehicleNoDrive_DriveTorque, setPxVehicleNoDrive_DriveTorque )
	, SteerAngle( "SteerAngle", getPxVehicleNoDrive_SteerAngle, getNbPxVehicleNoDrive_SteerAngle, setPxVehicleNoDrive_SteerAngle )
	, ConcreteTypeName( "ConcreteTypeName", getPxVehicleNoDrive_ConcreteTypeName)
{}
 PxVehicleNoDriveGeneratedValues::PxVehicleNoDriveGeneratedValues( const PxVehicleNoDrive* inSource )
		:PxVehicleWheelsGeneratedValues( inSource )
		,ConcreteTypeName( getPxVehicleNoDrive_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
