//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2018 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#define THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON

#define PX_PROPERTY_INFO_NAME PxVehiclePropertyInfoName
	class PxVehicleChassisData;
	struct PxVehicleChassisDataGeneratedValues
	{
		PxVec3 MMOI;
		PxReal MMass;
		PxVec3 MCMOffset;
		  PxVehicleChassisDataGeneratedValues( const PxVehicleChassisData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleChassisData, MMOI, PxVehicleChassisDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleChassisData, MMass, PxVehicleChassisDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleChassisData, MCMOffset, PxVehicleChassisDataGeneratedValues)
	struct PxVehicleChassisDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleChassisData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleChassisData_MMOI, PxVehicleChassisData, PxVec3, PxVec3 > MMOI;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleChassisData_MMass, PxVehicleChassisData, PxReal, PxReal > MMass;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleChassisData_MCMOffset, PxVehicleChassisData, PxVec3, PxVec3 > MCMOffset;

		 PxVehicleChassisDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleChassisData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MMOI, inStartIndex + 0 );; 
			inOperator( MMass, inStartIndex + 1 );; 
			inOperator( MCMOffset, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleChassisData>
	{ 
		PxVehicleChassisDataGeneratedInfo Info;
		const PxVehicleChassisDataGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxEMPTYConversion[] = {
		{ "PxEmpty", static_cast<PxU32>( physx::PxEmpty ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< const physx::PxEMPTY > { PxEnumTraits() : NameConversion( g_physx__PxEMPTYConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxVehicleEngineData;
	struct PxVehicleEngineDataGeneratedValues
	{
		PxReal RecipMOI;
		PxReal RecipMaxOmega;
		PxReal MMOI;
		PxReal MPeakTorque;
		PxReal MMaxOmega;
		PxReal MDampingRateFullThrottle;
		PxReal MDampingRateZeroThrottleClutchEngaged;
		PxReal MDampingRateZeroThrottleClutchDisengaged;
		  PxVehicleEngineDataGeneratedValues( const PxVehicleEngineData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, RecipMOI, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, RecipMaxOmega, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MMOI, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MPeakTorque, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MMaxOmega, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MDampingRateFullThrottle, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MDampingRateZeroThrottleClutchEngaged, PxVehicleEngineDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleEngineData, MDampingRateZeroThrottleClutchDisengaged, PxVehicleEngineDataGeneratedValues)
	struct PxVehicleEngineDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleEngineData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_RecipMOI, PxVehicleEngineData, PxReal > RecipMOI;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_RecipMaxOmega, PxVehicleEngineData, PxReal > RecipMaxOmega;
		MTorqueCurveProperty MTorqueCurve;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MMOI, PxVehicleEngineData, PxReal, PxReal > MMOI;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MPeakTorque, PxVehicleEngineData, PxReal, PxReal > MPeakTorque;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MMaxOmega, PxVehicleEngineData, PxReal, PxReal > MMaxOmega;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MDampingRateFullThrottle, PxVehicleEngineData, PxReal, PxReal > MDampingRateFullThrottle;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MDampingRateZeroThrottleClutchEngaged, PxVehicleEngineData, PxReal, PxReal > MDampingRateZeroThrottleClutchEngaged;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleEngineData_MDampingRateZeroThrottleClutchDisengaged, PxVehicleEngineData, PxReal, PxReal > MDampingRateZeroThrottleClutchDisengaged;

		 PxVehicleEngineDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleEngineData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 9; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RecipMOI, inStartIndex + 0 );; 
			inOperator( RecipMaxOmega, inStartIndex + 1 );; 
			inOperator( MTorqueCurve, inStartIndex + 2 );; 
			inOperator( MMOI, inStartIndex + 3 );; 
			inOperator( MPeakTorque, inStartIndex + 4 );; 
			inOperator( MMaxOmega, inStartIndex + 5 );; 
			inOperator( MDampingRateFullThrottle, inStartIndex + 6 );; 
			inOperator( MDampingRateZeroThrottleClutchEngaged, inStartIndex + 7 );; 
			inOperator( MDampingRateZeroThrottleClutchDisengaged, inStartIndex + 8 );; 
			return 9 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleEngineData>
	{ 
		PxVehicleEngineDataGeneratedInfo Info;
		const PxVehicleEngineDataGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxVehicleGearsData__EnumConversion[] = {
		{ "eREVERSE", static_cast<PxU32>( physx::PxVehicleGearsData::eREVERSE ) },
		{ "eNEUTRAL", static_cast<PxU32>( physx::PxVehicleGearsData::eNEUTRAL ) },
		{ "eFIRST", static_cast<PxU32>( physx::PxVehicleGearsData::eFIRST ) },
		{ "eSECOND", static_cast<PxU32>( physx::PxVehicleGearsData::eSECOND ) },
		{ "eTHIRD", static_cast<PxU32>( physx::PxVehicleGearsData::eTHIRD ) },
		{ "eFOURTH", static_cast<PxU32>( physx::PxVehicleGearsData::eFOURTH ) },
		{ "eFIFTH", static_cast<PxU32>( physx::PxVehicleGearsData::eFIFTH ) },
		{ "eSIXTH", static_cast<PxU32>( physx::PxVehicleGearsData::eSIXTH ) },
		{ "eSEVENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eSEVENTH ) },
		{ "eEIGHTH", static_cast<PxU32>( physx::PxVehicleGearsData::eEIGHTH ) },
		{ "eNINTH", static_cast<PxU32>( physx::PxVehicleGearsData::eNINTH ) },
		{ "eTENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTENTH ) },
		{ "eELEVENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eELEVENTH ) },
		{ "eTWELFTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWELFTH ) },
		{ "eTHIRTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTHIRTEENTH ) },
		{ "eFOURTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eFOURTEENTH ) },
		{ "eFIFTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eFIFTEENTH ) },
		{ "eSIXTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eSIXTEENTH ) },
		{ "eSEVENTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eSEVENTEENTH ) },
		{ "eEIGHTEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eEIGHTEENTH ) },
		{ "eNINETEENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eNINETEENTH ) },
		{ "eTWENTIETH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTIETH ) },
		{ "eTWENTYFIRST", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYFIRST ) },
		{ "eTWENTYSECOND", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYSECOND ) },
		{ "eTWENTYTHIRD", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYTHIRD ) },
		{ "eTWENTYFOURTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYFOURTH ) },
		{ "eTWENTYFIFTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYFIFTH ) },
		{ "eTWENTYSIXTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYSIXTH ) },
		{ "eTWENTYSEVENTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYSEVENTH ) },
		{ "eTWENTYEIGHTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYEIGHTH ) },
		{ "eTWENTYNINTH", static_cast<PxU32>( physx::PxVehicleGearsData::eTWENTYNINTH ) },
		{ "eTHIRTIETH", static_cast<PxU32>( physx::PxVehicleGearsData::eTHIRTIETH ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVehicleGearsData::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVehicleGearsData__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxVehicleGearsData;
	struct PxVehicleGearsDataGeneratedValues
	{
		PxReal GearRatio[physx::PxVehicleGearsData::eGEARSRATIO_COUNT];
		PxReal MFinalRatio;
		PxU32 MNbRatios;
		PxReal MSwitchTime;
		  PxVehicleGearsDataGeneratedValues( const PxVehicleGearsData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleGearsData, GearRatio, PxVehicleGearsDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleGearsData, MFinalRatio, PxVehicleGearsDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleGearsData, MNbRatios, PxVehicleGearsDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleGearsData, MSwitchTime, PxVehicleGearsDataGeneratedValues)
	struct PxVehicleGearsDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleGearsData"; }
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleGearsData_GearRatio, PxVehicleGearsData, PxVehicleGearsData::Enum, PxReal > GearRatio;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleGearsData_MFinalRatio, PxVehicleGearsData, PxReal, PxReal > MFinalRatio;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleGearsData_MNbRatios, PxVehicleGearsData, PxU32, PxU32 > MNbRatios;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleGearsData_MSwitchTime, PxVehicleGearsData, PxReal, PxReal > MSwitchTime;

		 PxVehicleGearsDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleGearsData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( GearRatio, inStartIndex + 0 );; 
			inOperator( MFinalRatio, inStartIndex + 1 );; 
			inOperator( MNbRatios, inStartIndex + 2 );; 
			inOperator( MSwitchTime, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleGearsData>
	{ 
		PxVehicleGearsDataGeneratedInfo Info;
		const PxVehicleGearsDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleAutoBoxData;
	struct PxVehicleAutoBoxDataGeneratedValues
	{
		PxReal Latency;
		PxReal UpRatios[physx::PxVehicleGearsData::eGEARSRATIO_COUNT];
		PxReal DownRatios[physx::PxVehicleGearsData::eGEARSRATIO_COUNT];
		  PxVehicleAutoBoxDataGeneratedValues( const PxVehicleAutoBoxData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAutoBoxData, Latency, PxVehicleAutoBoxDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAutoBoxData, UpRatios, PxVehicleAutoBoxDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAutoBoxData, DownRatios, PxVehicleAutoBoxDataGeneratedValues)
	struct PxVehicleAutoBoxDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleAutoBoxData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAutoBoxData_Latency, PxVehicleAutoBoxData, const PxReal, PxReal > Latency;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAutoBoxData_UpRatios, PxVehicleAutoBoxData, PxVehicleGearsData::Enum, PxReal > UpRatios;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAutoBoxData_DownRatios, PxVehicleAutoBoxData, PxVehicleGearsData::Enum, PxReal > DownRatios;

		 PxVehicleAutoBoxDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleAutoBoxData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Latency, inStartIndex + 0 );; 
			inOperator( UpRatios, inStartIndex + 1 );; 
			inOperator( DownRatios, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleAutoBoxData>
	{ 
		PxVehicleAutoBoxDataGeneratedInfo Info;
		const PxVehicleAutoBoxDataGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxVehicleDifferential4WData__EnumConversion[] = {
		{ "eDIFF_TYPE_LS_4WD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_LS_4WD ) },
		{ "eDIFF_TYPE_LS_FRONTWD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_LS_FRONTWD ) },
		{ "eDIFF_TYPE_LS_REARWD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_LS_REARWD ) },
		{ "eDIFF_TYPE_OPEN_4WD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_OPEN_4WD ) },
		{ "eDIFF_TYPE_OPEN_FRONTWD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_OPEN_FRONTWD ) },
		{ "eDIFF_TYPE_OPEN_REARWD", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eDIFF_TYPE_OPEN_REARWD ) },
		{ "eMAX_NB_DIFF_TYPES", static_cast<PxU32>( physx::PxVehicleDifferential4WData::eMAX_NB_DIFF_TYPES ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVehicleDifferential4WData::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVehicleDifferential4WData__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxVehicleDifferential4WData;
	struct PxVehicleDifferential4WDataGeneratedValues
	{
		PxReal MFrontRearSplit;
		PxReal MFrontLeftRightSplit;
		PxReal MRearLeftRightSplit;
		PxReal MCentreBias;
		PxReal MFrontBias;
		PxReal MRearBias;
		PxVehicleDifferential4WData::Enum MType;
		  PxVehicleDifferential4WDataGeneratedValues( const PxVehicleDifferential4WData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MFrontRearSplit, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MFrontLeftRightSplit, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MRearLeftRightSplit, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MCentreBias, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MFrontBias, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MRearBias, PxVehicleDifferential4WDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferential4WData, MType, PxVehicleDifferential4WDataGeneratedValues)
	struct PxVehicleDifferential4WDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleDifferential4WData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MFrontRearSplit, PxVehicleDifferential4WData, PxReal, PxReal > MFrontRearSplit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MFrontLeftRightSplit, PxVehicleDifferential4WData, PxReal, PxReal > MFrontLeftRightSplit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MRearLeftRightSplit, PxVehicleDifferential4WData, PxReal, PxReal > MRearLeftRightSplit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MCentreBias, PxVehicleDifferential4WData, PxReal, PxReal > MCentreBias;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MFrontBias, PxVehicleDifferential4WData, PxReal, PxReal > MFrontBias;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MRearBias, PxVehicleDifferential4WData, PxReal, PxReal > MRearBias;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferential4WData_MType, PxVehicleDifferential4WData, PxVehicleDifferential4WData::Enum, PxVehicleDifferential4WData::Enum > MType;

		 PxVehicleDifferential4WDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDifferential4WData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MFrontRearSplit, inStartIndex + 0 );; 
			inOperator( MFrontLeftRightSplit, inStartIndex + 1 );; 
			inOperator( MRearLeftRightSplit, inStartIndex + 2 );; 
			inOperator( MCentreBias, inStartIndex + 3 );; 
			inOperator( MFrontBias, inStartIndex + 4 );; 
			inOperator( MRearBias, inStartIndex + 5 );; 
			inOperator( MType, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDifferential4WData>
	{ 
		PxVehicleDifferential4WDataGeneratedInfo Info;
		const PxVehicleDifferential4WDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDifferentialNWData;
	struct PxVehicleDifferentialNWDataGeneratedValues
	{
		PxU32 DrivenWheelStatus;
		  PxVehicleDifferentialNWDataGeneratedValues( const PxVehicleDifferentialNWData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDifferentialNWData, DrivenWheelStatus, PxVehicleDifferentialNWDataGeneratedValues)
	struct PxVehicleDifferentialNWDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleDifferentialNWData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDifferentialNWData_DrivenWheelStatus, PxVehicleDifferentialNWData, PxU32, PxU32 > DrivenWheelStatus;

		 PxVehicleDifferentialNWDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDifferentialNWData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DrivenWheelStatus, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDifferentialNWData>
	{ 
		PxVehicleDifferentialNWDataGeneratedInfo Info;
		const PxVehicleDifferentialNWDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleAckermannGeometryData;
	struct PxVehicleAckermannGeometryDataGeneratedValues
	{
		PxReal MAccuracy;
		PxReal MFrontWidth;
		PxReal MRearWidth;
		PxReal MAxleSeparation;
		  PxVehicleAckermannGeometryDataGeneratedValues( const PxVehicleAckermannGeometryData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAckermannGeometryData, MAccuracy, PxVehicleAckermannGeometryDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAckermannGeometryData, MFrontWidth, PxVehicleAckermannGeometryDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAckermannGeometryData, MRearWidth, PxVehicleAckermannGeometryDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAckermannGeometryData, MAxleSeparation, PxVehicleAckermannGeometryDataGeneratedValues)
	struct PxVehicleAckermannGeometryDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleAckermannGeometryData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAckermannGeometryData_MAccuracy, PxVehicleAckermannGeometryData, PxReal, PxReal > MAccuracy;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAckermannGeometryData_MFrontWidth, PxVehicleAckermannGeometryData, PxReal, PxReal > MFrontWidth;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAckermannGeometryData_MRearWidth, PxVehicleAckermannGeometryData, PxReal, PxReal > MRearWidth;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAckermannGeometryData_MAxleSeparation, PxVehicleAckermannGeometryData, PxReal, PxReal > MAxleSeparation;

		 PxVehicleAckermannGeometryDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleAckermannGeometryData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MAccuracy, inStartIndex + 0 );; 
			inOperator( MFrontWidth, inStartIndex + 1 );; 
			inOperator( MRearWidth, inStartIndex + 2 );; 
			inOperator( MAxleSeparation, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleAckermannGeometryData>
	{ 
		PxVehicleAckermannGeometryDataGeneratedInfo Info;
		const PxVehicleAckermannGeometryDataGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxVehicleClutchAccuracyMode__EnumConversion[] = {
		{ "eESTIMATE", static_cast<PxU32>( physx::PxVehicleClutchAccuracyMode::eESTIMATE ) },
		{ "eBEST_POSSIBLE", static_cast<PxU32>( physx::PxVehicleClutchAccuracyMode::eBEST_POSSIBLE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVehicleClutchAccuracyMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVehicleClutchAccuracyMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxVehicleClutchData;
	struct PxVehicleClutchDataGeneratedValues
	{
		PxReal MStrength;
		PxVehicleClutchAccuracyMode::Enum MAccuracyMode;
		PxU32 MEstimateIterations;
		  PxVehicleClutchDataGeneratedValues( const PxVehicleClutchData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleClutchData, MStrength, PxVehicleClutchDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleClutchData, MAccuracyMode, PxVehicleClutchDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleClutchData, MEstimateIterations, PxVehicleClutchDataGeneratedValues)
	struct PxVehicleClutchDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleClutchData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleClutchData_MStrength, PxVehicleClutchData, PxReal, PxReal > MStrength;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleClutchData_MAccuracyMode, PxVehicleClutchData, PxVehicleClutchAccuracyMode::Enum, PxVehicleClutchAccuracyMode::Enum > MAccuracyMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleClutchData_MEstimateIterations, PxVehicleClutchData, PxU32, PxU32 > MEstimateIterations;

		 PxVehicleClutchDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleClutchData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MStrength, inStartIndex + 0 );; 
			inOperator( MAccuracyMode, inStartIndex + 1 );; 
			inOperator( MEstimateIterations, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleClutchData>
	{ 
		PxVehicleClutchDataGeneratedInfo Info;
		const PxVehicleClutchDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleTireLoadFilterData;
	struct PxVehicleTireLoadFilterDataGeneratedValues
	{
		PxReal Denominator;
		PxReal MMinNormalisedLoad;
		PxReal MMinFilteredNormalisedLoad;
		PxReal MMaxNormalisedLoad;
		PxReal MMaxFilteredNormalisedLoad;
		  PxVehicleTireLoadFilterDataGeneratedValues( const PxVehicleTireLoadFilterData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireLoadFilterData, Denominator, PxVehicleTireLoadFilterDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireLoadFilterData, MMinNormalisedLoad, PxVehicleTireLoadFilterDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireLoadFilterData, MMinFilteredNormalisedLoad, PxVehicleTireLoadFilterDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireLoadFilterData, MMaxNormalisedLoad, PxVehicleTireLoadFilterDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireLoadFilterData, MMaxFilteredNormalisedLoad, PxVehicleTireLoadFilterDataGeneratedValues)
	struct PxVehicleTireLoadFilterDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleTireLoadFilterData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireLoadFilterData_Denominator, PxVehicleTireLoadFilterData, PxReal > Denominator;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireLoadFilterData_MMinNormalisedLoad, PxVehicleTireLoadFilterData, PxReal, PxReal > MMinNormalisedLoad;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireLoadFilterData_MMinFilteredNormalisedLoad, PxVehicleTireLoadFilterData, PxReal, PxReal > MMinFilteredNormalisedLoad;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireLoadFilterData_MMaxNormalisedLoad, PxVehicleTireLoadFilterData, PxReal, PxReal > MMaxNormalisedLoad;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireLoadFilterData_MMaxFilteredNormalisedLoad, PxVehicleTireLoadFilterData, PxReal, PxReal > MMaxFilteredNormalisedLoad;

		 PxVehicleTireLoadFilterDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleTireLoadFilterData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Denominator, inStartIndex + 0 );; 
			inOperator( MMinNormalisedLoad, inStartIndex + 1 );; 
			inOperator( MMinFilteredNormalisedLoad, inStartIndex + 2 );; 
			inOperator( MMaxNormalisedLoad, inStartIndex + 3 );; 
			inOperator( MMaxFilteredNormalisedLoad, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleTireLoadFilterData>
	{ 
		PxVehicleTireLoadFilterDataGeneratedInfo Info;
		const PxVehicleTireLoadFilterDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleWheelData;
	struct PxVehicleWheelDataGeneratedValues
	{
		PxReal RecipRadius;
		PxReal RecipMOI;
		PxReal MRadius;
		PxReal MWidth;
		PxReal MMass;
		PxReal MMOI;
		PxReal MDampingRate;
		PxReal MMaxBrakeTorque;
		PxReal MMaxHandBrakeTorque;
		PxReal MMaxSteer;
		PxReal MToeAngle;
		  PxVehicleWheelDataGeneratedValues( const PxVehicleWheelData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, RecipRadius, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, RecipMOI, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MRadius, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MWidth, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MMass, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MMOI, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MDampingRate, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MMaxBrakeTorque, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MMaxHandBrakeTorque, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MMaxSteer, PxVehicleWheelDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelData, MToeAngle, PxVehicleWheelDataGeneratedValues)
	struct PxVehicleWheelDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleWheelData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_RecipRadius, PxVehicleWheelData, PxReal > RecipRadius;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_RecipMOI, PxVehicleWheelData, PxReal > RecipMOI;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MRadius, PxVehicleWheelData, PxReal, PxReal > MRadius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MWidth, PxVehicleWheelData, PxReal, PxReal > MWidth;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MMass, PxVehicleWheelData, PxReal, PxReal > MMass;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MMOI, PxVehicleWheelData, PxReal, PxReal > MMOI;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MDampingRate, PxVehicleWheelData, PxReal, PxReal > MDampingRate;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MMaxBrakeTorque, PxVehicleWheelData, PxReal, PxReal > MMaxBrakeTorque;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MMaxHandBrakeTorque, PxVehicleWheelData, PxReal, PxReal > MMaxHandBrakeTorque;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MMaxSteer, PxVehicleWheelData, PxReal, PxReal > MMaxSteer;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelData_MToeAngle, PxVehicleWheelData, PxReal, PxReal > MToeAngle;

		 PxVehicleWheelDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleWheelData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 11; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RecipRadius, inStartIndex + 0 );; 
			inOperator( RecipMOI, inStartIndex + 1 );; 
			inOperator( MRadius, inStartIndex + 2 );; 
			inOperator( MWidth, inStartIndex + 3 );; 
			inOperator( MMass, inStartIndex + 4 );; 
			inOperator( MMOI, inStartIndex + 5 );; 
			inOperator( MDampingRate, inStartIndex + 6 );; 
			inOperator( MMaxBrakeTorque, inStartIndex + 7 );; 
			inOperator( MMaxHandBrakeTorque, inStartIndex + 8 );; 
			inOperator( MMaxSteer, inStartIndex + 9 );; 
			inOperator( MToeAngle, inStartIndex + 10 );; 
			return 11 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleWheelData>
	{ 
		PxVehicleWheelDataGeneratedInfo Info;
		const PxVehicleWheelDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleSuspensionData;
	struct PxVehicleSuspensionDataGeneratedValues
	{
		PxReal RecipMaxCompression;
		PxReal RecipMaxDroop;
		PxReal MSpringStrength;
		PxReal MSpringDamperRate;
		PxReal MMaxCompression;
		PxReal MMaxDroop;
		PxReal MSprungMass;
		PxReal MCamberAtRest;
		PxReal MCamberAtMaxCompression;
		PxReal MCamberAtMaxDroop;
		  PxVehicleSuspensionDataGeneratedValues( const PxVehicleSuspensionData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, RecipMaxCompression, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, RecipMaxDroop, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MSpringStrength, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MSpringDamperRate, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MMaxCompression, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MMaxDroop, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MSprungMass, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MCamberAtRest, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MCamberAtMaxCompression, PxVehicleSuspensionDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleSuspensionData, MCamberAtMaxDroop, PxVehicleSuspensionDataGeneratedValues)
	struct PxVehicleSuspensionDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleSuspensionData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_RecipMaxCompression, PxVehicleSuspensionData, PxReal > RecipMaxCompression;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_RecipMaxDroop, PxVehicleSuspensionData, PxReal > RecipMaxDroop;
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MassAndPreserveNaturalFrequency, PxVehicleSuspensionData, const PxReal > MassAndPreserveNaturalFrequency;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MSpringStrength, PxVehicleSuspensionData, PxReal, PxReal > MSpringStrength;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MSpringDamperRate, PxVehicleSuspensionData, PxReal, PxReal > MSpringDamperRate;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MMaxCompression, PxVehicleSuspensionData, PxReal, PxReal > MMaxCompression;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MMaxDroop, PxVehicleSuspensionData, PxReal, PxReal > MMaxDroop;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MSprungMass, PxVehicleSuspensionData, PxReal, PxReal > MSprungMass;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MCamberAtRest, PxVehicleSuspensionData, PxReal, PxReal > MCamberAtRest;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MCamberAtMaxCompression, PxVehicleSuspensionData, PxReal, PxReal > MCamberAtMaxCompression;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleSuspensionData_MCamberAtMaxDroop, PxVehicleSuspensionData, PxReal, PxReal > MCamberAtMaxDroop;

		 PxVehicleSuspensionDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleSuspensionData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 11; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RecipMaxCompression, inStartIndex + 0 );; 
			inOperator( RecipMaxDroop, inStartIndex + 1 );; 
			inOperator( MassAndPreserveNaturalFrequency, inStartIndex + 2 );; 
			inOperator( MSpringStrength, inStartIndex + 3 );; 
			inOperator( MSpringDamperRate, inStartIndex + 4 );; 
			inOperator( MMaxCompression, inStartIndex + 5 );; 
			inOperator( MMaxDroop, inStartIndex + 6 );; 
			inOperator( MSprungMass, inStartIndex + 7 );; 
			inOperator( MCamberAtRest, inStartIndex + 8 );; 
			inOperator( MCamberAtMaxCompression, inStartIndex + 9 );; 
			inOperator( MCamberAtMaxDroop, inStartIndex + 10 );; 
			return 11 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleSuspensionData>
	{ 
		PxVehicleSuspensionDataGeneratedInfo Info;
		const PxVehicleSuspensionDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleAntiRollBarData;
	struct PxVehicleAntiRollBarDataGeneratedValues
	{
		PxU32 MWheel0;
		PxU32 MWheel1;
		PxF32 MStiffness;
		  PxVehicleAntiRollBarDataGeneratedValues( const PxVehicleAntiRollBarData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAntiRollBarData, MWheel0, PxVehicleAntiRollBarDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAntiRollBarData, MWheel1, PxVehicleAntiRollBarDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleAntiRollBarData, MStiffness, PxVehicleAntiRollBarDataGeneratedValues)
	struct PxVehicleAntiRollBarDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleAntiRollBarData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAntiRollBarData_MWheel0, PxVehicleAntiRollBarData, PxU32, PxU32 > MWheel0;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAntiRollBarData_MWheel1, PxVehicleAntiRollBarData, PxU32, PxU32 > MWheel1;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleAntiRollBarData_MStiffness, PxVehicleAntiRollBarData, PxF32, PxF32 > MStiffness;

		 PxVehicleAntiRollBarDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleAntiRollBarData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MWheel0, inStartIndex + 0 );; 
			inOperator( MWheel1, inStartIndex + 1 );; 
			inOperator( MStiffness, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleAntiRollBarData>
	{ 
		PxVehicleAntiRollBarDataGeneratedInfo Info;
		const PxVehicleAntiRollBarDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleTireData;
	struct PxVehicleTireDataGeneratedValues
	{
		PxReal RecipLongitudinalStiffnessPerUnitGravity;
		PxReal FrictionVsSlipGraphRecipx1Minusx0;
		PxReal FrictionVsSlipGraphRecipx2Minusx1;
		PxReal MLatStiffX;
		PxReal MLatStiffY;
		PxReal MLongitudinalStiffnessPerUnitGravity;
		PxReal MCamberStiffnessPerUnitGravity;
		PxU32 MType;
		PxReal MFrictionVsSlipGraph[3][2];
		  PxVehicleTireDataGeneratedValues( const PxVehicleTireData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, RecipLongitudinalStiffnessPerUnitGravity, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, FrictionVsSlipGraphRecipx1Minusx0, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, FrictionVsSlipGraphRecipx2Minusx1, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MLatStiffX, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MLatStiffY, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MLongitudinalStiffnessPerUnitGravity, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MCamberStiffnessPerUnitGravity, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MType, PxVehicleTireDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleTireData, MFrictionVsSlipGraph, PxVehicleTireDataGeneratedValues)
	struct PxVehicleTireDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleTireData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_RecipLongitudinalStiffnessPerUnitGravity, PxVehicleTireData, PxReal > RecipLongitudinalStiffnessPerUnitGravity;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_FrictionVsSlipGraphRecipx1Minusx0, PxVehicleTireData, PxReal > FrictionVsSlipGraphRecipx1Minusx0;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_FrictionVsSlipGraphRecipx2Minusx1, PxVehicleTireData, PxReal > FrictionVsSlipGraphRecipx2Minusx1;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_MLatStiffX, PxVehicleTireData, PxReal, PxReal > MLatStiffX;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_MLatStiffY, PxVehicleTireData, PxReal, PxReal > MLatStiffY;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_MLongitudinalStiffnessPerUnitGravity, PxVehicleTireData, PxReal, PxReal > MLongitudinalStiffnessPerUnitGravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_MCamberStiffnessPerUnitGravity, PxVehicleTireData, PxReal, PxReal > MCamberStiffnessPerUnitGravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleTireData_MType, PxVehicleTireData, PxU32, PxU32 > MType;
		MFrictionVsSlipGraphProperty MFrictionVsSlipGraph;

		 PxVehicleTireDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleTireData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 9; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RecipLongitudinalStiffnessPerUnitGravity, inStartIndex + 0 );; 
			inOperator( FrictionVsSlipGraphRecipx1Minusx0, inStartIndex + 1 );; 
			inOperator( FrictionVsSlipGraphRecipx2Minusx1, inStartIndex + 2 );; 
			inOperator( MLatStiffX, inStartIndex + 3 );; 
			inOperator( MLatStiffY, inStartIndex + 4 );; 
			inOperator( MLongitudinalStiffnessPerUnitGravity, inStartIndex + 5 );; 
			inOperator( MCamberStiffnessPerUnitGravity, inStartIndex + 6 );; 
			inOperator( MType, inStartIndex + 7 );; 
			inOperator( MFrictionVsSlipGraph, inStartIndex + 8 );; 
			return 9 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleTireData>
	{ 
		PxVehicleTireDataGeneratedInfo Info;
		const PxVehicleTireDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleWheels4SimData;
	struct PxVehicleWheels4SimDataGeneratedValues
	{
		const PxReal * TireRestLoadsArray;
		const PxReal * RecipTireRestLoadsArray;
		  PxVehicleWheels4SimDataGeneratedValues( const PxVehicleWheels4SimData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels4SimData, TireRestLoadsArray, PxVehicleWheels4SimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels4SimData, RecipTireRestLoadsArray, PxVehicleWheels4SimDataGeneratedValues)
	struct PxVehicleWheels4SimDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleWheels4SimData"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels4SimData_TireRestLoadsArray, PxVehicleWheels4SimData, const PxReal * > TireRestLoadsArray;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels4SimData_RecipTireRestLoadsArray, PxVehicleWheels4SimData, const PxReal * > RecipTireRestLoadsArray;

		 PxVehicleWheels4SimDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleWheels4SimData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TireRestLoadsArray, inStartIndex + 0 );; 
			inOperator( RecipTireRestLoadsArray, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleWheels4SimData>
	{ 
		PxVehicleWheels4SimDataGeneratedInfo Info;
		const PxVehicleWheels4SimDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleWheelsSimData;
	struct PxVehicleWheelsSimDataGeneratedValues
	{
		PxVehicleTireLoadFilterData TireLoadFilterData;
		PxF32 MinLongSlipDenominator;
		PxF32 ThresholdLongSpeed;
		PxU32 LowForwardSpeedSubStepCount;
		PxU32 HighForwardSpeedSubStepCount;
		  PxVehicleWheelsSimDataGeneratedValues( const PxVehicleWheelsSimData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsSimData, TireLoadFilterData, PxVehicleWheelsSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsSimData, MinLongSlipDenominator, PxVehicleWheelsSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsSimData, ThresholdLongSpeed, PxVehicleWheelsSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsSimData, LowForwardSpeedSubStepCount, PxVehicleWheelsSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsSimData, HighForwardSpeedSubStepCount, PxVehicleWheelsSimDataGeneratedValues)
	struct PxVehicleWheelsSimDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleWheelsSimData"; }
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_ChassisMass, PxVehicleWheelsSimData, const PxF32 > ChassisMass;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_SuspensionData, PxVehicleWheelsSimData, const PxU32, PxVehicleSuspensionData > SuspensionData;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_WheelData, PxVehicleWheelsSimData, const PxU32, PxVehicleWheelData > WheelData;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_TireData, PxVehicleWheelsSimData, const PxU32, PxVehicleTireData > TireData;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_SuspTravelDirection, PxVehicleWheelsSimData, const PxU32, PxVec3 > SuspTravelDirection;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_SuspForceAppPointOffset, PxVehicleWheelsSimData, const PxU32, PxVec3 > SuspForceAppPointOffset;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_TireForceAppPointOffset, PxVehicleWheelsSimData, const PxU32, PxVec3 > TireForceAppPointOffset;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_WheelCentreOffset, PxVehicleWheelsSimData, const PxU32, PxVec3 > WheelCentreOffset;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_WheelShapeMapping, PxVehicleWheelsSimData, const PxU32, PxI32 > WheelShapeMapping;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_SceneQueryFilterData, PxVehicleWheelsSimData, const PxU32, PxFilterData > SceneQueryFilterData;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_AntiRollBarData, PxVehicleWheelsSimData, const PxU32, PxVehicleAntiRollBarData > AntiRollBarData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_TireLoadFilterData, PxVehicleWheelsSimData, const PxVehicleTireLoadFilterData &, PxVehicleTireLoadFilterData > TireLoadFilterData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_MinLongSlipDenominator, PxVehicleWheelsSimData, const PxReal, PxF32 > MinLongSlipDenominator;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_ThresholdLongSpeed, PxVehicleWheelsSimData, const PxF32, PxF32 > ThresholdLongSpeed;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_LowForwardSpeedSubStepCount, PxVehicleWheelsSimData, const PxU32, PxU32 > LowForwardSpeedSubStepCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_HighForwardSpeedSubStepCount, PxVehicleWheelsSimData, const PxU32, PxU32 > HighForwardSpeedSubStepCount;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsSimData_WheelEnabledState, PxVehicleWheelsSimData, const PxU32, _Bool > WheelEnabledState;

		 PxVehicleWheelsSimDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleWheelsSimData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 17; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ChassisMass, inStartIndex + 0 );; 
			inOperator( SuspensionData, inStartIndex + 1 );; 
			inOperator( WheelData, inStartIndex + 2 );; 
			inOperator( TireData, inStartIndex + 3 );; 
			inOperator( SuspTravelDirection, inStartIndex + 4 );; 
			inOperator( SuspForceAppPointOffset, inStartIndex + 5 );; 
			inOperator( TireForceAppPointOffset, inStartIndex + 6 );; 
			inOperator( WheelCentreOffset, inStartIndex + 7 );; 
			inOperator( WheelShapeMapping, inStartIndex + 8 );; 
			inOperator( SceneQueryFilterData, inStartIndex + 9 );; 
			inOperator( AntiRollBarData, inStartIndex + 10 );; 
			inOperator( TireLoadFilterData, inStartIndex + 11 );; 
			inOperator( MinLongSlipDenominator, inStartIndex + 12 );; 
			inOperator( ThresholdLongSpeed, inStartIndex + 13 );; 
			inOperator( LowForwardSpeedSubStepCount, inStartIndex + 14 );; 
			inOperator( HighForwardSpeedSubStepCount, inStartIndex + 15 );; 
			inOperator( WheelEnabledState, inStartIndex + 16 );; 
			return 17 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleWheelsSimData>
	{ 
		PxVehicleWheelsSimDataGeneratedInfo Info;
		const PxVehicleWheelsSimDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleWheelsDynData;
	struct PxVehicleWheelsDynDataGeneratedValues
	{
		PxVehicleWheels4DynData * Wheel4DynData;
		  PxVehicleWheelsDynDataGeneratedValues( const PxVehicleWheelsDynData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheelsDynData, Wheel4DynData, PxVehicleWheelsDynDataGeneratedValues)
	struct PxVehicleWheelsDynDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleWheelsDynData"; }
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsDynData_TireForceShaderFunction, PxVehicleWheelsDynData, PxVehicleComputeTireForce > TireForceShaderFunction;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsDynData_WheelRotationSpeed, PxVehicleWheelsDynData, const PxU32, PxReal > WheelRotationSpeed;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsDynData_WheelRotationAngle, PxVehicleWheelsDynData, const PxU32, PxReal > WheelRotationAngle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheelsDynData_Wheel4DynData, PxVehicleWheelsDynData, PxVehicleWheels4DynData * > Wheel4DynData;

		 PxVehicleWheelsDynDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleWheelsDynData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TireForceShaderFunction, inStartIndex + 0 );; 
			inOperator( WheelRotationSpeed, inStartIndex + 1 );; 
			inOperator( WheelRotationAngle, inStartIndex + 2 );; 
			inOperator( Wheel4DynData, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleWheelsDynData>
	{ 
		PxVehicleWheelsDynDataGeneratedInfo Info;
		const PxVehicleWheelsDynDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleWheels;
	struct PxVehicleWheelsGeneratedValues
	{
		PxU32 VehicleType;
		const PxRigidDynamic * RigidDynamicActor;
		const char * ConcreteTypeName;
		PxVehicleWheelsSimData MWheelsSimData;
		PxVehicleWheelsDynData MWheelsDynData;
		  PxVehicleWheelsGeneratedValues( const PxVehicleWheels* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels, VehicleType, PxVehicleWheelsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels, RigidDynamicActor, PxVehicleWheelsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels, ConcreteTypeName, PxVehicleWheelsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels, MWheelsSimData, PxVehicleWheelsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleWheels, MWheelsDynData, PxVehicleWheelsGeneratedValues)
	struct PxVehicleWheelsGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleWheels"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels_VehicleType, PxVehicleWheels, PxU32 > VehicleType;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels_RigidDynamicActor, PxVehicleWheels, const PxRigidDynamic * > RigidDynamicActor;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels_ConcreteTypeName, PxVehicleWheels, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels_MWheelsSimData, PxVehicleWheels, PxVehicleWheelsSimData, PxVehicleWheelsSimData > MWheelsSimData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleWheels_MWheelsDynData, PxVehicleWheels, PxVehicleWheelsDynData, PxVehicleWheelsDynData > MWheelsDynData;

		 PxVehicleWheelsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleWheels*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( VehicleType, inStartIndex + 0 );; 
			inOperator( RigidDynamicActor, inStartIndex + 1 );; 
			inOperator( ConcreteTypeName, inStartIndex + 2 );; 
			inOperator( MWheelsSimData, inStartIndex + 3 );; 
			inOperator( MWheelsDynData, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleWheels>
	{ 
		PxVehicleWheelsGeneratedInfo Info;
		const PxVehicleWheelsGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDriveDynData;
	struct PxVehicleDriveDynDataGeneratedValues
	{
		_Bool GearUp;
		_Bool GearDown;
		_Bool UseAutoGears;
		PxU32 CurrentGear;
		PxU32 TargetGear;
		PxReal EngineRotationSpeed;
		PxU32 GearChange;
		PxReal GearSwitchTime;
		PxReal AutoBoxSwitchTime;
		_Bool MUseAutoGears;
		_Bool MGearUpPressed;
		_Bool MGearDownPressed;
		PxU32 MCurrentGear;
		PxU32 MTargetGear;
		PxReal MEnginespeed;
		PxReal MGearSwitchTime;
		PxReal MAutoBoxSwitchTime;
		  PxVehicleDriveDynDataGeneratedValues( const PxVehicleDriveDynData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, GearUp, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, GearDown, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, UseAutoGears, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, CurrentGear, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, TargetGear, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, EngineRotationSpeed, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, GearChange, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, GearSwitchTime, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, AutoBoxSwitchTime, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MUseAutoGears, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MGearUpPressed, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MGearDownPressed, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MCurrentGear, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MTargetGear, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MEnginespeed, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MGearSwitchTime, PxVehicleDriveDynDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveDynData, MAutoBoxSwitchTime, PxVehicleDriveDynDataGeneratedValues)
	struct PxVehicleDriveDynDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleDriveDynData"; }
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_AnalogInput, PxVehicleDriveDynData, const PxU32, PxReal > AnalogInput;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_GearUp, PxVehicleDriveDynData, const _Bool, _Bool > GearUp;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_GearDown, PxVehicleDriveDynData, const _Bool, _Bool > GearDown;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_UseAutoGears, PxVehicleDriveDynData, const _Bool, _Bool > UseAutoGears;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_CurrentGear, PxVehicleDriveDynData, PxU32, PxU32 > CurrentGear;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_TargetGear, PxVehicleDriveDynData, PxU32, PxU32 > TargetGear;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_EngineRotationSpeed, PxVehicleDriveDynData, const PxF32, PxReal > EngineRotationSpeed;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_GearChange, PxVehicleDriveDynData, const PxU32, PxU32 > GearChange;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_GearSwitchTime, PxVehicleDriveDynData, const PxReal, PxReal > GearSwitchTime;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_AutoBoxSwitchTime, PxVehicleDriveDynData, const PxReal, PxReal > AutoBoxSwitchTime;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MUseAutoGears, PxVehicleDriveDynData, _Bool, _Bool > MUseAutoGears;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MGearUpPressed, PxVehicleDriveDynData, _Bool, _Bool > MGearUpPressed;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MGearDownPressed, PxVehicleDriveDynData, _Bool, _Bool > MGearDownPressed;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MCurrentGear, PxVehicleDriveDynData, PxU32, PxU32 > MCurrentGear;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MTargetGear, PxVehicleDriveDynData, PxU32, PxU32 > MTargetGear;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MEnginespeed, PxVehicleDriveDynData, PxReal, PxReal > MEnginespeed;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MGearSwitchTime, PxVehicleDriveDynData, PxReal, PxReal > MGearSwitchTime;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveDynData_MAutoBoxSwitchTime, PxVehicleDriveDynData, PxReal, PxReal > MAutoBoxSwitchTime;

		 PxVehicleDriveDynDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveDynData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 18; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( AnalogInput, inStartIndex + 0 );; 
			inOperator( GearUp, inStartIndex + 1 );; 
			inOperator( GearDown, inStartIndex + 2 );; 
			inOperator( UseAutoGears, inStartIndex + 3 );; 
			inOperator( CurrentGear, inStartIndex + 4 );; 
			inOperator( TargetGear, inStartIndex + 5 );; 
			inOperator( EngineRotationSpeed, inStartIndex + 6 );; 
			inOperator( GearChange, inStartIndex + 7 );; 
			inOperator( GearSwitchTime, inStartIndex + 8 );; 
			inOperator( AutoBoxSwitchTime, inStartIndex + 9 );; 
			inOperator( MUseAutoGears, inStartIndex + 10 );; 
			inOperator( MGearUpPressed, inStartIndex + 11 );; 
			inOperator( MGearDownPressed, inStartIndex + 12 );; 
			inOperator( MCurrentGear, inStartIndex + 13 );; 
			inOperator( MTargetGear, inStartIndex + 14 );; 
			inOperator( MEnginespeed, inStartIndex + 15 );; 
			inOperator( MGearSwitchTime, inStartIndex + 16 );; 
			inOperator( MAutoBoxSwitchTime, inStartIndex + 17 );; 
			return 18 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveDynData>
	{ 
		PxVehicleDriveDynDataGeneratedInfo Info;
		const PxVehicleDriveDynDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDriveSimData;
	struct PxVehicleDriveSimDataGeneratedValues
	{
		PxVehicleEngineData EngineData;
		PxVehicleGearsData GearsData;
		PxVehicleClutchData ClutchData;
		PxVehicleAutoBoxData AutoBoxData;
		  PxVehicleDriveSimDataGeneratedValues( const PxVehicleDriveSimData* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData, EngineData, PxVehicleDriveSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData, GearsData, PxVehicleDriveSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData, ClutchData, PxVehicleDriveSimDataGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData, AutoBoxData, PxVehicleDriveSimDataGeneratedValues)
	struct PxVehicleDriveSimDataGeneratedInfo

	{
		static const char* getClassName() { return "PxVehicleDriveSimData"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData_EngineData, PxVehicleDriveSimData, const PxVehicleEngineData &, PxVehicleEngineData > EngineData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData_GearsData, PxVehicleDriveSimData, const PxVehicleGearsData &, PxVehicleGearsData > GearsData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData_ClutchData, PxVehicleDriveSimData, const PxVehicleClutchData &, PxVehicleClutchData > ClutchData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData_AutoBoxData, PxVehicleDriveSimData, const PxVehicleAutoBoxData &, PxVehicleAutoBoxData > AutoBoxData;

		 PxVehicleDriveSimDataGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveSimData*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( EngineData, inStartIndex + 0 );; 
			inOperator( GearsData, inStartIndex + 1 );; 
			inOperator( ClutchData, inStartIndex + 2 );; 
			inOperator( AutoBoxData, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveSimData>
	{ 
		PxVehicleDriveSimDataGeneratedInfo Info;
		const PxVehicleDriveSimDataGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDriveSimData4W;
	struct PxVehicleDriveSimData4WGeneratedValues
		: PxVehicleDriveSimDataGeneratedValues	{
		PxVehicleDifferential4WData DiffData;
		PxVehicleAckermannGeometryData AckermannGeometryData;
		  PxVehicleDriveSimData4WGeneratedValues( const PxVehicleDriveSimData4W* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData4W, DiffData, PxVehicleDriveSimData4WGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimData4W, AckermannGeometryData, PxVehicleDriveSimData4WGeneratedValues)
	struct PxVehicleDriveSimData4WGeneratedInfo
		: PxVehicleDriveSimDataGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDriveSimData4W"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData4W_DiffData, PxVehicleDriveSimData4W, const PxVehicleDifferential4WData &, PxVehicleDifferential4WData > DiffData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimData4W_AckermannGeometryData, PxVehicleDriveSimData4W, const PxVehicleAckermannGeometryData &, PxVehicleAckermannGeometryData > AckermannGeometryData;

		 PxVehicleDriveSimData4WGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveSimData4W*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleDriveSimDataGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleDriveSimDataGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleDriveSimDataGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleDriveSimDataGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DiffData, inStartIndex + 0 );; 
			inOperator( AckermannGeometryData, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveSimData4W>
	{ 
		PxVehicleDriveSimData4WGeneratedInfo Info;
		const PxVehicleDriveSimData4WGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDrive;
	struct PxVehicleDriveGeneratedValues
		: PxVehicleWheelsGeneratedValues	{
		const char * ConcreteTypeName;
		PxVehicleDriveDynData MDriveDynData;
		  PxVehicleDriveGeneratedValues( const PxVehicleDrive* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDrive, ConcreteTypeName, PxVehicleDriveGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDrive, MDriveDynData, PxVehicleDriveGeneratedValues)
	struct PxVehicleDriveGeneratedInfo
		: PxVehicleWheelsGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDrive"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDrive_ConcreteTypeName, PxVehicleDrive, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDrive_MDriveDynData, PxVehicleDrive, PxVehicleDriveDynData, PxVehicleDriveDynData > MDriveDynData;

		 PxVehicleDriveGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDrive*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleWheelsGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleWheelsGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleWheelsGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleWheelsGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConcreteTypeName, inStartIndex + 0 );; 
			inOperator( MDriveDynData, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDrive>
	{ 
		PxVehicleDriveGeneratedInfo Info;
		const PxVehicleDriveGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDrive4W;
	struct PxVehicleDrive4WGeneratedValues
		: PxVehicleDriveGeneratedValues	{
		const char * ConcreteTypeName;
		PxVehicleDriveSimData4W MDriveSimData;
		  PxVehicleDrive4WGeneratedValues( const PxVehicleDrive4W* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDrive4W, ConcreteTypeName, PxVehicleDrive4WGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDrive4W, MDriveSimData, PxVehicleDrive4WGeneratedValues)
	struct PxVehicleDrive4WGeneratedInfo
		: PxVehicleDriveGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDrive4W"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDrive4W_ConcreteTypeName, PxVehicleDrive4W, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDrive4W_MDriveSimData, PxVehicleDrive4W, PxVehicleDriveSimData4W, PxVehicleDriveSimData4W > MDriveSimData;

		 PxVehicleDrive4WGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDrive4W*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleDriveGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleDriveGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleDriveGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleDriveGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConcreteTypeName, inStartIndex + 0 );; 
			inOperator( MDriveSimData, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDrive4W>
	{ 
		PxVehicleDrive4WGeneratedInfo Info;
		const PxVehicleDrive4WGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxVehicleDriveTankControlModel__EnumConversion[] = {
		{ "eSTANDARD", static_cast<PxU32>( physx::PxVehicleDriveTankControlModel::eSTANDARD ) },
		{ "eSPECIAL", static_cast<PxU32>( physx::PxVehicleDriveTankControlModel::eSPECIAL ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVehicleDriveTankControlModel::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVehicleDriveTankControlModel__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxVehicleDriveTank;
	struct PxVehicleDriveTankGeneratedValues
		: PxVehicleDriveGeneratedValues	{
		PxVehicleDriveTankControlModel::Enum DriveModel;
		const char * ConcreteTypeName;
		PxVehicleDriveSimData MDriveSimData;
		  PxVehicleDriveTankGeneratedValues( const PxVehicleDriveTank* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveTank, DriveModel, PxVehicleDriveTankGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveTank, ConcreteTypeName, PxVehicleDriveTankGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveTank, MDriveSimData, PxVehicleDriveTankGeneratedValues)
	struct PxVehicleDriveTankGeneratedInfo
		: PxVehicleDriveGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDriveTank"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveTank_DriveModel, PxVehicleDriveTank, const PxVehicleDriveTankControlModel::Enum, PxVehicleDriveTankControlModel::Enum > DriveModel;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveTank_ConcreteTypeName, PxVehicleDriveTank, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveTank_MDriveSimData, PxVehicleDriveTank, PxVehicleDriveSimData, PxVehicleDriveSimData > MDriveSimData;

		 PxVehicleDriveTankGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveTank*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleDriveGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleDriveGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleDriveGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleDriveGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DriveModel, inStartIndex + 0 );; 
			inOperator( ConcreteTypeName, inStartIndex + 1 );; 
			inOperator( MDriveSimData, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveTank>
	{ 
		PxVehicleDriveTankGeneratedInfo Info;
		const PxVehicleDriveTankGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDriveSimDataNW;
	struct PxVehicleDriveSimDataNWGeneratedValues
		: PxVehicleDriveSimDataGeneratedValues	{
		PxVehicleDifferentialNWData DiffData;
		  PxVehicleDriveSimDataNWGeneratedValues( const PxVehicleDriveSimDataNW* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveSimDataNW, DiffData, PxVehicleDriveSimDataNWGeneratedValues)
	struct PxVehicleDriveSimDataNWGeneratedInfo
		: PxVehicleDriveSimDataGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDriveSimDataNW"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveSimDataNW_DiffData, PxVehicleDriveSimDataNW, const PxVehicleDifferentialNWData &, PxVehicleDifferentialNWData > DiffData;

		 PxVehicleDriveSimDataNWGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveSimDataNW*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleDriveSimDataGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleDriveSimDataGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleDriveSimDataGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleDriveSimDataGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( DiffData, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveSimDataNW>
	{ 
		PxVehicleDriveSimDataNWGeneratedInfo Info;
		const PxVehicleDriveSimDataNWGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleDriveNW;
	struct PxVehicleDriveNWGeneratedValues
		: PxVehicleDriveGeneratedValues	{
		const char * ConcreteTypeName;
		PxVehicleDriveSimDataNW MDriveSimData;
		  PxVehicleDriveNWGeneratedValues( const PxVehicleDriveNW* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveNW, ConcreteTypeName, PxVehicleDriveNWGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleDriveNW, MDriveSimData, PxVehicleDriveNWGeneratedValues)
	struct PxVehicleDriveNWGeneratedInfo
		: PxVehicleDriveGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleDriveNW"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveNW_ConcreteTypeName, PxVehicleDriveNW, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleDriveNW_MDriveSimData, PxVehicleDriveNW, PxVehicleDriveSimDataNW, PxVehicleDriveSimDataNW > MDriveSimData;

		 PxVehicleDriveNWGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleDriveNW*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleDriveGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleDriveGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleDriveGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleDriveGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConcreteTypeName, inStartIndex + 0 );; 
			inOperator( MDriveSimData, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleDriveNW>
	{ 
		PxVehicleDriveNWGeneratedInfo Info;
		const PxVehicleDriveNWGeneratedInfo* getInfo() { return &Info; }
	};

	class PxVehicleNoDrive;
	struct PxVehicleNoDriveGeneratedValues
		: PxVehicleWheelsGeneratedValues	{
		const char * ConcreteTypeName;
		  PxVehicleNoDriveGeneratedValues( const PxVehicleNoDrive* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxVehicleNoDrive, ConcreteTypeName, PxVehicleNoDriveGeneratedValues)
	struct PxVehicleNoDriveGeneratedInfo
		: PxVehicleWheelsGeneratedInfo
	{
		static const char* getClassName() { return "PxVehicleNoDrive"; }
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleNoDrive_BrakeTorque, PxVehicleNoDrive, const PxU32, PxReal > BrakeTorque;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleNoDrive_DriveTorque, PxVehicleNoDrive, const PxU32, PxReal > DriveTorque;
		PxExtendedIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleNoDrive_SteerAngle, PxVehicleNoDrive, const PxU32, PxReal > SteerAngle;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxVehicleNoDrive_ConcreteTypeName, PxVehicleNoDrive, const char * > ConcreteTypeName;

		 PxVehicleNoDriveGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxVehicleNoDrive*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxVehicleWheelsGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxVehicleWheelsGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxVehicleWheelsGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxVehicleWheelsGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( BrakeTorque, inStartIndex + 0 );; 
			inOperator( DriveTorque, inStartIndex + 1 );; 
			inOperator( SteerAngle, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxVehicleNoDrive>
	{ 
		PxVehicleNoDriveGeneratedInfo Info;
		const PxVehicleNoDriveGeneratedInfo* getInfo() { return &Info; }
	};



#undef THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON
#undef PX_PROPERTY_INFO_NAME
