//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2018 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#include "PxMetaDataObjects.h"
#include "PxMetaDataCppPrefix.h"
using namespace physx;
const PxTolerancesScale getPxPhysics_TolerancesScale( const PxPhysics* inObj ) { return inObj->getTolerancesScale(); }
PxU32 getPxPhysics_TriangleMeshes( const PxPhysics* inObj, PxTriangleMesh ** outBuffer, PxU32 inBufSize ) { return inObj->getTriangleMeshes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_TriangleMeshes( const PxPhysics* inObj ) { return inObj->getNbTriangleMeshes(  ); }
PxTriangleMesh * createPxPhysics_TriangleMeshes( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createTriangleMesh( inCreateParam ); }
PxU32 getPxPhysics_HeightFields( const PxPhysics* inObj, PxHeightField ** outBuffer, PxU32 inBufSize ) { return inObj->getHeightFields( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_HeightFields( const PxPhysics* inObj ) { return inObj->getNbHeightFields(  ); }
PxHeightField * createPxPhysics_HeightFields( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createHeightField( inCreateParam ); }
PxU32 getPxPhysics_ConvexMeshes( const PxPhysics* inObj, PxConvexMesh ** outBuffer, PxU32 inBufSize ) { return inObj->getConvexMeshes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_ConvexMeshes( const PxPhysics* inObj ) { return inObj->getNbConvexMeshes(  ); }
PxConvexMesh * createPxPhysics_ConvexMeshes( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createConvexMesh( inCreateParam ); }
PxU32 getPxPhysics_BVHStructures( const PxPhysics* inObj, PxBVHStructure ** outBuffer, PxU32 inBufSize ) { return inObj->getBVHStructures( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_BVHStructures( const PxPhysics* inObj ) { return inObj->getNbBVHStructures(  ); }
PxBVHStructure * createPxPhysics_BVHStructures( PxPhysics* inObj, PxInputStream & inCreateParam ){ return inObj->createBVHStructure( inCreateParam ); }
PxU32 getPxPhysics_Scenes( const PxPhysics* inObj, PxScene ** outBuffer, PxU32 inBufSize ) { return inObj->getScenes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Scenes( const PxPhysics* inObj ) { return inObj->getNbScenes(  ); }
PxScene * createPxPhysics_Scenes( PxPhysics* inObj, const PxSceneDesc & inCreateParam ){ return inObj->createScene( inCreateParam ); }
PxU32 getPxPhysics_Shapes( const PxPhysics* inObj, PxShape ** outBuffer, PxU32 inBufSize ) { return inObj->getShapes( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Shapes( const PxPhysics* inObj ) { return inObj->getNbShapes(  ); }
PxU32 getPxPhysics_Materials( const PxPhysics* inObj, PxMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxPhysics_Materials( const PxPhysics* inObj ) { return inObj->getNbMaterials(  ); }
PX_PHYSX_CORE_API PxPhysicsGeneratedInfo::PxPhysicsGeneratedInfo()
	: TolerancesScale( "TolerancesScale", getPxPhysics_TolerancesScale)
	, TriangleMeshes( "TriangleMeshes", getPxPhysics_TriangleMeshes, getNbPxPhysics_TriangleMeshes, createPxPhysics_TriangleMeshes )
	, HeightFields( "HeightFields", getPxPhysics_HeightFields, getNbPxPhysics_HeightFields, createPxPhysics_HeightFields )
	, ConvexMeshes( "ConvexMeshes", getPxPhysics_ConvexMeshes, getNbPxPhysics_ConvexMeshes, createPxPhysics_ConvexMeshes )
	, BVHStructures( "BVHStructures", getPxPhysics_BVHStructures, getNbPxPhysics_BVHStructures, createPxPhysics_BVHStructures )
	, Scenes( "Scenes", getPxPhysics_Scenes, getNbPxPhysics_Scenes, createPxPhysics_Scenes )
	, Shapes( "Shapes", getPxPhysics_Shapes, getNbPxPhysics_Shapes )
	, Materials( "Materials", getPxPhysics_Materials, getNbPxPhysics_Materials )
{}
PX_PHYSX_CORE_API PxPhysicsGeneratedValues::PxPhysicsGeneratedValues( const PxPhysics* inSource )
		:TolerancesScale( getPxPhysics_TolerancesScale( inSource ) )
{
	PX_UNUSED(inSource);
}
PxU32 getPxMaterial_ReferenceCount( const PxMaterial* inObj ) { return inObj->getReferenceCount(); }
void setPxMaterial_DynamicFriction( PxMaterial* inObj, PxReal inArg){ inObj->setDynamicFriction( inArg ); }
PxReal getPxMaterial_DynamicFriction( const PxMaterial* inObj ) { return inObj->getDynamicFriction(); }
void setPxMaterial_StaticFriction( PxMaterial* inObj, PxReal inArg){ inObj->setStaticFriction( inArg ); }
PxReal getPxMaterial_StaticFriction( const PxMaterial* inObj ) { return inObj->getStaticFriction(); }
void setPxMaterial_Restitution( PxMaterial* inObj, PxReal inArg){ inObj->setRestitution( inArg ); }
PxReal getPxMaterial_Restitution( const PxMaterial* inObj ) { return inObj->getRestitution(); }
void setPxMaterial_Flags( PxMaterial* inObj, PxMaterialFlags inArg){ inObj->setFlags( inArg ); }
PxMaterialFlags getPxMaterial_Flags( const PxMaterial* inObj ) { return inObj->getFlags(); }
void setPxMaterial_FrictionCombineMode( PxMaterial* inObj, PxCombineMode::Enum inArg){ inObj->setFrictionCombineMode( inArg ); }
PxCombineMode::Enum getPxMaterial_FrictionCombineMode( const PxMaterial* inObj ) { return inObj->getFrictionCombineMode(); }
void setPxMaterial_RestitutionCombineMode( PxMaterial* inObj, PxCombineMode::Enum inArg){ inObj->setRestitutionCombineMode( inArg ); }
PxCombineMode::Enum getPxMaterial_RestitutionCombineMode( const PxMaterial* inObj ) { return inObj->getRestitutionCombineMode(); }
const char * getPxMaterial_ConcreteTypeName( const PxMaterial* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxMaterialUserData( const PxMaterial* inOwner ) { return inOwner->userData; }
inline void setPxMaterialUserData( PxMaterial* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxMaterialGeneratedInfo::PxMaterialGeneratedInfo()
	: ReferenceCount( "ReferenceCount", getPxMaterial_ReferenceCount)
	, DynamicFriction( "DynamicFriction", setPxMaterial_DynamicFriction, getPxMaterial_DynamicFriction)
	, StaticFriction( "StaticFriction", setPxMaterial_StaticFriction, getPxMaterial_StaticFriction)
	, Restitution( "Restitution", setPxMaterial_Restitution, getPxMaterial_Restitution)
	, Flags( "Flags", setPxMaterial_Flags, getPxMaterial_Flags)
	, FrictionCombineMode( "FrictionCombineMode", setPxMaterial_FrictionCombineMode, getPxMaterial_FrictionCombineMode)
	, RestitutionCombineMode( "RestitutionCombineMode", setPxMaterial_RestitutionCombineMode, getPxMaterial_RestitutionCombineMode)
	, ConcreteTypeName( "ConcreteTypeName", getPxMaterial_ConcreteTypeName)
	, UserData( "UserData", setPxMaterialUserData, getPxMaterialUserData )
{}
PX_PHYSX_CORE_API PxMaterialGeneratedValues::PxMaterialGeneratedValues( const PxMaterial* inSource )
		:ReferenceCount( getPxMaterial_ReferenceCount( inSource ) )
		,DynamicFriction( getPxMaterial_DynamicFriction( inSource ) )
		,StaticFriction( getPxMaterial_StaticFriction( inSource ) )
		,Restitution( getPxMaterial_Restitution( inSource ) )
		,Flags( getPxMaterial_Flags( inSource ) )
		,FrictionCombineMode( getPxMaterial_FrictionCombineMode( inSource ) )
		,RestitutionCombineMode( getPxMaterial_RestitutionCombineMode( inSource ) )
		,ConcreteTypeName( getPxMaterial_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
PxScene * getPxActor_Scene( const PxActor* inObj ) { return inObj->getScene(); }
void setPxActor_Name( PxActor* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxActor_Name( const PxActor* inObj ) { return inObj->getName(); }
void setPxActor_ActorFlags( PxActor* inObj, PxActorFlags inArg){ inObj->setActorFlags( inArg ); }
PxActorFlags getPxActor_ActorFlags( const PxActor* inObj ) { return inObj->getActorFlags(); }
void setPxActor_DominanceGroup( PxActor* inObj, PxDominanceGroup inArg){ inObj->setDominanceGroup( inArg ); }
PxDominanceGroup getPxActor_DominanceGroup( const PxActor* inObj ) { return inObj->getDominanceGroup(); }
void setPxActor_OwnerClient( PxActor* inObj, PxClientID inArg){ inObj->setOwnerClient( inArg ); }
PxClientID getPxActor_OwnerClient( const PxActor* inObj ) { return inObj->getOwnerClient(); }
PxAggregate * getPxActor_Aggregate( const PxActor* inObj ) { return inObj->getAggregate(); }
inline void * getPxActorUserData( const PxActor* inOwner ) { return inOwner->userData; }
inline void setPxActorUserData( PxActor* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxActorGeneratedInfo::PxActorGeneratedInfo()
	: Scene( "Scene", getPxActor_Scene)
	, Name( "Name", setPxActor_Name, getPxActor_Name)
	, ActorFlags( "ActorFlags", setPxActor_ActorFlags, getPxActor_ActorFlags)
	, DominanceGroup( "DominanceGroup", setPxActor_DominanceGroup, getPxActor_DominanceGroup)
	, OwnerClient( "OwnerClient", setPxActor_OwnerClient, getPxActor_OwnerClient)
	, Aggregate( "Aggregate", getPxActor_Aggregate)
	, UserData( "UserData", setPxActorUserData, getPxActorUserData )
{}
PX_PHYSX_CORE_API PxActorGeneratedValues::PxActorGeneratedValues( const PxActor* inSource )
		:Scene( getPxActor_Scene( inSource ) )
		,Name( getPxActor_Name( inSource ) )
		,ActorFlags( getPxActor_ActorFlags( inSource ) )
		,DominanceGroup( getPxActor_DominanceGroup( inSource ) )
		,OwnerClient( getPxActor_OwnerClient( inSource ) )
		,Aggregate( getPxActor_Aggregate( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
void setPxRigidActor_GlobalPose( PxRigidActor* inObj, const PxTransform & inArg){ inObj->setGlobalPose( inArg ); }
PxTransform getPxRigidActor_GlobalPose( const PxRigidActor* inObj ) { return inObj->getGlobalPose(); }
PxU32 getPxRigidActor_Shapes( const PxRigidActor* inObj, PxShape ** outBuffer, PxU32 inBufSize ) { return inObj->getShapes( outBuffer, inBufSize ); }
PxU32 getNbPxRigidActor_Shapes( const PxRigidActor* inObj ) { return inObj->getNbShapes(  ); }
PxU32 getPxRigidActor_Constraints( const PxRigidActor* inObj, PxConstraint ** outBuffer, PxU32 inBufSize ) { return inObj->getConstraints( outBuffer, inBufSize ); }
PxU32 getNbPxRigidActor_Constraints( const PxRigidActor* inObj ) { return inObj->getNbConstraints(  ); }
PX_PHYSX_CORE_API PxRigidActorGeneratedInfo::PxRigidActorGeneratedInfo()
	: GlobalPose( "GlobalPose", setPxRigidActor_GlobalPose, getPxRigidActor_GlobalPose)
	, Shapes( "Shapes", getPxRigidActor_Shapes, getNbPxRigidActor_Shapes )
	, Constraints( "Constraints", getPxRigidActor_Constraints, getNbPxRigidActor_Constraints )
{}
PX_PHYSX_CORE_API PxRigidActorGeneratedValues::PxRigidActorGeneratedValues( const PxRigidActor* inSource )
		:PxActorGeneratedValues( inSource )
		,GlobalPose( getPxRigidActor_GlobalPose( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxRigidBody_CMassLocalPose( PxRigidBody* inObj, const PxTransform & inArg){ inObj->setCMassLocalPose( inArg ); }
PxTransform getPxRigidBody_CMassLocalPose( const PxRigidBody* inObj ) { return inObj->getCMassLocalPose(); }
void setPxRigidBody_Mass( PxRigidBody* inObj, PxReal inArg){ inObj->setMass( inArg ); }
PxReal getPxRigidBody_Mass( const PxRigidBody* inObj ) { return inObj->getMass(); }
PxReal getPxRigidBody_InvMass( const PxRigidBody* inObj ) { return inObj->getInvMass(); }
void setPxRigidBody_MassSpaceInertiaTensor( PxRigidBody* inObj, const PxVec3 & inArg){ inObj->setMassSpaceInertiaTensor( inArg ); }
PxVec3 getPxRigidBody_MassSpaceInertiaTensor( const PxRigidBody* inObj ) { return inObj->getMassSpaceInertiaTensor(); }
PxVec3 getPxRigidBody_MassSpaceInvInertiaTensor( const PxRigidBody* inObj ) { return inObj->getMassSpaceInvInertiaTensor(); }
void setPxRigidBody_LinearDamping( PxRigidBody* inObj, PxReal inArg){ inObj->setLinearDamping( inArg ); }
PxReal getPxRigidBody_LinearDamping( const PxRigidBody* inObj ) { return inObj->getLinearDamping(); }
void setPxRigidBody_AngularDamping( PxRigidBody* inObj, PxReal inArg){ inObj->setAngularDamping( inArg ); }
PxReal getPxRigidBody_AngularDamping( const PxRigidBody* inObj ) { return inObj->getAngularDamping(); }
void setPxRigidBody_LinearVelocity( PxRigidBody* inObj, const PxVec3 & inArg){ inObj->setLinearVelocity( inArg ); }
PxVec3 getPxRigidBody_LinearVelocity( const PxRigidBody* inObj ) { return inObj->getLinearVelocity(); }
void setPxRigidBody_AngularVelocity( PxRigidBody* inObj, const PxVec3 & inArg){ inObj->setAngularVelocity( inArg ); }
PxVec3 getPxRigidBody_AngularVelocity( const PxRigidBody* inObj ) { return inObj->getAngularVelocity(); }
void setPxRigidBody_MaxAngularVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxAngularVelocity( inArg ); }
PxReal getPxRigidBody_MaxAngularVelocity( const PxRigidBody* inObj ) { return inObj->getMaxAngularVelocity(); }
void setPxRigidBody_MaxLinearVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxLinearVelocity( inArg ); }
PxReal getPxRigidBody_MaxLinearVelocity( const PxRigidBody* inObj ) { return inObj->getMaxLinearVelocity(); }
void setPxRigidBody_RigidBodyFlags( PxRigidBody* inObj, PxRigidBodyFlags inArg){ inObj->setRigidBodyFlags( inArg ); }
PxRigidBodyFlags getPxRigidBody_RigidBodyFlags( const PxRigidBody* inObj ) { return inObj->getRigidBodyFlags(); }
void setPxRigidBody_MinCCDAdvanceCoefficient( PxRigidBody* inObj, PxReal inArg){ inObj->setMinCCDAdvanceCoefficient( inArg ); }
PxReal getPxRigidBody_MinCCDAdvanceCoefficient( const PxRigidBody* inObj ) { return inObj->getMinCCDAdvanceCoefficient(); }
void setPxRigidBody_MaxDepenetrationVelocity( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxDepenetrationVelocity( inArg ); }
PxReal getPxRigidBody_MaxDepenetrationVelocity( const PxRigidBody* inObj ) { return inObj->getMaxDepenetrationVelocity(); }
void setPxRigidBody_MaxContactImpulse( PxRigidBody* inObj, PxReal inArg){ inObj->setMaxContactImpulse( inArg ); }
PxReal getPxRigidBody_MaxContactImpulse( const PxRigidBody* inObj ) { return inObj->getMaxContactImpulse(); }
PX_PHYSX_CORE_API PxRigidBodyGeneratedInfo::PxRigidBodyGeneratedInfo()
	: CMassLocalPose( "CMassLocalPose", setPxRigidBody_CMassLocalPose, getPxRigidBody_CMassLocalPose)
	, Mass( "Mass", setPxRigidBody_Mass, getPxRigidBody_Mass)
	, InvMass( "InvMass", getPxRigidBody_InvMass)
	, MassSpaceInertiaTensor( "MassSpaceInertiaTensor", setPxRigidBody_MassSpaceInertiaTensor, getPxRigidBody_MassSpaceInertiaTensor)
	, MassSpaceInvInertiaTensor( "MassSpaceInvInertiaTensor", getPxRigidBody_MassSpaceInvInertiaTensor)
	, LinearDamping( "LinearDamping", setPxRigidBody_LinearDamping, getPxRigidBody_LinearDamping)
	, AngularDamping( "AngularDamping", setPxRigidBody_AngularDamping, getPxRigidBody_AngularDamping)
	, LinearVelocity( "LinearVelocity", setPxRigidBody_LinearVelocity, getPxRigidBody_LinearVelocity)
	, AngularVelocity( "AngularVelocity", setPxRigidBody_AngularVelocity, getPxRigidBody_AngularVelocity)
	, MaxAngularVelocity( "MaxAngularVelocity", setPxRigidBody_MaxAngularVelocity, getPxRigidBody_MaxAngularVelocity)
	, MaxLinearVelocity( "MaxLinearVelocity", setPxRigidBody_MaxLinearVelocity, getPxRigidBody_MaxLinearVelocity)
	, RigidBodyFlags( "RigidBodyFlags", setPxRigidBody_RigidBodyFlags, getPxRigidBody_RigidBodyFlags)
	, MinCCDAdvanceCoefficient( "MinCCDAdvanceCoefficient", setPxRigidBody_MinCCDAdvanceCoefficient, getPxRigidBody_MinCCDAdvanceCoefficient)
	, MaxDepenetrationVelocity( "MaxDepenetrationVelocity", setPxRigidBody_MaxDepenetrationVelocity, getPxRigidBody_MaxDepenetrationVelocity)
	, MaxContactImpulse( "MaxContactImpulse", setPxRigidBody_MaxContactImpulse, getPxRigidBody_MaxContactImpulse)
{}
PX_PHYSX_CORE_API PxRigidBodyGeneratedValues::PxRigidBodyGeneratedValues( const PxRigidBody* inSource )
		:PxRigidActorGeneratedValues( inSource )
		,CMassLocalPose( getPxRigidBody_CMassLocalPose( inSource ) )
		,Mass( getPxRigidBody_Mass( inSource ) )
		,InvMass( getPxRigidBody_InvMass( inSource ) )
		,MassSpaceInertiaTensor( getPxRigidBody_MassSpaceInertiaTensor( inSource ) )
		,MassSpaceInvInertiaTensor( getPxRigidBody_MassSpaceInvInertiaTensor( inSource ) )
		,LinearDamping( getPxRigidBody_LinearDamping( inSource ) )
		,AngularDamping( getPxRigidBody_AngularDamping( inSource ) )
		,LinearVelocity( getPxRigidBody_LinearVelocity( inSource ) )
		,AngularVelocity( getPxRigidBody_AngularVelocity( inSource ) )
		,MaxAngularVelocity( getPxRigidBody_MaxAngularVelocity( inSource ) )
		,MaxLinearVelocity( getPxRigidBody_MaxLinearVelocity( inSource ) )
		,RigidBodyFlags( getPxRigidBody_RigidBodyFlags( inSource ) )
		,MinCCDAdvanceCoefficient( getPxRigidBody_MinCCDAdvanceCoefficient( inSource ) )
		,MaxDepenetrationVelocity( getPxRigidBody_MaxDepenetrationVelocity( inSource ) )
		,MaxContactImpulse( getPxRigidBody_MaxContactImpulse( inSource ) )
{
	PX_UNUSED(inSource);
}
_Bool getPxRigidDynamic_IsSleeping( const PxRigidDynamic* inObj ) { return inObj->isSleeping(); }
void setPxRigidDynamic_SleepThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setSleepThreshold( inArg ); }
PxReal getPxRigidDynamic_SleepThreshold( const PxRigidDynamic* inObj ) { return inObj->getSleepThreshold(); }
void setPxRigidDynamic_StabilizationThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setStabilizationThreshold( inArg ); }
PxReal getPxRigidDynamic_StabilizationThreshold( const PxRigidDynamic* inObj ) { return inObj->getStabilizationThreshold(); }
void setPxRigidDynamic_RigidDynamicLockFlags( PxRigidDynamic* inObj, PxRigidDynamicLockFlags inArg){ inObj->setRigidDynamicLockFlags( inArg ); }
PxRigidDynamicLockFlags getPxRigidDynamic_RigidDynamicLockFlags( const PxRigidDynamic* inObj ) { return inObj->getRigidDynamicLockFlags(); }
void setPxRigidDynamic_WakeCounter( PxRigidDynamic* inObj, PxReal inArg){ inObj->setWakeCounter( inArg ); }
PxReal getPxRigidDynamic_WakeCounter( const PxRigidDynamic* inObj ) { return inObj->getWakeCounter(); }
void setPxRigidDynamic_SolverIterationCounts( PxRigidDynamic* inObj, PxU32 inArg0, PxU32 inArg1 ) { inObj->setSolverIterationCounts( inArg0, inArg1 ); }
void getPxRigidDynamic_SolverIterationCounts( const PxRigidDynamic* inObj, PxU32& inArg0, PxU32& inArg1 ) { inObj->getSolverIterationCounts( inArg0, inArg1 ); }
void setPxRigidDynamic_ContactReportThreshold( PxRigidDynamic* inObj, PxReal inArg){ inObj->setContactReportThreshold( inArg ); }
PxReal getPxRigidDynamic_ContactReportThreshold( const PxRigidDynamic* inObj ) { return inObj->getContactReportThreshold(); }
const char * getPxRigidDynamic_ConcreteTypeName( const PxRigidDynamic* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxRigidDynamicGeneratedInfo::PxRigidDynamicGeneratedInfo()
	: IsSleeping( "IsSleeping", getPxRigidDynamic_IsSleeping)
	, SleepThreshold( "SleepThreshold", setPxRigidDynamic_SleepThreshold, getPxRigidDynamic_SleepThreshold)
	, StabilizationThreshold( "StabilizationThreshold", setPxRigidDynamic_StabilizationThreshold, getPxRigidDynamic_StabilizationThreshold)
	, RigidDynamicLockFlags( "RigidDynamicLockFlags", setPxRigidDynamic_RigidDynamicLockFlags, getPxRigidDynamic_RigidDynamicLockFlags)
	, WakeCounter( "WakeCounter", setPxRigidDynamic_WakeCounter, getPxRigidDynamic_WakeCounter)
	, SolverIterationCounts( "SolverIterationCounts", "minPositionIters", "minVelocityIters", setPxRigidDynamic_SolverIterationCounts, getPxRigidDynamic_SolverIterationCounts)
	, ContactReportThreshold( "ContactReportThreshold", setPxRigidDynamic_ContactReportThreshold, getPxRigidDynamic_ContactReportThreshold)
	, ConcreteTypeName( "ConcreteTypeName", getPxRigidDynamic_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxRigidDynamicGeneratedValues::PxRigidDynamicGeneratedValues( const PxRigidDynamic* inSource )
		:PxRigidBodyGeneratedValues( inSource )
		,IsSleeping( getPxRigidDynamic_IsSleeping( inSource ) )
		,SleepThreshold( getPxRigidDynamic_SleepThreshold( inSource ) )
		,StabilizationThreshold( getPxRigidDynamic_StabilizationThreshold( inSource ) )
		,RigidDynamicLockFlags( getPxRigidDynamic_RigidDynamicLockFlags( inSource ) )
		,WakeCounter( getPxRigidDynamic_WakeCounter( inSource ) )
		,ContactReportThreshold( getPxRigidDynamic_ContactReportThreshold( inSource ) )
		,ConcreteTypeName( getPxRigidDynamic_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
	getPxRigidDynamic_SolverIterationCounts( inSource, SolverIterationCounts[0], SolverIterationCounts[1] );
}
const char * getPxRigidStatic_ConcreteTypeName( const PxRigidStatic* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxRigidStaticGeneratedInfo::PxRigidStaticGeneratedInfo()
	: ConcreteTypeName( "ConcreteTypeName", getPxRigidStatic_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxRigidStaticGeneratedValues::PxRigidStaticGeneratedValues( const PxRigidStatic* inSource )
		:PxRigidActorGeneratedValues( inSource )
		,ConcreteTypeName( getPxRigidStatic_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
PxArticulationJointBase * getPxArticulationLink_InboundJoint( const PxArticulationLink* inObj ) { return inObj->getInboundJoint(); }
PxU32 getPxArticulationLink_InboundJointDof( const PxArticulationLink* inObj ) { return inObj->getInboundJointDof(); }
PxU32 getPxArticulationLink_LinkIndex( const PxArticulationLink* inObj ) { return inObj->getLinkIndex(); }
PxU32 getPxArticulationLink_Children( const PxArticulationLink* inObj, PxArticulationLink ** outBuffer, PxU32 inBufSize ) { return inObj->getChildren( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationLink_Children( const PxArticulationLink* inObj ) { return inObj->getNbChildren(  ); }
const char * getPxArticulationLink_ConcreteTypeName( const PxArticulationLink* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxArticulationLinkGeneratedInfo::PxArticulationLinkGeneratedInfo()
	: InboundJoint( "InboundJoint", getPxArticulationLink_InboundJoint)
	, InboundJointDof( "InboundJointDof", getPxArticulationLink_InboundJointDof)
	, LinkIndex( "LinkIndex", getPxArticulationLink_LinkIndex)
	, Children( "Children", getPxArticulationLink_Children, getNbPxArticulationLink_Children )
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationLink_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxArticulationLinkGeneratedValues::PxArticulationLinkGeneratedValues( const PxArticulationLink* inSource )
		:PxRigidBodyGeneratedValues( inSource )
		,InboundJoint( getPxArticulationLink_InboundJoint( inSource ) )
		,InboundJointDof( getPxArticulationLink_InboundJointDof( inSource ) )
		,LinkIndex( getPxArticulationLink_LinkIndex( inSource ) )
		,ConcreteTypeName( getPxArticulationLink_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxArticulationJointBase_ParentPose( PxArticulationJointBase* inObj, const PxTransform & inArg){ inObj->setParentPose( inArg ); }
PxTransform getPxArticulationJointBase_ParentPose( const PxArticulationJointBase* inObj ) { return inObj->getParentPose(); }
void setPxArticulationJointBase_ChildPose( PxArticulationJointBase* inObj, const PxTransform & inArg){ inObj->setChildPose( inArg ); }
PxTransform getPxArticulationJointBase_ChildPose( const PxArticulationJointBase* inObj ) { return inObj->getChildPose(); }
PX_PHYSX_CORE_API PxArticulationJointBaseGeneratedInfo::PxArticulationJointBaseGeneratedInfo()
	: ParentPose( "ParentPose", setPxArticulationJointBase_ParentPose, getPxArticulationJointBase_ParentPose)
	, ChildPose( "ChildPose", setPxArticulationJointBase_ChildPose, getPxArticulationJointBase_ChildPose)
{}
PX_PHYSX_CORE_API PxArticulationJointBaseGeneratedValues::PxArticulationJointBaseGeneratedValues( const PxArticulationJointBase* inSource )
		:ParentPose( getPxArticulationJointBase_ParentPose( inSource ) )
		,ChildPose( getPxArticulationJointBase_ChildPose( inSource ) )
{
	PX_UNUSED(inSource);
}
void setPxArticulationJoint_TargetOrientation( PxArticulationJoint* inObj, const PxQuat & inArg){ inObj->setTargetOrientation( inArg ); }
PxQuat getPxArticulationJoint_TargetOrientation( const PxArticulationJoint* inObj ) { return inObj->getTargetOrientation(); }
void setPxArticulationJoint_TargetVelocity( PxArticulationJoint* inObj, const PxVec3 & inArg){ inObj->setTargetVelocity( inArg ); }
PxVec3 getPxArticulationJoint_TargetVelocity( const PxArticulationJoint* inObj ) { return inObj->getTargetVelocity(); }
void setPxArticulationJoint_DriveType( PxArticulationJoint* inObj, PxArticulationJointDriveType::Enum inArg){ inObj->setDriveType( inArg ); }
PxArticulationJointDriveType::Enum getPxArticulationJoint_DriveType( const PxArticulationJoint* inObj ) { return inObj->getDriveType(); }
void setPxArticulationJoint_Stiffness( PxArticulationJoint* inObj, PxReal inArg){ inObj->setStiffness( inArg ); }
PxReal getPxArticulationJoint_Stiffness( const PxArticulationJoint* inObj ) { return inObj->getStiffness(); }
void setPxArticulationJoint_Damping( PxArticulationJoint* inObj, PxReal inArg){ inObj->setDamping( inArg ); }
PxReal getPxArticulationJoint_Damping( const PxArticulationJoint* inObj ) { return inObj->getDamping(); }
void setPxArticulationJoint_InternalCompliance( PxArticulationJoint* inObj, PxReal inArg){ inObj->setInternalCompliance( inArg ); }
PxReal getPxArticulationJoint_InternalCompliance( const PxArticulationJoint* inObj ) { return inObj->getInternalCompliance(); }
void setPxArticulationJoint_ExternalCompliance( PxArticulationJoint* inObj, PxReal inArg){ inObj->setExternalCompliance( inArg ); }
PxReal getPxArticulationJoint_ExternalCompliance( const PxArticulationJoint* inObj ) { return inObj->getExternalCompliance(); }
void setPxArticulationJoint_SwingLimit( PxArticulationJoint* inObj, PxReal inArg0, PxReal inArg1 ) { inObj->setSwingLimit( inArg0, inArg1 ); }
void getPxArticulationJoint_SwingLimit( const PxArticulationJoint* inObj, PxReal& inArg0, PxReal& inArg1 ) { inObj->getSwingLimit( inArg0, inArg1 ); }
void setPxArticulationJoint_TangentialStiffness( PxArticulationJoint* inObj, PxReal inArg){ inObj->setTangentialStiffness( inArg ); }
PxReal getPxArticulationJoint_TangentialStiffness( const PxArticulationJoint* inObj ) { return inObj->getTangentialStiffness(); }
void setPxArticulationJoint_TangentialDamping( PxArticulationJoint* inObj, PxReal inArg){ inObj->setTangentialDamping( inArg ); }
PxReal getPxArticulationJoint_TangentialDamping( const PxArticulationJoint* inObj ) { return inObj->getTangentialDamping(); }
void setPxArticulationJoint_SwingLimitContactDistance( PxArticulationJoint* inObj, PxReal inArg){ inObj->setSwingLimitContactDistance( inArg ); }
PxReal getPxArticulationJoint_SwingLimitContactDistance( const PxArticulationJoint* inObj ) { return inObj->getSwingLimitContactDistance(); }
void setPxArticulationJoint_SwingLimitEnabled( PxArticulationJoint* inObj, _Bool inArg){ inObj->setSwingLimitEnabled( inArg ); }
_Bool getPxArticulationJoint_SwingLimitEnabled( const PxArticulationJoint* inObj ) { return inObj->getSwingLimitEnabled(); }
void setPxArticulationJoint_TwistLimit( PxArticulationJoint* inObj, PxReal inArg0, PxReal inArg1 ) { inObj->setTwistLimit( inArg0, inArg1 ); }
void getPxArticulationJoint_TwistLimit( const PxArticulationJoint* inObj, PxReal& inArg0, PxReal& inArg1 ) { inObj->getTwistLimit( inArg0, inArg1 ); }
void setPxArticulationJoint_TwistLimitEnabled( PxArticulationJoint* inObj, _Bool inArg){ inObj->setTwistLimitEnabled( inArg ); }
_Bool getPxArticulationJoint_TwistLimitEnabled( const PxArticulationJoint* inObj ) { return inObj->getTwistLimitEnabled(); }
void setPxArticulationJoint_TwistLimitContactDistance( PxArticulationJoint* inObj, PxReal inArg){ inObj->setTwistLimitContactDistance( inArg ); }
PxReal getPxArticulationJoint_TwistLimitContactDistance( const PxArticulationJoint* inObj ) { return inObj->getTwistLimitContactDistance(); }
const char * getPxArticulationJoint_ConcreteTypeName( const PxArticulationJoint* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxArticulationJointGeneratedInfo::PxArticulationJointGeneratedInfo()
	: TargetOrientation( "TargetOrientation", setPxArticulationJoint_TargetOrientation, getPxArticulationJoint_TargetOrientation)
	, TargetVelocity( "TargetVelocity", setPxArticulationJoint_TargetVelocity, getPxArticulationJoint_TargetVelocity)
	, DriveType( "DriveType", setPxArticulationJoint_DriveType, getPxArticulationJoint_DriveType)
	, Stiffness( "Stiffness", setPxArticulationJoint_Stiffness, getPxArticulationJoint_Stiffness)
	, Damping( "Damping", setPxArticulationJoint_Damping, getPxArticulationJoint_Damping)
	, InternalCompliance( "InternalCompliance", setPxArticulationJoint_InternalCompliance, getPxArticulationJoint_InternalCompliance)
	, ExternalCompliance( "ExternalCompliance", setPxArticulationJoint_ExternalCompliance, getPxArticulationJoint_ExternalCompliance)
	, SwingLimit( "SwingLimit", "zLimit", "yLimit", setPxArticulationJoint_SwingLimit, getPxArticulationJoint_SwingLimit)
	, TangentialStiffness( "TangentialStiffness", setPxArticulationJoint_TangentialStiffness, getPxArticulationJoint_TangentialStiffness)
	, TangentialDamping( "TangentialDamping", setPxArticulationJoint_TangentialDamping, getPxArticulationJoint_TangentialDamping)
	, SwingLimitContactDistance( "SwingLimitContactDistance", setPxArticulationJoint_SwingLimitContactDistance, getPxArticulationJoint_SwingLimitContactDistance)
	, SwingLimitEnabled( "SwingLimitEnabled", setPxArticulationJoint_SwingLimitEnabled, getPxArticulationJoint_SwingLimitEnabled)
	, TwistLimit( "TwistLimit", "lower", "upper", setPxArticulationJoint_TwistLimit, getPxArticulationJoint_TwistLimit)
	, TwistLimitEnabled( "TwistLimitEnabled", setPxArticulationJoint_TwistLimitEnabled, getPxArticulationJoint_TwistLimitEnabled)
	, TwistLimitContactDistance( "TwistLimitContactDistance", setPxArticulationJoint_TwistLimitContactDistance, getPxArticulationJoint_TwistLimitContactDistance)
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationJoint_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxArticulationJointGeneratedValues::PxArticulationJointGeneratedValues( const PxArticulationJoint* inSource )
		:PxArticulationJointBaseGeneratedValues( inSource )
		,TargetOrientation( getPxArticulationJoint_TargetOrientation( inSource ) )
		,TargetVelocity( getPxArticulationJoint_TargetVelocity( inSource ) )
		,DriveType( getPxArticulationJoint_DriveType( inSource ) )
		,Stiffness( getPxArticulationJoint_Stiffness( inSource ) )
		,Damping( getPxArticulationJoint_Damping( inSource ) )
		,InternalCompliance( getPxArticulationJoint_InternalCompliance( inSource ) )
		,ExternalCompliance( getPxArticulationJoint_ExternalCompliance( inSource ) )
		,TangentialStiffness( getPxArticulationJoint_TangentialStiffness( inSource ) )
		,TangentialDamping( getPxArticulationJoint_TangentialDamping( inSource ) )
		,SwingLimitContactDistance( getPxArticulationJoint_SwingLimitContactDistance( inSource ) )
		,SwingLimitEnabled( getPxArticulationJoint_SwingLimitEnabled( inSource ) )
		,TwistLimitEnabled( getPxArticulationJoint_TwistLimitEnabled( inSource ) )
		,TwistLimitContactDistance( getPxArticulationJoint_TwistLimitContactDistance( inSource ) )
		,ConcreteTypeName( getPxArticulationJoint_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
	getPxArticulationJoint_SwingLimit( inSource, SwingLimit[0], SwingLimit[1] );
	getPxArticulationJoint_TwistLimit( inSource, TwistLimit[0], TwistLimit[1] );
}
PxScene * getPxArticulationBase_Scene( const PxArticulationBase* inObj ) { return inObj->getScene(); }
void setPxArticulationBase_SolverIterationCounts( PxArticulationBase* inObj, PxU32 inArg0, PxU32 inArg1 ) { inObj->setSolverIterationCounts( inArg0, inArg1 ); }
void getPxArticulationBase_SolverIterationCounts( const PxArticulationBase* inObj, PxU32& inArg0, PxU32& inArg1 ) { inObj->getSolverIterationCounts( inArg0, inArg1 ); }
_Bool getPxArticulationBase_IsSleeping( const PxArticulationBase* inObj ) { return inObj->isSleeping(); }
void setPxArticulationBase_SleepThreshold( PxArticulationBase* inObj, PxReal inArg){ inObj->setSleepThreshold( inArg ); }
PxReal getPxArticulationBase_SleepThreshold( const PxArticulationBase* inObj ) { return inObj->getSleepThreshold(); }
void setPxArticulationBase_StabilizationThreshold( PxArticulationBase* inObj, PxReal inArg){ inObj->setStabilizationThreshold( inArg ); }
PxReal getPxArticulationBase_StabilizationThreshold( const PxArticulationBase* inObj ) { return inObj->getStabilizationThreshold(); }
void setPxArticulationBase_WakeCounter( PxArticulationBase* inObj, PxReal inArg){ inObj->setWakeCounter( inArg ); }
PxReal getPxArticulationBase_WakeCounter( const PxArticulationBase* inObj ) { return inObj->getWakeCounter(); }
PxU32 getPxArticulationBase_Links( const PxArticulationBase* inObj, PxArticulationLink ** outBuffer, PxU32 inBufSize ) { return inObj->getLinks( outBuffer, inBufSize ); }
PxU32 getNbPxArticulationBase_Links( const PxArticulationBase* inObj ) { return inObj->getNbLinks(  ); }
void setPxArticulationBase_Name( PxArticulationBase* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxArticulationBase_Name( const PxArticulationBase* inObj ) { return inObj->getName(); }
PxAggregate * getPxArticulationBase_Aggregate( const PxArticulationBase* inObj ) { return inObj->getAggregate(); }
PxArticulationBase::Enum getPxArticulationBase_Type( const PxArticulationBase* inObj ) { return inObj->getType(); }
inline void * getPxArticulationBaseUserData( const PxArticulationBase* inOwner ) { return inOwner->userData; }
inline void setPxArticulationBaseUserData( PxArticulationBase* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxArticulationBaseGeneratedInfo::PxArticulationBaseGeneratedInfo()
	: Scene( "Scene", getPxArticulationBase_Scene)
	, SolverIterationCounts( "SolverIterationCounts", "minPositionIters", "minVelocityIters", setPxArticulationBase_SolverIterationCounts, getPxArticulationBase_SolverIterationCounts)
	, IsSleeping( "IsSleeping", getPxArticulationBase_IsSleeping)
	, SleepThreshold( "SleepThreshold", setPxArticulationBase_SleepThreshold, getPxArticulationBase_SleepThreshold)
	, StabilizationThreshold( "StabilizationThreshold", setPxArticulationBase_StabilizationThreshold, getPxArticulationBase_StabilizationThreshold)
	, WakeCounter( "WakeCounter", setPxArticulationBase_WakeCounter, getPxArticulationBase_WakeCounter)
	, Links( "Links", getPxArticulationBase_Links, getNbPxArticulationBase_Links )
	, Name( "Name", setPxArticulationBase_Name, getPxArticulationBase_Name)
	, Aggregate( "Aggregate", getPxArticulationBase_Aggregate)
	, Type( "Type", getPxArticulationBase_Type)
	, UserData( "UserData", setPxArticulationBaseUserData, getPxArticulationBaseUserData )
{}
PX_PHYSX_CORE_API PxArticulationBaseGeneratedValues::PxArticulationBaseGeneratedValues( const PxArticulationBase* inSource )
		:Scene( getPxArticulationBase_Scene( inSource ) )
		,IsSleeping( getPxArticulationBase_IsSleeping( inSource ) )
		,SleepThreshold( getPxArticulationBase_SleepThreshold( inSource ) )
		,StabilizationThreshold( getPxArticulationBase_StabilizationThreshold( inSource ) )
		,WakeCounter( getPxArticulationBase_WakeCounter( inSource ) )
		,Name( getPxArticulationBase_Name( inSource ) )
		,Aggregate( getPxArticulationBase_Aggregate( inSource ) )
		,Type( getPxArticulationBase_Type( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	getPxArticulationBase_SolverIterationCounts( inSource, SolverIterationCounts[0], SolverIterationCounts[1] );
}
void setPxArticulation_MaxProjectionIterations( PxArticulation* inObj, PxU32 inArg){ inObj->setMaxProjectionIterations( inArg ); }
PxU32 getPxArticulation_MaxProjectionIterations( const PxArticulation* inObj ) { return inObj->getMaxProjectionIterations(); }
void setPxArticulation_SeparationTolerance( PxArticulation* inObj, PxReal inArg){ inObj->setSeparationTolerance( inArg ); }
PxReal getPxArticulation_SeparationTolerance( const PxArticulation* inObj ) { return inObj->getSeparationTolerance(); }
void setPxArticulation_InternalDriveIterations( PxArticulation* inObj, PxU32 inArg){ inObj->setInternalDriveIterations( inArg ); }
PxU32 getPxArticulation_InternalDriveIterations( const PxArticulation* inObj ) { return inObj->getInternalDriveIterations(); }
void setPxArticulation_ExternalDriveIterations( PxArticulation* inObj, PxU32 inArg){ inObj->setExternalDriveIterations( inArg ); }
PxU32 getPxArticulation_ExternalDriveIterations( const PxArticulation* inObj ) { return inObj->getExternalDriveIterations(); }
PX_PHYSX_CORE_API PxArticulationGeneratedInfo::PxArticulationGeneratedInfo()
	: MaxProjectionIterations( "MaxProjectionIterations", setPxArticulation_MaxProjectionIterations, getPxArticulation_MaxProjectionIterations)
	, SeparationTolerance( "SeparationTolerance", setPxArticulation_SeparationTolerance, getPxArticulation_SeparationTolerance)
	, InternalDriveIterations( "InternalDriveIterations", setPxArticulation_InternalDriveIterations, getPxArticulation_InternalDriveIterations)
	, ExternalDriveIterations( "ExternalDriveIterations", setPxArticulation_ExternalDriveIterations, getPxArticulation_ExternalDriveIterations)
{}
PX_PHYSX_CORE_API PxArticulationGeneratedValues::PxArticulationGeneratedValues( const PxArticulation* inSource )
		:PxArticulationBaseGeneratedValues( inSource )
		,MaxProjectionIterations( getPxArticulation_MaxProjectionIterations( inSource ) )
		,SeparationTolerance( getPxArticulation_SeparationTolerance( inSource ) )
		,InternalDriveIterations( getPxArticulation_InternalDriveIterations( inSource ) )
		,ExternalDriveIterations( getPxArticulation_ExternalDriveIterations( inSource ) )
{
	PX_UNUSED(inSource);
}
PxU32 getPxAggregate_MaxNbActors( const PxAggregate* inObj ) { return inObj->getMaxNbActors(); }
PxU32 getPxAggregate_Actors( const PxAggregate* inObj, PxActor ** outBuffer, PxU32 inBufSize ) { return inObj->getActors( outBuffer, inBufSize ); }
PxU32 getNbPxAggregate_Actors( const PxAggregate* inObj ) { return inObj->getNbActors(  ); }
_Bool getPxAggregate_SelfCollision( const PxAggregate* inObj ) { return inObj->getSelfCollision(); }
const char * getPxAggregate_ConcreteTypeName( const PxAggregate* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxAggregateGeneratedInfo::PxAggregateGeneratedInfo()
	: MaxNbActors( "MaxNbActors", getPxAggregate_MaxNbActors)
	, Actors( "Actors", getPxAggregate_Actors, getNbPxAggregate_Actors )
	, SelfCollision( "SelfCollision", getPxAggregate_SelfCollision)
	, ConcreteTypeName( "ConcreteTypeName", getPxAggregate_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxAggregateGeneratedValues::PxAggregateGeneratedValues( const PxAggregate* inSource )
		:MaxNbActors( getPxAggregate_MaxNbActors( inSource ) )
		,SelfCollision( getPxAggregate_SelfCollision( inSource ) )
		,ConcreteTypeName( getPxAggregate_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
PxScene * getPxConstraint_Scene( const PxConstraint* inObj ) { return inObj->getScene(); }
void setPxConstraint_Actors( PxConstraint* inObj, PxRigidActor * inArg0, PxRigidActor * inArg1 ) { inObj->setActors( inArg0, inArg1 ); }
void getPxConstraint_Actors( const PxConstraint* inObj, PxRigidActor *& inArg0, PxRigidActor *& inArg1 ) { inObj->getActors( inArg0, inArg1 ); }
void setPxConstraint_Flags( PxConstraint* inObj, PxConstraintFlags inArg){ inObj->setFlags( inArg ); }
PxConstraintFlags getPxConstraint_Flags( const PxConstraint* inObj ) { return inObj->getFlags(); }
_Bool getPxConstraint_IsValid( const PxConstraint* inObj ) { return inObj->isValid(); }
void setPxConstraint_BreakForce( PxConstraint* inObj, PxReal inArg0, PxReal inArg1 ) { inObj->setBreakForce( inArg0, inArg1 ); }
void getPxConstraint_BreakForce( const PxConstraint* inObj, PxReal& inArg0, PxReal& inArg1 ) { inObj->getBreakForce( inArg0, inArg1 ); }
void setPxConstraint_MinResponseThreshold( PxConstraint* inObj, PxReal inArg){ inObj->setMinResponseThreshold( inArg ); }
PxReal getPxConstraint_MinResponseThreshold( const PxConstraint* inObj ) { return inObj->getMinResponseThreshold(); }
const char * getPxConstraint_ConcreteTypeName( const PxConstraint* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxConstraintGeneratedInfo::PxConstraintGeneratedInfo()
	: Scene( "Scene", getPxConstraint_Scene)
	, Actors( "Actors", "actor0", "actor1", setPxConstraint_Actors, getPxConstraint_Actors)
	, Flags( "Flags", setPxConstraint_Flags, getPxConstraint_Flags)
	, IsValid( "IsValid", getPxConstraint_IsValid)
	, BreakForce( "BreakForce", "linear", "angular", setPxConstraint_BreakForce, getPxConstraint_BreakForce)
	, MinResponseThreshold( "MinResponseThreshold", setPxConstraint_MinResponseThreshold, getPxConstraint_MinResponseThreshold)
	, ConcreteTypeName( "ConcreteTypeName", getPxConstraint_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxConstraintGeneratedValues::PxConstraintGeneratedValues( const PxConstraint* inSource )
		:Scene( getPxConstraint_Scene( inSource ) )
		,Flags( getPxConstraint_Flags( inSource ) )
		,IsValid( getPxConstraint_IsValid( inSource ) )
		,MinResponseThreshold( getPxConstraint_MinResponseThreshold( inSource ) )
		,ConcreteTypeName( getPxConstraint_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
	getPxConstraint_Actors( inSource, Actors[0], Actors[1] );
	getPxConstraint_BreakForce( inSource, BreakForce[0], BreakForce[1] );
}
PxU32 getPxShape_ReferenceCount( const PxShape* inObj ) { return inObj->getReferenceCount(); }
PxGeometryType::Enum getPxShape_GeometryType( const PxShape* inObj ) { return inObj->getGeometryType(); }
void setPxShape_Geometry( PxShape* inObj, const PxGeometry & inArg){ inObj->setGeometry( inArg ); }
PxGeometryHolder getPxShape_Geometry( const PxShape* inObj ) { return inObj->getGeometry(); }
void setPxShape_LocalPose( PxShape* inObj, const PxTransform & inArg){ inObj->setLocalPose( inArg ); }
PxTransform getPxShape_LocalPose( const PxShape* inObj ) { return inObj->getLocalPose(); }
void setPxShape_SimulationFilterData( PxShape* inObj, const PxFilterData & inArg){ inObj->setSimulationFilterData( inArg ); }
PxFilterData getPxShape_SimulationFilterData( const PxShape* inObj ) { return inObj->getSimulationFilterData(); }
void setPxShape_QueryFilterData( PxShape* inObj, const PxFilterData & inArg){ inObj->setQueryFilterData( inArg ); }
PxFilterData getPxShape_QueryFilterData( const PxShape* inObj ) { return inObj->getQueryFilterData(); }
PxU32 getPxShape_Materials( const PxShape* inObj, PxMaterial ** outBuffer, PxU32 inBufSize ) { return inObj->getMaterials( outBuffer, inBufSize ); }
PxU32 getNbPxShape_Materials( const PxShape* inObj ) { return inObj->getNbMaterials(  ); }
void setPxShape_ContactOffset( PxShape* inObj, PxReal inArg){ inObj->setContactOffset( inArg ); }
PxReal getPxShape_ContactOffset( const PxShape* inObj ) { return inObj->getContactOffset(); }
void setPxShape_RestOffset( PxShape* inObj, PxReal inArg){ inObj->setRestOffset( inArg ); }
PxReal getPxShape_RestOffset( const PxShape* inObj ) { return inObj->getRestOffset(); }
void setPxShape_TorsionalPatchRadius( PxShape* inObj, PxReal inArg){ inObj->setTorsionalPatchRadius( inArg ); }
PxReal getPxShape_TorsionalPatchRadius( const PxShape* inObj ) { return inObj->getTorsionalPatchRadius(); }
void setPxShape_MinTorsionalPatchRadius( PxShape* inObj, PxReal inArg){ inObj->setMinTorsionalPatchRadius( inArg ); }
PxReal getPxShape_MinTorsionalPatchRadius( const PxShape* inObj ) { return inObj->getMinTorsionalPatchRadius(); }
void setPxShape_Flags( PxShape* inObj, PxShapeFlags inArg){ inObj->setFlags( inArg ); }
PxShapeFlags getPxShape_Flags( const PxShape* inObj ) { return inObj->getFlags(); }
_Bool getPxShape_IsExclusive( const PxShape* inObj ) { return inObj->isExclusive(); }
void setPxShape_Name( PxShape* inObj, const char * inArg){ inObj->setName( inArg ); }
const char * getPxShape_Name( const PxShape* inObj ) { return inObj->getName(); }
const char * getPxShape_ConcreteTypeName( const PxShape* inObj ) { return inObj->getConcreteTypeName(); }
inline void * getPxShapeUserData( const PxShape* inOwner ) { return inOwner->userData; }
inline void setPxShapeUserData( PxShape* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxShapeGeneratedInfo::PxShapeGeneratedInfo()
	: ReferenceCount( "ReferenceCount", getPxShape_ReferenceCount)
	, GeometryType( "GeometryType", getPxShape_GeometryType)
	, Geometry( "Geometry", setPxShape_Geometry, getPxShape_Geometry)
	, LocalPose( "LocalPose", setPxShape_LocalPose, getPxShape_LocalPose)
	, SimulationFilterData( "SimulationFilterData", setPxShape_SimulationFilterData, getPxShape_SimulationFilterData)
	, QueryFilterData( "QueryFilterData", setPxShape_QueryFilterData, getPxShape_QueryFilterData)
	, Materials( "Materials", getPxShape_Materials, getNbPxShape_Materials )
	, ContactOffset( "ContactOffset", setPxShape_ContactOffset, getPxShape_ContactOffset)
	, RestOffset( "RestOffset", setPxShape_RestOffset, getPxShape_RestOffset)
	, TorsionalPatchRadius( "TorsionalPatchRadius", setPxShape_TorsionalPatchRadius, getPxShape_TorsionalPatchRadius)
	, MinTorsionalPatchRadius( "MinTorsionalPatchRadius", setPxShape_MinTorsionalPatchRadius, getPxShape_MinTorsionalPatchRadius)
	, Flags( "Flags", setPxShape_Flags, getPxShape_Flags)
	, IsExclusive( "IsExclusive", getPxShape_IsExclusive)
	, Name( "Name", setPxShape_Name, getPxShape_Name)
	, ConcreteTypeName( "ConcreteTypeName", getPxShape_ConcreteTypeName)
	, UserData( "UserData", setPxShapeUserData, getPxShapeUserData )
{}
PX_PHYSX_CORE_API PxShapeGeneratedValues::PxShapeGeneratedValues( const PxShape* inSource )
		:ReferenceCount( getPxShape_ReferenceCount( inSource ) )
		,GeometryType( getPxShape_GeometryType( inSource ) )
		,Geometry( getPxShape_Geometry( inSource ) )
		,LocalPose( getPxShape_LocalPose( inSource ) )
		,SimulationFilterData( getPxShape_SimulationFilterData( inSource ) )
		,QueryFilterData( getPxShape_QueryFilterData( inSource ) )
		,ContactOffset( getPxShape_ContactOffset( inSource ) )
		,RestOffset( getPxShape_RestOffset( inSource ) )
		,TorsionalPatchRadius( getPxShape_TorsionalPatchRadius( inSource ) )
		,MinTorsionalPatchRadius( getPxShape_MinTorsionalPatchRadius( inSource ) )
		,Flags( getPxShape_Flags( inSource ) )
		,IsExclusive( getPxShape_IsExclusive( inSource ) )
		,Name( getPxShape_Name( inSource ) )
		,ConcreteTypeName( getPxShape_ConcreteTypeName( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
}
PxU32 getPxPruningStructure_RigidActors( const PxPruningStructure* inObj, PxRigidActor ** outBuffer, PxU32 inBufSize ) { return inObj->getRigidActors( outBuffer, inBufSize ); }
PxU32 getNbPxPruningStructure_RigidActors( const PxPruningStructure* inObj ) { return inObj->getNbRigidActors(  ); }
const char * getPxPruningStructure_ConcreteTypeName( const PxPruningStructure* inObj ) { return inObj->getConcreteTypeName(); }
PX_PHYSX_CORE_API PxPruningStructureGeneratedInfo::PxPruningStructureGeneratedInfo()
	: RigidActors( "RigidActors", getPxPruningStructure_RigidActors, getNbPxPruningStructure_RigidActors )
	, ConcreteTypeName( "ConcreteTypeName", getPxPruningStructure_ConcreteTypeName)
{}
PX_PHYSX_CORE_API PxPruningStructureGeneratedValues::PxPruningStructureGeneratedValues( const PxPruningStructure* inSource )
		:ConcreteTypeName( getPxPruningStructure_ConcreteTypeName( inSource ) )
{
	PX_UNUSED(inSource);
}
_Bool getPxTolerancesScale_IsValid( const PxTolerancesScale* inObj ) { return inObj->isValid(); }
inline PxReal getPxTolerancesScaleLength( const PxTolerancesScale* inOwner ) { return inOwner->length; }
inline void setPxTolerancesScaleLength( PxTolerancesScale* inOwner, PxReal inData) { inOwner->length = inData; }
inline PxReal getPxTolerancesScaleSpeed( const PxTolerancesScale* inOwner ) { return inOwner->speed; }
inline void setPxTolerancesScaleSpeed( PxTolerancesScale* inOwner, PxReal inData) { inOwner->speed = inData; }
PX_PHYSX_CORE_API PxTolerancesScaleGeneratedInfo::PxTolerancesScaleGeneratedInfo()
	: IsValid( "IsValid", getPxTolerancesScale_IsValid)
	, Length( "Length", setPxTolerancesScaleLength, getPxTolerancesScaleLength )
	, Speed( "Speed", setPxTolerancesScaleSpeed, getPxTolerancesScaleSpeed )
{}
PX_PHYSX_CORE_API PxTolerancesScaleGeneratedValues::PxTolerancesScaleGeneratedValues( const PxTolerancesScale* inSource )
		:IsValid( getPxTolerancesScale_IsValid( inSource ) )
		,Length( inSource->length )
		,Speed( inSource->speed )
{
	PX_UNUSED(inSource);
}
PX_PHYSX_CORE_API PxGeometryGeneratedInfo::PxGeometryGeneratedInfo()
{}
PX_PHYSX_CORE_API PxGeometryGeneratedValues::PxGeometryGeneratedValues( const PxGeometry* inSource )
{
	PX_UNUSED(inSource);
}
inline PxVec3 getPxBoxGeometryHalfExtents( const PxBoxGeometry* inOwner ) { return inOwner->halfExtents; }
inline void setPxBoxGeometryHalfExtents( PxBoxGeometry* inOwner, PxVec3 inData) { inOwner->halfExtents = inData; }
PX_PHYSX_CORE_API PxBoxGeometryGeneratedInfo::PxBoxGeometryGeneratedInfo()
	: HalfExtents( "HalfExtents", setPxBoxGeometryHalfExtents, getPxBoxGeometryHalfExtents )
{}
PX_PHYSX_CORE_API PxBoxGeometryGeneratedValues::PxBoxGeometryGeneratedValues( const PxBoxGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,HalfExtents( inSource->halfExtents )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxCapsuleGeometryRadius( const PxCapsuleGeometry* inOwner ) { return inOwner->radius; }
inline void setPxCapsuleGeometryRadius( PxCapsuleGeometry* inOwner, PxReal inData) { inOwner->radius = inData; }
inline PxReal getPxCapsuleGeometryHalfHeight( const PxCapsuleGeometry* inOwner ) { return inOwner->halfHeight; }
inline void setPxCapsuleGeometryHalfHeight( PxCapsuleGeometry* inOwner, PxReal inData) { inOwner->halfHeight = inData; }
PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedInfo::PxCapsuleGeometryGeneratedInfo()
	: Radius( "Radius", setPxCapsuleGeometryRadius, getPxCapsuleGeometryRadius )
	, HalfHeight( "HalfHeight", setPxCapsuleGeometryHalfHeight, getPxCapsuleGeometryHalfHeight )
{}
PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedValues::PxCapsuleGeometryGeneratedValues( const PxCapsuleGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Radius( inSource->radius )
		,HalfHeight( inSource->halfHeight )
{
	PX_UNUSED(inSource);
}
inline PxVec3 getPxMeshScaleScale( const PxMeshScale* inOwner ) { return inOwner->scale; }
inline void setPxMeshScaleScale( PxMeshScale* inOwner, PxVec3 inData) { inOwner->scale = inData; }
inline PxQuat getPxMeshScaleRotation( const PxMeshScale* inOwner ) { return inOwner->rotation; }
inline void setPxMeshScaleRotation( PxMeshScale* inOwner, PxQuat inData) { inOwner->rotation = inData; }
PX_PHYSX_CORE_API PxMeshScaleGeneratedInfo::PxMeshScaleGeneratedInfo()
	: Scale( "Scale", setPxMeshScaleScale, getPxMeshScaleScale )
	, Rotation( "Rotation", setPxMeshScaleRotation, getPxMeshScaleRotation )
{}
PX_PHYSX_CORE_API PxMeshScaleGeneratedValues::PxMeshScaleGeneratedValues( const PxMeshScale* inSource )
		:Scale( inSource->scale )
		,Rotation( inSource->rotation )
{
	PX_UNUSED(inSource);
}
inline PxMeshScale getPxConvexMeshGeometryScale( const PxConvexMeshGeometry* inOwner ) { return inOwner->scale; }
inline void setPxConvexMeshGeometryScale( PxConvexMeshGeometry* inOwner, PxMeshScale inData) { inOwner->scale = inData; }
inline PxConvexMesh * getPxConvexMeshGeometryConvexMesh( const PxConvexMeshGeometry* inOwner ) { return inOwner->convexMesh; }
inline void setPxConvexMeshGeometryConvexMesh( PxConvexMeshGeometry* inOwner, PxConvexMesh * inData) { inOwner->convexMesh = inData; }
inline PxConvexMeshGeometryFlags getPxConvexMeshGeometryMeshFlags( const PxConvexMeshGeometry* inOwner ) { return inOwner->meshFlags; }
inline void setPxConvexMeshGeometryMeshFlags( PxConvexMeshGeometry* inOwner, PxConvexMeshGeometryFlags inData) { inOwner->meshFlags = inData; }
PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedInfo::PxConvexMeshGeometryGeneratedInfo()
	: Scale( "Scale", setPxConvexMeshGeometryScale, getPxConvexMeshGeometryScale )
	, ConvexMesh( "ConvexMesh", setPxConvexMeshGeometryConvexMesh, getPxConvexMeshGeometryConvexMesh )
	, MeshFlags( "MeshFlags", setPxConvexMeshGeometryMeshFlags, getPxConvexMeshGeometryMeshFlags )
{}
PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedValues::PxConvexMeshGeometryGeneratedValues( const PxConvexMeshGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Scale( inSource->scale )
		,ConvexMesh( inSource->convexMesh )
		,MeshFlags( inSource->meshFlags )
{
	PX_UNUSED(inSource);
}
inline PxReal getPxSphereGeometryRadius( const PxSphereGeometry* inOwner ) { return inOwner->radius; }
inline void setPxSphereGeometryRadius( PxSphereGeometry* inOwner, PxReal inData) { inOwner->radius = inData; }
PX_PHYSX_CORE_API PxSphereGeometryGeneratedInfo::PxSphereGeometryGeneratedInfo()
	: Radius( "Radius", setPxSphereGeometryRadius, getPxSphereGeometryRadius )
{}
PX_PHYSX_CORE_API PxSphereGeometryGeneratedValues::PxSphereGeometryGeneratedValues( const PxSphereGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Radius( inSource->radius )
{
	PX_UNUSED(inSource);
}
PX_PHYSX_CORE_API PxPlaneGeometryGeneratedInfo::PxPlaneGeometryGeneratedInfo()
{}
PX_PHYSX_CORE_API PxPlaneGeometryGeneratedValues::PxPlaneGeometryGeneratedValues( const PxPlaneGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
{
	PX_UNUSED(inSource);
}
inline PxMeshScale getPxTriangleMeshGeometryScale( const PxTriangleMeshGeometry* inOwner ) { return inOwner->scale; }
inline void setPxTriangleMeshGeometryScale( PxTriangleMeshGeometry* inOwner, PxMeshScale inData) { inOwner->scale = inData; }
inline PxMeshGeometryFlags getPxTriangleMeshGeometryMeshFlags( const PxTriangleMeshGeometry* inOwner ) { return inOwner->meshFlags; }
inline void setPxTriangleMeshGeometryMeshFlags( PxTriangleMeshGeometry* inOwner, PxMeshGeometryFlags inData) { inOwner->meshFlags = inData; }
inline PxTriangleMesh * getPxTriangleMeshGeometryTriangleMesh( const PxTriangleMeshGeometry* inOwner ) { return inOwner->triangleMesh; }
inline void setPxTriangleMeshGeometryTriangleMesh( PxTriangleMeshGeometry* inOwner, PxTriangleMesh * inData) { inOwner->triangleMesh = inData; }
PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedInfo::PxTriangleMeshGeometryGeneratedInfo()
	: Scale( "Scale", setPxTriangleMeshGeometryScale, getPxTriangleMeshGeometryScale )
	, MeshFlags( "MeshFlags", setPxTriangleMeshGeometryMeshFlags, getPxTriangleMeshGeometryMeshFlags )
	, TriangleMesh( "TriangleMesh", setPxTriangleMeshGeometryTriangleMesh, getPxTriangleMeshGeometryTriangleMesh )
{}
PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedValues::PxTriangleMeshGeometryGeneratedValues( const PxTriangleMeshGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,Scale( inSource->scale )
		,MeshFlags( inSource->meshFlags )
		,TriangleMesh( inSource->triangleMesh )
{
	PX_UNUSED(inSource);
}
inline PxHeightField * getPxHeightFieldGeometryHeightField( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightField; }
inline void setPxHeightFieldGeometryHeightField( PxHeightFieldGeometry* inOwner, PxHeightField * inData) { inOwner->heightField = inData; }
inline PxReal getPxHeightFieldGeometryHeightScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightScale; }
inline void setPxHeightFieldGeometryHeightScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->heightScale = inData; }
inline PxReal getPxHeightFieldGeometryRowScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->rowScale; }
inline void setPxHeightFieldGeometryRowScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->rowScale = inData; }
inline PxReal getPxHeightFieldGeometryColumnScale( const PxHeightFieldGeometry* inOwner ) { return inOwner->columnScale; }
inline void setPxHeightFieldGeometryColumnScale( PxHeightFieldGeometry* inOwner, PxReal inData) { inOwner->columnScale = inData; }
inline PxMeshGeometryFlags getPxHeightFieldGeometryHeightFieldFlags( const PxHeightFieldGeometry* inOwner ) { return inOwner->heightFieldFlags; }
inline void setPxHeightFieldGeometryHeightFieldFlags( PxHeightFieldGeometry* inOwner, PxMeshGeometryFlags inData) { inOwner->heightFieldFlags = inData; }
PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedInfo::PxHeightFieldGeometryGeneratedInfo()
	: HeightField( "HeightField", setPxHeightFieldGeometryHeightField, getPxHeightFieldGeometryHeightField )
	, HeightScale( "HeightScale", setPxHeightFieldGeometryHeightScale, getPxHeightFieldGeometryHeightScale )
	, RowScale( "RowScale", setPxHeightFieldGeometryRowScale, getPxHeightFieldGeometryRowScale )
	, ColumnScale( "ColumnScale", setPxHeightFieldGeometryColumnScale, getPxHeightFieldGeometryColumnScale )
	, HeightFieldFlags( "HeightFieldFlags", setPxHeightFieldGeometryHeightFieldFlags, getPxHeightFieldGeometryHeightFieldFlags )
{}
PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedValues::PxHeightFieldGeometryGeneratedValues( const PxHeightFieldGeometry* inSource )
		:PxGeometryGeneratedValues( inSource )
		,HeightField( inSource->heightField )
		,HeightScale( inSource->heightScale )
		,RowScale( inSource->rowScale )
		,ColumnScale( inSource->columnScale )
		,HeightFieldFlags( inSource->heightFieldFlags )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxHeightFieldDescNbRows( const PxHeightFieldDesc* inOwner ) { return inOwner->nbRows; }
inline void setPxHeightFieldDescNbRows( PxHeightFieldDesc* inOwner, PxU32 inData) { inOwner->nbRows = inData; }
inline PxU32 getPxHeightFieldDescNbColumns( const PxHeightFieldDesc* inOwner ) { return inOwner->nbColumns; }
inline void setPxHeightFieldDescNbColumns( PxHeightFieldDesc* inOwner, PxU32 inData) { inOwner->nbColumns = inData; }
inline PxHeightFieldFormat::Enum getPxHeightFieldDescFormat( const PxHeightFieldDesc* inOwner ) { return inOwner->format; }
inline void setPxHeightFieldDescFormat( PxHeightFieldDesc* inOwner, PxHeightFieldFormat::Enum inData) { inOwner->format = inData; }
inline PxStridedData getPxHeightFieldDescSamples( const PxHeightFieldDesc* inOwner ) { return inOwner->samples; }
inline void setPxHeightFieldDescSamples( PxHeightFieldDesc* inOwner, PxStridedData inData) { inOwner->samples = inData; }
inline PxReal getPxHeightFieldDescConvexEdgeThreshold( const PxHeightFieldDesc* inOwner ) { return inOwner->convexEdgeThreshold; }
inline void setPxHeightFieldDescConvexEdgeThreshold( PxHeightFieldDesc* inOwner, PxReal inData) { inOwner->convexEdgeThreshold = inData; }
inline PxHeightFieldFlags getPxHeightFieldDescFlags( const PxHeightFieldDesc* inOwner ) { return inOwner->flags; }
inline void setPxHeightFieldDescFlags( PxHeightFieldDesc* inOwner, PxHeightFieldFlags inData) { inOwner->flags = inData; }
PX_PHYSX_CORE_API PxHeightFieldDescGeneratedInfo::PxHeightFieldDescGeneratedInfo()
	: NbRows( "NbRows", setPxHeightFieldDescNbRows, getPxHeightFieldDescNbRows )
	, NbColumns( "NbColumns", setPxHeightFieldDescNbColumns, getPxHeightFieldDescNbColumns )
	, Format( "Format", setPxHeightFieldDescFormat, getPxHeightFieldDescFormat )
	, Samples( "Samples", setPxHeightFieldDescSamples, getPxHeightFieldDescSamples )
	, ConvexEdgeThreshold( "ConvexEdgeThreshold", setPxHeightFieldDescConvexEdgeThreshold, getPxHeightFieldDescConvexEdgeThreshold )
	, Flags( "Flags", setPxHeightFieldDescFlags, getPxHeightFieldDescFlags )
{}
PX_PHYSX_CORE_API PxHeightFieldDescGeneratedValues::PxHeightFieldDescGeneratedValues( const PxHeightFieldDesc* inSource )
		:NbRows( inSource->nbRows )
		,NbColumns( inSource->nbColumns )
		,Format( inSource->format )
		,Samples( inSource->samples )
		,ConvexEdgeThreshold( inSource->convexEdgeThreshold )
		,Flags( inSource->flags )
{
	PX_UNUSED(inSource);
}
void setPxArticulationJointReducedCoordinate_JointType( PxArticulationJointReducedCoordinate* inObj, PxArticulationJointType::Enum inArg){ inObj->setJointType( inArg ); }
PxArticulationJointType::Enum getPxArticulationJointReducedCoordinate_JointType( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getJointType(); }
void setPxArticulationJointReducedCoordinate_Motion( PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex, PxArticulationMotion::Enum inArg ){ inObj->setMotion( inIndex, inArg ); }
PxArticulationMotion::Enum getPxArticulationJointReducedCoordinate_Motion( const PxArticulationJointReducedCoordinate* inObj, PxArticulationAxis::Enum inIndex ) { return inObj->getMotion( inIndex ); }
void setPxArticulationJointReducedCoordinate_FrictionCoefficient( PxArticulationJointReducedCoordinate* inObj, const PxReal inArg){ inObj->setFrictionCoefficient( inArg ); }
PxReal getPxArticulationJointReducedCoordinate_FrictionCoefficient( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getFrictionCoefficient(); }
const char * getPxArticulationJointReducedCoordinate_ConcreteTypeName( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getConcreteTypeName(); }
void setPxArticulationJointReducedCoordinate_MaxJointVelocity( PxArticulationJointReducedCoordinate* inObj, const PxReal inArg){ inObj->setMaxJointVelocity( inArg ); }
PxReal getPxArticulationJointReducedCoordinate_MaxJointVelocity( const PxArticulationJointReducedCoordinate* inObj ) { return inObj->getMaxJointVelocity(); }
PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedInfo::PxArticulationJointReducedCoordinateGeneratedInfo()
	: JointType( "JointType", setPxArticulationJointReducedCoordinate_JointType, getPxArticulationJointReducedCoordinate_JointType)
	, Motion( "Motion", setPxArticulationJointReducedCoordinate_Motion, getPxArticulationJointReducedCoordinate_Motion)
	, FrictionCoefficient( "FrictionCoefficient", setPxArticulationJointReducedCoordinate_FrictionCoefficient, getPxArticulationJointReducedCoordinate_FrictionCoefficient)
	, ConcreteTypeName( "ConcreteTypeName", getPxArticulationJointReducedCoordinate_ConcreteTypeName)
	, MaxJointVelocity( "MaxJointVelocity", setPxArticulationJointReducedCoordinate_MaxJointVelocity, getPxArticulationJointReducedCoordinate_MaxJointVelocity)
{}
PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedValues::PxArticulationJointReducedCoordinateGeneratedValues( const PxArticulationJointReducedCoordinate* inSource )
		:PxArticulationJointBaseGeneratedValues( inSource )
		,JointType( getPxArticulationJointReducedCoordinate_JointType( inSource ) )
		,FrictionCoefficient( getPxArticulationJointReducedCoordinate_FrictionCoefficient( inSource ) )
		,ConcreteTypeName( getPxArticulationJointReducedCoordinate_ConcreteTypeName( inSource ) )
		,MaxJointVelocity( getPxArticulationJointReducedCoordinate_MaxJointVelocity( inSource ) )
{
	PX_UNUSED(inSource);
		for ( PxU32 idx = 0; idx < static_cast<PxU32>( physx::PxArticulationAxis::eCOUNT ); ++idx )
		Motion[idx] = getPxArticulationJointReducedCoordinate_Motion( inSource, static_cast< PxArticulationAxis::Enum >( idx ) );
}
PxSceneFlags getPxScene_Flags( const PxScene* inObj ) { return inObj->getFlags(); }
void setPxScene_Limits( PxScene* inObj, const PxSceneLimits & inArg){ inObj->setLimits( inArg ); }
PxSceneLimits getPxScene_Limits( const PxScene* inObj ) { return inObj->getLimits(); }
PxU32 getPxScene_Timestamp( const PxScene* inObj ) { return inObj->getTimestamp(); }
PxU32 getPxScene_Actors( const PxScene* inObj, PxActorTypeFlags inFilter, PxActor ** outBuffer, PxU32 inBufSize ) { return inObj->getActors( inFilter, outBuffer, inBufSize ); }
PxU32 getNbPxScene_Actors( const PxScene* inObj, PxActorTypeFlags inFilter ) { return inObj->getNbActors( inFilter ); }
PxU32 getPxScene_Articulations( const PxScene* inObj, PxArticulationBase ** outBuffer, PxU32 inBufSize ) { return inObj->getArticulations( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Articulations( const PxScene* inObj ) { return inObj->getNbArticulations(  ); }
PxU32 getPxScene_Constraints( const PxScene* inObj, PxConstraint ** outBuffer, PxU32 inBufSize ) { return inObj->getConstraints( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Constraints( const PxScene* inObj ) { return inObj->getNbConstraints(  ); }
PxU32 getPxScene_Aggregates( const PxScene* inObj, PxAggregate ** outBuffer, PxU32 inBufSize ) { return inObj->getAggregates( outBuffer, inBufSize ); }
PxU32 getNbPxScene_Aggregates( const PxScene* inObj ) { return inObj->getNbAggregates(  ); }
PxCpuDispatcher * getPxScene_CpuDispatcher( const PxScene* inObj ) { return inObj->getCpuDispatcher(); }
PxGpuDispatcher * getPxScene_GpuDispatcher( const PxScene* inObj ) { return inObj->getGpuDispatcher(); }
void setPxScene_SimulationEventCallback( PxScene* inObj, PxSimulationEventCallback * inArg){ inObj->setSimulationEventCallback( inArg ); }
PxSimulationEventCallback * getPxScene_SimulationEventCallback( const PxScene* inObj ) { return inObj->getSimulationEventCallback(); }
void setPxScene_ContactModifyCallback( PxScene* inObj, PxContactModifyCallback * inArg){ inObj->setContactModifyCallback( inArg ); }
PxContactModifyCallback * getPxScene_ContactModifyCallback( const PxScene* inObj ) { return inObj->getContactModifyCallback(); }
void setPxScene_CCDContactModifyCallback( PxScene* inObj, PxCCDContactModifyCallback * inArg){ inObj->setCCDContactModifyCallback( inArg ); }
PxCCDContactModifyCallback * getPxScene_CCDContactModifyCallback( const PxScene* inObj ) { return inObj->getCCDContactModifyCallback(); }
void setPxScene_BroadPhaseCallback( PxScene* inObj, PxBroadPhaseCallback * inArg){ inObj->setBroadPhaseCallback( inArg ); }
PxBroadPhaseCallback * getPxScene_BroadPhaseCallback( const PxScene* inObj ) { return inObj->getBroadPhaseCallback(); }
PxU32 getPxScene_FilterShaderDataSize( const PxScene* inObj ) { return inObj->getFilterShaderDataSize(); }
PxSimulationFilterShader getPxScene_FilterShader( const PxScene* inObj ) { return inObj->getFilterShader(); }
PxSimulationFilterCallback * getPxScene_FilterCallback( const PxScene* inObj ) { return inObj->getFilterCallback(); }
void setPxScene_Gravity( PxScene* inObj, const PxVec3 & inArg){ inObj->setGravity( inArg ); }
PxVec3 getPxScene_Gravity( const PxScene* inObj ) { return inObj->getGravity(); }
void setPxScene_BounceThresholdVelocity( PxScene* inObj, const PxReal inArg){ inObj->setBounceThresholdVelocity( inArg ); }
PxReal getPxScene_BounceThresholdVelocity( const PxScene* inObj ) { return inObj->getBounceThresholdVelocity(); }
void setPxScene_CCDMaxPasses( PxScene* inObj, PxU32 inArg){ inObj->setCCDMaxPasses( inArg ); }
PxU32 getPxScene_CCDMaxPasses( const PxScene* inObj ) { return inObj->getCCDMaxPasses(); }
PxReal getPxScene_FrictionOffsetThreshold( const PxScene* inObj ) { return inObj->getFrictionOffsetThreshold(); }
void setPxScene_FrictionType( PxScene* inObj, PxFrictionType::Enum inArg){ inObj->setFrictionType( inArg ); }
PxFrictionType::Enum getPxScene_FrictionType( const PxScene* inObj ) { return inObj->getFrictionType(); }
void setPxScene_VisualizationCullingBox( PxScene* inObj, const PxBounds3 & inArg){ inObj->setVisualizationCullingBox( inArg ); }
PxBounds3 getPxScene_VisualizationCullingBox( const PxScene* inObj ) { return inObj->getVisualizationCullingBox(); }
PxPruningStructureType::Enum getPxScene_StaticStructure( const PxScene* inObj ) { return inObj->getStaticStructure(); }
PxPruningStructureType::Enum getPxScene_DynamicStructure( const PxScene* inObj ) { return inObj->getDynamicStructure(); }
void setPxScene_DynamicTreeRebuildRateHint( PxScene* inObj, PxU32 inArg){ inObj->setDynamicTreeRebuildRateHint( inArg ); }
PxU32 getPxScene_DynamicTreeRebuildRateHint( const PxScene* inObj ) { return inObj->getDynamicTreeRebuildRateHint(); }
void setPxScene_SceneQueryUpdateMode( PxScene* inObj, PxSceneQueryUpdateMode::Enum inArg){ inObj->setSceneQueryUpdateMode( inArg ); }
PxSceneQueryUpdateMode::Enum getPxScene_SceneQueryUpdateMode( const PxScene* inObj ) { return inObj->getSceneQueryUpdateMode(); }
PxU32 getPxScene_SceneQueryStaticTimestamp( const PxScene* inObj ) { return inObj->getSceneQueryStaticTimestamp(); }
PxBroadPhaseType::Enum getPxScene_BroadPhaseType( const PxScene* inObj ) { return inObj->getBroadPhaseType(); }
PxU32 getPxScene_BroadPhaseRegions( const PxScene* inObj, PxBroadPhaseRegionInfo* outBuffer, PxU32 inBufSize ) { return inObj->getBroadPhaseRegions( outBuffer, inBufSize ); }
PxU32 getNbPxScene_BroadPhaseRegions( const PxScene* inObj ) { return inObj->getNbBroadPhaseRegions(  ); }
PxTaskManager * getPxScene_TaskManager( const PxScene* inObj ) { return inObj->getTaskManager(); }
void setPxScene_NbContactDataBlocks( PxScene* inObj, PxU32 inArg){ inObj->setNbContactDataBlocks( inArg ); }
PxU32 getPxScene_MaxNbContactDataBlocksUsed( const PxScene* inObj ) { return inObj->getMaxNbContactDataBlocksUsed(); }
PxU32 getPxScene_ContactReportStreamBufferSize( const PxScene* inObj ) { return inObj->getContactReportStreamBufferSize(); }
void setPxScene_SolverBatchSize( PxScene* inObj, PxU32 inArg){ inObj->setSolverBatchSize( inArg ); }
PxU32 getPxScene_SolverBatchSize( const PxScene* inObj ) { return inObj->getSolverBatchSize(); }
PxReal getPxScene_WakeCounterResetValue( const PxScene* inObj ) { return inObj->getWakeCounterResetValue(); }
inline void * getPxSceneUserData( const PxScene* inOwner ) { return inOwner->userData; }
inline void setPxSceneUserData( PxScene* inOwner, void * inData) { inOwner->userData = inData; }
PX_PHYSX_CORE_API PxSceneGeneratedInfo::PxSceneGeneratedInfo()
	: Flags( "Flags", getPxScene_Flags)
	, Limits( "Limits", setPxScene_Limits, getPxScene_Limits)
	, Timestamp( "Timestamp", getPxScene_Timestamp)
	, Actors( "Actors", getPxScene_Actors, getNbPxScene_Actors )
	, Articulations( "Articulations", getPxScene_Articulations, getNbPxScene_Articulations )
	, Constraints( "Constraints", getPxScene_Constraints, getNbPxScene_Constraints )
	, Aggregates( "Aggregates", getPxScene_Aggregates, getNbPxScene_Aggregates )
	, CpuDispatcher( "CpuDispatcher", getPxScene_CpuDispatcher)
	, GpuDispatcher( "GpuDispatcher", getPxScene_GpuDispatcher)
	, SimulationEventCallback( "SimulationEventCallback", setPxScene_SimulationEventCallback, getPxScene_SimulationEventCallback)
	, ContactModifyCallback( "ContactModifyCallback", setPxScene_ContactModifyCallback, getPxScene_ContactModifyCallback)
	, CCDContactModifyCallback( "CCDContactModifyCallback", setPxScene_CCDContactModifyCallback, getPxScene_CCDContactModifyCallback)
	, BroadPhaseCallback( "BroadPhaseCallback", setPxScene_BroadPhaseCallback, getPxScene_BroadPhaseCallback)
	, FilterShaderDataSize( "FilterShaderDataSize", getPxScene_FilterShaderDataSize)
	, FilterShader( "FilterShader", getPxScene_FilterShader)
	, FilterCallback( "FilterCallback", getPxScene_FilterCallback)
	, Gravity( "Gravity", setPxScene_Gravity, getPxScene_Gravity)
	, BounceThresholdVelocity( "BounceThresholdVelocity", setPxScene_BounceThresholdVelocity, getPxScene_BounceThresholdVelocity)
	, CCDMaxPasses( "CCDMaxPasses", setPxScene_CCDMaxPasses, getPxScene_CCDMaxPasses)
	, FrictionOffsetThreshold( "FrictionOffsetThreshold", getPxScene_FrictionOffsetThreshold)
	, FrictionType( "FrictionType", setPxScene_FrictionType, getPxScene_FrictionType)
	, VisualizationCullingBox( "VisualizationCullingBox", setPxScene_VisualizationCullingBox, getPxScene_VisualizationCullingBox)
	, StaticStructure( "StaticStructure", getPxScene_StaticStructure)
	, DynamicStructure( "DynamicStructure", getPxScene_DynamicStructure)
	, DynamicTreeRebuildRateHint( "DynamicTreeRebuildRateHint", setPxScene_DynamicTreeRebuildRateHint, getPxScene_DynamicTreeRebuildRateHint)
	, SceneQueryUpdateMode( "SceneQueryUpdateMode", setPxScene_SceneQueryUpdateMode, getPxScene_SceneQueryUpdateMode)
	, SceneQueryStaticTimestamp( "SceneQueryStaticTimestamp", getPxScene_SceneQueryStaticTimestamp)
	, BroadPhaseType( "BroadPhaseType", getPxScene_BroadPhaseType)
	, BroadPhaseRegions( "BroadPhaseRegions", getPxScene_BroadPhaseRegions, getNbPxScene_BroadPhaseRegions )
	, TaskManager( "TaskManager", getPxScene_TaskManager)
	, NbContactDataBlocks( "NbContactDataBlocks", setPxScene_NbContactDataBlocks)
	, MaxNbContactDataBlocksUsed( "MaxNbContactDataBlocksUsed", getPxScene_MaxNbContactDataBlocksUsed)
	, ContactReportStreamBufferSize( "ContactReportStreamBufferSize", getPxScene_ContactReportStreamBufferSize)
	, SolverBatchSize( "SolverBatchSize", setPxScene_SolverBatchSize, getPxScene_SolverBatchSize)
	, WakeCounterResetValue( "WakeCounterResetValue", getPxScene_WakeCounterResetValue)
	, UserData( "UserData", setPxSceneUserData, getPxSceneUserData )
{}
PX_PHYSX_CORE_API PxSceneGeneratedValues::PxSceneGeneratedValues( const PxScene* inSource )
		:Flags( getPxScene_Flags( inSource ) )
		,Limits( getPxScene_Limits( inSource ) )
		,Timestamp( getPxScene_Timestamp( inSource ) )
		,CpuDispatcher( getPxScene_CpuDispatcher( inSource ) )
		,GpuDispatcher( getPxScene_GpuDispatcher( inSource ) )
		,SimulationEventCallback( getPxScene_SimulationEventCallback( inSource ) )
		,ContactModifyCallback( getPxScene_ContactModifyCallback( inSource ) )
		,CCDContactModifyCallback( getPxScene_CCDContactModifyCallback( inSource ) )
		,BroadPhaseCallback( getPxScene_BroadPhaseCallback( inSource ) )
		,FilterShaderDataSize( getPxScene_FilterShaderDataSize( inSource ) )
		,FilterShader( getPxScene_FilterShader( inSource ) )
		,FilterCallback( getPxScene_FilterCallback( inSource ) )
		,Gravity( getPxScene_Gravity( inSource ) )
		,BounceThresholdVelocity( getPxScene_BounceThresholdVelocity( inSource ) )
		,CCDMaxPasses( getPxScene_CCDMaxPasses( inSource ) )
		,FrictionOffsetThreshold( getPxScene_FrictionOffsetThreshold( inSource ) )
		,FrictionType( getPxScene_FrictionType( inSource ) )
		,VisualizationCullingBox( getPxScene_VisualizationCullingBox( inSource ) )
		,StaticStructure( getPxScene_StaticStructure( inSource ) )
		,DynamicStructure( getPxScene_DynamicStructure( inSource ) )
		,DynamicTreeRebuildRateHint( getPxScene_DynamicTreeRebuildRateHint( inSource ) )
		,SceneQueryUpdateMode( getPxScene_SceneQueryUpdateMode( inSource ) )
		,SceneQueryStaticTimestamp( getPxScene_SceneQueryStaticTimestamp( inSource ) )
		,BroadPhaseType( getPxScene_BroadPhaseType( inSource ) )
		,TaskManager( getPxScene_TaskManager( inSource ) )
		,MaxNbContactDataBlocksUsed( getPxScene_MaxNbContactDataBlocksUsed( inSource ) )
		,ContactReportStreamBufferSize( getPxScene_ContactReportStreamBufferSize( inSource ) )
		,SolverBatchSize( getPxScene_SolverBatchSize( inSource ) )
		,WakeCounterResetValue( getPxScene_WakeCounterResetValue( inSource ) )
		,UserData( inSource->userData )
{
	PX_UNUSED(inSource);
	inSource->getSimulationStatistics(SimulationStatistics);
}
inline PxU32 getPxSceneLimitsMaxNbActors( const PxSceneLimits* inOwner ) { return inOwner->maxNbActors; }
inline void setPxSceneLimitsMaxNbActors( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbActors = inData; }
inline PxU32 getPxSceneLimitsMaxNbBodies( const PxSceneLimits* inOwner ) { return inOwner->maxNbBodies; }
inline void setPxSceneLimitsMaxNbBodies( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbBodies = inData; }
inline PxU32 getPxSceneLimitsMaxNbStaticShapes( const PxSceneLimits* inOwner ) { return inOwner->maxNbStaticShapes; }
inline void setPxSceneLimitsMaxNbStaticShapes( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbStaticShapes = inData; }
inline PxU32 getPxSceneLimitsMaxNbDynamicShapes( const PxSceneLimits* inOwner ) { return inOwner->maxNbDynamicShapes; }
inline void setPxSceneLimitsMaxNbDynamicShapes( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbDynamicShapes = inData; }
inline PxU32 getPxSceneLimitsMaxNbAggregates( const PxSceneLimits* inOwner ) { return inOwner->maxNbAggregates; }
inline void setPxSceneLimitsMaxNbAggregates( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbAggregates = inData; }
inline PxU32 getPxSceneLimitsMaxNbConstraints( const PxSceneLimits* inOwner ) { return inOwner->maxNbConstraints; }
inline void setPxSceneLimitsMaxNbConstraints( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbConstraints = inData; }
inline PxU32 getPxSceneLimitsMaxNbRegions( const PxSceneLimits* inOwner ) { return inOwner->maxNbRegions; }
inline void setPxSceneLimitsMaxNbRegions( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbRegions = inData; }
inline PxU32 getPxSceneLimitsMaxNbBroadPhaseOverlaps( const PxSceneLimits* inOwner ) { return inOwner->maxNbBroadPhaseOverlaps; }
inline void setPxSceneLimitsMaxNbBroadPhaseOverlaps( PxSceneLimits* inOwner, PxU32 inData) { inOwner->maxNbBroadPhaseOverlaps = inData; }
PX_PHYSX_CORE_API PxSceneLimitsGeneratedInfo::PxSceneLimitsGeneratedInfo()
	: MaxNbActors( "MaxNbActors", setPxSceneLimitsMaxNbActors, getPxSceneLimitsMaxNbActors )
	, MaxNbBodies( "MaxNbBodies", setPxSceneLimitsMaxNbBodies, getPxSceneLimitsMaxNbBodies )
	, MaxNbStaticShapes( "MaxNbStaticShapes", setPxSceneLimitsMaxNbStaticShapes, getPxSceneLimitsMaxNbStaticShapes )
	, MaxNbDynamicShapes( "MaxNbDynamicShapes", setPxSceneLimitsMaxNbDynamicShapes, getPxSceneLimitsMaxNbDynamicShapes )
	, MaxNbAggregates( "MaxNbAggregates", setPxSceneLimitsMaxNbAggregates, getPxSceneLimitsMaxNbAggregates )
	, MaxNbConstraints( "MaxNbConstraints", setPxSceneLimitsMaxNbConstraints, getPxSceneLimitsMaxNbConstraints )
	, MaxNbRegions( "MaxNbRegions", setPxSceneLimitsMaxNbRegions, getPxSceneLimitsMaxNbRegions )
	, MaxNbBroadPhaseOverlaps( "MaxNbBroadPhaseOverlaps", setPxSceneLimitsMaxNbBroadPhaseOverlaps, getPxSceneLimitsMaxNbBroadPhaseOverlaps )
{}
PX_PHYSX_CORE_API PxSceneLimitsGeneratedValues::PxSceneLimitsGeneratedValues( const PxSceneLimits* inSource )
		:MaxNbActors( inSource->maxNbActors )
		,MaxNbBodies( inSource->maxNbBodies )
		,MaxNbStaticShapes( inSource->maxNbStaticShapes )
		,MaxNbDynamicShapes( inSource->maxNbDynamicShapes )
		,MaxNbAggregates( inSource->maxNbAggregates )
		,MaxNbConstraints( inSource->maxNbConstraints )
		,MaxNbRegions( inSource->maxNbRegions )
		,MaxNbBroadPhaseOverlaps( inSource->maxNbBroadPhaseOverlaps )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxgDynamicsMemoryConfigConstraintBufferCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->constraintBufferCapacity; }
inline void setPxgDynamicsMemoryConfigConstraintBufferCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->constraintBufferCapacity = inData; }
inline PxU32 getPxgDynamicsMemoryConfigContactBufferCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->contactBufferCapacity; }
inline void setPxgDynamicsMemoryConfigContactBufferCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->contactBufferCapacity = inData; }
inline PxU32 getPxgDynamicsMemoryConfigTempBufferCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->tempBufferCapacity; }
inline void setPxgDynamicsMemoryConfigTempBufferCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->tempBufferCapacity = inData; }
inline PxU32 getPxgDynamicsMemoryConfigContactStreamSize( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->contactStreamSize; }
inline void setPxgDynamicsMemoryConfigContactStreamSize( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->contactStreamSize = inData; }
inline PxU32 getPxgDynamicsMemoryConfigPatchStreamSize( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->patchStreamSize; }
inline void setPxgDynamicsMemoryConfigPatchStreamSize( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->patchStreamSize = inData; }
inline PxU32 getPxgDynamicsMemoryConfigForceStreamCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->forceStreamCapacity; }
inline void setPxgDynamicsMemoryConfigForceStreamCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->forceStreamCapacity = inData; }
inline PxU32 getPxgDynamicsMemoryConfigHeapCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->heapCapacity; }
inline void setPxgDynamicsMemoryConfigHeapCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->heapCapacity = inData; }
inline PxU32 getPxgDynamicsMemoryConfigFoundLostPairsCapacity( const PxgDynamicsMemoryConfig* inOwner ) { return inOwner->foundLostPairsCapacity; }
inline void setPxgDynamicsMemoryConfigFoundLostPairsCapacity( PxgDynamicsMemoryConfig* inOwner, PxU32 inData) { inOwner->foundLostPairsCapacity = inData; }
PX_PHYSX_CORE_API PxgDynamicsMemoryConfigGeneratedInfo::PxgDynamicsMemoryConfigGeneratedInfo()
	: ConstraintBufferCapacity( "ConstraintBufferCapacity", setPxgDynamicsMemoryConfigConstraintBufferCapacity, getPxgDynamicsMemoryConfigConstraintBufferCapacity )
	, ContactBufferCapacity( "ContactBufferCapacity", setPxgDynamicsMemoryConfigContactBufferCapacity, getPxgDynamicsMemoryConfigContactBufferCapacity )
	, TempBufferCapacity( "TempBufferCapacity", setPxgDynamicsMemoryConfigTempBufferCapacity, getPxgDynamicsMemoryConfigTempBufferCapacity )
	, ContactStreamSize( "ContactStreamSize", setPxgDynamicsMemoryConfigContactStreamSize, getPxgDynamicsMemoryConfigContactStreamSize )
	, PatchStreamSize( "PatchStreamSize", setPxgDynamicsMemoryConfigPatchStreamSize, getPxgDynamicsMemoryConfigPatchStreamSize )
	, ForceStreamCapacity( "ForceStreamCapacity", setPxgDynamicsMemoryConfigForceStreamCapacity, getPxgDynamicsMemoryConfigForceStreamCapacity )
	, HeapCapacity( "HeapCapacity", setPxgDynamicsMemoryConfigHeapCapacity, getPxgDynamicsMemoryConfigHeapCapacity )
	, FoundLostPairsCapacity( "FoundLostPairsCapacity", setPxgDynamicsMemoryConfigFoundLostPairsCapacity, getPxgDynamicsMemoryConfigFoundLostPairsCapacity )
{}
PX_PHYSX_CORE_API PxgDynamicsMemoryConfigGeneratedValues::PxgDynamicsMemoryConfigGeneratedValues( const PxgDynamicsMemoryConfig* inSource )
		:ConstraintBufferCapacity( inSource->constraintBufferCapacity )
		,ContactBufferCapacity( inSource->contactBufferCapacity )
		,TempBufferCapacity( inSource->tempBufferCapacity )
		,ContactStreamSize( inSource->contactStreamSize )
		,PatchStreamSize( inSource->patchStreamSize )
		,ForceStreamCapacity( inSource->forceStreamCapacity )
		,HeapCapacity( inSource->heapCapacity )
		,FoundLostPairsCapacity( inSource->foundLostPairsCapacity )
{
	PX_UNUSED(inSource);
}
void setPxSceneDesc_ToDefault( PxSceneDesc* inObj, const PxTolerancesScale & inArg){ inObj->setToDefault( inArg ); }
inline PxVec3 getPxSceneDescGravity( const PxSceneDesc* inOwner ) { return inOwner->gravity; }
inline void setPxSceneDescGravity( PxSceneDesc* inOwner, PxVec3 inData) { inOwner->gravity = inData; }
inline PxSimulationEventCallback * getPxSceneDescSimulationEventCallback( const PxSceneDesc* inOwner ) { return inOwner->simulationEventCallback; }
inline void setPxSceneDescSimulationEventCallback( PxSceneDesc* inOwner, PxSimulationEventCallback * inData) { inOwner->simulationEventCallback = inData; }
inline PxContactModifyCallback * getPxSceneDescContactModifyCallback( const PxSceneDesc* inOwner ) { return inOwner->contactModifyCallback; }
inline void setPxSceneDescContactModifyCallback( PxSceneDesc* inOwner, PxContactModifyCallback * inData) { inOwner->contactModifyCallback = inData; }
inline PxCCDContactModifyCallback * getPxSceneDescCcdContactModifyCallback( const PxSceneDesc* inOwner ) { return inOwner->ccdContactModifyCallback; }
inline void setPxSceneDescCcdContactModifyCallback( PxSceneDesc* inOwner, PxCCDContactModifyCallback * inData) { inOwner->ccdContactModifyCallback = inData; }
inline const void * getPxSceneDescFilterShaderData( const PxSceneDesc* inOwner ) { return inOwner->filterShaderData; }
inline void setPxSceneDescFilterShaderData( PxSceneDesc* inOwner, const void * inData) { inOwner->filterShaderData = inData; }
inline PxU32 getPxSceneDescFilterShaderDataSize( const PxSceneDesc* inOwner ) { return inOwner->filterShaderDataSize; }
inline void setPxSceneDescFilterShaderDataSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->filterShaderDataSize = inData; }
inline PxSimulationFilterShader getPxSceneDescFilterShader( const PxSceneDesc* inOwner ) { return inOwner->filterShader; }
inline void setPxSceneDescFilterShader( PxSceneDesc* inOwner, PxSimulationFilterShader inData) { inOwner->filterShader = inData; }
inline PxSimulationFilterCallback * getPxSceneDescFilterCallback( const PxSceneDesc* inOwner ) { return inOwner->filterCallback; }
inline void setPxSceneDescFilterCallback( PxSceneDesc* inOwner, PxSimulationFilterCallback * inData) { inOwner->filterCallback = inData; }
inline PxPairFilteringMode::Enum getPxSceneDescKineKineFilteringMode( const PxSceneDesc* inOwner ) { return inOwner->kineKineFilteringMode; }
inline void setPxSceneDescKineKineFilteringMode( PxSceneDesc* inOwner, PxPairFilteringMode::Enum inData) { inOwner->kineKineFilteringMode = inData; }
inline PxPairFilteringMode::Enum getPxSceneDescStaticKineFilteringMode( const PxSceneDesc* inOwner ) { return inOwner->staticKineFilteringMode; }
inline void setPxSceneDescStaticKineFilteringMode( PxSceneDesc* inOwner, PxPairFilteringMode::Enum inData) { inOwner->staticKineFilteringMode = inData; }
inline PxBroadPhaseType::Enum getPxSceneDescBroadPhaseType( const PxSceneDesc* inOwner ) { return inOwner->broadPhaseType; }
inline void setPxSceneDescBroadPhaseType( PxSceneDesc* inOwner, PxBroadPhaseType::Enum inData) { inOwner->broadPhaseType = inData; }
inline PxBroadPhaseCallback * getPxSceneDescBroadPhaseCallback( const PxSceneDesc* inOwner ) { return inOwner->broadPhaseCallback; }
inline void setPxSceneDescBroadPhaseCallback( PxSceneDesc* inOwner, PxBroadPhaseCallback * inData) { inOwner->broadPhaseCallback = inData; }
inline PxSceneLimits getPxSceneDescLimits( const PxSceneDesc* inOwner ) { return inOwner->limits; }
inline void setPxSceneDescLimits( PxSceneDesc* inOwner, PxSceneLimits inData) { inOwner->limits = inData; }
inline PxFrictionType::Enum getPxSceneDescFrictionType( const PxSceneDesc* inOwner ) { return inOwner->frictionType; }
inline void setPxSceneDescFrictionType( PxSceneDesc* inOwner, PxFrictionType::Enum inData) { inOwner->frictionType = inData; }
inline PxSolverType::Enum getPxSceneDescSolverType( const PxSceneDesc* inOwner ) { return inOwner->solverType; }
inline void setPxSceneDescSolverType( PxSceneDesc* inOwner, PxSolverType::Enum inData) { inOwner->solverType = inData; }
inline PxReal getPxSceneDescBounceThresholdVelocity( const PxSceneDesc* inOwner ) { return inOwner->bounceThresholdVelocity; }
inline void setPxSceneDescBounceThresholdVelocity( PxSceneDesc* inOwner, PxReal inData) { inOwner->bounceThresholdVelocity = inData; }
inline PxReal getPxSceneDescFrictionOffsetThreshold( const PxSceneDesc* inOwner ) { return inOwner->frictionOffsetThreshold; }
inline void setPxSceneDescFrictionOffsetThreshold( PxSceneDesc* inOwner, PxReal inData) { inOwner->frictionOffsetThreshold = inData; }
inline PxReal getPxSceneDescCcdMaxSeparation( const PxSceneDesc* inOwner ) { return inOwner->ccdMaxSeparation; }
inline void setPxSceneDescCcdMaxSeparation( PxSceneDesc* inOwner, PxReal inData) { inOwner->ccdMaxSeparation = inData; }
inline PxReal getPxSceneDescSolverOffsetSlop( const PxSceneDesc* inOwner ) { return inOwner->solverOffsetSlop; }
inline void setPxSceneDescSolverOffsetSlop( PxSceneDesc* inOwner, PxReal inData) { inOwner->solverOffsetSlop = inData; }
inline PxSceneFlags getPxSceneDescFlags( const PxSceneDesc* inOwner ) { return inOwner->flags; }
inline void setPxSceneDescFlags( PxSceneDesc* inOwner, PxSceneFlags inData) { inOwner->flags = inData; }
inline PxCpuDispatcher * getPxSceneDescCpuDispatcher( const PxSceneDesc* inOwner ) { return inOwner->cpuDispatcher; }
inline void setPxSceneDescCpuDispatcher( PxSceneDesc* inOwner, PxCpuDispatcher * inData) { inOwner->cpuDispatcher = inData; }
inline PxGpuDispatcher * getPxSceneDescGpuDispatcher( const PxSceneDesc* inOwner ) { return inOwner->gpuDispatcher; }
inline void setPxSceneDescGpuDispatcher( PxSceneDesc* inOwner, PxGpuDispatcher * inData) { inOwner->gpuDispatcher = inData; }
inline PxPruningStructureType::Enum getPxSceneDescStaticStructure( const PxSceneDesc* inOwner ) { return inOwner->staticStructure; }
inline void setPxSceneDescStaticStructure( PxSceneDesc* inOwner, PxPruningStructureType::Enum inData) { inOwner->staticStructure = inData; }
inline PxPruningStructureType::Enum getPxSceneDescDynamicStructure( const PxSceneDesc* inOwner ) { return inOwner->dynamicStructure; }
inline void setPxSceneDescDynamicStructure( PxSceneDesc* inOwner, PxPruningStructureType::Enum inData) { inOwner->dynamicStructure = inData; }
inline PxU32 getPxSceneDescDynamicTreeRebuildRateHint( const PxSceneDesc* inOwner ) { return inOwner->dynamicTreeRebuildRateHint; }
inline void setPxSceneDescDynamicTreeRebuildRateHint( PxSceneDesc* inOwner, PxU32 inData) { inOwner->dynamicTreeRebuildRateHint = inData; }
inline PxSceneQueryUpdateMode::Enum getPxSceneDescSceneQueryUpdateMode( const PxSceneDesc* inOwner ) { return inOwner->sceneQueryUpdateMode; }
inline void setPxSceneDescSceneQueryUpdateMode( PxSceneDesc* inOwner, PxSceneQueryUpdateMode::Enum inData) { inOwner->sceneQueryUpdateMode = inData; }
inline void * getPxSceneDescUserData( const PxSceneDesc* inOwner ) { return inOwner->userData; }
inline void setPxSceneDescUserData( PxSceneDesc* inOwner, void * inData) { inOwner->userData = inData; }
inline PxU32 getPxSceneDescSolverBatchSize( const PxSceneDesc* inOwner ) { return inOwner->solverBatchSize; }
inline void setPxSceneDescSolverBatchSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->solverBatchSize = inData; }
inline PxU32 getPxSceneDescNbContactDataBlocks( const PxSceneDesc* inOwner ) { return inOwner->nbContactDataBlocks; }
inline void setPxSceneDescNbContactDataBlocks( PxSceneDesc* inOwner, PxU32 inData) { inOwner->nbContactDataBlocks = inData; }
inline PxU32 getPxSceneDescMaxNbContactDataBlocks( const PxSceneDesc* inOwner ) { return inOwner->maxNbContactDataBlocks; }
inline void setPxSceneDescMaxNbContactDataBlocks( PxSceneDesc* inOwner, PxU32 inData) { inOwner->maxNbContactDataBlocks = inData; }
inline PxReal getPxSceneDescMaxBiasCoefficient( const PxSceneDesc* inOwner ) { return inOwner->maxBiasCoefficient; }
inline void setPxSceneDescMaxBiasCoefficient( PxSceneDesc* inOwner, PxReal inData) { inOwner->maxBiasCoefficient = inData; }
inline PxU32 getPxSceneDescContactReportStreamBufferSize( const PxSceneDesc* inOwner ) { return inOwner->contactReportStreamBufferSize; }
inline void setPxSceneDescContactReportStreamBufferSize( PxSceneDesc* inOwner, PxU32 inData) { inOwner->contactReportStreamBufferSize = inData; }
inline PxU32 getPxSceneDescCcdMaxPasses( const PxSceneDesc* inOwner ) { return inOwner->ccdMaxPasses; }
inline void setPxSceneDescCcdMaxPasses( PxSceneDesc* inOwner, PxU32 inData) { inOwner->ccdMaxPasses = inData; }
inline PxReal getPxSceneDescWakeCounterResetValue( const PxSceneDesc* inOwner ) { return inOwner->wakeCounterResetValue; }
inline void setPxSceneDescWakeCounterResetValue( PxSceneDesc* inOwner, PxReal inData) { inOwner->wakeCounterResetValue = inData; }
inline PxBounds3 getPxSceneDescSanityBounds( const PxSceneDesc* inOwner ) { return inOwner->sanityBounds; }
inline void setPxSceneDescSanityBounds( PxSceneDesc* inOwner, PxBounds3 inData) { inOwner->sanityBounds = inData; }
inline PxgDynamicsMemoryConfig getPxSceneDescGpuDynamicsConfig( const PxSceneDesc* inOwner ) { return inOwner->gpuDynamicsConfig; }
inline void setPxSceneDescGpuDynamicsConfig( PxSceneDesc* inOwner, PxgDynamicsMemoryConfig inData) { inOwner->gpuDynamicsConfig = inData; }
inline PxU32 getPxSceneDescGpuMaxNumPartitions( const PxSceneDesc* inOwner ) { return inOwner->gpuMaxNumPartitions; }
inline void setPxSceneDescGpuMaxNumPartitions( PxSceneDesc* inOwner, PxU32 inData) { inOwner->gpuMaxNumPartitions = inData; }
inline PxU32 getPxSceneDescGpuComputeVersion( const PxSceneDesc* inOwner ) { return inOwner->gpuComputeVersion; }
inline void setPxSceneDescGpuComputeVersion( PxSceneDesc* inOwner, PxU32 inData) { inOwner->gpuComputeVersion = inData; }
PX_PHYSX_CORE_API PxSceneDescGeneratedInfo::PxSceneDescGeneratedInfo()
	: ToDefault( "ToDefault", setPxSceneDesc_ToDefault)
	, Gravity( "Gravity", setPxSceneDescGravity, getPxSceneDescGravity )
	, SimulationEventCallback( "SimulationEventCallback", setPxSceneDescSimulationEventCallback, getPxSceneDescSimulationEventCallback )
	, ContactModifyCallback( "ContactModifyCallback", setPxSceneDescContactModifyCallback, getPxSceneDescContactModifyCallback )
	, CcdContactModifyCallback( "CcdContactModifyCallback", setPxSceneDescCcdContactModifyCallback, getPxSceneDescCcdContactModifyCallback )
	, FilterShaderData( "FilterShaderData", setPxSceneDescFilterShaderData, getPxSceneDescFilterShaderData )
	, FilterShaderDataSize( "FilterShaderDataSize", setPxSceneDescFilterShaderDataSize, getPxSceneDescFilterShaderDataSize )
	, FilterShader( "FilterShader", setPxSceneDescFilterShader, getPxSceneDescFilterShader )
	, FilterCallback( "FilterCallback", setPxSceneDescFilterCallback, getPxSceneDescFilterCallback )
	, KineKineFilteringMode( "KineKineFilteringMode", setPxSceneDescKineKineFilteringMode, getPxSceneDescKineKineFilteringMode )
	, StaticKineFilteringMode( "StaticKineFilteringMode", setPxSceneDescStaticKineFilteringMode, getPxSceneDescStaticKineFilteringMode )
	, BroadPhaseType( "BroadPhaseType", setPxSceneDescBroadPhaseType, getPxSceneDescBroadPhaseType )
	, BroadPhaseCallback( "BroadPhaseCallback", setPxSceneDescBroadPhaseCallback, getPxSceneDescBroadPhaseCallback )
	, Limits( "Limits", setPxSceneDescLimits, getPxSceneDescLimits )
	, FrictionType( "FrictionType", setPxSceneDescFrictionType, getPxSceneDescFrictionType )
	, SolverType( "SolverType", setPxSceneDescSolverType, getPxSceneDescSolverType )
	, BounceThresholdVelocity( "BounceThresholdVelocity", setPxSceneDescBounceThresholdVelocity, getPxSceneDescBounceThresholdVelocity )
	, FrictionOffsetThreshold( "FrictionOffsetThreshold", setPxSceneDescFrictionOffsetThreshold, getPxSceneDescFrictionOffsetThreshold )
	, CcdMaxSeparation( "CcdMaxSeparation", setPxSceneDescCcdMaxSeparation, getPxSceneDescCcdMaxSeparation )
	, SolverOffsetSlop( "SolverOffsetSlop", setPxSceneDescSolverOffsetSlop, getPxSceneDescSolverOffsetSlop )
	, Flags( "Flags", setPxSceneDescFlags, getPxSceneDescFlags )
	, CpuDispatcher( "CpuDispatcher", setPxSceneDescCpuDispatcher, getPxSceneDescCpuDispatcher )
	, GpuDispatcher( "GpuDispatcher", setPxSceneDescGpuDispatcher, getPxSceneDescGpuDispatcher )
	, StaticStructure( "StaticStructure", setPxSceneDescStaticStructure, getPxSceneDescStaticStructure )
	, DynamicStructure( "DynamicStructure", setPxSceneDescDynamicStructure, getPxSceneDescDynamicStructure )
	, DynamicTreeRebuildRateHint( "DynamicTreeRebuildRateHint", setPxSceneDescDynamicTreeRebuildRateHint, getPxSceneDescDynamicTreeRebuildRateHint )
	, SceneQueryUpdateMode( "SceneQueryUpdateMode", setPxSceneDescSceneQueryUpdateMode, getPxSceneDescSceneQueryUpdateMode )
	, UserData( "UserData", setPxSceneDescUserData, getPxSceneDescUserData )
	, SolverBatchSize( "SolverBatchSize", setPxSceneDescSolverBatchSize, getPxSceneDescSolverBatchSize )
	, NbContactDataBlocks( "NbContactDataBlocks", setPxSceneDescNbContactDataBlocks, getPxSceneDescNbContactDataBlocks )
	, MaxNbContactDataBlocks( "MaxNbContactDataBlocks", setPxSceneDescMaxNbContactDataBlocks, getPxSceneDescMaxNbContactDataBlocks )
	, MaxBiasCoefficient( "MaxBiasCoefficient", setPxSceneDescMaxBiasCoefficient, getPxSceneDescMaxBiasCoefficient )
	, ContactReportStreamBufferSize( "ContactReportStreamBufferSize", setPxSceneDescContactReportStreamBufferSize, getPxSceneDescContactReportStreamBufferSize )
	, CcdMaxPasses( "CcdMaxPasses", setPxSceneDescCcdMaxPasses, getPxSceneDescCcdMaxPasses )
	, WakeCounterResetValue( "WakeCounterResetValue", setPxSceneDescWakeCounterResetValue, getPxSceneDescWakeCounterResetValue )
	, SanityBounds( "SanityBounds", setPxSceneDescSanityBounds, getPxSceneDescSanityBounds )
	, GpuDynamicsConfig( "GpuDynamicsConfig", setPxSceneDescGpuDynamicsConfig, getPxSceneDescGpuDynamicsConfig )
	, GpuMaxNumPartitions( "GpuMaxNumPartitions", setPxSceneDescGpuMaxNumPartitions, getPxSceneDescGpuMaxNumPartitions )
	, GpuComputeVersion( "GpuComputeVersion", setPxSceneDescGpuComputeVersion, getPxSceneDescGpuComputeVersion )
{}
PX_PHYSX_CORE_API PxSceneDescGeneratedValues::PxSceneDescGeneratedValues( const PxSceneDesc* inSource )
		:Gravity( inSource->gravity )
		,SimulationEventCallback( inSource->simulationEventCallback )
		,ContactModifyCallback( inSource->contactModifyCallback )
		,CcdContactModifyCallback( inSource->ccdContactModifyCallback )
		,FilterShaderData( inSource->filterShaderData )
		,FilterShaderDataSize( inSource->filterShaderDataSize )
		,FilterShader( inSource->filterShader )
		,FilterCallback( inSource->filterCallback )
		,KineKineFilteringMode( inSource->kineKineFilteringMode )
		,StaticKineFilteringMode( inSource->staticKineFilteringMode )
		,BroadPhaseType( inSource->broadPhaseType )
		,BroadPhaseCallback( inSource->broadPhaseCallback )
		,Limits( inSource->limits )
		,FrictionType( inSource->frictionType )
		,SolverType( inSource->solverType )
		,BounceThresholdVelocity( inSource->bounceThresholdVelocity )
		,FrictionOffsetThreshold( inSource->frictionOffsetThreshold )
		,CcdMaxSeparation( inSource->ccdMaxSeparation )
		,SolverOffsetSlop( inSource->solverOffsetSlop )
		,Flags( inSource->flags )
		,CpuDispatcher( inSource->cpuDispatcher )
		,GpuDispatcher( inSource->gpuDispatcher )
		,StaticStructure( inSource->staticStructure )
		,DynamicStructure( inSource->dynamicStructure )
		,DynamicTreeRebuildRateHint( inSource->dynamicTreeRebuildRateHint )
		,SceneQueryUpdateMode( inSource->sceneQueryUpdateMode )
		,UserData( inSource->userData )
		,SolverBatchSize( inSource->solverBatchSize )
		,NbContactDataBlocks( inSource->nbContactDataBlocks )
		,MaxNbContactDataBlocks( inSource->maxNbContactDataBlocks )
		,MaxBiasCoefficient( inSource->maxBiasCoefficient )
		,ContactReportStreamBufferSize( inSource->contactReportStreamBufferSize )
		,CcdMaxPasses( inSource->ccdMaxPasses )
		,WakeCounterResetValue( inSource->wakeCounterResetValue )
		,SanityBounds( inSource->sanityBounds )
		,GpuDynamicsConfig( inSource->gpuDynamicsConfig )
		,GpuMaxNumPartitions( inSource->gpuMaxNumPartitions )
		,GpuComputeVersion( inSource->gpuComputeVersion )
{
	PX_UNUSED(inSource);
}
inline PxU32 getPxSimulationStatisticsNbActiveConstraints( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveConstraints; }
inline void setPxSimulationStatisticsNbActiveConstraints( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveConstraints = inData; }
inline PxU32 getPxSimulationStatisticsNbActiveDynamicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveDynamicBodies; }
inline void setPxSimulationStatisticsNbActiveDynamicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveDynamicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbActiveKinematicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbActiveKinematicBodies; }
inline void setPxSimulationStatisticsNbActiveKinematicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbActiveKinematicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbStaticBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbStaticBodies; }
inline void setPxSimulationStatisticsNbStaticBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbStaticBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbDynamicBodies( const PxSimulationStatistics* inOwner ) { return inOwner->nbDynamicBodies; }
inline void setPxSimulationStatisticsNbDynamicBodies( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDynamicBodies = inData; }
inline PxU32 getPxSimulationStatisticsNbAggregates( const PxSimulationStatistics* inOwner ) { return inOwner->nbAggregates; }
inline void setPxSimulationStatisticsNbAggregates( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbAggregates = inData; }
inline PxU32 getPxSimulationStatisticsNbArticulations( const PxSimulationStatistics* inOwner ) { return inOwner->nbArticulations; }
inline void setPxSimulationStatisticsNbArticulations( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbArticulations = inData; }
inline PxU32 getPxSimulationStatisticsNbAxisSolverConstraints( const PxSimulationStatistics* inOwner ) { return inOwner->nbAxisSolverConstraints; }
inline void setPxSimulationStatisticsNbAxisSolverConstraints( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbAxisSolverConstraints = inData; }
inline PxU32 getPxSimulationStatisticsCompressedContactSize( const PxSimulationStatistics* inOwner ) { return inOwner->compressedContactSize; }
inline void setPxSimulationStatisticsCompressedContactSize( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->compressedContactSize = inData; }
inline PxU32 getPxSimulationStatisticsRequiredContactConstraintMemory( const PxSimulationStatistics* inOwner ) { return inOwner->requiredContactConstraintMemory; }
inline void setPxSimulationStatisticsRequiredContactConstraintMemory( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->requiredContactConstraintMemory = inData; }
inline PxU32 getPxSimulationStatisticsPeakConstraintMemory( const PxSimulationStatistics* inOwner ) { return inOwner->peakConstraintMemory; }
inline void setPxSimulationStatisticsPeakConstraintMemory( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->peakConstraintMemory = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsTotal( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsTotal; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsTotal( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsTotal = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsWithCacheHits; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsWithCacheHits = inData; }
inline PxU32 getPxSimulationStatisticsNbDiscreteContactPairsWithContacts( const PxSimulationStatistics* inOwner ) { return inOwner->nbDiscreteContactPairsWithContacts; }
inline void setPxSimulationStatisticsNbDiscreteContactPairsWithContacts( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbDiscreteContactPairsWithContacts = inData; }
inline PxU32 getPxSimulationStatisticsNbNewPairs( const PxSimulationStatistics* inOwner ) { return inOwner->nbNewPairs; }
inline void setPxSimulationStatisticsNbNewPairs( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbNewPairs = inData; }
inline PxU32 getPxSimulationStatisticsNbLostPairs( const PxSimulationStatistics* inOwner ) { return inOwner->nbLostPairs; }
inline void setPxSimulationStatisticsNbLostPairs( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbLostPairs = inData; }
inline PxU32 getPxSimulationStatisticsNbNewTouches( const PxSimulationStatistics* inOwner ) { return inOwner->nbNewTouches; }
inline void setPxSimulationStatisticsNbNewTouches( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbNewTouches = inData; }
inline PxU32 getPxSimulationStatisticsNbLostTouches( const PxSimulationStatistics* inOwner ) { return inOwner->nbLostTouches; }
inline void setPxSimulationStatisticsNbLostTouches( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbLostTouches = inData; }
inline PxU32 getPxSimulationStatisticsNbPartitions( const PxSimulationStatistics* inOwner ) { return inOwner->nbPartitions; }
inline void setPxSimulationStatisticsNbPartitions( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbPartitions = inData; }
inline PxU32 getPxSimulationStatisticsNbBroadPhaseAdds( const PxSimulationStatistics* inOwner ) { return inOwner->nbBroadPhaseAdds; }
inline void setPxSimulationStatisticsNbBroadPhaseAdds( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbBroadPhaseAdds = inData; }
inline PxU32 getPxSimulationStatisticsNbBroadPhaseRemoves( const PxSimulationStatistics* inOwner ) { return inOwner->nbBroadPhaseRemoves; }
inline void setPxSimulationStatisticsNbBroadPhaseRemoves( PxSimulationStatistics* inOwner, PxU32 inData) { inOwner->nbBroadPhaseRemoves = inData; }
PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedInfo::PxSimulationStatisticsGeneratedInfo()
	: NbActiveConstraints( "NbActiveConstraints", setPxSimulationStatisticsNbActiveConstraints, getPxSimulationStatisticsNbActiveConstraints )
	, NbActiveDynamicBodies( "NbActiveDynamicBodies", setPxSimulationStatisticsNbActiveDynamicBodies, getPxSimulationStatisticsNbActiveDynamicBodies )
	, NbActiveKinematicBodies( "NbActiveKinematicBodies", setPxSimulationStatisticsNbActiveKinematicBodies, getPxSimulationStatisticsNbActiveKinematicBodies )
	, NbStaticBodies( "NbStaticBodies", setPxSimulationStatisticsNbStaticBodies, getPxSimulationStatisticsNbStaticBodies )
	, NbDynamicBodies( "NbDynamicBodies", setPxSimulationStatisticsNbDynamicBodies, getPxSimulationStatisticsNbDynamicBodies )
	, NbAggregates( "NbAggregates", setPxSimulationStatisticsNbAggregates, getPxSimulationStatisticsNbAggregates )
	, NbArticulations( "NbArticulations", setPxSimulationStatisticsNbArticulations, getPxSimulationStatisticsNbArticulations )
	, NbAxisSolverConstraints( "NbAxisSolverConstraints", setPxSimulationStatisticsNbAxisSolverConstraints, getPxSimulationStatisticsNbAxisSolverConstraints )
	, CompressedContactSize( "CompressedContactSize", setPxSimulationStatisticsCompressedContactSize, getPxSimulationStatisticsCompressedContactSize )
	, RequiredContactConstraintMemory( "RequiredContactConstraintMemory", setPxSimulationStatisticsRequiredContactConstraintMemory, getPxSimulationStatisticsRequiredContactConstraintMemory )
	, PeakConstraintMemory( "PeakConstraintMemory", setPxSimulationStatisticsPeakConstraintMemory, getPxSimulationStatisticsPeakConstraintMemory )
	, NbDiscreteContactPairsTotal( "NbDiscreteContactPairsTotal", setPxSimulationStatisticsNbDiscreteContactPairsTotal, getPxSimulationStatisticsNbDiscreteContactPairsTotal )
	, NbDiscreteContactPairsWithCacheHits( "NbDiscreteContactPairsWithCacheHits", setPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits, getPxSimulationStatisticsNbDiscreteContactPairsWithCacheHits )
	, NbDiscreteContactPairsWithContacts( "NbDiscreteContactPairsWithContacts", setPxSimulationStatisticsNbDiscreteContactPairsWithContacts, getPxSimulationStatisticsNbDiscreteContactPairsWithContacts )
	, NbNewPairs( "NbNewPairs", setPxSimulationStatisticsNbNewPairs, getPxSimulationStatisticsNbNewPairs )
	, NbLostPairs( "NbLostPairs", setPxSimulationStatisticsNbLostPairs, getPxSimulationStatisticsNbLostPairs )
	, NbNewTouches( "NbNewTouches", setPxSimulationStatisticsNbNewTouches, getPxSimulationStatisticsNbNewTouches )
	, NbLostTouches( "NbLostTouches", setPxSimulationStatisticsNbLostTouches, getPxSimulationStatisticsNbLostTouches )
	, NbPartitions( "NbPartitions", setPxSimulationStatisticsNbPartitions, getPxSimulationStatisticsNbPartitions )
	, NbBroadPhaseAdds( "NbBroadPhaseAdds", setPxSimulationStatisticsNbBroadPhaseAdds, getPxSimulationStatisticsNbBroadPhaseAdds )
	, NbBroadPhaseRemoves( "NbBroadPhaseRemoves", setPxSimulationStatisticsNbBroadPhaseRemoves, getPxSimulationStatisticsNbBroadPhaseRemoves )
{}
PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedValues::PxSimulationStatisticsGeneratedValues( const PxSimulationStatistics* inSource )
		:NbActiveConstraints( inSource->nbActiveConstraints )
		,NbActiveDynamicBodies( inSource->nbActiveDynamicBodies )
		,NbActiveKinematicBodies( inSource->nbActiveKinematicBodies )
		,NbStaticBodies( inSource->nbStaticBodies )
		,NbDynamicBodies( inSource->nbDynamicBodies )
		,NbAggregates( inSource->nbAggregates )
		,NbArticulations( inSource->nbArticulations )
		,NbAxisSolverConstraints( inSource->nbAxisSolverConstraints )
		,CompressedContactSize( inSource->compressedContactSize )
		,RequiredContactConstraintMemory( inSource->requiredContactConstraintMemory )
		,PeakConstraintMemory( inSource->peakConstraintMemory )
		,NbDiscreteContactPairsTotal( inSource->nbDiscreteContactPairsTotal )
		,NbDiscreteContactPairsWithCacheHits( inSource->nbDiscreteContactPairsWithCacheHits )
		,NbDiscreteContactPairsWithContacts( inSource->nbDiscreteContactPairsWithContacts )
		,NbNewPairs( inSource->nbNewPairs )
		,NbLostPairs( inSource->nbLostPairs )
		,NbNewTouches( inSource->nbNewTouches )
		,NbLostTouches( inSource->nbLostTouches )
		,NbPartitions( inSource->nbPartitions )
		,NbBroadPhaseAdds( inSource->nbBroadPhaseAdds )
		,NbBroadPhaseRemoves( inSource->nbBroadPhaseRemoves )
{
	PX_UNUSED(inSource);
	PxMemCopy( NbDiscreteContactPairs, inSource->nbDiscreteContactPairs, sizeof( NbDiscreteContactPairs ) );
	PxMemCopy( NbModifiedContactPairs, inSource->nbModifiedContactPairs, sizeof( NbModifiedContactPairs ) );
	PxMemCopy( NbCCDPairs, inSource->nbCCDPairs, sizeof( NbCCDPairs ) );
	PxMemCopy( NbTriggerPairs, inSource->nbTriggerPairs, sizeof( NbTriggerPairs ) );
	PxMemCopy( NbShapes, inSource->nbShapes, sizeof( NbShapes ) );
}
