//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Copyright (c) 2008-2018 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

// This code is auto-generated by the PhysX Clang metadata generator.  Do not edit or be
// prepared for your edits to be quietly ignored next time the clang metadata generator is
// run.  You can find the most recent version of clang metadata generator by contacting
// Chris Nuernberger <chrisn@nvidia.com> or Dilip or Adam.
// The source code for the generate was at one time checked into:
// physx/PhysXMetaDataGenerator/llvm/tools/clang/lib/Frontend/PhysXMetaDataAction.cpp
#define THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON

#define PX_PROPERTY_INFO_NAME PxPropertyInfoName
	static PxU32ToName g_physx__PxShapeFlag__EnumConversion[] = {
		{ "eSIMULATION_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eSIMULATION_SHAPE ) },
		{ "eSCENE_QUERY_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eSCENE_QUERY_SHAPE ) },
		{ "eTRIGGER_SHAPE", static_cast<PxU32>( physx::PxShapeFlag::eTRIGGER_SHAPE ) },
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxShapeFlag::eVISUALIZATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxShapeFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxShapeFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxPhysics;
	struct PxPhysicsGeneratedValues
	{
		PxTolerancesScale TolerancesScale;
		 PX_PHYSX_CORE_API PxPhysicsGeneratedValues( const PxPhysics* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPhysics, TolerancesScale, PxPhysicsGeneratedValues)
	struct PxPhysicsGeneratedInfo

	{
		static const char* getClassName() { return "PxPhysics"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_TolerancesScale, PxPhysics, const PxTolerancesScale > TolerancesScale;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_TriangleMeshes, PxPhysics, PxTriangleMesh *, PxInputStream & > TriangleMeshes;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_HeightFields, PxPhysics, PxHeightField *, PxInputStream & > HeightFields;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_ConvexMeshes, PxPhysics, PxConvexMesh *, PxInputStream & > ConvexMeshes;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_BVHStructures, PxPhysics, PxBVHStructure *, PxInputStream & > BVHStructures;
		PxFactoryCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Scenes, PxPhysics, PxScene *, const PxSceneDesc & > Scenes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Shapes, PxPhysics, PxShape * > Shapes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPhysics_Materials, PxPhysics, PxMaterial * > Materials;

		PX_PHYSX_CORE_API PxPhysicsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPhysics*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TolerancesScale, inStartIndex + 0 );; 
			inOperator( TriangleMeshes, inStartIndex + 1 );; 
			inOperator( HeightFields, inStartIndex + 2 );; 
			inOperator( ConvexMeshes, inStartIndex + 3 );; 
			inOperator( BVHStructures, inStartIndex + 4 );; 
			inOperator( Scenes, inStartIndex + 5 );; 
			inOperator( Shapes, inStartIndex + 6 );; 
			inOperator( Materials, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPhysics>
	{ 
		PxPhysicsGeneratedInfo Info;
		const PxPhysicsGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxMaterialFlag__EnumConversion[] = {
		{ "eDISABLE_FRICTION", static_cast<PxU32>( physx::PxMaterialFlag::eDISABLE_FRICTION ) },
		{ "eDISABLE_STRONG_FRICTION", static_cast<PxU32>( physx::PxMaterialFlag::eDISABLE_STRONG_FRICTION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxMaterialFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxMaterialFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxCombineMode__EnumConversion[] = {
		{ "eAVERAGE", static_cast<PxU32>( physx::PxCombineMode::eAVERAGE ) },
		{ "eMIN", static_cast<PxU32>( physx::PxCombineMode::eMIN ) },
		{ "eMULTIPLY", static_cast<PxU32>( physx::PxCombineMode::eMULTIPLY ) },
		{ "eMAX", static_cast<PxU32>( physx::PxCombineMode::eMAX ) },
		{ "eN_VALUES", static_cast<PxU32>( physx::PxCombineMode::eN_VALUES ) },
		{ "ePAD_32", static_cast<PxU32>( physx::PxCombineMode::ePAD_32 ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxCombineMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxCombineMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxMaterial;
	struct PxMaterialGeneratedValues
	{
		PxU32 ReferenceCount;
		PxReal DynamicFriction;
		PxReal StaticFriction;
		PxReal Restitution;
		PxMaterialFlags Flags;
		PxCombineMode::Enum FrictionCombineMode;
		PxCombineMode::Enum RestitutionCombineMode;
		const char * ConcreteTypeName;
		void * UserData;
		 PX_PHYSX_CORE_API PxMaterialGeneratedValues( const PxMaterial* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, ReferenceCount, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, DynamicFriction, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, StaticFriction, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, Restitution, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, Flags, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, FrictionCombineMode, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, RestitutionCombineMode, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, ConcreteTypeName, PxMaterialGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMaterial, UserData, PxMaterialGeneratedValues)
	struct PxMaterialGeneratedInfo

	{
		static const char* getClassName() { return "PxMaterial"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_ReferenceCount, PxMaterial, PxU32 > ReferenceCount;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_DynamicFriction, PxMaterial, PxReal, PxReal > DynamicFriction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_StaticFriction, PxMaterial, PxReal, PxReal > StaticFriction;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_Restitution, PxMaterial, PxReal, PxReal > Restitution;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_Flags, PxMaterial, PxMaterialFlags, PxMaterialFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_FrictionCombineMode, PxMaterial, PxCombineMode::Enum, PxCombineMode::Enum > FrictionCombineMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_RestitutionCombineMode, PxMaterial, PxCombineMode::Enum, PxCombineMode::Enum > RestitutionCombineMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_ConcreteTypeName, PxMaterial, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMaterial_UserData, PxMaterial, void *, void * > UserData;

		PX_PHYSX_CORE_API PxMaterialGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxMaterial*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 9; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ReferenceCount, inStartIndex + 0 );; 
			inOperator( DynamicFriction, inStartIndex + 1 );; 
			inOperator( StaticFriction, inStartIndex + 2 );; 
			inOperator( Restitution, inStartIndex + 3 );; 
			inOperator( Flags, inStartIndex + 4 );; 
			inOperator( FrictionCombineMode, inStartIndex + 5 );; 
			inOperator( RestitutionCombineMode, inStartIndex + 6 );; 
			inOperator( ConcreteTypeName, inStartIndex + 7 );; 
			inOperator( UserData, inStartIndex + 8 );; 
			return 9 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxMaterial>
	{ 
		PxMaterialGeneratedInfo Info;
		const PxMaterialGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxActorType__EnumConversion[] = {
		{ "eRIGID_STATIC", static_cast<PxU32>( physx::PxActorType::eRIGID_STATIC ) },
		{ "eRIGID_DYNAMIC", static_cast<PxU32>( physx::PxActorType::eRIGID_DYNAMIC ) },
		{ "eARTICULATION_LINK", static_cast<PxU32>( physx::PxActorType::eARTICULATION_LINK ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxActorFlag__EnumConversion[] = {
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxActorFlag::eVISUALIZATION ) },
		{ "eDISABLE_GRAVITY", static_cast<PxU32>( physx::PxActorFlag::eDISABLE_GRAVITY ) },
		{ "eSEND_SLEEP_NOTIFIES", static_cast<PxU32>( physx::PxActorFlag::eSEND_SLEEP_NOTIFIES ) },
		{ "eDISABLE_SIMULATION", static_cast<PxU32>( physx::PxActorFlag::eDISABLE_SIMULATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxActor;
	struct PxActorGeneratedValues
	{
		PxScene * Scene;
		const char * Name;
		PxActorFlags ActorFlags;
		PxDominanceGroup DominanceGroup;
		PxClientID OwnerClient;
		PxAggregate * Aggregate;
		void * UserData;
		 PX_PHYSX_CORE_API PxActorGeneratedValues( const PxActor* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Scene, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Name, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, ActorFlags, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, DominanceGroup, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, OwnerClient, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, Aggregate, PxActorGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxActor, UserData, PxActorGeneratedValues)
	struct PxActorGeneratedInfo

	{
		static const char* getClassName() { return "PxActor"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Scene, PxActor, PxScene * > Scene;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Name, PxActor, const char *, const char * > Name;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_ActorFlags, PxActor, PxActorFlags, PxActorFlags > ActorFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_DominanceGroup, PxActor, PxDominanceGroup, PxDominanceGroup > DominanceGroup;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_OwnerClient, PxActor, PxClientID, PxClientID > OwnerClient;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_Aggregate, PxActor, PxAggregate * > Aggregate;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxActor_UserData, PxActor, void *, void * > UserData;

		PX_PHYSX_CORE_API PxActorGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxActor*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( Name, inStartIndex + 1 );; 
			inOperator( ActorFlags, inStartIndex + 2 );; 
			inOperator( DominanceGroup, inStartIndex + 3 );; 
			inOperator( OwnerClient, inStartIndex + 4 );; 
			inOperator( Aggregate, inStartIndex + 5 );; 
			inOperator( UserData, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxActor>
	{ 
		PxActorGeneratedInfo Info;
		const PxActorGeneratedInfo* getInfo() { return &Info; }
	};

	class PxRigidActor;
	struct PxRigidActorGeneratedValues
		: PxActorGeneratedValues	{
		PxTransform GlobalPose;
		 PX_PHYSX_CORE_API PxRigidActorGeneratedValues( const PxRigidActor* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidActor, GlobalPose, PxRigidActorGeneratedValues)
	struct PxRigidActorGeneratedInfo
		: PxActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidActor"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidActor_GlobalPose, PxRigidActor, const PxTransform &, PxTransform > GlobalPose;
		PxRigidActorShapeCollection Shapes;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidActor_Constraints, PxRigidActor, PxConstraint * > Constraints;

		PX_PHYSX_CORE_API PxRigidActorGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidActor*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( GlobalPose, inStartIndex + 0 );; 
			inOperator( Shapes, inStartIndex + 1 );; 
			inOperator( Constraints, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidActor>
	{ 
		PxRigidActorGeneratedInfo Info;
		const PxRigidActorGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxForceMode__EnumConversion[] = {
		{ "eFORCE", static_cast<PxU32>( physx::PxForceMode::eFORCE ) },
		{ "eIMPULSE", static_cast<PxU32>( physx::PxForceMode::eIMPULSE ) },
		{ "eVELOCITY_CHANGE", static_cast<PxU32>( physx::PxForceMode::eVELOCITY_CHANGE ) },
		{ "eACCELERATION", static_cast<PxU32>( physx::PxForceMode::eACCELERATION ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxForceMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxForceMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxRigidBodyFlag__EnumConversion[] = {
		{ "eKINEMATIC", static_cast<PxU32>( physx::PxRigidBodyFlag::eKINEMATIC ) },
		{ "eUSE_KINEMATIC_TARGET_FOR_SCENE_QUERIES", static_cast<PxU32>( physx::PxRigidBodyFlag::eUSE_KINEMATIC_TARGET_FOR_SCENE_QUERIES ) },
		{ "eENABLE_CCD", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD ) },
		{ "eENABLE_CCD_FRICTION", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD_FRICTION ) },
		{ "eENABLE_POSE_INTEGRATION_PREVIEW", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_POSE_INTEGRATION_PREVIEW ) },
		{ "eENABLE_SPECULATIVE_CCD", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_SPECULATIVE_CCD ) },
		{ "eENABLE_CCD_MAX_CONTACT_IMPULSE", static_cast<PxU32>( physx::PxRigidBodyFlag::eENABLE_CCD_MAX_CONTACT_IMPULSE ) },
		{ "eRETAIN_ACCELERATIONS", static_cast<PxU32>( physx::PxRigidBodyFlag::eRETAIN_ACCELERATIONS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxRigidBodyFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxRigidBodyFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxRigidBody;
	struct PxRigidBodyGeneratedValues
		: PxRigidActorGeneratedValues	{
		PxTransform CMassLocalPose;
		PxReal Mass;
		PxReal InvMass;
		PxVec3 MassSpaceInertiaTensor;
		PxVec3 MassSpaceInvInertiaTensor;
		PxReal LinearDamping;
		PxReal AngularDamping;
		PxVec3 LinearVelocity;
		PxVec3 AngularVelocity;
		PxReal MaxAngularVelocity;
		PxReal MaxLinearVelocity;
		PxRigidBodyFlags RigidBodyFlags;
		PxReal MinCCDAdvanceCoefficient;
		PxReal MaxDepenetrationVelocity;
		PxReal MaxContactImpulse;
		 PX_PHYSX_CORE_API PxRigidBodyGeneratedValues( const PxRigidBody* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, CMassLocalPose, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, Mass, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, InvMass, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MassSpaceInertiaTensor, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MassSpaceInvInertiaTensor, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, LinearDamping, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, AngularDamping, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, LinearVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, AngularVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxAngularVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxLinearVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, RigidBodyFlags, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MinCCDAdvanceCoefficient, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxDepenetrationVelocity, PxRigidBodyGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidBody, MaxContactImpulse, PxRigidBodyGeneratedValues)
	struct PxRigidBodyGeneratedInfo
		: PxRigidActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidBody"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_CMassLocalPose, PxRigidBody, const PxTransform &, PxTransform > CMassLocalPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_Mass, PxRigidBody, PxReal, PxReal > Mass;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_InvMass, PxRigidBody, PxReal > InvMass;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MassSpaceInertiaTensor, PxRigidBody, const PxVec3 &, PxVec3 > MassSpaceInertiaTensor;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MassSpaceInvInertiaTensor, PxRigidBody, PxVec3 > MassSpaceInvInertiaTensor;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_LinearDamping, PxRigidBody, PxReal, PxReal > LinearDamping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_AngularDamping, PxRigidBody, PxReal, PxReal > AngularDamping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_LinearVelocity, PxRigidBody, const PxVec3 &, PxVec3 > LinearVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_AngularVelocity, PxRigidBody, const PxVec3 &, PxVec3 > AngularVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxAngularVelocity, PxRigidBody, PxReal, PxReal > MaxAngularVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxLinearVelocity, PxRigidBody, PxReal, PxReal > MaxLinearVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_RigidBodyFlags, PxRigidBody, PxRigidBodyFlags, PxRigidBodyFlags > RigidBodyFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MinCCDAdvanceCoefficient, PxRigidBody, PxReal, PxReal > MinCCDAdvanceCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxDepenetrationVelocity, PxRigidBody, PxReal, PxReal > MaxDepenetrationVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidBody_MaxContactImpulse, PxRigidBody, PxReal, PxReal > MaxContactImpulse;

		PX_PHYSX_CORE_API PxRigidBodyGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidBody*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 15; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( CMassLocalPose, inStartIndex + 0 );; 
			inOperator( Mass, inStartIndex + 1 );; 
			inOperator( InvMass, inStartIndex + 2 );; 
			inOperator( MassSpaceInertiaTensor, inStartIndex + 3 );; 
			inOperator( MassSpaceInvInertiaTensor, inStartIndex + 4 );; 
			inOperator( LinearDamping, inStartIndex + 5 );; 
			inOperator( AngularDamping, inStartIndex + 6 );; 
			inOperator( LinearVelocity, inStartIndex + 7 );; 
			inOperator( AngularVelocity, inStartIndex + 8 );; 
			inOperator( MaxAngularVelocity, inStartIndex + 9 );; 
			inOperator( MaxLinearVelocity, inStartIndex + 10 );; 
			inOperator( RigidBodyFlags, inStartIndex + 11 );; 
			inOperator( MinCCDAdvanceCoefficient, inStartIndex + 12 );; 
			inOperator( MaxDepenetrationVelocity, inStartIndex + 13 );; 
			inOperator( MaxContactImpulse, inStartIndex + 14 );; 
			return 15 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidBody>
	{ 
		PxRigidBodyGeneratedInfo Info;
		const PxRigidBodyGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxRigidDynamicLockFlag__EnumConversion[] = {
		{ "eLOCK_LINEAR_X", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_X ) },
		{ "eLOCK_LINEAR_Y", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_Y ) },
		{ "eLOCK_LINEAR_Z", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_LINEAR_Z ) },
		{ "eLOCK_ANGULAR_X", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_X ) },
		{ "eLOCK_ANGULAR_Y", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_Y ) },
		{ "eLOCK_ANGULAR_Z", static_cast<PxU32>( physx::PxRigidDynamicLockFlag::eLOCK_ANGULAR_Z ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxRigidDynamicLockFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxRigidDynamicLockFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxRigidDynamic;
	struct PxRigidDynamicGeneratedValues
		: PxRigidBodyGeneratedValues	{
		_Bool IsSleeping;
		PxReal SleepThreshold;
		PxReal StabilizationThreshold;
		PxRigidDynamicLockFlags RigidDynamicLockFlags;
		PxReal WakeCounter;
		PxU32 SolverIterationCounts[2];
		PxReal ContactReportThreshold;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxRigidDynamicGeneratedValues( const PxRigidDynamic* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, IsSleeping, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, SleepThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, StabilizationThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, RigidDynamicLockFlags, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, WakeCounter, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, SolverIterationCounts, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, ContactReportThreshold, PxRigidDynamicGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidDynamic, ConcreteTypeName, PxRigidDynamicGeneratedValues)
	struct PxRigidDynamicGeneratedInfo
		: PxRigidBodyGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidDynamic"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_IsSleeping, PxRigidDynamic, _Bool > IsSleeping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_SleepThreshold, PxRigidDynamic, PxReal, PxReal > SleepThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_StabilizationThreshold, PxRigidDynamic, PxReal, PxReal > StabilizationThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_RigidDynamicLockFlags, PxRigidDynamic, PxRigidDynamicLockFlags, PxRigidDynamicLockFlags > RigidDynamicLockFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_WakeCounter, PxRigidDynamic, PxReal, PxReal > WakeCounter;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_SolverIterationCounts, PxRigidDynamic, PxU32 > SolverIterationCounts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_ContactReportThreshold, PxRigidDynamic, PxReal, PxReal > ContactReportThreshold;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidDynamic_ConcreteTypeName, PxRigidDynamic, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxRigidDynamicGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidDynamic*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidBodyGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidBodyGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidBodyGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidBodyGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsSleeping, inStartIndex + 0 );; 
			inOperator( SleepThreshold, inStartIndex + 1 );; 
			inOperator( StabilizationThreshold, inStartIndex + 2 );; 
			inOperator( RigidDynamicLockFlags, inStartIndex + 3 );; 
			inOperator( WakeCounter, inStartIndex + 4 );; 
			inOperator( SolverIterationCounts, inStartIndex + 5 );; 
			inOperator( ContactReportThreshold, inStartIndex + 6 );; 
			inOperator( ConcreteTypeName, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidDynamic>
	{ 
		PxRigidDynamicGeneratedInfo Info;
		const PxRigidDynamicGeneratedInfo* getInfo() { return &Info; }
	};

	class PxRigidStatic;
	struct PxRigidStaticGeneratedValues
		: PxRigidActorGeneratedValues	{
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxRigidStaticGeneratedValues( const PxRigidStatic* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxRigidStatic, ConcreteTypeName, PxRigidStaticGeneratedValues)
	struct PxRigidStaticGeneratedInfo
		: PxRigidActorGeneratedInfo
	{
		static const char* getClassName() { return "PxRigidStatic"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxRigidStatic_ConcreteTypeName, PxRigidStatic, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxRigidStaticGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxRigidStatic*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidActorGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidActorGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidActorGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidActorGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConcreteTypeName, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxRigidStatic>
	{ 
		PxRigidStaticGeneratedInfo Info;
		const PxRigidStaticGeneratedInfo* getInfo() { return &Info; }
	};

	class PxArticulationLink;
	struct PxArticulationLinkGeneratedValues
		: PxRigidBodyGeneratedValues	{
		PxArticulationJointBase * InboundJoint;
		PxU32 InboundJointDof;
		PxU32 LinkIndex;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxArticulationLinkGeneratedValues( const PxArticulationLink* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, InboundJoint, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, InboundJointDof, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, LinkIndex, PxArticulationLinkGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationLink, ConcreteTypeName, PxArticulationLinkGeneratedValues)
	struct PxArticulationLinkGeneratedInfo
		: PxRigidBodyGeneratedInfo
	{
		static const char* getClassName() { return "PxArticulationLink"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_InboundJoint, PxArticulationLink, PxArticulationJointBase * > InboundJoint;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_InboundJointDof, PxArticulationLink, PxU32 > InboundJointDof;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_LinkIndex, PxArticulationLink, PxU32 > LinkIndex;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_Children, PxArticulationLink, PxArticulationLink * > Children;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationLink_ConcreteTypeName, PxArticulationLink, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxArticulationLinkGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationLink*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxRigidBodyGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxRigidBodyGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxRigidBodyGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxRigidBodyGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( InboundJoint, inStartIndex + 0 );; 
			inOperator( InboundJointDof, inStartIndex + 1 );; 
			inOperator( LinkIndex, inStartIndex + 2 );; 
			inOperator( Children, inStartIndex + 3 );; 
			inOperator( ConcreteTypeName, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationLink>
	{ 
		PxArticulationLinkGeneratedInfo Info;
		const PxArticulationLinkGeneratedInfo* getInfo() { return &Info; }
	};

	class PxArticulationJointBase;
	struct PxArticulationJointBaseGeneratedValues
	{
		PxTransform ParentPose;
		PxTransform ChildPose;
		 PX_PHYSX_CORE_API PxArticulationJointBaseGeneratedValues( const PxArticulationJointBase* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointBase, ParentPose, PxArticulationJointBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointBase, ChildPose, PxArticulationJointBaseGeneratedValues)
	struct PxArticulationJointBaseGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationJointBase"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointBase_ParentPose, PxArticulationJointBase, const PxTransform &, PxTransform > ParentPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointBase_ChildPose, PxArticulationJointBase, const PxTransform &, PxTransform > ChildPose;

		PX_PHYSX_CORE_API PxArticulationJointBaseGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationJointBase*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ParentPose, inStartIndex + 0 );; 
			inOperator( ChildPose, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationJointBase>
	{ 
		PxArticulationJointBaseGeneratedInfo Info;
		const PxArticulationJointBaseGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationJointDriveType__EnumConversion[] = {
		{ "eTARGET", static_cast<PxU32>( physx::PxArticulationJointDriveType::eTARGET ) },
		{ "eERROR", static_cast<PxU32>( physx::PxArticulationJointDriveType::eERROR ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationJointDriveType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationJointDriveType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxArticulationJoint;
	struct PxArticulationJointGeneratedValues
		: PxArticulationJointBaseGeneratedValues	{
		PxQuat TargetOrientation;
		PxVec3 TargetVelocity;
		PxArticulationJointDriveType::Enum DriveType;
		PxReal Stiffness;
		PxReal Damping;
		PxReal InternalCompliance;
		PxReal ExternalCompliance;
		PxReal SwingLimit[2];
		PxReal TangentialStiffness;
		PxReal TangentialDamping;
		PxReal SwingLimitContactDistance;
		_Bool SwingLimitEnabled;
		PxReal TwistLimit[2];
		_Bool TwistLimitEnabled;
		PxReal TwistLimitContactDistance;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxArticulationJointGeneratedValues( const PxArticulationJoint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TargetOrientation, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TargetVelocity, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, DriveType, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, Stiffness, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, Damping, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, InternalCompliance, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, ExternalCompliance, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, SwingLimit, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TangentialStiffness, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TangentialDamping, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, SwingLimitContactDistance, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, SwingLimitEnabled, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TwistLimit, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TwistLimitEnabled, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, TwistLimitContactDistance, PxArticulationJointGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJoint, ConcreteTypeName, PxArticulationJointGeneratedValues)
	struct PxArticulationJointGeneratedInfo
		: PxArticulationJointBaseGeneratedInfo
	{
		static const char* getClassName() { return "PxArticulationJoint"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TargetOrientation, PxArticulationJoint, const PxQuat &, PxQuat > TargetOrientation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TargetVelocity, PxArticulationJoint, const PxVec3 &, PxVec3 > TargetVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_DriveType, PxArticulationJoint, PxArticulationJointDriveType::Enum, PxArticulationJointDriveType::Enum > DriveType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_Stiffness, PxArticulationJoint, PxReal, PxReal > Stiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_Damping, PxArticulationJoint, PxReal, PxReal > Damping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_InternalCompliance, PxArticulationJoint, PxReal, PxReal > InternalCompliance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_ExternalCompliance, PxArticulationJoint, PxReal, PxReal > ExternalCompliance;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_SwingLimit, PxArticulationJoint, PxReal > SwingLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TangentialStiffness, PxArticulationJoint, PxReal, PxReal > TangentialStiffness;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TangentialDamping, PxArticulationJoint, PxReal, PxReal > TangentialDamping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_SwingLimitContactDistance, PxArticulationJoint, PxReal, PxReal > SwingLimitContactDistance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_SwingLimitEnabled, PxArticulationJoint, _Bool, _Bool > SwingLimitEnabled;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TwistLimit, PxArticulationJoint, PxReal > TwistLimit;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TwistLimitEnabled, PxArticulationJoint, _Bool, _Bool > TwistLimitEnabled;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_TwistLimitContactDistance, PxArticulationJoint, PxReal, PxReal > TwistLimitContactDistance;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJoint_ConcreteTypeName, PxArticulationJoint, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxArticulationJointGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationJoint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxArticulationJointBaseGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxArticulationJointBaseGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxArticulationJointBaseGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 16; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxArticulationJointBaseGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( TargetOrientation, inStartIndex + 0 );; 
			inOperator( TargetVelocity, inStartIndex + 1 );; 
			inOperator( DriveType, inStartIndex + 2 );; 
			inOperator( Stiffness, inStartIndex + 3 );; 
			inOperator( Damping, inStartIndex + 4 );; 
			inOperator( InternalCompliance, inStartIndex + 5 );; 
			inOperator( ExternalCompliance, inStartIndex + 6 );; 
			inOperator( SwingLimit, inStartIndex + 7 );; 
			inOperator( TangentialStiffness, inStartIndex + 8 );; 
			inOperator( TangentialDamping, inStartIndex + 9 );; 
			inOperator( SwingLimitContactDistance, inStartIndex + 10 );; 
			inOperator( SwingLimitEnabled, inStartIndex + 11 );; 
			inOperator( TwistLimit, inStartIndex + 12 );; 
			inOperator( TwistLimitEnabled, inStartIndex + 13 );; 
			inOperator( TwistLimitContactDistance, inStartIndex + 14 );; 
			inOperator( ConcreteTypeName, inStartIndex + 15 );; 
			return 16 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationJoint>
	{ 
		PxArticulationJointGeneratedInfo Info;
		const PxArticulationJointGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationBase__EnumConversion[] = {
		{ "eReducedCoordinate", static_cast<PxU32>( physx::PxArticulationBase::eReducedCoordinate ) },
		{ "eMaximumCoordinate", static_cast<PxU32>( physx::PxArticulationBase::eMaximumCoordinate ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationBase::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationBase__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxArticulationBase;
	struct PxArticulationBaseGeneratedValues
	{
		PxScene * Scene;
		PxU32 SolverIterationCounts[2];
		_Bool IsSleeping;
		PxReal SleepThreshold;
		PxReal StabilizationThreshold;
		PxReal WakeCounter;
		const char * Name;
		PxAggregate * Aggregate;
		PxArticulationBase::Enum Type;
		void * UserData;
		 PX_PHYSX_CORE_API PxArticulationBaseGeneratedValues( const PxArticulationBase* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, Scene, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, SolverIterationCounts, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, IsSleeping, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, SleepThreshold, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, StabilizationThreshold, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, WakeCounter, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, Name, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, Aggregate, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, Type, PxArticulationBaseGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationBase, UserData, PxArticulationBaseGeneratedValues)
	struct PxArticulationBaseGeneratedInfo

	{
		static const char* getClassName() { return "PxArticulationBase"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_Scene, PxArticulationBase, PxScene * > Scene;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_SolverIterationCounts, PxArticulationBase, PxU32 > SolverIterationCounts;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_IsSleeping, PxArticulationBase, _Bool > IsSleeping;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_SleepThreshold, PxArticulationBase, PxReal, PxReal > SleepThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_StabilizationThreshold, PxArticulationBase, PxReal, PxReal > StabilizationThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_WakeCounter, PxArticulationBase, PxReal, PxReal > WakeCounter;
		PxArticulationLinkCollectionProp Links;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_Name, PxArticulationBase, const char *, const char * > Name;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_Aggregate, PxArticulationBase, PxAggregate * > Aggregate;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_Type, PxArticulationBase, PxArticulationBase::Enum > Type;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationBase_UserData, PxArticulationBase, void *, void * > UserData;

		PX_PHYSX_CORE_API PxArticulationBaseGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationBase*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 11; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( SolverIterationCounts, inStartIndex + 1 );; 
			inOperator( IsSleeping, inStartIndex + 2 );; 
			inOperator( SleepThreshold, inStartIndex + 3 );; 
			inOperator( StabilizationThreshold, inStartIndex + 4 );; 
			inOperator( WakeCounter, inStartIndex + 5 );; 
			inOperator( Links, inStartIndex + 6 );; 
			inOperator( Name, inStartIndex + 7 );; 
			inOperator( Aggregate, inStartIndex + 8 );; 
			inOperator( Type, inStartIndex + 9 );; 
			inOperator( UserData, inStartIndex + 10 );; 
			return 11 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationBase>
	{ 
		PxArticulationBaseGeneratedInfo Info;
		const PxArticulationBaseGeneratedInfo* getInfo() { return &Info; }
	};

	class PxArticulation;
	struct PxArticulationGeneratedValues
		: PxArticulationBaseGeneratedValues	{
		PxU32 MaxProjectionIterations;
		PxReal SeparationTolerance;
		PxU32 InternalDriveIterations;
		PxU32 ExternalDriveIterations;
		 PX_PHYSX_CORE_API PxArticulationGeneratedValues( const PxArticulation* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulation, MaxProjectionIterations, PxArticulationGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulation, SeparationTolerance, PxArticulationGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulation, InternalDriveIterations, PxArticulationGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulation, ExternalDriveIterations, PxArticulationGeneratedValues)
	struct PxArticulationGeneratedInfo
		: PxArticulationBaseGeneratedInfo
	{
		static const char* getClassName() { return "PxArticulation"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulation_MaxProjectionIterations, PxArticulation, PxU32, PxU32 > MaxProjectionIterations;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulation_SeparationTolerance, PxArticulation, PxReal, PxReal > SeparationTolerance;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulation_InternalDriveIterations, PxArticulation, PxU32, PxU32 > InternalDriveIterations;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulation_ExternalDriveIterations, PxArticulation, PxU32, PxU32 > ExternalDriveIterations;

		PX_PHYSX_CORE_API PxArticulationGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulation*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxArticulationBaseGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxArticulationBaseGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxArticulationBaseGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxArticulationBaseGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxProjectionIterations, inStartIndex + 0 );; 
			inOperator( SeparationTolerance, inStartIndex + 1 );; 
			inOperator( InternalDriveIterations, inStartIndex + 2 );; 
			inOperator( ExternalDriveIterations, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulation>
	{ 
		PxArticulationGeneratedInfo Info;
		const PxArticulationGeneratedInfo* getInfo() { return &Info; }
	};

	class PxAggregate;
	struct PxAggregateGeneratedValues
	{
		PxU32 MaxNbActors;
		_Bool SelfCollision;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxAggregateGeneratedValues( const PxAggregate* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, MaxNbActors, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, SelfCollision, PxAggregateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxAggregate, ConcreteTypeName, PxAggregateGeneratedValues)
	struct PxAggregateGeneratedInfo

	{
		static const char* getClassName() { return "PxAggregate"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_MaxNbActors, PxAggregate, PxU32 > MaxNbActors;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_Actors, PxAggregate, PxActor * > Actors;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_SelfCollision, PxAggregate, _Bool > SelfCollision;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxAggregate_ConcreteTypeName, PxAggregate, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxAggregateGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxAggregate*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 4; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxNbActors, inStartIndex + 0 );; 
			inOperator( Actors, inStartIndex + 1 );; 
			inOperator( SelfCollision, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			return 4 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxAggregate>
	{ 
		PxAggregateGeneratedInfo Info;
		const PxAggregateGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxConstraintFlag__EnumConversion[] = {
		{ "eBROKEN", static_cast<PxU32>( physx::PxConstraintFlag::eBROKEN ) },
		{ "ePROJECT_TO_ACTOR0", static_cast<PxU32>( physx::PxConstraintFlag::ePROJECT_TO_ACTOR0 ) },
		{ "ePROJECT_TO_ACTOR1", static_cast<PxU32>( physx::PxConstraintFlag::ePROJECT_TO_ACTOR1 ) },
		{ "ePROJECTION", static_cast<PxU32>( physx::PxConstraintFlag::ePROJECTION ) },
		{ "eCOLLISION_ENABLED", static_cast<PxU32>( physx::PxConstraintFlag::eCOLLISION_ENABLED ) },
		{ "eVISUALIZATION", static_cast<PxU32>( physx::PxConstraintFlag::eVISUALIZATION ) },
		{ "eDRIVE_LIMITS_ARE_FORCES", static_cast<PxU32>( physx::PxConstraintFlag::eDRIVE_LIMITS_ARE_FORCES ) },
		{ "eIMPROVED_SLERP", static_cast<PxU32>( physx::PxConstraintFlag::eIMPROVED_SLERP ) },
		{ "eDISABLE_PREPROCESSING", static_cast<PxU32>( physx::PxConstraintFlag::eDISABLE_PREPROCESSING ) },
		{ "eENABLE_EXTENDED_LIMITS", static_cast<PxU32>( physx::PxConstraintFlag::eENABLE_EXTENDED_LIMITS ) },
		{ "eGPU_COMPATIBLE", static_cast<PxU32>( physx::PxConstraintFlag::eGPU_COMPATIBLE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxConstraintFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxConstraintFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxConstraint;
	struct PxConstraintGeneratedValues
	{
		PxScene * Scene;
		PxRigidActor * Actors[2];
		PxConstraintFlags Flags;
		_Bool IsValid;
		PxReal BreakForce[2];
		PxReal MinResponseThreshold;
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxConstraintGeneratedValues( const PxConstraint* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Scene, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Actors, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, Flags, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, IsValid, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, BreakForce, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, MinResponseThreshold, PxConstraintGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConstraint, ConcreteTypeName, PxConstraintGeneratedValues)
	struct PxConstraintGeneratedInfo

	{
		static const char* getClassName() { return "PxConstraint"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Scene, PxConstraint, PxScene * > Scene;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Actors, PxConstraint, PxRigidActor * > Actors;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_Flags, PxConstraint, PxConstraintFlags, PxConstraintFlags > Flags;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_IsValid, PxConstraint, _Bool > IsValid;
		PxRangePropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_BreakForce, PxConstraint, PxReal > BreakForce;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_MinResponseThreshold, PxConstraint, PxReal, PxReal > MinResponseThreshold;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxConstraint_ConcreteTypeName, PxConstraint, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxConstraintGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxConstraint*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 7; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scene, inStartIndex + 0 );; 
			inOperator( Actors, inStartIndex + 1 );; 
			inOperator( Flags, inStartIndex + 2 );; 
			inOperator( IsValid, inStartIndex + 3 );; 
			inOperator( BreakForce, inStartIndex + 4 );; 
			inOperator( MinResponseThreshold, inStartIndex + 5 );; 
			inOperator( ConcreteTypeName, inStartIndex + 6 );; 
			return 7 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxConstraint>
	{ 
		PxConstraintGeneratedInfo Info;
		const PxConstraintGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxGeometryType__EnumConversion[] = {
		{ "eSPHERE", static_cast<PxU32>( physx::PxGeometryType::eSPHERE ) },
		{ "ePLANE", static_cast<PxU32>( physx::PxGeometryType::ePLANE ) },
		{ "eCAPSULE", static_cast<PxU32>( physx::PxGeometryType::eCAPSULE ) },
		{ "eBOX", static_cast<PxU32>( physx::PxGeometryType::eBOX ) },
		{ "eCONVEXMESH", static_cast<PxU32>( physx::PxGeometryType::eCONVEXMESH ) },
		{ "eTRIANGLEMESH", static_cast<PxU32>( physx::PxGeometryType::eTRIANGLEMESH ) },
		{ "eHEIGHTFIELD", static_cast<PxU32>( physx::PxGeometryType::eHEIGHTFIELD ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxGeometryType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxGeometryType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxShape;
	struct PxShapeGeneratedValues
	{
		PxU32 ReferenceCount;
		PxGeometryType::Enum GeometryType;
		PxGeometryHolder Geometry;
		PxTransform LocalPose;
		PxFilterData SimulationFilterData;
		PxFilterData QueryFilterData;
		PxReal ContactOffset;
		PxReal RestOffset;
		PxReal TorsionalPatchRadius;
		PxReal MinTorsionalPatchRadius;
		PxShapeFlags Flags;
		_Bool IsExclusive;
		const char * Name;
		const char * ConcreteTypeName;
		void * UserData;
		 PX_PHYSX_CORE_API PxShapeGeneratedValues( const PxShape* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, ReferenceCount, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, GeometryType, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Geometry, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, LocalPose, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, SimulationFilterData, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, QueryFilterData, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, ContactOffset, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, RestOffset, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, TorsionalPatchRadius, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, MinTorsionalPatchRadius, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Flags, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, IsExclusive, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, Name, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, ConcreteTypeName, PxShapeGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxShape, UserData, PxShapeGeneratedValues)
	struct PxShapeGeneratedInfo

	{
		static const char* getClassName() { return "PxShape"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_ReferenceCount, PxShape, PxU32 > ReferenceCount;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_GeometryType, PxShape, PxGeometryType::Enum > GeometryType;
		PxShapeGeometryProperty Geometry;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_LocalPose, PxShape, const PxTransform &, PxTransform > LocalPose;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_SimulationFilterData, PxShape, const PxFilterData &, PxFilterData > SimulationFilterData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_QueryFilterData, PxShape, const PxFilterData &, PxFilterData > QueryFilterData;
		PxShapeMaterialsProperty Materials;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_ContactOffset, PxShape, PxReal, PxReal > ContactOffset;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_RestOffset, PxShape, PxReal, PxReal > RestOffset;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_TorsionalPatchRadius, PxShape, PxReal, PxReal > TorsionalPatchRadius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_MinTorsionalPatchRadius, PxShape, PxReal, PxReal > MinTorsionalPatchRadius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_Flags, PxShape, PxShapeFlags, PxShapeFlags > Flags;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_IsExclusive, PxShape, _Bool > IsExclusive;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_Name, PxShape, const char *, const char * > Name;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_ConcreteTypeName, PxShape, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxShape_UserData, PxShape, void *, void * > UserData;

		PX_PHYSX_CORE_API PxShapeGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxShape*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 16; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ReferenceCount, inStartIndex + 0 );; 
			inOperator( GeometryType, inStartIndex + 1 );; 
			inOperator( Geometry, inStartIndex + 2 );; 
			inOperator( LocalPose, inStartIndex + 3 );; 
			inOperator( SimulationFilterData, inStartIndex + 4 );; 
			inOperator( QueryFilterData, inStartIndex + 5 );; 
			inOperator( Materials, inStartIndex + 6 );; 
			inOperator( ContactOffset, inStartIndex + 7 );; 
			inOperator( RestOffset, inStartIndex + 8 );; 
			inOperator( TorsionalPatchRadius, inStartIndex + 9 );; 
			inOperator( MinTorsionalPatchRadius, inStartIndex + 10 );; 
			inOperator( Flags, inStartIndex + 11 );; 
			inOperator( IsExclusive, inStartIndex + 12 );; 
			inOperator( Name, inStartIndex + 13 );; 
			inOperator( ConcreteTypeName, inStartIndex + 14 );; 
			inOperator( UserData, inStartIndex + 15 );; 
			return 16 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxShape>
	{ 
		PxShapeGeneratedInfo Info;
		const PxShapeGeneratedInfo* getInfo() { return &Info; }
	};

	class PxPruningStructure;
	struct PxPruningStructureGeneratedValues
	{
		const char * ConcreteTypeName;
		 PX_PHYSX_CORE_API PxPruningStructureGeneratedValues( const PxPruningStructure* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxPruningStructure, ConcreteTypeName, PxPruningStructureGeneratedValues)
	struct PxPruningStructureGeneratedInfo

	{
		static const char* getClassName() { return "PxPruningStructure"; }
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_RigidActors, PxPruningStructure, PxRigidActor * > RigidActors;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxPruningStructure_ConcreteTypeName, PxPruningStructure, const char * > ConcreteTypeName;

		PX_PHYSX_CORE_API PxPruningStructureGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPruningStructure*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( RigidActors, inStartIndex + 0 );; 
			inOperator( ConcreteTypeName, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPruningStructure>
	{ 
		PxPruningStructureGeneratedInfo Info;
		const PxPruningStructureGeneratedInfo* getInfo() { return &Info; }
	};

	class PxTolerancesScale;
	struct PxTolerancesScaleGeneratedValues
	{
		_Bool IsValid;
		PxReal Length;
		PxReal Speed;
		 PX_PHYSX_CORE_API PxTolerancesScaleGeneratedValues( const PxTolerancesScale* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, IsValid, PxTolerancesScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, Length, PxTolerancesScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTolerancesScale, Speed, PxTolerancesScaleGeneratedValues)
	struct PxTolerancesScaleGeneratedInfo

	{
		static const char* getClassName() { return "PxTolerancesScale"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_IsValid, PxTolerancesScale, _Bool > IsValid;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_Length, PxTolerancesScale, PxReal, PxReal > Length;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTolerancesScale_Speed, PxTolerancesScale, PxReal, PxReal > Speed;

		PX_PHYSX_CORE_API PxTolerancesScaleGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxTolerancesScale*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( IsValid, inStartIndex + 0 );; 
			inOperator( Length, inStartIndex + 1 );; 
			inOperator( Speed, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxTolerancesScale>
	{ 
		PxTolerancesScaleGeneratedInfo Info;
		const PxTolerancesScaleGeneratedInfo* getInfo() { return &Info; }
	};

	class PxGeometry;
	struct PxGeometryGeneratedValues
	{
		 PX_PHYSX_CORE_API PxGeometryGeneratedValues( const PxGeometry* inSource );
	};
	struct PxGeometryGeneratedInfo

	{
		static const char* getClassName() { return "PxGeometry"; }

		PX_PHYSX_CORE_API PxGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 0; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return 0 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxGeometry>
	{ 
		PxGeometryGeneratedInfo Info;
		const PxGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxBoxGeometry;
	struct PxBoxGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxVec3 HalfExtents;
		 PX_PHYSX_CORE_API PxBoxGeometryGeneratedValues( const PxBoxGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxBoxGeometry, HalfExtents, PxBoxGeometryGeneratedValues)
	struct PxBoxGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxBoxGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxBoxGeometry_HalfExtents, PxBoxGeometry, PxVec3, PxVec3 > HalfExtents;

		PX_PHYSX_CORE_API PxBoxGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxBoxGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( HalfExtents, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxBoxGeometry>
	{ 
		PxBoxGeometryGeneratedInfo Info;
		const PxBoxGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxCapsuleGeometry;
	struct PxCapsuleGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxReal Radius;
		PxReal HalfHeight;
		 PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedValues( const PxCapsuleGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxCapsuleGeometry, Radius, PxCapsuleGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxCapsuleGeometry, HalfHeight, PxCapsuleGeometryGeneratedValues)
	struct PxCapsuleGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxCapsuleGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxCapsuleGeometry_Radius, PxCapsuleGeometry, PxReal, PxReal > Radius;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxCapsuleGeometry_HalfHeight, PxCapsuleGeometry, PxReal, PxReal > HalfHeight;

		PX_PHYSX_CORE_API PxCapsuleGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxCapsuleGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Radius, inStartIndex + 0 );; 
			inOperator( HalfHeight, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxCapsuleGeometry>
	{ 
		PxCapsuleGeometryGeneratedInfo Info;
		const PxCapsuleGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxMeshScale;
	struct PxMeshScaleGeneratedValues
	{
		PxVec3 Scale;
		PxQuat Rotation;
		 PX_PHYSX_CORE_API PxMeshScaleGeneratedValues( const PxMeshScale* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMeshScale, Scale, PxMeshScaleGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxMeshScale, Rotation, PxMeshScaleGeneratedValues)
	struct PxMeshScaleGeneratedInfo

	{
		static const char* getClassName() { return "PxMeshScale"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMeshScale_Scale, PxMeshScale, PxVec3, PxVec3 > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxMeshScale_Rotation, PxMeshScale, PxQuat, PxQuat > Rotation;

		PX_PHYSX_CORE_API PxMeshScaleGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxMeshScale*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 2; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( Rotation, inStartIndex + 1 );; 
			return 2 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxMeshScale>
	{ 
		PxMeshScaleGeneratedInfo Info;
		const PxMeshScaleGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxConvexMeshGeometryFlag__EnumConversion[] = {
		{ "eTIGHT_BOUNDS", static_cast<PxU32>( physx::PxConvexMeshGeometryFlag::eTIGHT_BOUNDS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxConvexMeshGeometryFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxConvexMeshGeometryFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxConvexMeshGeometry;
	struct PxConvexMeshGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxMeshScale Scale;
		PxConvexMesh * ConvexMesh;
		PxConvexMeshGeometryFlags MeshFlags;
		 PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedValues( const PxConvexMeshGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, Scale, PxConvexMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, ConvexMesh, PxConvexMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxConvexMeshGeometry, MeshFlags, PxConvexMeshGeometryGeneratedValues)
	struct PxConvexMeshGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxConvexMeshGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_Scale, PxConvexMeshGeometry, PxMeshScale, PxMeshScale > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_ConvexMesh, PxConvexMeshGeometry, PxConvexMesh *, PxConvexMesh * > ConvexMesh;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxConvexMeshGeometry_MeshFlags, PxConvexMeshGeometry, PxConvexMeshGeometryFlags, PxConvexMeshGeometryFlags > MeshFlags;

		PX_PHYSX_CORE_API PxConvexMeshGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxConvexMeshGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( ConvexMesh, inStartIndex + 1 );; 
			inOperator( MeshFlags, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxConvexMeshGeometry>
	{ 
		PxConvexMeshGeometryGeneratedInfo Info;
		const PxConvexMeshGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSphereGeometry;
	struct PxSphereGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxReal Radius;
		 PX_PHYSX_CORE_API PxSphereGeometryGeneratedValues( const PxSphereGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSphereGeometry, Radius, PxSphereGeometryGeneratedValues)
	struct PxSphereGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxSphereGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSphereGeometry_Radius, PxSphereGeometry, PxReal, PxReal > Radius;

		PX_PHYSX_CORE_API PxSphereGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSphereGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 1; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Radius, inStartIndex + 0 );; 
			return 1 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSphereGeometry>
	{ 
		PxSphereGeometryGeneratedInfo Info;
		const PxSphereGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxPlaneGeometry;
	struct PxPlaneGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		 PX_PHYSX_CORE_API PxPlaneGeometryGeneratedValues( const PxPlaneGeometry* inSource );
	};
	struct PxPlaneGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxPlaneGeometry"; }

		PX_PHYSX_CORE_API PxPlaneGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxPlaneGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 0; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return 0 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxPlaneGeometry>
	{ 
		PxPlaneGeometryGeneratedInfo Info;
		const PxPlaneGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxMeshGeometryFlag__EnumConversion[] = {
		{ "eDOUBLE_SIDED", static_cast<PxU32>( physx::PxMeshGeometryFlag::eDOUBLE_SIDED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxMeshGeometryFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxMeshGeometryFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxTriangleMeshGeometry;
	struct PxTriangleMeshGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxMeshScale Scale;
		PxMeshGeometryFlags MeshFlags;
		PxTriangleMesh * TriangleMesh;
		 PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedValues( const PxTriangleMeshGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, Scale, PxTriangleMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, MeshFlags, PxTriangleMeshGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxTriangleMeshGeometry, TriangleMesh, PxTriangleMeshGeometryGeneratedValues)
	struct PxTriangleMeshGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxTriangleMeshGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_Scale, PxTriangleMeshGeometry, PxMeshScale, PxMeshScale > Scale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_MeshFlags, PxTriangleMeshGeometry, PxMeshGeometryFlags, PxMeshGeometryFlags > MeshFlags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxTriangleMeshGeometry_TriangleMesh, PxTriangleMeshGeometry, PxTriangleMesh *, PxTriangleMesh * > TriangleMesh;

		PX_PHYSX_CORE_API PxTriangleMeshGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxTriangleMeshGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 3; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Scale, inStartIndex + 0 );; 
			inOperator( MeshFlags, inStartIndex + 1 );; 
			inOperator( TriangleMesh, inStartIndex + 2 );; 
			return 3 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxTriangleMeshGeometry>
	{ 
		PxTriangleMeshGeometryGeneratedInfo Info;
		const PxTriangleMeshGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	class PxHeightFieldGeometry;
	struct PxHeightFieldGeometryGeneratedValues
		: PxGeometryGeneratedValues	{
		PxHeightField * HeightField;
		PxReal HeightScale;
		PxReal RowScale;
		PxReal ColumnScale;
		PxMeshGeometryFlags HeightFieldFlags;
		 PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedValues( const PxHeightFieldGeometry* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightField, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, RowScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, ColumnScale, PxHeightFieldGeometryGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldGeometry, HeightFieldFlags, PxHeightFieldGeometryGeneratedValues)
	struct PxHeightFieldGeometryGeneratedInfo
		: PxGeometryGeneratedInfo
	{
		static const char* getClassName() { return "PxHeightFieldGeometry"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightField, PxHeightFieldGeometry, PxHeightField *, PxHeightField * > HeightField;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightScale, PxHeightFieldGeometry, PxReal, PxReal > HeightScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_RowScale, PxHeightFieldGeometry, PxReal, PxReal > RowScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_ColumnScale, PxHeightFieldGeometry, PxReal, PxReal > ColumnScale;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldGeometry_HeightFieldFlags, PxHeightFieldGeometry, PxMeshGeometryFlags, PxMeshGeometryFlags > HeightFieldFlags;

		PX_PHYSX_CORE_API PxHeightFieldGeometryGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxHeightFieldGeometry*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxGeometryGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxGeometryGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxGeometryGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxGeometryGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( HeightField, inStartIndex + 0 );; 
			inOperator( HeightScale, inStartIndex + 1 );; 
			inOperator( RowScale, inStartIndex + 2 );; 
			inOperator( ColumnScale, inStartIndex + 3 );; 
			inOperator( HeightFieldFlags, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxHeightFieldGeometry>
	{ 
		PxHeightFieldGeometryGeneratedInfo Info;
		const PxHeightFieldGeometryGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxHeightFieldFormat__EnumConversion[] = {
		{ "eS16_TM", static_cast<PxU32>( physx::PxHeightFieldFormat::eS16_TM ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHeightFieldFormat::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHeightFieldFormat__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxHeightFieldFlag__EnumConversion[] = {
		{ "eNO_BOUNDARY_EDGES", static_cast<PxU32>( physx::PxHeightFieldFlag::eNO_BOUNDARY_EDGES ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHeightFieldFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHeightFieldFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxHeightFieldDesc;
	struct PxHeightFieldDescGeneratedValues
	{
		PxU32 NbRows;
		PxU32 NbColumns;
		PxHeightFieldFormat::Enum Format;
		PxStridedData Samples;
		PxReal ConvexEdgeThreshold;
		PxHeightFieldFlags Flags;
		 PX_PHYSX_CORE_API PxHeightFieldDescGeneratedValues( const PxHeightFieldDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, NbRows, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, NbColumns, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Format, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Samples, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, ConvexEdgeThreshold, PxHeightFieldDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxHeightFieldDesc, Flags, PxHeightFieldDescGeneratedValues)
	struct PxHeightFieldDescGeneratedInfo

	{
		static const char* getClassName() { return "PxHeightFieldDesc"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_NbRows, PxHeightFieldDesc, PxU32, PxU32 > NbRows;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_NbColumns, PxHeightFieldDesc, PxU32, PxU32 > NbColumns;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Format, PxHeightFieldDesc, PxHeightFieldFormat::Enum, PxHeightFieldFormat::Enum > Format;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Samples, PxHeightFieldDesc, PxStridedData, PxStridedData > Samples;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_ConvexEdgeThreshold, PxHeightFieldDesc, PxReal, PxReal > ConvexEdgeThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxHeightFieldDesc_Flags, PxHeightFieldDesc, PxHeightFieldFlags, PxHeightFieldFlags > Flags;

		PX_PHYSX_CORE_API PxHeightFieldDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxHeightFieldDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 6; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( NbRows, inStartIndex + 0 );; 
			inOperator( NbColumns, inStartIndex + 1 );; 
			inOperator( Format, inStartIndex + 2 );; 
			inOperator( Samples, inStartIndex + 3 );; 
			inOperator( ConvexEdgeThreshold, inStartIndex + 4 );; 
			inOperator( Flags, inStartIndex + 5 );; 
			return 6 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxHeightFieldDesc>
	{ 
		PxHeightFieldDescGeneratedInfo Info;
		const PxHeightFieldDescGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxArticulationJointType__EnumConversion[] = {
		{ "ePRISMATIC", static_cast<PxU32>( physx::PxArticulationJointType::ePRISMATIC ) },
		{ "eREVOLUTE", static_cast<PxU32>( physx::PxArticulationJointType::eREVOLUTE ) },
		{ "eSPHERICAL", static_cast<PxU32>( physx::PxArticulationJointType::eSPHERICAL ) },
		{ "eFIX", static_cast<PxU32>( physx::PxArticulationJointType::eFIX ) },
		{ "eUNDEFINED", static_cast<PxU32>( physx::PxArticulationJointType::eUNDEFINED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationJointType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationJointType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxArticulationAxis__EnumConversion[] = {
		{ "eTWIST", static_cast<PxU32>( physx::PxArticulationAxis::eTWIST ) },
		{ "eSWING1", static_cast<PxU32>( physx::PxArticulationAxis::eSWING1 ) },
		{ "eSWING2", static_cast<PxU32>( physx::PxArticulationAxis::eSWING2 ) },
		{ "eX", static_cast<PxU32>( physx::PxArticulationAxis::eX ) },
		{ "eY", static_cast<PxU32>( physx::PxArticulationAxis::eY ) },
		{ "eZ", static_cast<PxU32>( physx::PxArticulationAxis::eZ ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationAxis::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationAxis__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxArticulationMotion__EnumConversion[] = {
		{ "eLOCKED", static_cast<PxU32>( physx::PxArticulationMotion::eLOCKED ) },
		{ "eLIMITED", static_cast<PxU32>( physx::PxArticulationMotion::eLIMITED ) },
		{ "eFREE", static_cast<PxU32>( physx::PxArticulationMotion::eFREE ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxArticulationMotion::Enum > { PxEnumTraits() : NameConversion( g_physx__PxArticulationMotion__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxArticulationJointReducedCoordinate;
	struct PxArticulationJointReducedCoordinateGeneratedValues
		: PxArticulationJointBaseGeneratedValues	{
		PxArticulationJointType::Enum JointType;
		PxArticulationMotion::Enum Motion[physx::PxArticulationAxis::eCOUNT];
		PxReal FrictionCoefficient;
		const char * ConcreteTypeName;
		PxReal MaxJointVelocity;
		 PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedValues( const PxArticulationJointReducedCoordinate* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, JointType, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, Motion, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, FrictionCoefficient, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, ConcreteTypeName, PxArticulationJointReducedCoordinateGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxArticulationJointReducedCoordinate, MaxJointVelocity, PxArticulationJointReducedCoordinateGeneratedValues)
	struct PxArticulationJointReducedCoordinateGeneratedInfo
		: PxArticulationJointBaseGeneratedInfo
	{
		static const char* getClassName() { return "PxArticulationJointReducedCoordinate"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_JointType, PxArticulationJointReducedCoordinate, PxArticulationJointType::Enum, PxArticulationJointType::Enum > JointType;
		PxIndexedPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_Motion, PxArticulationJointReducedCoordinate, PxArticulationAxis::Enum, PxArticulationMotion::Enum > Motion;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_FrictionCoefficient, PxArticulationJointReducedCoordinate, const PxReal, PxReal > FrictionCoefficient;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_ConcreteTypeName, PxArticulationJointReducedCoordinate, const char * > ConcreteTypeName;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxArticulationJointReducedCoordinate_MaxJointVelocity, PxArticulationJointReducedCoordinate, const PxReal, PxReal > MaxJointVelocity;

		PX_PHYSX_CORE_API PxArticulationJointReducedCoordinateGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxArticulationJointReducedCoordinate*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
			inOperator( *static_cast<PxArticulationJointBaseGeneratedInfo*>( this ) );
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inStartIndex = PxArticulationJointBaseGeneratedInfo::visitBaseProperties( inOperator, inStartIndex );
			inStartIndex = PxArticulationJointBaseGeneratedInfo::visitInstanceProperties( inOperator, inStartIndex );
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 5; }
		static PxU32 totalPropertyCount() { return instancePropertyCount()
				+ PxArticulationJointBaseGeneratedInfo::totalPropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( JointType, inStartIndex + 0 );; 
			inOperator( Motion, inStartIndex + 1 );; 
			inOperator( FrictionCoefficient, inStartIndex + 2 );; 
			inOperator( ConcreteTypeName, inStartIndex + 3 );; 
			inOperator( MaxJointVelocity, inStartIndex + 4 );; 
			return 5 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxArticulationJointReducedCoordinate>
	{ 
		PxArticulationJointReducedCoordinateGeneratedInfo Info;
		const PxArticulationJointReducedCoordinateGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSceneFlag__EnumConversion[] = {
		{ "eENABLE_ACTIVE_ACTORS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_ACTIVE_ACTORS ) },
		{ "eENABLE_CCD", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_CCD ) },
		{ "eDISABLE_CCD_RESWEEP", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CCD_RESWEEP ) },
		{ "eADAPTIVE_FORCE", static_cast<PxU32>( physx::PxSceneFlag::eADAPTIVE_FORCE ) },
		{ "eENABLE_KINEMATIC_STATIC_PAIRS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_KINEMATIC_STATIC_PAIRS ) },
		{ "eENABLE_KINEMATIC_PAIRS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_KINEMATIC_PAIRS ) },
		{ "eENABLE_PCM", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_PCM ) },
		{ "eDISABLE_CONTACT_REPORT_BUFFER_RESIZE", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CONTACT_REPORT_BUFFER_RESIZE ) },
		{ "eDISABLE_CONTACT_CACHE", static_cast<PxU32>( physx::PxSceneFlag::eDISABLE_CONTACT_CACHE ) },
		{ "eREQUIRE_RW_LOCK", static_cast<PxU32>( physx::PxSceneFlag::eREQUIRE_RW_LOCK ) },
		{ "eENABLE_STABILIZATION", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_STABILIZATION ) },
		{ "eENABLE_AVERAGE_POINT", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_AVERAGE_POINT ) },
		{ "eEXCLUDE_KINEMATICS_FROM_ACTIVE_ACTORS", static_cast<PxU32>( physx::PxSceneFlag::eEXCLUDE_KINEMATICS_FROM_ACTIVE_ACTORS ) },
		{ "eENABLE_GPU_DYNAMICS", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_GPU_DYNAMICS ) },
		{ "eENABLE_ENHANCED_DETERMINISM", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_ENHANCED_DETERMINISM ) },
		{ "eENABLE_FRICTION_EVERY_ITERATION", static_cast<PxU32>( physx::PxSceneFlag::eENABLE_FRICTION_EVERY_ITERATION ) },
		{ "eMUTABLE_FLAGS", static_cast<PxU32>( physx::PxSceneFlag::eMUTABLE_FLAGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSceneFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSceneFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxActorTypeFlag__EnumConversion[] = {
		{ "eRIGID_STATIC", static_cast<PxU32>( physx::PxActorTypeFlag::eRIGID_STATIC ) },
		{ "eRIGID_DYNAMIC", static_cast<PxU32>( physx::PxActorTypeFlag::eRIGID_DYNAMIC ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxActorTypeFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxActorTypeFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxFrictionType__EnumConversion[] = {
		{ "ePATCH", static_cast<PxU32>( physx::PxFrictionType::ePATCH ) },
		{ "eONE_DIRECTIONAL", static_cast<PxU32>( physx::PxFrictionType::eONE_DIRECTIONAL ) },
		{ "eTWO_DIRECTIONAL", static_cast<PxU32>( physx::PxFrictionType::eTWO_DIRECTIONAL ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxFrictionType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxFrictionType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxVisualizationParameter__EnumConversion[] = {
		{ "eSCALE", static_cast<PxU32>( physx::PxVisualizationParameter::eSCALE ) },
		{ "eWORLD_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eWORLD_AXES ) },
		{ "eBODY_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_AXES ) },
		{ "eBODY_MASS_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_MASS_AXES ) },
		{ "eBODY_LIN_VELOCITY", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_LIN_VELOCITY ) },
		{ "eBODY_ANG_VELOCITY", static_cast<PxU32>( physx::PxVisualizationParameter::eBODY_ANG_VELOCITY ) },
		{ "eCONTACT_POINT", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_POINT ) },
		{ "eCONTACT_NORMAL", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_NORMAL ) },
		{ "eCONTACT_ERROR", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_ERROR ) },
		{ "eCONTACT_FORCE", static_cast<PxU32>( physx::PxVisualizationParameter::eCONTACT_FORCE ) },
		{ "eACTOR_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eACTOR_AXES ) },
		{ "eCOLLISION_AABBS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_AABBS ) },
		{ "eCOLLISION_SHAPES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_SHAPES ) },
		{ "eCOLLISION_AXES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_AXES ) },
		{ "eCOLLISION_COMPOUNDS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_COMPOUNDS ) },
		{ "eCOLLISION_FNORMALS", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_FNORMALS ) },
		{ "eCOLLISION_EDGES", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_EDGES ) },
		{ "eCOLLISION_STATIC", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_STATIC ) },
		{ "eCOLLISION_DYNAMIC", static_cast<PxU32>( physx::PxVisualizationParameter::eCOLLISION_DYNAMIC ) },
		{ "eDEPRECATED_COLLISION_PAIRS", static_cast<PxU32>( physx::PxVisualizationParameter::eDEPRECATED_COLLISION_PAIRS ) },
		{ "eJOINT_LOCAL_FRAMES", static_cast<PxU32>( physx::PxVisualizationParameter::eJOINT_LOCAL_FRAMES ) },
		{ "eJOINT_LIMITS", static_cast<PxU32>( physx::PxVisualizationParameter::eJOINT_LIMITS ) },
		{ "eCULL_BOX", static_cast<PxU32>( physx::PxVisualizationParameter::eCULL_BOX ) },
		{ "eMBP_REGIONS", static_cast<PxU32>( physx::PxVisualizationParameter::eMBP_REGIONS ) },
		{ "eNUM_VALUES", static_cast<PxU32>( physx::PxVisualizationParameter::eNUM_VALUES ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxVisualizationParameter::Enum > { PxEnumTraits() : NameConversion( g_physx__PxVisualizationParameter__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxPruningStructureType__EnumConversion[] = {
		{ "eNONE", static_cast<PxU32>( physx::PxPruningStructureType::eNONE ) },
		{ "eDYNAMIC_AABB_TREE", static_cast<PxU32>( physx::PxPruningStructureType::eDYNAMIC_AABB_TREE ) },
		{ "eSTATIC_AABB_TREE", static_cast<PxU32>( physx::PxPruningStructureType::eSTATIC_AABB_TREE ) },
		{ "eLAST", static_cast<PxU32>( physx::PxPruningStructureType::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxPruningStructureType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxPruningStructureType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxSceneQueryUpdateMode__EnumConversion[] = {
		{ "eBUILD_ENABLED_COMMIT_ENABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_ENABLED_COMMIT_ENABLED ) },
		{ "eBUILD_ENABLED_COMMIT_DISABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_ENABLED_COMMIT_DISABLED ) },
		{ "eBUILD_DISABLED_COMMIT_DISABLED", static_cast<PxU32>( physx::PxSceneQueryUpdateMode::eBUILD_DISABLED_COMMIT_DISABLED ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSceneQueryUpdateMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSceneQueryUpdateMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxHitFlag__EnumConversion[] = {
		{ "ePOSITION", static_cast<PxU32>( physx::PxHitFlag::ePOSITION ) },
		{ "eNORMAL", static_cast<PxU32>( physx::PxHitFlag::eNORMAL ) },
		{ "eUV", static_cast<PxU32>( physx::PxHitFlag::eUV ) },
		{ "eASSUME_NO_INITIAL_OVERLAP", static_cast<PxU32>( physx::PxHitFlag::eASSUME_NO_INITIAL_OVERLAP ) },
		{ "eMESH_MULTIPLE", static_cast<PxU32>( physx::PxHitFlag::eMESH_MULTIPLE ) },
		{ "eMESH_ANY", static_cast<PxU32>( physx::PxHitFlag::eMESH_ANY ) },
		{ "eMESH_BOTH_SIDES", static_cast<PxU32>( physx::PxHitFlag::eMESH_BOTH_SIDES ) },
		{ "ePRECISE_SWEEP", static_cast<PxU32>( physx::PxHitFlag::ePRECISE_SWEEP ) },
		{ "eMTD", static_cast<PxU32>( physx::PxHitFlag::eMTD ) },
		{ "eFACE_INDEX", static_cast<PxU32>( physx::PxHitFlag::eFACE_INDEX ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxHitFlag::eDEFAULT ) },
		{ "eMODIFIABLE_FLAGS", static_cast<PxU32>( physx::PxHitFlag::eMODIFIABLE_FLAGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxHitFlag::Enum > { PxEnumTraits() : NameConversion( g_physx__PxHitFlag__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxBroadPhaseType__EnumConversion[] = {
		{ "eSAP", static_cast<PxU32>( physx::PxBroadPhaseType::eSAP ) },
		{ "eMBP", static_cast<PxU32>( physx::PxBroadPhaseType::eMBP ) },
		{ "eABP", static_cast<PxU32>( physx::PxBroadPhaseType::eABP ) },
		{ "eGPU", static_cast<PxU32>( physx::PxBroadPhaseType::eGPU ) },
		{ "eLAST", static_cast<PxU32>( physx::PxBroadPhaseType::eLAST ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxBroadPhaseType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxBroadPhaseType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxScene;
	struct PxSceneGeneratedValues
	{
		PxSceneFlags Flags;
		PxSceneLimits Limits;
		PxU32 Timestamp;
		PxCpuDispatcher * CpuDispatcher;
		PxGpuDispatcher * GpuDispatcher;
		PxSimulationEventCallback * SimulationEventCallback;
		PxContactModifyCallback * ContactModifyCallback;
		PxCCDContactModifyCallback * CCDContactModifyCallback;
		PxBroadPhaseCallback * BroadPhaseCallback;
		PxU32 FilterShaderDataSize;
		PxSimulationFilterShader FilterShader;
		PxSimulationFilterCallback * FilterCallback;
		PxVec3 Gravity;
		PxReal BounceThresholdVelocity;
		PxU32 CCDMaxPasses;
		PxReal FrictionOffsetThreshold;
		PxFrictionType::Enum FrictionType;
		PxBounds3 VisualizationCullingBox;
		PxPruningStructureType::Enum StaticStructure;
		PxPruningStructureType::Enum DynamicStructure;
		PxU32 DynamicTreeRebuildRateHint;
		PxSceneQueryUpdateMode::Enum SceneQueryUpdateMode;
		PxU32 SceneQueryStaticTimestamp;
		PxBroadPhaseType::Enum BroadPhaseType;
		PxTaskManager * TaskManager;
		PxU32 MaxNbContactDataBlocksUsed;
		PxU32 ContactReportStreamBufferSize;
		PxU32 SolverBatchSize;
		PxReal WakeCounterResetValue;
		void * UserData;
		PxSimulationStatistics SimulationStatistics;
		 PX_PHYSX_CORE_API PxSceneGeneratedValues( const PxScene* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Flags, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Limits, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Timestamp, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CpuDispatcher, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, GpuDispatcher, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SimulationEventCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, ContactModifyCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDContactModifyCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BroadPhaseCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterShaderDataSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterShader, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FilterCallback, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, Gravity, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BounceThresholdVelocity, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, CCDMaxPasses, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FrictionOffsetThreshold, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, FrictionType, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, VisualizationCullingBox, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, StaticStructure, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, DynamicStructure, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, DynamicTreeRebuildRateHint, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SceneQueryUpdateMode, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SceneQueryStaticTimestamp, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, BroadPhaseType, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, TaskManager, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, MaxNbContactDataBlocksUsed, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, ContactReportStreamBufferSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SolverBatchSize, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, WakeCounterResetValue, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, UserData, PxSceneGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxScene, SimulationStatistics, PxSceneGeneratedValues)
	struct PxSceneGeneratedInfo

	{
		static const char* getClassName() { return "PxScene"; }
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Flags, PxScene, PxSceneFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Limits, PxScene, const PxSceneLimits &, PxSceneLimits > Limits;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Timestamp, PxScene, PxU32 > Timestamp;
		PxReadOnlyFilteredCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Actors, PxScene, PxActor *, PxActorTypeFlags > Actors;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Articulations, PxScene, PxArticulationBase * > Articulations;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Constraints, PxScene, PxConstraint * > Constraints;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Aggregates, PxScene, PxAggregate * > Aggregates;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CpuDispatcher, PxScene, PxCpuDispatcher * > CpuDispatcher;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_GpuDispatcher, PxScene, PxGpuDispatcher * > GpuDispatcher;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SimulationEventCallback, PxScene, PxSimulationEventCallback *, PxSimulationEventCallback * > SimulationEventCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_ContactModifyCallback, PxScene, PxContactModifyCallback *, PxContactModifyCallback * > ContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDContactModifyCallback, PxScene, PxCCDContactModifyCallback *, PxCCDContactModifyCallback * > CCDContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseCallback, PxScene, PxBroadPhaseCallback *, PxBroadPhaseCallback * > BroadPhaseCallback;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterShaderDataSize, PxScene, PxU32 > FilterShaderDataSize;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterShader, PxScene, PxSimulationFilterShader > FilterShader;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FilterCallback, PxScene, PxSimulationFilterCallback * > FilterCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_Gravity, PxScene, const PxVec3 &, PxVec3 > Gravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BounceThresholdVelocity, PxScene, const PxReal, PxReal > BounceThresholdVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_CCDMaxPasses, PxScene, PxU32, PxU32 > CCDMaxPasses;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FrictionOffsetThreshold, PxScene, PxReal > FrictionOffsetThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_FrictionType, PxScene, PxFrictionType::Enum, PxFrictionType::Enum > FrictionType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_VisualizationCullingBox, PxScene, const PxBounds3 &, PxBounds3 > VisualizationCullingBox;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_StaticStructure, PxScene, PxPruningStructureType::Enum > StaticStructure;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_DynamicStructure, PxScene, PxPruningStructureType::Enum > DynamicStructure;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_DynamicTreeRebuildRateHint, PxScene, PxU32, PxU32 > DynamicTreeRebuildRateHint;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SceneQueryUpdateMode, PxScene, PxSceneQueryUpdateMode::Enum, PxSceneQueryUpdateMode::Enum > SceneQueryUpdateMode;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SceneQueryStaticTimestamp, PxScene, PxU32 > SceneQueryStaticTimestamp;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseType, PxScene, PxBroadPhaseType::Enum > BroadPhaseType;
		PxReadOnlyCollectionPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_BroadPhaseRegions, PxScene, PxBroadPhaseRegionInfo > BroadPhaseRegions;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_TaskManager, PxScene, PxTaskManager * > TaskManager;
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_NbContactDataBlocks, PxScene, PxU32 > NbContactDataBlocks;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_MaxNbContactDataBlocksUsed, PxScene, PxU32 > MaxNbContactDataBlocksUsed;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_ContactReportStreamBufferSize, PxScene, PxU32 > ContactReportStreamBufferSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_SolverBatchSize, PxScene, PxU32, PxU32 > SolverBatchSize;
		PxReadOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_WakeCounterResetValue, PxScene, PxReal > WakeCounterResetValue;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxScene_UserData, PxScene, void *, void * > UserData;
		SimulationStatisticsProperty SimulationStatistics;

		PX_PHYSX_CORE_API PxSceneGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxScene*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 37; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( Flags, inStartIndex + 0 );; 
			inOperator( Limits, inStartIndex + 1 );; 
			inOperator( Timestamp, inStartIndex + 2 );; 
			inOperator( Actors, inStartIndex + 3 );; 
			inOperator( Articulations, inStartIndex + 4 );; 
			inOperator( Constraints, inStartIndex + 5 );; 
			inOperator( Aggregates, inStartIndex + 6 );; 
			inOperator( CpuDispatcher, inStartIndex + 7 );; 
			inOperator( GpuDispatcher, inStartIndex + 8 );; 
			inOperator( SimulationEventCallback, inStartIndex + 9 );; 
			inOperator( ContactModifyCallback, inStartIndex + 10 );; 
			inOperator( CCDContactModifyCallback, inStartIndex + 11 );; 
			inOperator( BroadPhaseCallback, inStartIndex + 12 );; 
			inOperator( FilterShaderDataSize, inStartIndex + 13 );; 
			inOperator( FilterShader, inStartIndex + 14 );; 
			inOperator( FilterCallback, inStartIndex + 15 );; 
			inOperator( Gravity, inStartIndex + 16 );; 
			inOperator( BounceThresholdVelocity, inStartIndex + 17 );; 
			inOperator( CCDMaxPasses, inStartIndex + 18 );; 
			inOperator( FrictionOffsetThreshold, inStartIndex + 19 );; 
			inOperator( FrictionType, inStartIndex + 20 );; 
			inOperator( VisualizationCullingBox, inStartIndex + 21 );; 
			inOperator( StaticStructure, inStartIndex + 22 );; 
			inOperator( DynamicStructure, inStartIndex + 23 );; 
			inOperator( DynamicTreeRebuildRateHint, inStartIndex + 24 );; 
			inOperator( SceneQueryUpdateMode, inStartIndex + 25 );; 
			inOperator( SceneQueryStaticTimestamp, inStartIndex + 26 );; 
			inOperator( BroadPhaseType, inStartIndex + 27 );; 
			inOperator( BroadPhaseRegions, inStartIndex + 28 );; 
			inOperator( TaskManager, inStartIndex + 29 );; 
			inOperator( NbContactDataBlocks, inStartIndex + 30 );; 
			inOperator( MaxNbContactDataBlocksUsed, inStartIndex + 31 );; 
			inOperator( ContactReportStreamBufferSize, inStartIndex + 32 );; 
			inOperator( SolverBatchSize, inStartIndex + 33 );; 
			inOperator( WakeCounterResetValue, inStartIndex + 34 );; 
			inOperator( UserData, inStartIndex + 35 );; 
			inOperator( SimulationStatistics, inStartIndex + 36 );; 
			return 37 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxScene>
	{ 
		PxSceneGeneratedInfo Info;
		const PxSceneGeneratedInfo* getInfo() { return &Info; }
	};

	class PxSceneLimits;
	struct PxSceneLimitsGeneratedValues
	{
		PxU32 MaxNbActors;
		PxU32 MaxNbBodies;
		PxU32 MaxNbStaticShapes;
		PxU32 MaxNbDynamicShapes;
		PxU32 MaxNbAggregates;
		PxU32 MaxNbConstraints;
		PxU32 MaxNbRegions;
		PxU32 MaxNbBroadPhaseOverlaps;
		 PX_PHYSX_CORE_API PxSceneLimitsGeneratedValues( const PxSceneLimits* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbActors, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbBodies, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbStaticShapes, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbDynamicShapes, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbAggregates, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbConstraints, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbRegions, PxSceneLimitsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneLimits, MaxNbBroadPhaseOverlaps, PxSceneLimitsGeneratedValues)
	struct PxSceneLimitsGeneratedInfo

	{
		static const char* getClassName() { return "PxSceneLimits"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbActors, PxSceneLimits, PxU32, PxU32 > MaxNbActors;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbBodies, PxSceneLimits, PxU32, PxU32 > MaxNbBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbStaticShapes, PxSceneLimits, PxU32, PxU32 > MaxNbStaticShapes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbDynamicShapes, PxSceneLimits, PxU32, PxU32 > MaxNbDynamicShapes;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbAggregates, PxSceneLimits, PxU32, PxU32 > MaxNbAggregates;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbConstraints, PxSceneLimits, PxU32, PxU32 > MaxNbConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbRegions, PxSceneLimits, PxU32, PxU32 > MaxNbRegions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneLimits_MaxNbBroadPhaseOverlaps, PxSceneLimits, PxU32, PxU32 > MaxNbBroadPhaseOverlaps;

		PX_PHYSX_CORE_API PxSceneLimitsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneLimits*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( MaxNbActors, inStartIndex + 0 );; 
			inOperator( MaxNbBodies, inStartIndex + 1 );; 
			inOperator( MaxNbStaticShapes, inStartIndex + 2 );; 
			inOperator( MaxNbDynamicShapes, inStartIndex + 3 );; 
			inOperator( MaxNbAggregates, inStartIndex + 4 );; 
			inOperator( MaxNbConstraints, inStartIndex + 5 );; 
			inOperator( MaxNbRegions, inStartIndex + 6 );; 
			inOperator( MaxNbBroadPhaseOverlaps, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneLimits>
	{ 
		PxSceneLimitsGeneratedInfo Info;
		const PxSceneLimitsGeneratedInfo* getInfo() { return &Info; }
	};

	struct PxgDynamicsMemoryConfig;
	struct PxgDynamicsMemoryConfigGeneratedValues
	{
		PxU32 ConstraintBufferCapacity;
		PxU32 ContactBufferCapacity;
		PxU32 TempBufferCapacity;
		PxU32 ContactStreamSize;
		PxU32 PatchStreamSize;
		PxU32 ForceStreamCapacity;
		PxU32 HeapCapacity;
		PxU32 FoundLostPairsCapacity;
		 PX_PHYSX_CORE_API PxgDynamicsMemoryConfigGeneratedValues( const PxgDynamicsMemoryConfig* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, ConstraintBufferCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, ContactBufferCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, TempBufferCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, ContactStreamSize, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, PatchStreamSize, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, ForceStreamCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, HeapCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxgDynamicsMemoryConfig, FoundLostPairsCapacity, PxgDynamicsMemoryConfigGeneratedValues)
	struct PxgDynamicsMemoryConfigGeneratedInfo

	{
		static const char* getClassName() { return "PxgDynamicsMemoryConfig"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_ConstraintBufferCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > ConstraintBufferCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_ContactBufferCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > ContactBufferCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_TempBufferCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > TempBufferCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_ContactStreamSize, PxgDynamicsMemoryConfig, PxU32, PxU32 > ContactStreamSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_PatchStreamSize, PxgDynamicsMemoryConfig, PxU32, PxU32 > PatchStreamSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_ForceStreamCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > ForceStreamCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_HeapCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > HeapCapacity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxgDynamicsMemoryConfig_FoundLostPairsCapacity, PxgDynamicsMemoryConfig, PxU32, PxU32 > FoundLostPairsCapacity;

		PX_PHYSX_CORE_API PxgDynamicsMemoryConfigGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxgDynamicsMemoryConfig*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 8; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ConstraintBufferCapacity, inStartIndex + 0 );; 
			inOperator( ContactBufferCapacity, inStartIndex + 1 );; 
			inOperator( TempBufferCapacity, inStartIndex + 2 );; 
			inOperator( ContactStreamSize, inStartIndex + 3 );; 
			inOperator( PatchStreamSize, inStartIndex + 4 );; 
			inOperator( ForceStreamCapacity, inStartIndex + 5 );; 
			inOperator( HeapCapacity, inStartIndex + 6 );; 
			inOperator( FoundLostPairsCapacity, inStartIndex + 7 );; 
			return 8 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxgDynamicsMemoryConfig>
	{ 
		PxgDynamicsMemoryConfigGeneratedInfo Info;
		const PxgDynamicsMemoryConfigGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxPairFilteringMode__EnumConversion[] = {
		{ "eKEEP", static_cast<PxU32>( physx::PxPairFilteringMode::eKEEP ) },
		{ "eSUPPRESS", static_cast<PxU32>( physx::PxPairFilteringMode::eSUPPRESS ) },
		{ "eKILL", static_cast<PxU32>( physx::PxPairFilteringMode::eKILL ) },
		{ "eDEFAULT", static_cast<PxU32>( physx::PxPairFilteringMode::eDEFAULT ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxPairFilteringMode::Enum > { PxEnumTraits() : NameConversion( g_physx__PxPairFilteringMode__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	static PxU32ToName g_physx__PxSolverType__EnumConversion[] = {
		{ "ePGS", static_cast<PxU32>( physx::PxSolverType::ePGS ) },
		{ "eTGS", static_cast<PxU32>( physx::PxSolverType::eTGS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSolverType::Enum > { PxEnumTraits() : NameConversion( g_physx__PxSolverType__EnumConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSceneDesc;
	struct PxSceneDescGeneratedValues
	{
		PxVec3 Gravity;
		PxSimulationEventCallback * SimulationEventCallback;
		PxContactModifyCallback * ContactModifyCallback;
		PxCCDContactModifyCallback * CcdContactModifyCallback;
		const void * FilterShaderData;
		PxU32 FilterShaderDataSize;
		PxSimulationFilterShader FilterShader;
		PxSimulationFilterCallback * FilterCallback;
		PxPairFilteringMode::Enum KineKineFilteringMode;
		PxPairFilteringMode::Enum StaticKineFilteringMode;
		PxBroadPhaseType::Enum BroadPhaseType;
		PxBroadPhaseCallback * BroadPhaseCallback;
		PxSceneLimits Limits;
		PxFrictionType::Enum FrictionType;
		PxSolverType::Enum SolverType;
		PxReal BounceThresholdVelocity;
		PxReal FrictionOffsetThreshold;
		PxReal CcdMaxSeparation;
		PxReal SolverOffsetSlop;
		PxSceneFlags Flags;
		PxCpuDispatcher * CpuDispatcher;
		PxGpuDispatcher * GpuDispatcher;
		PxPruningStructureType::Enum StaticStructure;
		PxPruningStructureType::Enum DynamicStructure;
		PxU32 DynamicTreeRebuildRateHint;
		PxSceneQueryUpdateMode::Enum SceneQueryUpdateMode;
		void * UserData;
		PxU32 SolverBatchSize;
		PxU32 NbContactDataBlocks;
		PxU32 MaxNbContactDataBlocks;
		PxReal MaxBiasCoefficient;
		PxU32 ContactReportStreamBufferSize;
		PxU32 CcdMaxPasses;
		PxReal WakeCounterResetValue;
		PxBounds3 SanityBounds;
		PxgDynamicsMemoryConfig GpuDynamicsConfig;
		PxU32 GpuMaxNumPartitions;
		PxU32 GpuComputeVersion;
		 PX_PHYSX_CORE_API PxSceneDescGeneratedValues( const PxSceneDesc* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Gravity, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SimulationEventCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, ContactModifyCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdContactModifyCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShaderData, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShaderDataSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterShader, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FilterCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, KineKineFilteringMode, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, StaticKineFilteringMode, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BroadPhaseType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BroadPhaseCallback, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Limits, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FrictionType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverType, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, BounceThresholdVelocity, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, FrictionOffsetThreshold, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdMaxSeparation, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverOffsetSlop, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, Flags, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CpuDispatcher, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuDispatcher, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, StaticStructure, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, DynamicStructure, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, DynamicTreeRebuildRateHint, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SceneQueryUpdateMode, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, UserData, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SolverBatchSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, NbContactDataBlocks, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, MaxNbContactDataBlocks, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, MaxBiasCoefficient, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, ContactReportStreamBufferSize, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, CcdMaxPasses, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, WakeCounterResetValue, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, SanityBounds, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuDynamicsConfig, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuMaxNumPartitions, PxSceneDescGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSceneDesc, GpuComputeVersion, PxSceneDescGeneratedValues)
	struct PxSceneDescGeneratedInfo

	{
		static const char* getClassName() { return "PxSceneDesc"; }
		PxWriteOnlyPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ToDefault, PxSceneDesc, const PxTolerancesScale & > ToDefault;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Gravity, PxSceneDesc, PxVec3, PxVec3 > Gravity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SimulationEventCallback, PxSceneDesc, PxSimulationEventCallback *, PxSimulationEventCallback * > SimulationEventCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ContactModifyCallback, PxSceneDesc, PxContactModifyCallback *, PxContactModifyCallback * > ContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdContactModifyCallback, PxSceneDesc, PxCCDContactModifyCallback *, PxCCDContactModifyCallback * > CcdContactModifyCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShaderData, PxSceneDesc, const void *, const void * > FilterShaderData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShaderDataSize, PxSceneDesc, PxU32, PxU32 > FilterShaderDataSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterShader, PxSceneDesc, PxSimulationFilterShader, PxSimulationFilterShader > FilterShader;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FilterCallback, PxSceneDesc, PxSimulationFilterCallback *, PxSimulationFilterCallback * > FilterCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_KineKineFilteringMode, PxSceneDesc, PxPairFilteringMode::Enum, PxPairFilteringMode::Enum > KineKineFilteringMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_StaticKineFilteringMode, PxSceneDesc, PxPairFilteringMode::Enum, PxPairFilteringMode::Enum > StaticKineFilteringMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BroadPhaseType, PxSceneDesc, PxBroadPhaseType::Enum, PxBroadPhaseType::Enum > BroadPhaseType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BroadPhaseCallback, PxSceneDesc, PxBroadPhaseCallback *, PxBroadPhaseCallback * > BroadPhaseCallback;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Limits, PxSceneDesc, PxSceneLimits, PxSceneLimits > Limits;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FrictionType, PxSceneDesc, PxFrictionType::Enum, PxFrictionType::Enum > FrictionType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverType, PxSceneDesc, PxSolverType::Enum, PxSolverType::Enum > SolverType;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_BounceThresholdVelocity, PxSceneDesc, PxReal, PxReal > BounceThresholdVelocity;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_FrictionOffsetThreshold, PxSceneDesc, PxReal, PxReal > FrictionOffsetThreshold;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdMaxSeparation, PxSceneDesc, PxReal, PxReal > CcdMaxSeparation;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverOffsetSlop, PxSceneDesc, PxReal, PxReal > SolverOffsetSlop;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_Flags, PxSceneDesc, PxSceneFlags, PxSceneFlags > Flags;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CpuDispatcher, PxSceneDesc, PxCpuDispatcher *, PxCpuDispatcher * > CpuDispatcher;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuDispatcher, PxSceneDesc, PxGpuDispatcher *, PxGpuDispatcher * > GpuDispatcher;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_StaticStructure, PxSceneDesc, PxPruningStructureType::Enum, PxPruningStructureType::Enum > StaticStructure;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_DynamicStructure, PxSceneDesc, PxPruningStructureType::Enum, PxPruningStructureType::Enum > DynamicStructure;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_DynamicTreeRebuildRateHint, PxSceneDesc, PxU32, PxU32 > DynamicTreeRebuildRateHint;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SceneQueryUpdateMode, PxSceneDesc, PxSceneQueryUpdateMode::Enum, PxSceneQueryUpdateMode::Enum > SceneQueryUpdateMode;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_UserData, PxSceneDesc, void *, void * > UserData;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SolverBatchSize, PxSceneDesc, PxU32, PxU32 > SolverBatchSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_NbContactDataBlocks, PxSceneDesc, PxU32, PxU32 > NbContactDataBlocks;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_MaxNbContactDataBlocks, PxSceneDesc, PxU32, PxU32 > MaxNbContactDataBlocks;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_MaxBiasCoefficient, PxSceneDesc, PxReal, PxReal > MaxBiasCoefficient;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_ContactReportStreamBufferSize, PxSceneDesc, PxU32, PxU32 > ContactReportStreamBufferSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_CcdMaxPasses, PxSceneDesc, PxU32, PxU32 > CcdMaxPasses;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_WakeCounterResetValue, PxSceneDesc, PxReal, PxReal > WakeCounterResetValue;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_SanityBounds, PxSceneDesc, PxBounds3, PxBounds3 > SanityBounds;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuDynamicsConfig, PxSceneDesc, PxgDynamicsMemoryConfig, PxgDynamicsMemoryConfig > GpuDynamicsConfig;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuMaxNumPartitions, PxSceneDesc, PxU32, PxU32 > GpuMaxNumPartitions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSceneDesc_GpuComputeVersion, PxSceneDesc, PxU32, PxU32 > GpuComputeVersion;

		PX_PHYSX_CORE_API PxSceneDescGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSceneDesc*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 39; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( ToDefault, inStartIndex + 0 );; 
			inOperator( Gravity, inStartIndex + 1 );; 
			inOperator( SimulationEventCallback, inStartIndex + 2 );; 
			inOperator( ContactModifyCallback, inStartIndex + 3 );; 
			inOperator( CcdContactModifyCallback, inStartIndex + 4 );; 
			inOperator( FilterShaderData, inStartIndex + 5 );; 
			inOperator( FilterShaderDataSize, inStartIndex + 6 );; 
			inOperator( FilterShader, inStartIndex + 7 );; 
			inOperator( FilterCallback, inStartIndex + 8 );; 
			inOperator( KineKineFilteringMode, inStartIndex + 9 );; 
			inOperator( StaticKineFilteringMode, inStartIndex + 10 );; 
			inOperator( BroadPhaseType, inStartIndex + 11 );; 
			inOperator( BroadPhaseCallback, inStartIndex + 12 );; 
			inOperator( Limits, inStartIndex + 13 );; 
			inOperator( FrictionType, inStartIndex + 14 );; 
			inOperator( SolverType, inStartIndex + 15 );; 
			inOperator( BounceThresholdVelocity, inStartIndex + 16 );; 
			inOperator( FrictionOffsetThreshold, inStartIndex + 17 );; 
			inOperator( CcdMaxSeparation, inStartIndex + 18 );; 
			inOperator( SolverOffsetSlop, inStartIndex + 19 );; 
			inOperator( Flags, inStartIndex + 20 );; 
			inOperator( CpuDispatcher, inStartIndex + 21 );; 
			inOperator( GpuDispatcher, inStartIndex + 22 );; 
			inOperator( StaticStructure, inStartIndex + 23 );; 
			inOperator( DynamicStructure, inStartIndex + 24 );; 
			inOperator( DynamicTreeRebuildRateHint, inStartIndex + 25 );; 
			inOperator( SceneQueryUpdateMode, inStartIndex + 26 );; 
			inOperator( UserData, inStartIndex + 27 );; 
			inOperator( SolverBatchSize, inStartIndex + 28 );; 
			inOperator( NbContactDataBlocks, inStartIndex + 29 );; 
			inOperator( MaxNbContactDataBlocks, inStartIndex + 30 );; 
			inOperator( MaxBiasCoefficient, inStartIndex + 31 );; 
			inOperator( ContactReportStreamBufferSize, inStartIndex + 32 );; 
			inOperator( CcdMaxPasses, inStartIndex + 33 );; 
			inOperator( WakeCounterResetValue, inStartIndex + 34 );; 
			inOperator( SanityBounds, inStartIndex + 35 );; 
			inOperator( GpuDynamicsConfig, inStartIndex + 36 );; 
			inOperator( GpuMaxNumPartitions, inStartIndex + 37 );; 
			inOperator( GpuComputeVersion, inStartIndex + 38 );; 
			return 39 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSceneDesc>
	{ 
		PxSceneDescGeneratedInfo Info;
		const PxSceneDescGeneratedInfo* getInfo() { return &Info; }
	};

	static PxU32ToName g_physx__PxSimulationStatistics__RbPairStatsTypeConversion[] = {
		{ "eDISCRETE_CONTACT_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eDISCRETE_CONTACT_PAIRS ) },
		{ "eCCD_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eCCD_PAIRS ) },
		{ "eMODIFIED_CONTACT_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eMODIFIED_CONTACT_PAIRS ) },
		{ "eTRIGGER_PAIRS", static_cast<PxU32>( physx::PxSimulationStatistics::eTRIGGER_PAIRS ) },
		{ NULL, 0 }
	};

template<> struct PxEnumTraits< physx::PxSimulationStatistics::RbPairStatsType > { PxEnumTraits() : NameConversion( g_physx__PxSimulationStatistics__RbPairStatsTypeConversion ) {} const PxU32ToName* NameConversion; }; 
	class PxSimulationStatistics;
	struct PxSimulationStatisticsGeneratedValues
	{
		PxU32 NbActiveConstraints;
		PxU32 NbActiveDynamicBodies;
		PxU32 NbActiveKinematicBodies;
		PxU32 NbStaticBodies;
		PxU32 NbDynamicBodies;
		PxU32 NbAggregates;
		PxU32 NbArticulations;
		PxU32 NbAxisSolverConstraints;
		PxU32 CompressedContactSize;
		PxU32 RequiredContactConstraintMemory;
		PxU32 PeakConstraintMemory;
		PxU32 NbDiscreteContactPairsTotal;
		PxU32 NbDiscreteContactPairsWithCacheHits;
		PxU32 NbDiscreteContactPairsWithContacts;
		PxU32 NbNewPairs;
		PxU32 NbLostPairs;
		PxU32 NbNewTouches;
		PxU32 NbLostTouches;
		PxU32 NbPartitions;
		PxU32 NbBroadPhaseAdds;
		PxU32 NbBroadPhaseRemoves;
		PxU32 NbDiscreteContactPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbModifiedContactPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbCCDPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbTriggerPairs[PxGeometryType::eGEOMETRY_COUNT][PxGeometryType::eGEOMETRY_COUNT];
		PxU32 NbShapes[PxGeometryType::eGEOMETRY_COUNT];
		 PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedValues( const PxSimulationStatistics* inSource );
	};
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveConstraints, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveDynamicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbActiveKinematicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbStaticBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDynamicBodies, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbAggregates, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbArticulations, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbAxisSolverConstraints, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, CompressedContactSize, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, RequiredContactConstraintMemory, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, PeakConstraintMemory, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsTotal, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsWithCacheHits, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairsWithContacts, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbNewPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbLostPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbNewTouches, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbLostTouches, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbPartitions, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbBroadPhaseAdds, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbBroadPhaseRemoves, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbDiscreteContactPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbModifiedContactPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbCCDPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbTriggerPairs, PxSimulationStatisticsGeneratedValues)
	DEFINE_PROPERTY_TO_VALUE_STRUCT_MAP( PxSimulationStatistics, NbShapes, PxSimulationStatisticsGeneratedValues)
	struct PxSimulationStatisticsGeneratedInfo

	{
		static const char* getClassName() { return "PxSimulationStatistics"; }
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveConstraints, PxSimulationStatistics, PxU32, PxU32 > NbActiveConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveDynamicBodies, PxSimulationStatistics, PxU32, PxU32 > NbActiveDynamicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbActiveKinematicBodies, PxSimulationStatistics, PxU32, PxU32 > NbActiveKinematicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbStaticBodies, PxSimulationStatistics, PxU32, PxU32 > NbStaticBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDynamicBodies, PxSimulationStatistics, PxU32, PxU32 > NbDynamicBodies;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbAggregates, PxSimulationStatistics, PxU32, PxU32 > NbAggregates;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbArticulations, PxSimulationStatistics, PxU32, PxU32 > NbArticulations;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbAxisSolverConstraints, PxSimulationStatistics, PxU32, PxU32 > NbAxisSolverConstraints;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_CompressedContactSize, PxSimulationStatistics, PxU32, PxU32 > CompressedContactSize;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_RequiredContactConstraintMemory, PxSimulationStatistics, PxU32, PxU32 > RequiredContactConstraintMemory;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_PeakConstraintMemory, PxSimulationStatistics, PxU32, PxU32 > PeakConstraintMemory;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsTotal, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsTotal;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsWithCacheHits, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsWithCacheHits;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbDiscreteContactPairsWithContacts, PxSimulationStatistics, PxU32, PxU32 > NbDiscreteContactPairsWithContacts;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbNewPairs, PxSimulationStatistics, PxU32, PxU32 > NbNewPairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbLostPairs, PxSimulationStatistics, PxU32, PxU32 > NbLostPairs;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbNewTouches, PxSimulationStatistics, PxU32, PxU32 > NbNewTouches;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbLostTouches, PxSimulationStatistics, PxU32, PxU32 > NbLostTouches;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbPartitions, PxSimulationStatistics, PxU32, PxU32 > NbPartitions;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbBroadPhaseAdds, PxSimulationStatistics, PxU32, PxU32 > NbBroadPhaseAdds;
		PxPropertyInfo<PX_PROPERTY_INFO_NAME::PxSimulationStatistics_NbBroadPhaseRemoves, PxSimulationStatistics, PxU32, PxU32 > NbBroadPhaseRemoves;
		NbDiscreteContactPairsProperty NbDiscreteContactPairs;
		NbModifiedContactPairsProperty NbModifiedContactPairs;
		NbCCDPairsProperty NbCCDPairs;
		NbTriggerPairsProperty NbTriggerPairs;
		NbShapesProperty NbShapes;

		PX_PHYSX_CORE_API PxSimulationStatisticsGeneratedInfo();
		template<typename TReturnType, typename TOperator>
		TReturnType visitType( TOperator inOperator ) const
		{
			return inOperator( reinterpret_cast<PxSimulationStatistics*>(NULL) );
		}
		template<typename TOperator>
		void visitBases( TOperator inOperator )
		{
			PX_UNUSED(inOperator);
		}
		template<typename TOperator>
		PxU32 visitBaseProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			return inStartIndex;
		}
		static PxU32 instancePropertyCount() { return 26; }
		static PxU32 totalPropertyCount() { return instancePropertyCount(); }
		template<typename TOperator>
		PxU32 visitInstanceProperties( TOperator inOperator, PxU32 inStartIndex = 0 ) const
		{
			PX_UNUSED(inOperator);
			PX_UNUSED(inStartIndex);
			inOperator( NbActiveConstraints, inStartIndex + 0 );; 
			inOperator( NbActiveDynamicBodies, inStartIndex + 1 );; 
			inOperator( NbActiveKinematicBodies, inStartIndex + 2 );; 
			inOperator( NbStaticBodies, inStartIndex + 3 );; 
			inOperator( NbDynamicBodies, inStartIndex + 4 );; 
			inOperator( NbAggregates, inStartIndex + 5 );; 
			inOperator( NbArticulations, inStartIndex + 6 );; 
			inOperator( NbAxisSolverConstraints, inStartIndex + 7 );; 
			inOperator( CompressedContactSize, inStartIndex + 8 );; 
			inOperator( RequiredContactConstraintMemory, inStartIndex + 9 );; 
			inOperator( PeakConstraintMemory, inStartIndex + 10 );; 
			inOperator( NbDiscreteContactPairsTotal, inStartIndex + 11 );; 
			inOperator( NbDiscreteContactPairsWithCacheHits, inStartIndex + 12 );; 
			inOperator( NbDiscreteContactPairsWithContacts, inStartIndex + 13 );; 
			inOperator( NbNewPairs, inStartIndex + 14 );; 
			inOperator( NbLostPairs, inStartIndex + 15 );; 
			inOperator( NbNewTouches, inStartIndex + 16 );; 
			inOperator( NbLostTouches, inStartIndex + 17 );; 
			inOperator( NbPartitions, inStartIndex + 18 );; 
			inOperator( NbBroadPhaseAdds, inStartIndex + 19 );; 
			inOperator( NbBroadPhaseRemoves, inStartIndex + 20 );; 
			inOperator( NbDiscreteContactPairs, inStartIndex + 21 );; 
			inOperator( NbModifiedContactPairs, inStartIndex + 22 );; 
			inOperator( NbCCDPairs, inStartIndex + 23 );; 
			inOperator( NbTriggerPairs, inStartIndex + 24 );; 
			inOperator( NbShapes, inStartIndex + 25 );; 
			return 26 + inStartIndex;
		}
	};
	template<> struct PxClassInfoTraits<PxSimulationStatistics>
	{ 
		PxSimulationStatisticsGeneratedInfo Info;
		const PxSimulationStatisticsGeneratedInfo* getInfo() { return &Info; }
	};



#undef THERE_IS_NO_INCLUDE_GUARD_HERE_FOR_A_REASON
#undef PX_PROPERTY_INFO_NAME
