##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
##  * Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
##  * Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
##  * Neither the name of NVIDIA CORPORATION nor the names of its
##    contributors may be used to endorse or promote products derived
##    from this software without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
## EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
## IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
## CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
## EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
## PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
## OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
## OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
## Copyright (c) 2018 NVIDIA Corporation. All rights reserved.

#
# Build FastXml common
#


SET(PHYSX_SOURCE_DIR ${PHYSX_ROOT_DIR}/source)
SET(LL_SOURCE_DIR ${PHYSX_SOURCE_DIR}/fastxml)

# Include here after the directories are defined so that the platform specific file can use the variables.
include(${PHYSX_ROOT_DIR}/${PROJECT_CMAKE_FILES_DIR}/${TARGET_BUILD_PLATFORM}/FastXml.cmake)


SET(FASTXML_HEADERS
	${LL_SOURCE_DIR}/include/PsFastXml.h
)
SOURCE_GROUP(include FILES ${FASTXML_HEADERS})

SET(FASTXML_SOURCE
	${LL_SOURCE_DIR}/src/PsFastXml.cpp
)
SOURCE_GROUP(src FILES ${FASTXML_SOURCE})

ADD_LIBRARY(FastXml ${FASTXML_LIBTYPE} 	
	${FASTXML_HEADERS}
	${FASTXML_SOURCE}
)

GET_TARGET_PROPERTY(PHYSXFOUNDATION_INCLUDES PhysXFoundation INTERFACE_INCLUDE_DIRECTORIES)

TARGET_INCLUDE_DIRECTORIES(FastXml
	PRIVATE ${PLATFORM_INCLUDES}
	PRIVATE ${PHYSXFOUNDATION_INCLUDES}
	PRIVATE ${LL_SOURCE_DIR}/include
)

TARGET_COMPILE_DEFINITIONS(FastXml 
	PRIVATE ${FASTXML_COMPILE_DEFS}
)

IF(NV_USE_GAMEWORKS_OUTPUT_DIRS AND FASTXML_LIBTYPE STREQUAL "STATIC")
	SET_TARGET_PROPERTIES(FastXml PROPERTIES 
		ARCHIVE_OUTPUT_NAME_DEBUG "FastXml_static"
		ARCHIVE_OUTPUT_NAME_CHECKED "FastXml_static"
		ARCHIVE_OUTPUT_NAME_PROFILE "FastXml_static"
		ARCHIVE_OUTPUT_NAME_RELEASE "FastXml_static"
	)
ENDIF()

IF(FASTXML_COMPILE_PDB_NAME_DEBUG)
	SET_TARGET_PROPERTIES(FastXml PROPERTIES 
		COMPILE_PDB_NAME_DEBUG "${FASTXML_COMPILE_PDB_NAME_DEBUG}"
		COMPILE_PDB_NAME_CHECKED "${FASTXML_COMPILE_PDB_NAME_CHECKED}"
		COMPILE_PDB_NAME_PROFILE "${FASTXML_COMPILE_PDB_NAME_PROFILE}"
		COMPILE_PDB_NAME_RELEASE "${FASTXML_COMPILE_PDB_NAME_RELEASE}"
	)
ENDIF()

IF(PX_GENERATE_SOURCE_DISTRO)
	LIST(APPEND SOURCE_DISTRO_FILE_LIST ${FASTXML_HEADERS})
	LIST(APPEND SOURCE_DISTRO_FILE_LIST ${FASTXML_SOURCE})
ENDIF()

# enable -fPIC so we can link static libs with the editor
SET_TARGET_PROPERTIES(FastXml PROPERTIES POSITION_INDEPENDENT_CODE TRUE)

