message(STATUS "Testing configuration ${activeConfig}.")

macro(TestExists exeName)
  set(exeFile "${dir}/${activeConfig}/${exeName}.exe")
  if(${ARGN} EXISTS "${exeFile}")
    message(STATUS "File ${exeFile} was correctly found ${ARGN} to exist.")
  else()
    message(FATAL_ERROR "File ${exeFile} was expected ${ARGN} to exist!")
  endif()
endmacro()

TestExists(DefaultBuilt)
TestExists(AlwaysBuilt)
TestExists(NeverBuilt NOT)
foreach(config ${allConfigs})
  if(config STREQUAL activeConfig)
    TestExists(BuiltIn${config})
    TestExists(ExcludedIn${config} NOT)
  else()
    TestExists(BuiltIn${config} NOT)
    TestExists(ExcludedIn${config})
  endif()
endforeach()
