/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.lighting;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseLightNode;

public abstract class BaseDirectionalLight
extends BaseLightNode {
    protected static final int FIELD_DIRECTION = 6;
    protected static final int LAST_DIRECTIONALLIGHT_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfDirection;

    protected BaseDirectionalLight() {
        super("DirectionalLight");
        this.hasChanged = new boolean[7];
        this.vfDirection = new float[]{0.0f, 0.0f, -1.0f};
    }

    protected BaseDirectionalLight(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLLightNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfDirection[0] = vRMLFieldData.floatArrayValue[0];
                this.vfDirection[1] = vRMLFieldData.floatArrayValue[1];
                this.vfDirection[2] = vRMLFieldData.floatArrayValue[2];
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfDirection;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public int getFieldIndex(String string) {
        int n;
        Integer n2 = (Integer)fieldMap.get(string);
        int n3 = n = n2 == null ? -1 : n2;
        if (n == 5 && (this.vrmlMajorVersion == 2 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion == 0)) {
            n = -1;
        }
        return n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfDirection, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("DirLight sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("DirLight sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setDirection(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setDirection(float[] fArray) {
        this.vfDirection[0] = fArray[0];
        this.vfDirection[1] = fArray[1];
        this.vfDirection[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseDirectionalLight.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseDirectionalLight.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        BaseDirectionalLight.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BaseDirectionalLight.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        BaseDirectionalLight.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "on");
        BaseDirectionalLight.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "global");
        BaseDirectionalLight.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(4);
        fieldMap.put("on", n);
        fieldMap.put("set_on", n);
        fieldMap.put("on_changed", n);
        n = new Integer(5);
        fieldMap.put("global", n);
        fieldMap.put("set_global", n);
        fieldMap.put("global_changed", n);
        n = new Integer(3);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(6);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
    }
}

