/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkUnsignedLongArray.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// Instantiate superclass first to give the template a DLL interface.
#include "vtkDataArrayTemplate.txx"
VTK_DATA_ARRAY_TEMPLATE_INSTANTIATE(unsigned long);

#define __vtkUnsignedLongArray_cxx
#include "vtkUnsignedLongArray.h"

#include "vtkObjectFactory.h"

//----------------------------------------------------------------------------
vtkCxxRevisionMacro(vtkUnsignedLongArray, "1.35");
vtkStandardNewMacro(vtkUnsignedLongArray);

//----------------------------------------------------------------------------
vtkUnsignedLongArray::vtkUnsignedLongArray(vtkIdType numComp): RealSuperclass(numComp)
{
}

//----------------------------------------------------------------------------
vtkUnsignedLongArray::~vtkUnsignedLongArray()
{
}

//----------------------------------------------------------------------------
void vtkUnsignedLongArray::PrintSelf(ostream& os, vtkIndent indent)
{
  this->RealSuperclass::PrintSelf(os,indent);
}
