/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkImage2dFourierBandPassFilter.hh
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Copyright (c) 1993-1995 Ken Martin, Will Schroeder, Bill Lorensen.

This software is copyrighted by Ken Martin, Will Schroeder and Bill Lorensen.
The following terms apply to all files associated with the software unless
explicitly disclaimed in individual files. This copyright specifically does
not apply to the related textbook "The Visualization Toolkit" ISBN
013199837-4 published by Prentice Hall which is covered by its own copyright.

The authors hereby grant permission to use, copy, and distribute this
software and its documentation for any purpose, provided that existing
copyright notices are retained in all copies and that this notice is included
verbatim in any distributions. Additionally, the authors grant permission to
modify this software and its documentation for any purpose, provided that
such modifications are not distributed without the explicit consent of the
authors and that existing copyright notices are retained in all copies. Some
of the algorithms implemented by this software are patented, observe all
applicable patent law.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN
"AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


=========================================================================*/
// .NAME vtkImage2dFourierBandPassFilter - Simple frequency domain band pass.
// .SECTION Description
// vtkImage2dFourierBandPassFilter just sets a portion of the image to zero.
// Input and Output must be floats.



#ifndef __vtkImage2dFourierBandPassFilter_h
#define __vtkImage2dFourierBandPassFilter_h


#include "vtkImageFilter.hh"

class vtkImage2dFourierBandPassFilter : public vtkImageFilter
{
public:
  vtkImage2dFourierBandPassFilter();
  char *GetClassName() {return "vtkImage2dFourierBandPassFilter";};

  void SetAxes2d(int axis0, int axis1);
  void InterceptCacheUpdate(vtkImageRegion *region);
  
  // Description:
  // Set/Get the band to pass. (0->1)
  vtkSetMacro(LowPass, float);
  vtkGetMacro(LowPass, float);
  vtkSetMacro(HighPass, float);
  vtkGetMacro(HighPass, float);
  
  
protected:
  float LowPass;
  float HighPass;
  
  void Execute1d(vtkImageRegion *inRegion, vtkImageRegion *outRegion);
};

#endif



