#ifndef TEMPLATES_HPP
#define TEMPLATES_HPP

#include "NestedRefine.hpp"

/*
 * This header contains the field values of the refinement patterns for
 * each entity types and their possible degrees. It also contains the permutations
 *  of the locally ordered vertices and half-facets on parent half-facets needed
 * for book-keeping purposes. The fields are described in the refPattern structure
 *  in NestedRefine class.
 *
 */

namespace moab{

  const NestedRefine::refPatterns NestedRefine::refTemplates[9][MAX_DEGREE] = {

    //EDGE
    {
      // Deg 2
      /*    0------2------1    */
     /*           1            2         */

      {1,0,0,1,2,
       {2,2},
       {{1.0/2.0,0,0}},
       {{0,2},{2,1}},

       {{1,0},{2,1},{2,0}},
       {{0,0,2,0}, {1,1,0,0}},

       {{}},
       {{}},
       {{1,1},{1,2}},
       {{}}
      },

      // Deg 3
      /*    0------2------3------1    */
     /*           1            2           3         */

      {2,0,0,2,3,
       {2,3},
       {{1.0/3.0,0,0},{2.0/3.0,0,0}},
       {{0,2},{2,3},{3,1}},

       {{1,0},{3,1},{2,0},{3,0}},
       {{0,0,2,0},{1,1,3,0},{2,1,0,0}},

       {{}},
       {{}},
       {{1,1},{1,3}},
       {{}}
      },

      // Deg 5
      /*    0------2------3------4------5------1    */
     /*           1            2          3           4            5         */

      {4,0,0,4,5,
       {2,5},
       {{1.0/5.0,0,0},{2.0/5.0,0,0},{3.0/5.0,0,0},{4.0/5.0,0,0}},
       {{0,2},{2,3},{3,4},{4,5},{5,1}},

       {{1,0},{5,1},{2,0},{3,0},{4,0},{5,0}},
       {{0,0,2,0},{1,1,3,0},{2,1,4,0},{3,1,5,0},{4,1,0,0}},

       {{}},
       {{}},
       {{1,1},{1,5}},
       {{}}
      }
    },

    //TRI
    {
      // Deg 2
      /*  2
         /  \
     5 /-- \ 4
       /_\/_\
      0   3  1   */

      {1,0,0,3,4,
       {3,5},
       {{0.5,0,0},{0.5,0.5,0},{0,0.5,0}},
       {{0,3,5},{3,4,5},{3,1,4},{5,4,2}},

       {{1,0},{3,1},{4,2},{3,0},{4,1},{1,2}},
       {{0,0,2,2,0,0},{3,2,4,0,1,1},{0,0,0,0,2,0},{2,1,0,0,0,0}},

       {{3},{4},{5}},
       {{}},
       {{2,1,3},{2,3,4},{2,4,1}},
       {{}}
       },

      // Deg 3
      /*  2
          /_\
        7    6
       /_\/_\
      8   9    5
     /_\/_\/_\
    0   3   4   1
    */

      {2,1,0,7,9,
       {3,9},
       {{1.0/3.0,0,0},{2.0/3.0,0,0},{2.0/3.0,1.0/3.0,0},{1.0/3.0,2.0/3.0,0},{0,2.0/3.0,0},{0,1.0/3.0,0},{1.0/3.0,1.0/3.0,0}},
       {{0,3,8},{3,9,8},{3,4,9},{4,5,9},{4,1,5},{8,9,7},{9,6,7},{9,5,6},{7,6,2}},

       {{1,0},{5,1},{9,2},{3,0},{5,0},{8,1},{9,1},{6,2},{1,2},{8,0}},
       {{0,0,2,2,0,0},{3,2,6,0,1,1},{0,0,4,2,2,1},{5,2,8,0,3,1},{0,0,0,0,4,0},{2,1,7,2,0,0},{8,2,9,0,6,1},{4,1,0,0,7,0},{7,1,0,0,0,0}},

       {{3,4},{5,6},{7,8}},
       {{9}},
       {{3,1,3,5},{3,5,8,9},{3,9,6,1}},
       {{}}
       },

      // Deg 5
      /*    2
            /_\
          11  10
          /_\/_\
        12 19  9
        /_\/_\/_\
      13 20 18  8
      /_\/_\/_\/_\
    14 15 16 17  7
    /_\/_\/_\/_\/_\
   0   3   4   5   6   1
    */


     {4,6,0,18,25,
      {3,20},
      {{1/5.0,0,0},
       {2/5.0,0,0},
       {3/5.0,0,0},
       {4/5.0,0,0},
       {4/5.0,1/5.0,0},
       {3/5.0,2/5.0,0},
       {2/5.0,3/5.0,0},
       {1/5.0,4/5.0,0},
       {0,4/5.0,0},
       {0,3/5.0,0},
       {0,2/5.0,0},
       {0,1/5.0,0},
       {1/5.0,1/5.0,0},
       {2/5.0,1/5.0,0},
       {3/5.0,1/5.0,0},
       {2/5.0,2/5.0,0},
       {1/5.0,3/5.0,0},
       {1/5.0,2/5.0,0}},

      {{0,3,14},{3,15,14},{3,4,15},{4,16,15},{4,5,16},{5,17,16},{5,6,17},{6,7,17},{6,1,7},{14,15,13},{15,20,13},{15,16,20},{16,18,20},{16,17,18},{17,8,18},{17,7,8},{13,20,12},{20,19,12},{20,18,19},{18,9,19},{18,8,9},{12,19,11},{19,10,11},{19,9,10},{11,10,2}},

      {{1,0},{9,1},{25,2},{3,0},{5,0},{7,0},{9,0},{16,1},{21,1},{24,1},{25,1},{22,2},{17,2},{10,2},{1,2},{12,0},{14,0},{16,0},{21,0},{24,0},{19,0}},
      {{0,0,2,2,0,0},{3,2,10,0,1,1},{0,0,4,2,2,0},{5,2,12,0,3,1},{0,0,6,2,4,1},{7,2,14,0,5,1},{0,0,8,2,6,1},{9,2,16,0,7,1},{0,0,0,0,8,1},{2,1,11,2,0,0},{12,2,17,0,10,1},{4,1,13,2,11,0},{14,2,19,0,12,1},{6,1,15,2,13,1},{16,2,21,0,14,1},{8,1,0,0,15,0},{11,1,18,2,0,0},{19,2,22,0,17,1},{13,1,20,2,18,0},{21,2,24,0,19,1},{15,1,0,0,20,0},{18,1,23,2,0,0},{24,2,25,0,22,1},{20,1,0,0,23,0},{23,1,0,0,0,0}},

     {{3,4,5,6},{7,8,9,10},{11,12,13,14}},
      {{15,16,17,18,19,20}},
     {{5,1,3,5,7,9},{5,9,16,21,24,25},{5,25,22,17,10,1}},
      {{}}
      }

    },

    //QUAD
    {
      // Deg 2
      /*
       3---6---2
       |       |      |
       7---8---5
       |       |      |
       0---4---1
       * */

      {1,1,0,5,4,
       {4,8},
       {{0,-1,0},{1,0,0},{0,1,0},{-1,0,0},{0,0,0}},
       {{0,4,8,7},{4,1,5,8},{8,5,2,6},{7,8,6,3}},

       {{1,0},{2,1},{3,2},{4,3},{2,0},{3,1},{4,2},{1,3},{3,0}},
       {{0,0,2,3,4,0,0,0},{0,0,0,0,3,0,1,1},{2,2,0,0,0,0,4,1},{1,2,3,3,0,0,0,0}},

       {{4},{5},{6},{7}},
       {{8}},
       {{2,1,2},{2,2,3},{2,3,4},{2,4,1}},
       {{}}
      },

      // Deg 3
      /*
       3---9---8---2
       |       |      |      |
     10---15--14--7
       |       |      |      |
     11---12--13--6
       |       |      |      |
       0---4---5---1
       * */


      {2,4,0,12,9,
       {4,15},
       {{-1.0/3.0,-1,0},{1.0/3.0,-1,0},{1,-1.0/3.0,0},{1,1.0/3.0,0},{1.0/3.0,1,0},{-1.0/3.0,1,0},{-1,1.0/3.0,0},{-1,-1.0/3.0,0},{-1.0/3.0, -1.0/3.0,0},{1.0/3.0, -1.0/3.0,0},{1.0/3.0, 1.0/3.0,0},{-1.0/3.0, 1.0/3.0,0}},
       {{0,4,12,11},{4,5,13,12},{5,1,6,13},{11,12,15,10},{12,13,14,15},{13,6,7,14},{10,15,9,3},{15,14,8,9},{14,7,2,8}},

       {{1,0},{3,1},{9,2},{7,3},{2,0},{3,0},{6,1},{9,1},{8,2},{7,2},{4,3},{1,3},{5,0},{6,0},{9,0},{8,0}},
       {{0,0,2,3,4,0,0,0}, {0,0,3,3,5,0,1,1}, {0,0,0,0,6,0,2,1}, {1,2,5,3,7,0,0,0}, {2,2,6,3,8,0,4,1}, {3,2,0,0,9,0,5,1}, {4,2,8,3,0,0,0,0}, {5,2,9,3,0,0,7,1}, {6,2,0,0,0,0,8,1}},

       {{4,5},{6,7},{8,9},{10,11}},
       {{12,13,14,15}},
       {{3,1,2,3},{3,3,6,9},{3,9,8,7},{3,7,4,1}},
       {{}}
      } ,

      // Deg 5
      /*
        3---15---14---13 ---12 ---2
         |       |        |         |         |         |
       16---29---28---27 ---26---11
         |       |        |         |         |         |
       17---30---35---34 ---25 ---10
         |       |        |         |         |         |
       18---31---32---33 ---24 ---9
         |       |        |         |         |         |
       19---20---21---22 ---23 ---8
         |       |        |         |         |         |
         0--- 4---  5---  6 ---  7 --- 1
       * */

      {4,16,0,32,25,
       {4,35},
       {{-3/5.0,-1,0},{-1/5.0,-1,0},{1/5.0,-1,0},{3/5.0,-1,0},{1,-3/5.0,0},{1,-1/5.0,0},{1,1/5.0,0},{1,3/5.0,0},{3/5.0,1,0},{1/5.0,1,0},{-1/5.0,1,0},{-3/5.0,1,0},{-1,3/5.0,0},{-1,1/5.0,0},{-1,-1/5.0,0},{-1,-3/5.0,0},{-3/5.0,-3/5.0,0},{-1/5.0,-3/5.0,0},{1/5.0,-3/5.0,0},{3/5.0,-3/5.0,0},{3/5.0,-1/5.0,0},{3/5.0,1/5.0,0},{3/5.0,3/5.0,0},{1/5.0,3/5.0,0},{-1/5.0,3/5.0,0},{-3/5.0,3/5.0,0},{-3/5.0,1/5.0,0},{-3/5.0,-1/5.0,0},{-1/5.0,-1/5.0,0},{1/5.0,-1/5.0,0},{1/5.0,1/5.0,0},{-1/5.0,1/5.0,0}},
      {{0,4,20,19},{4,5,21,20},{5,6,22,21},{6,7,23,22},{7,1,8,23},{19,20,31,18},{20,21,32,31},{21,22,33,32},{22,23,24,33},{23,8,9,24},{18,31,30,17},{31,32,35,30},{32,33,34,35},{33,24,25,34},{24,9,10,25},{17,30,29,16},{30,35,28,29},{35,34,27,28},{34,25,26,27},{25,10,11,26},{16,29,15,3},{29,28,14,15},{28,27,13,14},{27,26,12,13},{26,11,2,12}},

       {{1,0},{5,1},{25,2},{21,3},{2,0},{3,0},{4,0},{5,0},{10,1},{15,1},{20,1},{25,1},{24,2},{23,2},{22,2},{21,2},{16,3},{11,3},{6,3},{1,3},{7,0},{8,0},{9,0},{10,0},{15,0},{20,0},{25,0},{24,0},{23,0},{22,0},{17,0},{12,0},{13,0},{14,0},{19,0},{18,0}},
      {{0,0,2,3,6,0,0,0},
       {0,0,3,3,7,0,1,1},
       {0,0,4,3,8,0,2,1},
       {0,0,5,3,9,0,3,1},
       {0,0,0,0,10,0,4,1},
       {1,2,7,3,11,0,0,0},
       {2,2,8,3,12,0,6,1},
       {3,2,9,3,13,0,7,1},
       {4,2,10,3,14,0,8,1},
       {5,2,0,0,15,0,9,1},
       {6,2,12,3,16,0,0,0},
       {7,2,13,3,17,0,11,1},
       {8,2,14,3,18,0,12,1},
       {9,2,15,3,19,0,13,1},
       {10,2,0,0,20,0,14,1},
       {11,2,17,3,21,0,0,0},
       {12,2,18,3,22,0,16,1},
       {13,2,19,3,23,0,17,1},
       {14,2,20,3,24,0,18,1},
       {15,2,0,0,25,0,19,1},
       {16,2,22,3,0,0,0,0},
       {17,2,23,3,0,0,21,1},
       {18,2,24,3,0,0,22,1},
       {19,2,25,3,0,0,23,1},
       {20,2,0,0,0,0,24,1}},

       {{4,5,6,7},{8,9,10,11},{12,13,14,15},{16,17,18,19}},
       {{20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35}},
      {{5,1,2,3,4,5},{5,5,10,15,20,25},{5,25,24,23,22,21},{5,21,16,11,6,1}},
       {{}}
      }
    },

    //TET_Combination1
    {
      // Degree 2
      {
        1,0,0,6,8,
        {4,9},
        {{0.5,0,0},{0.5,0.5,0},{0,0.5,0},{0,0,0.5},{0.5,0,0.5},{0,0.5,0.5}},
        {{0,4,6,7},{4,8,6,7},{4,5,6,8},{6,8,5,9},{6,8,9,7},{4,1,5,8},{6,5,2,9},{7,8,9,3}},

        {{1,0},{6,1},{7,2},{8,2},{6,0},{7,1},{1,2},{8,0},{8,1},{8,2}},
        {{0,0,2,2,0,0,0,0},{0,0,5,0,1,1,3,2},{6,2,4,3,2,3,0,0},{5,3,0,0,7,0,3,1},{2,1,8,3,0,0,4,0},{0,0,0,0,3,0,0,0},{4,2,0,0,0,0,0,0},{0,0,0,0,0,0,5,1}},

        {{4},{5},{6},{7},{8},{9}},
        {{}},
        {{4,1,2,6,8},{4,6,4,7,8},{4,7,5,1,8},{4,1,3,7,6}},
        {{6,0,0},{7,1,1},{1,2,2},{8,0,0},{8,1,1},{8,2,2}}
      },

      //Degree 3
      {
        2,1,0,16,27,
        {4,19},
        {{1/3.0,0,0}, {2/3.0,0,0}, {2/3.0,1/3.0,0}, {1/3.0,2/3.0,0}, {0,2/3.0,0}, {0,1/3.0,0}, {0,0,1/3.0}, {0,0,2/3.0}, {2/3.0,0,1/3.0}, {1/3.0,0,2/3.0}, {0,2/3.0,1/3.0}, {0,1/3.0,2/3.0}, {1/3.0,0,1/3.0}, {1/3.0,1/3.0,1/3.0}, {0,1/3.0,1/3.0}, {1/3.0,1/3.0,0}},

        { {0,4,9,10}, {4,16,9,10}, {4,19,9,16}, {9,16,19,18}, {9,16,18,10},
          {4,5,19,16}, {5,12,19,16}, {5,6,19,12}, {19,12,6,17}, {19,12,17,16},
          {5,1,6,12}, {19,6,7,17}, {19,17,8,18}, {19,7,8,17}, {8,17,7,14},
          {8,17,14,18}, {8,7,2,14}, {19,16,17,18}, {9,19,8,18},
          {10,16,18,11}, {16,13,18,11}, {16,17,18,13}, {18,13,17,15},
          {18,13,15,11}, {16,12,17,13}, {18,17,14,15}, {11,13,15,3}
        },

        {{1,0}, {11,1}, {17,2}, {27,2}, {6,0}, {11,0}, {12,1}, {17,1}, {19,2}, {1,2}, {20,0}, {27,0}, {25,1}, {27,1}, {26,2}, {27,2}, {25,0}, {26,0}, {20,2}, {6,3}},
        {{0,0,2,2,0,0,0,0},
         {0,0,5,0,1,1,3,2},
         {6,2,4,3,2,3,0,0},
         {5,3,18,0,19,0,3,1},
         {2,1,20,3,0,0,4,0},
         {0,0,7,2,3,0,0,0},
         {0,0,10,0,6,1,8,2},
         {11,2,9,3,7,3,0,0},
         {10,3,0,0,12,0,8,1},
         {7,1,25,3,18,3,9,0},
         {0,0,0,0,8,0,0,0},
         {9,2,0,0,14,0,0,0},
         {18,2,16,0,19,1,14,2},
         {12,2,15,3,13,3,0,0},
         {16,3,0,0,17,0,14,1},
         {13,1,26,3,0,0,15,0},
         {15,2,0,0,0,0,0,0},
         {4,1,22,3,13,0,10,2},
         {4,2,13,2,0,0,0,0},
         {0,0,21,2,0,0,5,1},
         {0,0,24,0,20,1,22,2},
         {25,2,23,3,21,3,18,1},
         {24,3,0,0,26,0,22,1},
         {21,1,27,3,0,0,23,0},
         {0,0,0,0,22,0,10,1},
         {23,2,0,0,0,0,16,1},
         {0,0,0,0,0,0,24,1}
        },

        {{4,5}, {6,7}, {8,9}, {10,11}, {12,13}, {14,15}},
        {{16}, {17}, {18}, {19}},
        {{9,1,2,6,7,11,20,21,25,27}, {9,11,9,12,15,17,25,23,26,27}, {9,17,16,19,5,1,26,24,20,27}, {9,1,3,19,14,17,6,8,12,11}},
        {{6,0,0,11,0,0},{12,1,1,17,1,1},{19,2,2,1,2,2},{20,0,0,27,0,0},{25,1,1,27,1,1},{26,2,2,27,2,2}}
      }
    },

    // TET_Combination2
    {
      // Degree 2
      {
        1,0,0,6,8,
        {4,9},
        {{0.5,0,0},{0.5,0.5,0},{0,0.5,0},{0,0,0.5},{0.5,0,0.5},{0,0.5,0.5}},
        {{0,4,6,7},{4,8,9,7},{4,9,8,5},{4,5,6,9},{6,4,9,7},{4,1,5,8},{6,5,2,9},{7,8,9,3}},

        {{1,0},{6,1},{7,2},{8,2},{6,0},{7,1},{1,2},{8,0},{8,1},{8,2}},
        {{0,0,5,0,0,0,0,0},{0,0,8,3,5,1,3,3},{4,0,0,0,6,2,2,3},{3,0,7,0,5,3,0,0},{1,1,2,2,0,0,4,2},{0,0,0,0,3,2,0,0},{4,1,0,0,0,0,0,0},{0,0,0,0,0,0,2,1}},

        {{4},{5},{6},{7},{8},{9}},
        {{}},
        {{4,1,2,6,8},{4,6,3,7,8},{4,7,5,1,8},{4,1,4,7,6}},
        {{6,0,0},{7,1,1},{1,2,2},{8,0,0},{8,1,1},{8,2,2}}
      },


      //Degree 3
      {
        2,1,0,16,27,
        {4,19},
        {{1/3.0,0,0}, {2/3.0,0,0}, {2/3.0,1/3.0,0}, {1/3.0,2/3.0,0}, {0,2/3.0,0}, {0,1/3.0,0}, {0,0,1/3.0}, {0,0,2/3.0}, {2/3.0,0,1/3.0}, {1/3.0,0,2/3.0}, {0,2/3.0,1/3.0}, {0,1/3.0,2/3.0}, {1/3.0,0,1/3.0}, {1/3.0,1/3.0,1/3.0}, {0,1/3.0,1/3.0}, {1/3.0,1/3.0,0}},

        {{0,4,9,10}, {4,16,18,10}, {4,18,16,19}, {4,19,9,18},
        {9,4,18,10}, {4,5,19,16}, {5,12,17,16}, {5,17,12,6},
        {5,6,19,17}, {19,5,17,16}, {5,1,6,12}, {19,6,7,17},
        {19,17,14,18}, {19,14,17,7}, {19,7,8,14}, {8,19,14,18},
        {8,7,2,14}, {19,16,17,18}, {9,19,8,18}, {10,16,18,11},
        {16,13,15,11}, {16,15,13,17}, {16,17,18,15}, {18,16,15,11},
        {16,12,17,13}, {18,17,14,15}, {11,13,15,3}},

        {{1,0}, {11,1}, {17,2}, {27,2}, {6,0}, {11,0}, {12,1}, {17,1}, {19,2}, {1,2}, {20,0}, {27,0}, {25,1}, {27,1}, {26,2}, {27,2}, {25,0}, {26,0}, {20,2}, {6,3}},
        {{0,0,5,0,0,0,0,0},
         {0,0,20,3,5,1,3,3},
         {4,0,18,0,6,2,2,3},
         {3,0,19,0,5,3,0,0},
         {1,1,2,2,0,0,4,2},
         {0,0,10,0,3,2,0,0},
         {0,0,25,3,10,1,8,3},
         {9,0,0,0,11,2,7,3},
         {8,0,12,0,10,3,0,0},
         {6,1,7,2,18,3,9,2},
         {0,0,0,0,8,2,0,0},
         {9,1,0,0,14,2,0,0},
         {18,2,26,3,16,1,14,3},
         {15,0,0,0,12,2,13,3},
         {14,0,17,0,16,3,0,0},
         {19,1,13,2,0,0,15,2},
         {15,1,0,0,0,0,0,0},
         {3,1,23,3,13,0,10,2},
         {4,1,16,0,0,0,0,0},
         {0,0,24,0,0,0,2,1},
         {0,0,27,3,24,1,22,3},
         {23,0,0,0,25,2,21,3},
         {22,0,26,0,24,3,18,1},
         {20,1,21,2,0,0,23,2},
         {0,0,0,0,22,2,7,1},
         {23,1,0,0,0,0,13,1},
         {0,0,0,0,0,0,21,1}
        },

        {{4,5}, {6,7}, {8,9}, {10,11}, {12,13}, {14,15}},
        {{16}, {17}, {18}, {19}},
        {
          {9,1,2,6,7,11,20,21,25,27},
          {9,11,8,12,14,17,25,22,26,27},
          {9,17,16,19,5,1,26,24,20,27},
          {9,1,4,19,15,17,6,9,12,11}},
        {{6,0,0,11,0,0},{12,1,1,17,1,1},{19,2,2,1,2,2},{20,0,0,27,0,0},{25,1,1,27,1,1},{26,2,2,27,2,2}}
      }
    },

    //TET_Combination3
    {
      // Degree 2
      {
        1,0,0,6,8,
        {4,9},
        {{0.5,0,0},{0.5,0.5,0},{0,0.5,0},{0,0,0.5},{0.5,0,0.5},{0,0.5,0.5}},
        {{0,4,6,7},{4,8,5,7},{7,8,5,9},{7,5,6,9},{4,5,6,7},{4,1,5,8},{6,5,2,9},{7,8,9,3}},

        {{1,0},{6,1},{7,2},{8,2},{6,0},{7,1},{1,2},{8,0},{8,1},{8,2}},
        {{0,0,5,2,0,0,0,0},{0,0,3,3,5,0,6,2},{8,3,0,0,4,0,2,1},{3,2,7,0,0,0,5,1},{2,2,4,3,1,1,0,0},{0,0,0,0,2,3,0,0},{4,1,0,0,0,0,0,0},{0,0,0,0,0,0,3,0}},

        {{4},{5},{6},{7},{8},{9}},
        {{}},
        {{4,1,2,6,8},{4,6,3,7,8},{4,7,4,1,8},{4,1,5,7,6}},
        {{6,0,0},{7,1,1},{1,2,2},{8,0,0},{8,1,1},{8,2,2}}
      },

      //Degree 3
      {
        2,1,0,16,27,
        {4,19},
        {{1/3.0,0,0}, {2/3.0,0,0}, {2/3.0,1/3.0,0}, {1/3.0,2/3.0,0}, {0,2/3.0,0}, {0,1/3.0,0}, {0,0,1/3.0}, {0,0,2/3.0}, {2/3.0,0,1/3.0}, {1/3.0,0,2/3.0}, {0,2/3.0,1/3.0}, {0,1/3.0,2/3.0}, {1/3.0,0,1/3.0}, {1/3.0,1/3.0,1/3.0}, {0,1/3.0,1/3.0}, {1/3.0,1/3.0,0}},

        {{0,4,9,10}, {4,16,19,10}, {10,16,19,18}, {10,19,9,18},
        {4,19,9,10}, {4,5,19,16}, {5,12,6,16}, {16,12,6,17},
        {16,6,19,17}, {5,6,19,16}, {5,1,6,12}, {19,6,7,17},
        {19,17,7,18}, {18,17,7,14}, {18,7,8,14}, {19,7,8,18},
        {8,7,2,14}, {19,16,17,18}, {9,19,8,18}, {10,16,18,11},
        {16,13,17,11}, {11,13,17,15}, {11,17,18,15}, {16,17,18,11},
        {16,12,17,13}, {18,17,14,15}, {11,13,15,3}},

        {{1,0}, {11,1}, {17,2}, {27,2}, {6,0}, {11,0}, {12,1}, {17,1}, {19,2}, {1,2}, {20,0}, {27,0}, {25,1}, {27,1}, {26,2}, {27,2}, {25,0}, {26,0}, {20,2}, {6,3}},
        {{0,0,5,2,0,0,0,0},
         {0,0,3,3,5,0,6,2},
         {20,3,18,0,4,0,2,1},
         {3,2,19,0,0,0,5,1},
         {2,2,4,3,1,1,0,0},
         {0,0,10,2,2,3,0,0},
         {0,0,8,3,10,0,11,2},
         {25,3,0,0,9,0,7,1},
         {8,2,12,0,18,3,10,1},
         {7,2,9,3,6,1,0,0},
         {0,0,0,0,7,3,0,0},
         {9,1,0,0,13,3,0,0},
         {18,2,14,3,16,0,12,2},
         {26,3,0,0,15,0,13,1},
         {14,2,17,0,0,0,16,1},
         {13,2,15,3,19,1,0,0},
         {15,1,0,0,0,0,0,0},
         {3,1,24,3,13,0,9,2},
         {4,1,16,2,0,0,0,0},
         {0,0,24,2,0,0,3,0},
         {0,0,22,3,24,0,25,2},
         {27,3,0,0,23,0,21,1},
         {22,2,26,0,0,0,24,1},
         {21,2,23,3,20,1,18,1},
         {0,0,0,0,21,3,8,0},
         {23,1,0,0,0,0,14,0},
         {0,0,0,0,0,0,22,0}
        },

        {{4,5}, {6,7}, {8,9}, {10,11}, {12,13}, {14,15}},
        {{16}, {17}, {18}, {19}},
        {{9,1,2,6,7,11,20,21,25,27},
         {9,11,8,12,14,17,25,22,26,27},
         {9,17,15,19,4,1,26,23,20,27},
         {9,1,5,19,16,17,6,10,12,11}},
        {{6,0,0,11,0,0},{12,1,1,17,1,1},{19,2,2,1,2,2},{20,0,0,27,0,0},{25,1,1,27,1,1},{26,2,2,27,2,2}}
      }
    },

    //PRISM
    {
      {0,0,0,0,0,{},{{}},{{}},{{}},{{}},{{}},{{}},{{}}, {{}}}, //deg 2

      {0,0,0,0,0,{},{{}},{{}},{{}},{{}},{{}},{{}},{{}}, {{}}} //deg3
    },

    //KNIFE
    {
      {0,0,0,0,0,{},{{}},{{}},{{}},{{}},{{}},{{}},{{}}, {{}}},
      {0,0,0,0,0,{},{{}},{{}},{{}},{{}},{{}},{{}},{{}}, {{}}}
    },

    //HEX
    {
      //Deg 2
      {
        1,1,1,19,8,
        {8,26},
        {{0,-1,-1},{1,0,-1},{0,1,-1},{-1,0,-1},{-1,-1,0},{1,-1,0},{1,1,0},{-1,1,0},{0,-1,1},{1,0,1},{0,1,1},{-1,0,1},{0,-1,0},{1,0,0},{0,1,0},{-1,0,0},{0,0,-1},{0,0,1},{0,0,0}},
        {{0,8,24,11,12,20,26,23},
         {8,1,9,24,20,13,21,26},
         {11,24,10,3,23,26,22,15},
         {24,9,2,10,26,21,14,22},
         {12,20,26,23,4,16,25,19},
         {20,13,21,26,16,5,17,25},
         {23,26,22,15,19,25,18,7},
         {26,21,14,22,25,17,6,18}},

        {{1,0}, {2,1}, {4,2}, {3,3}, {5,5}, {6,5}, {8,5}, {7,5}, {2,0}, {4,1}, {3,2}, {1,3}, {5,0}, {6,1}, {8,2}, {7,3}, {6,5}, {8,5}, {7,5}, {5,5}, {6,0}, {8,1}, {7,2}, {5,3}, {2,4}, {8,5}, {8,0}},
        {{0,0,2,3,3,0,0,0,0,0,5,4},
         {0,0,0,0,4,0,1,1,0,0,6,4},
         {1,2,4,3,0,0,0,0,0,0,7,4},
         {2,2,0,0,0,0,3,1,0,0,8,4},
         {0,0,6,3,7,0,0,0,1,5,0,0},
         {0,0,0,0,8,0,5,1,2,5,0,0},
         {5,2,8,3,0,0,0,0,3,5,0,0},
         {6,2,0,0,0,0,7,1,4,5,0,0}},

        {{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19}},
        {{20},{21},{22},{23},{24},{25}},
        {{4,1,2,6,5}, {4,2,4,8,6}, {4,4,3,7,8},{4,3,1,5,7},{4,1,3,4,2},{4,5,6,8,7}},
        {{2,0,0},{4,1,1},{3,2,2},{1,3,3},{5,0,0},{6,1,1},{8,2,2},{7,3,3},{6,0,4},{8,1,5},{7,2,6},{5,3,7}}
      },

      //Deg 3
      {
        2,4,8,56,27,
        {8,63},
        {{-1/3.0,-1,-1}, {1/3.0,-1,-1}, {1,-1/3.0,-1}, {1,1/3.0,-1},
         {1/3.0,1,-1}, {-1/3.0,1,-1}, {-1,1/3.0,-1}, {-1,-1/3.0,-1},
         {-1,-1,-1/3.0}, {-1,-1,1/3.0}, {1,-1,-1/3.0}, {1,-1,1/3.0},
         {1,1,-1/3.0}, {1,1,1/3.0}, {-1,1,-1/3.0}, {-1,1,1/3.0},
         {-1/3.0,-1,1}, {1/3.0,-1,1}, {1,-1/3.0,1}, {1,1/3.0,1},
         {1/3.0,1,1}, {-1/3.0,1,1}, {-1,1/3.0,1}, {-1,-1/3.0,1},
         {-1/3.0,-1,-1/3.0}, {1/3.0,-1,-1/3.0}, {1/3.0,-1,1/3.0}, {-1/3.0,-1,1/3.0},
         {1,-1/3.0,-1/3.0}, {1,1/3.0,-1/3.0}, {1,1/3.0,1/3.0}, {1,-1/3.0,1/3.0},
         {1/3.0,1,-1/3.0}, {-1/3.0,1,-1/3.0}, {-1/3.0,1,1/3.0}, {1/3.0,1,1/3.0},
         {-1,1/3.0,-1/3.0}, {-1,-1/3.0,-1/3.0}, {-1,-1/3.0,1/3.0}, {-1,1/3.0,1/3.0},
         {-1/3.0,-1/3.0,-1}, {-1/3.0,1/3.0,-1}, {1/3.0,1/3.0,-1}, {1/3.0,-1/3.0,-1},
         {-1/3.0,-1/3.0,1}, {1/3.0,-1/3.0,1}, {1/3.0,1/3.0,1}, {-1/3.0,1/3.0,1},
         {-1/3.0,-1/3.0,-1/3.0}, {1/3.0,-1/3.0,-1/3.0}, {1/3.0,1/3.0,-1/3.0}, {-1/3.0,1/3.0,-1/3.0},
         {-1/3.0,-1/3.0,1/3.0}, {1/3.0,-1/3.0,1/3.0}, {1/3.0,1/3.0,1/3.0}, {-1/3.0,1/3.0,1/3.0}
        },

        {
          {0,8,48,15,16,32,56,45},
          {8,9,51,48,32,33,57,56},
          {9,1,10,51,33,18,36,57},
          {15,48,49,14,45,56,59,44},
          {48,51,50,49,56,57,58,59},
          {51,10,11,50,57,36,37,58},
          {14,49,13,3,44,59,41,22},
          {49,50,12,13,59,58,40,41},
          {50,11,2,12,58,37,20,40},
          {16,32,56,45,17,35,60,46},
          {32,33,57,56,35,34,61,60},
          {33,18,36,57,34,19,39,61},
          {45,56,59,44,46,60,63,47},
          {56,57,58,59,60,61,62,63},
          {57,36,37,58,61,39,38,62},
          {44,59,41,22,47,63,42,23},
          {59,58,40,41,63,62,43,42},
          {58,37,20,40,62,38,21,43},
          {17,35,60,46,4,24,52,31},
          {35,34,61,60,24,25,53,52},
          {34,19,39,61,25,5,26,53},
          {46,60,63,47,31,52,55,30},
          {60,61,62,63,52,53,54,55},
          {61,39,38,62,53,26,27,54},
          {47,63,42,23,30,55,29,7},
          {63,62,43,42,55,54,28,29},
          {62,38,21,43,54,27,6,28}
        },

        {
          {1,0}, {3,1}, {9,2}, {7,3}, {19,5}, {21,5}, {27,5}, {25,5}, {2,0}, {3,0},
          {6,1}, {9,1}, {8,2}, {7,2}, {4,3}, {1,3}, {10,0}, {19,0}, {12,1}, {21,1},
          {18,2}, {27,2}, {16,3}, {25,3}, {20,5}, {21,5}, {24,5}, {27,5}, {26,5}, {25,5},
          {22,5}, {19,5}, {11,0}, {12,0}, {21,0}, {20,0}, {15,1}, {18,1}, {27,1}, {24,1},
          {17,2}, {16,2}, {25,2}, {26,2}, {13,3}, {10,3}, {19,3}, {22,3}, {5,4}, {8,4},
          {9,4}, {6,4}, {23,5}, {24,5}, {27,5}, {26,5}, {14,4}, {15,4}, {18,4}, {17,4},
          {23,4}, {24,4}, {27,4}, {26,4}
        },

        {
          {0,0,2,3,4,0,0,0,0,0,10,4},
          {0,0,3,3,5,0,1,1,0,0,11,4},
          {0,0,0,0,6,0,2,1,0,0,12,4},
          {1,2,5,3,7,0,0,0,0,0,13,4},
          {2,2,6,3,8,0,4,1,0,0,14,4},
          {3,2,0,0,9,0,5,1,0,0,15,4},
          {4,2,8,3,0,0,0,0,0,0,16,4},
          {5,2,9,3,0,0,7,1,0,0,17,4},
          {6,2,0,0,0,0,8,1,0,0,18,4},

          {0,0,11,3,13,0,0,0,1,5,19,4},
          {0,0,12,3,14,0,10,1,2,5,20,4},
          {0,0,0,0,15,0,11,1,3,5,21,4},
          {10,2,14,3,16,0,0,0,4,5,22,4},
          {11,2,15,3,17,0,13,1,5,5,23,4},
          {12,2,0,0,18,0,14,1,6,5,24,4},
          {13,2,17,3,0,0,0,0,7,5,25,4},
          {14,2,18,3,0,0,16,1,8,5,26,4},
          {15,2,0,0,0,0,17,1,9,5,27,4},

          {0,0,20,3,22,0,0,0,10,5,0,0},
          {0,0,21,3,23,0,19,1,11,5,0,0},
          {0,0,0,0,24,0,20,1,12,5,0,0},
          {19,2,23,3,25,0,0,0,13,5,0,0},
          {20,2,24,3,26,0,22,1,14,5,0,0},
          {21,2,0,0,27,0,23,1,15,5,0,0},
          {22,2,26,3,0,0,0,0,16,5,0,0},
          {23,2,27,3,0,0,25,1,17,5,0,0},
          {24,2,0,0,0,0,26,1,18,5,0,0}
        },

        {{8,9}, {10,11}, {12,13}, {14,15}, {16,17}, {18,19}, {20,21}, {22,23}, {24,25}, {26,27}, {28,29}, {30,31}},
        {{32,33,34,35}, {36,37,38,39}, {40,41,42,43}, {44,45,46,47}, {48,49,50,51}, {52,53,54,55}},
        {{9,1,2,3,10,11,12,19,20,21}, {9,3,6,9,12,15,18,21,24,27}, {9,9,8,7,18,17,16,27,26,25},
         {9,7,4,1,16,13,10,25,22,19}, {9,1,4,7,2,5,8,3,6,9}, {9,19,20,21,22,23,24,25,26,27}},
        {{2,0,0,3,0,0},{6,1,1,9,1,1},{8,2,2,7,2,2},{4,3,3,1,3,3},{10,0,0,19,0,0},{12,1,1,21,1,1},
         {18,2,2,27,2,2},{16,3,3,25,3,3},{20,0,4,21,0,4},{24,1,5,27,1,5},{26,2,6,25,2,6},{22,3,7,19,3,7}}
      }
    }
  };


  const NestedRefine::pmat NestedRefine::permutation[2] =
  {
    //MBTRI
    {
      6,
      {{0,1,2},{1,0,2}, {2,1,0}, {0,2,1}, {2,0,1}, {1,2,0}},
      {{0,1,2},{0,2,1},{1,0,2},{2,1,0},{2,0,1},{1,2,0}},
      {1,0,0,0,1,1},
      {{1,2,3,4},{3,2,1,4}, {4,2,3,1}, {1,2,4,3}, {4,2,1,3}, {3,2,4,1}},
      {{1,2,3,4,5,6,7,8,9},{5,4,3,2,1,8,7,6,9}, {9,7,8,4,5,6,2,3,1}, {1,2,6,7,9,3,4,8,5}, {9,7,6,2,1,8,4,3,5}, {5,4,8,7,9,3,2,6,1}}
    },

    //MBQUAD
    {
      8,
      {{0,1,2,3},{1,0,3,2}, {2,1,0,3},  {3,2,1,0}, {0,3,2,1}, {3,0,1,2},  {2,3,0,1}, {1,2,3,0}},
      {{0,1,2,3},{0,3,2,1},{1,0,3,2},{2,1,0,3},{3,2,1,0},{3,0,1,2},{2,3,0,1},{1,2,3,0}},
      {1,0,0,0,0,1,1,1},
      {{1,2,3,4},{2,1,4,3}, {3,2,1,4}, {4,3,2,1}, {1,4,3,2}, {4,1,2,3},{3,4,1,2}, {2,3,4,1}},
      {{1,2,3,4,5,6,7,8,9},{3,2,1,6,5,4,9,8,7}, {9,6,3,8,5,2,7,1}, {7,8,9,4,5,6,1,2,3}, {1,4,7,2,5,8,3,6,9}, {7,4,1,8,5,2,9,6,3}, {9,8,7,6,5,4,3,2,1},{3,6,9,2,5,8,1,4,7}}
    }
  };

  const NestedRefine::intFEdge NestedRefine::intFacEdg[2][2] =
  {
    //MBTRI
    {{3, {{3,4},{4,5},{5,3}}},
     {9, {{8,3},{3,9},{9,4},{4,5},{5,9},{9,8},{7,9},{9,6},{6,7}}}},

    //MBQUAD
    {{4,{{4,8},{7,8},{8,6},{8,5}}},
     {12,{{4,12},{12,15},{15,9},{5,13},{13,14},{14,8},{11,12},{12,13},{13,6},{10,15},{15,14},{14,7}}}}
  };

}//namesapce moab

#endif
