//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME
// .SECTION
//

#ifndef __PreviewPanel_h
#define __PreviewPanel_h
#include <memory>

#include <QDockWidget>

#include <smtk/PublicPointerDefs.h>

namespace smtk
{
namespace attribute
{
class System;
}

namespace extension
{
class qtUIManager;
}
}

namespace Ui
{
class PreviewPanel;
}

class QModelIndex;
/**
 * \brief Panel widget to display smtk::common::View previews.
 *
 */
class PreviewPanel : public QDockWidget
{
  Q_OBJECT

public:
  PreviewPanel(QWidget* parent, smtk::attribute::SystemPtr system);
  ~PreviewPanel();

public slots:
  void updateCurrentView(const QModelIndex& currentDef, const QModelIndex& previousDef);

private:
  /**
 * Sample code to create a View for each AttDef (taken form qtAttributePreview).
 * \note TODO This is deprecated and will be deleted after finishing this class.
 */
  void createViewForAllAttributes(smtk::common::ViewPtr& root);

  /**
 * Instance a smtk::common::View for the input AttDef. Returns a nullptr if the
 * Definition is invalid. Make sure SMTK's specific View "types" are used on
 * View construction for it to construct/display correctly (see
 * qtUIManager::registerViewConstructor()).
 *
 * \sa smtk::extension::qtUIManager
 */
  smtk::common::ViewPtr createView(const smtk::attribute::DefinitionPtr& def);

  /**
 * Populate widget with SMTK-generated attribute widgets.
 */
  void createViewWidget(const smtk::common::ViewPtr& view);

  PreviewPanel(const PreviewPanel&) = delete;
  void operator=(const PreviewPanel&) = delete;

  std::unique_ptr<Ui::PreviewPanel> Ui;
  QWidget* PreviewWidget = nullptr;
  smtk::attribute::SystemPtr AttributeSystem;
  std::unique_ptr<smtk::extension::qtUIManager> UIManager;
  /**
 * TODO Keeps track of views generated by this widget (for preview) in order
 * to remove them later (before exporting/saving).
 */
  //  std::vector<smtk::common::ViewPtr> m_generatedViews;
};
#endif //__PreviewPanel_h
