set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/ZERO_CHECK.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${vcProjectFile} does not exist.")
  return()
endif()

set(found_CMakeInputs 0)
file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "<([A-Za-z0-9_]+) +Include=.*CMakeInputs.cmake")
    set(rule "${CMAKE_MATCH_1}")
    if(NOT rule STREQUAL "None")
      set(RunCMake_TEST_FAILED "CMakeInputs.cmake referenced as ${rule} instead of None")
      return()
    endif()
    if(found_CMakeInputs)
      set(RunCMake_TEST_FAILED "CMakeInputs.cmake referenced multiple times")
      return()
    endif()
    set(found_CMakeInputs 1)
  endif()
endforeach()
if(NOT found_CMakeInputs)
  set(RunCMake_TEST_FAILED "CMakeInputs.cmake not referenced")
endif()
