# 9.1.0 Release Notes

Changes made since VTK 9.0.0 include the following.

[](#changes)
## Changes

[](#changes-charts)
### Charts

* `vtkChartXYZ` now applies matrix transformations in the right order (see
  [issue 17542][vtk-issue17542])

[vtk-issue17542]: https://gitlab.kitware.com/vtk/vtk/-/issues/17542

[](#changes-data)
### Data

* The node numbering for `VTK_LAGRANGE_HEXAHEDRON` has been corrected to match
  the numbering of `VTK_QUADRATIC_HEXAHEDRON` when the Lagrange cell is
  quadratic. Readers can internally convert data to the new numbering with XML
  file version 2.2 and legacy file version 5.1. The `(0, 1)` edge is swapped
  with the `(1, 1)` edge:

```
       quadratic                         VTK_QUADRATIC_HEXAHEDRON
VTK_LAGRANGE_HEXAHEDRON                  VTK_LAGRANGE_HEXAHEDRON
    before VTK 9.1                           VTK 9.1 and later

       +_____+_____+                        +_____+_____+
       |\          :\                       |\          :\
       | +         : +                      | +         : +
       |  \     19 +  \                     |  \     18 +  \
    18 +   +-----+-----+                 19 +   +-----+-----+
       |   |       :   |                    |   |       :   |
       |__ | _+____:   |                    |__ | _+____:   |
       \   +        \  +                    \   +        \  +
        +  |         + |                     +  |         + |
         \ |          \|                      \ |          \|
           +_____+_____+                        +_____+_____+
```

* `vtkPolyData::ComputeBounds()` used to ignore points that do not belong to
  any cell which was not consistent with other `vtkPointSet` subclasses. See
  [ParaView issue #20354][paraview-issue20354]. The previous behavior is
  available through `vtkPolyData::ComputeCellsBounds()` and
  `vtkPolyData::GetCellsBounds()` (usually for rendering purposes).

[paraview-issue28354]: https://gitlab.kitware.com/paraview/paraview/-/issues/20354

[](#changes-filters)
### Filters

* The `VTK::FlowPaths` and `VTK::ParallelFlowPaths` filters now use a
  `vtkSignedCharArray` rather than a `vtkCharArray` since the latter is
  ambiguous as to whether it is signed or unsigned. This affects the
  `protected` API available to subclasses and the usage of the output's
  `ParticleSourceId` point data array.
* `vtkStaticCellLocator::FindCellsAlongLine()` now uses a tolerance for
  intersections with boxes.
* The tolerance used in `vtkStaticCellLocator` is now retrieved from the
  locator's tolerance rather than relying on the size of the dataset. Previous
  behavior may be restored using the `UseDiagonalLengthTolerance` property.
* `vtkTubeFilter` now increases the radius of tubes linearly with respect to
  the norm of the input vector when the radius is selected to vary by the
  vector's norm.
* `vtkArrayCalculator` has been updated to use C++ containers rather than raw
  pointers.
* `vtkArrayCalculator` no longer supports the old `dot` syntax by default and
  the `dot()` function must be used instead.
* `vtkArrayCalculator` can now use [`exprtk`][exprtk] to parse expressions (the
  new default). This brings in functionality, but cannot define functions that
  return vectors.
* `vtkArrayCalculator`'s input variable names must now be sanitized or quoted.

[exprtk]: https://github.com/ArashPartow/exprtk

[](#changes-io)
### I/O

* There is a new `VTK::IOChemistry` module which contains chemistry-related
  readers. Moved classes:
  * `vtkCMLMoleculeReader`: from `VTK::DomainsChemistry`
  * `vtkGaussianCubeReader`: from `VTK::IOGeometry`
  * `vtkGaussianCubeReader2`: from `VTK::IOGeometry`
  * `vtkMoleculeReaderBase`: from `VTK::IOGeometry`
  * `vtkPDBReader`: from `VTK::IOGeometry`
  * `vtkVASPAnimationReader`: from `VTK::DomainsChemistry`
  * `vtkVASPTessellationReader`: from `VTK::DomainsChemistry`
  * `vtkXYZMolReader`: from `VTK::IOGeometry`
  * `vtkXYZMolReader2`: from `VTK::IOGeometry`
* `vtkOpenFOAMReader` no longer supports the `include` compatibility keyword
  (deprecated in 2008).
* `vtkOpenFOAMReader` no longer treats `uniformFixedValue` as special. Proper
  support requires logic that would require VTK to use OpenFOAM libraries.
* `vtkOpenFOAMReader` no longer supports OpenFOAM 1.3 cloud naming (deprecated
  in 2007).

[](#changes-rendering)
### Rendering

* `vtkVolumeMapper` and its subclasses now accept `vtkDataSet` input, but
  ignore any type that is not a `vtkImageData` or `vtkRectilinearGrid` (or
  their subclasses). Derived classes may need to `SafeDownCast` if the input is
  assumed to be `vtkImageData`.
* OpenGL framebuffers are now handled using a `RenderFramebuffer` that is
  internally managed rather than destinations such as `BackLeft` and `Front`.
  If `SwapBuffers` is on, then the `RenderFramebuffer` will be blitted to a
  `DisplayFramebuffer` (twice for stereo rendering). The
  `vtkOpenGLRenderWindow::BlitToRenderFramebuffer` may be used to blit the
  current read framebuffer to the render framebuffer to initialize color and
  depth data. The `vtkOpenGLRenderWindow::FrameBlitMode` property may be set to
  control the following behavior:
  * `BlitToHardware`: blit to hardware buffers (such as `BACK_LEFT`)
  * `BlitToCurrent`: blit to the bound draw framebuffer
  * `NoBlit`: blitting will be handled externally
* `vtkTexture`'s API now more closely matches OpenGL's API. Instead of `Repeat`
  and `EdgeClamp` properties, `Wrap` is provided using values such as
  `ClampToEdge`, `Repeat`, `MirroredRepeat`, and `ClampToBorder`. A border
  color may be selected when using `ClampToBorder`.

[](#changes-java)
### Java

* The `byte`, `short`, `long`, and `float` types may now be exposed in the
  wrapped Java APIs. The Java API now uses types as close as possible to the
  C++ types used in the wrapped API.

[](#changes-python)
### Python

* VTK now defaults to Python 3.x rather than Python 2.
* The `VTK::WebPython` module no longer supports Python 2.
* Python 2.6, 3.2, and 3.3 are no longer supported. Python 3.6 or higher is
  recommended.
* VTK's web support now requires `wslink>=1.0.0`. This slims down the
  dependency tree by dropping Twisted in favor of `asyncio` and `aiohttp`.
* VTK's wheels are now built via CI (rather than by hand). Wheels are available for:
  * Python versions 3.6, 3.7, 3.8, and 3.9
  * Platforms `manylinux2014`, `macos10.10`, and `windows`
  * Python 3.9 also supports `macos11.0` `arm64`
  * Official wheels do not use any external dependencies, but see
    [`build.md`][build.md] for instructions on building custom wheels.
* VTK object `repr()` now shows the address of the underlying C++
  `vtkObjectBase` and the Python object itself:
  * `<vtkmodules.vtkCommonCore.vtkFloatArray(0xbd306710) at 0x69252b820>`.
* VTK objects which are not derived from `vtkObjectBase` now have a `repr()`
  that shows the construction method (though this is dependent on how the
  backing type serializes itself, so it may not be 100% accurate; please file
  issues for types which look "odd"):
  * `vtkmodules.vtkCommonCore.vtkVariant("hello")`
  * `vtkmodules.vtkCommonDataModel.vtkVector3f([1.0, 2.0, 3.0])`

[build.md]: ../dev/build.md

[](#changes-rendering)
### Rendering

* `vtkTextProperty::LineSpacing` now defaults to `1.0` rather than `1.1`.

[](#changes-infrastructure)
### Infrastructure

* VTK's deprecation mechanism now marks specific APIs as deprecated so that
  compilers may warn about its usage. Clients still requiring older APIs can
  suppress warnings by defining `VTK_DEPRECATION_LEVEL` to
  `VTK_VERSION_CHECK(x, y, z)` to suppress warnings about APIs deprecated after
  `x.y.z`.

[](#new-features)
## New Features

[](#new-features-algorithms)
### Algorithms

* `vtkFFT` is now available to perform discrete Fourier transformations.

[](#new-features-core)
### Core

* The `vtkGaussianRandomSequence::GetNextScaledValue()`,
  `vtkMinimalStandardRandomSequence::GetNextRangeValue()`, and
  `vtkRandomSequence::GetNextValue()` APIs have been added to avoid the
  `->Next()`, `->GetValue()` ping-ponging.
* `vtkVariant::ToString()` and `vtkVariant::ToUnicodeString()` now support
  formatting and precision arguments when processing numerical values or
  arrays.

[](#new-features-charts)
### Charts

* `vtkChartMatrix` may now share `x` and/or `y` axes between charts using the
  `Link(c1, c2)` and `Unlink(c1, c2)` methods. Labels for the axes may be set
  using the `LabelOuter(leftBottom, rightTop)` method.
* `vtkChartMatrix` now supports nested `vtkChartMatrix` items.
* `vtkChartMatrix::Paint` and `vtkChartMatrix::GetChartIndex` methods have been
  refactored to use an iterator-based API.
* `vtkChartXYZ` now resizes dynamically with the scene by managing its
  margins). Manual calls to `SetGeometry` is no longer necessary.
* `vtkChartXYZ` now supports removing plots.
* `vtkChartXYZ` can now turn off its clipping planes to avoid disappearing
  plots when zooming in.
* `vtkChartXYZ` can now zoom the axes along with the data.
* `vtkChartXYZ` now supports axes labels.
* `vtkChartXYZ` now uses `vtkTextProperty` for its text rendering.

[](#new-features-data)
### Data

* `vtkDataObjectTypes::TypeIdIsA` may be used to determine if a type is the
  same as or a specialization of another type.
* `vtkDataObjectTypes::GetCommonBaseTypeId` may be used to find the first
  common base class of two types.
* `vtkPartitionedDataSetCollection` and `vtkDataAssembly` has been introduced
  to represent hierarchical datasets rather than `vtkMultiBlockDataSet` and
  `vtkMultiPieceDataSet`. The new `vtkConvertToPartitionedDataSetCollection`
  filter can be used to convert any dataset into a
  `vtkPartitionedDataSetCollection` with `vtkDataAssembly` representing any
  hierarchical organization within a `vtkMultiBlockDataSet`. Converting back
  may be performed with `vtkPConvertToMultiBlockDataSet` or
  `vtkConvertToMultiBlockDataSet`.
* `vtkUnstructuredGrid::GetCell` is now thread-safe.

[](#new-features-documentation)
### Documentation

* VTK's Doxygen documentation now cross-references pages with the
  [vtk-examples][vtk-examples] website to examples using the class. Images for
  the classes are now embedded into the class documentation as well.

![Doxygen Examples](imgs/9.1/Doxygen_CrossReference_Examples.png)

[vtk-examples]: https://kitware.github.io/vtk-examples/site/

[](#new-features-geometry)
### Geometry

* The `vtkCell` API now includes support for the 19-node-pyramid named
  `vtkTriQuadraticPyramid`. Along with the addition of this API, several
  filters, readers and tests have been updated to incorporate
  `vtkTriQuadraticPyramid`:
  - Filters:
    * `vtkCellValidator`
    * `vtkUnstructuredGridGeometryFilter`
    * `vtkReflectionFilter`
    * `vtkBoxClipDataset`
    * `vtkCellTypeSource`
  - Readers:
    * `vtkIossReader`

[](#new-features-filters)
### Filters

* `vtk3DLinearGridPlaneCutter` has been updated to also handle cell data. Each
  triangle of the output dataset contains the attributes of the cell it
  originated from. Using this class should be faster than using the
  `vtkUnstructuredGridCutter` or the `vtkDataSetCutter` and should avoid some
  small projection error. The `vtkCutter` has also been updated to benefit from
  these changes.
* `vtkMergeVectorComponents` has been added to the `VTK::FiltersGeneral` module
  which supports `vtkDataSet` objects and may be used to combine three arrays
  of components into a new output array. This filter supports multithreading
  via `vtkSMPTools`.
* `vtkArrowSource` now has an option to be placed and oriented around its
  center which makes placing it after scaling and rotation much easier.
* `vtkDataSetSurfaceFilter` can now extract surfaces from all structured data
  sets including `vtkImageData`, `vtkStructuredGrid`, and `vtkRectilinearGrid`
  when they have blanked cells marked using a ghost array.
* `vtkDataSetSurfaceFilter` has a "fast mode" which only considers the
  outer-most surface without considering external faces within the outer shell
  which is intended for rendering purposes.
* `vtkExtractExodusGlobalTemporalVariables` now supports field data arrays.
* `vtkExtractEdges` now supports a `UseAllPoints` to use a non-`Locator`-based
  strategy to skip selecting only the points which are used and instead assumes
  that all points will be present in the output.
* The `vtkGhostCellsGenerator` filter is now available to generate ghost cells.
  It uses DIY for MPI communication internally and can handle any
  `vtkMultiBlockDataSet`, `vtkPartitionedDataSet`, and
  `vtkPartitionedDataSetCollection` that is filled with the supported input
  dataset types including `vtkImageData`, `vtkRectilinearGrid`,
  `vtkStructuredGrid`, `vtkUnstructuredGrid`, and `vtkPolyData`. Ghost cells
  are only exchanged with elements of the same type and are treated as the
  "closest" supported common ancestor class. Note that `vtkHyperTreeGrid` is
  not supported and `vtkHyperTreeGridGhostCellsGenerator` should be used for it
  instead.
* `vtkGroupDataSetsFilter` may be used to combine input datasets into a
  `vtkMultiBlockDataSet`, `vtkPartitionedDataSet`, or
  `vtkPartitionedDataSetCollection`. Each input is added as an individual block
  and may be named using `SetInputName`.
* `vtkGroupTimeStepsFilter` may be used to turn temporal data into a single
  `vtkMultiBlockDataSet` or `vtkPartitionedDataSetCollection` with all of the
  temporal data. The output type is `vtkPartitionedDataSetCollection` unless
  the input is `vtkMultiBlockDataSet` in which case another
  `vtkMultiBlockDataSet` is output.
* `vtkVortexCore`'s output points now include interpolated variables of the
  input points.
* `vtkVortexCore` is now fully multithreaded using `vtkSMPTools`.
* `vtkMergeTimeFilter` may be used to synchronize multiple input temporal
  datasets. The output is a `vtkMultiBlockDataSet` with one block per input
  element. The output timestep may be either a union or intersection of the
  input timestep lists (which may be de-duplicated with either absolute or
  relative tolerances).
* `vtkResizingWindowToImageFilter` may be used as an alternative to
  `vtkWindowToImageFilter` to create screenshots of any size and aspect ratio
  using the `SetSize(width, height)` method regardless of the window size. Note
  that offscreen buffers are used and therefore memory usage is higher than
  `vtkWindowToImageFilter`. Memory usage may be limited using the
  `SetSizeLimit(width, height)` method (defaulting to `(4000, 4000)`). For
  images larger than the limit the filter will fallback to
  `vtkWindowToImageFilter` in order to save memory.
* `vtkExtractVectorComponents` can now work multithreaded using `vtkSMPTools`.
* `vtkPartitionedDataSetCollectionSource` is now available to programmatically
  produce a `vtkPartitionedDataSetCollection`.
* `vtkThresholdPoints::InputArrayComponent` has been added to enable selection
  of a single component within the active data array. If a value larger than
  the number of components is used, the magnitude of each array tuple will be
  used.
* `vtkTubeBender` is now provided in order to generate better paths for tubes
  in `vtkTubeFilter`. This is particularly visible when generating tubes around
  acute angles.
* `vtkArrayCalculator` now supports multithreading via `vtkSMPTools`.
* `vtkVectorFieldTopology` may be used to compute the topological skeleton of a
  2D or 3D vector field given as a set of critical points and separatrices.
  Separatrices are lines in 2D and surfaces in 3D (computed via
  `vtkStreamSurface`).
* `vtkTableFFT` now offers a frequency column in the output table.
* `vtkTableFFT` can now compute the FFT per block and then average these
  results.
* `vtkTableFFT` can now apply a windowing function before computing the FFT.
* `vtkMergeCells` can now merge points using double precision tolerances.
* `vtkTemporalPathLineFilter` can now manage backwards times using its
  `SetBackwardTime()` method. When using backwards time, each
  `vtkDataObject::DATA_TIME_STEP()` from subsequent `::RequestData()` method
  calls will decrease.

[](#new-features-imaging)
### Imaging

* The `vtkImageProbeFilter` works like `vtkProbeFilter`, but is designed for
  image data. It uses `vtkImageInterpolator` rather than cell and point
  interpolations. The filter supports SMP acceleration.

[](#new-features-io)
### I/O

* VTK can now read ADIOS2 files or data streams using [Fides][fides]. This can
  be provided as a JSON file containing the data model or Fides can generate
  its own data model automatically (see Fides documentation for details). Fides
  converts the ADIOS2 data to a VTK-m dataset and the `vtkFidesReader` creates
  partitioned datasets that contain either native VTK datasets or VTK VTK-m
  datasets. Time and time streaming is supported. Note that the interface for
  time streaming is different and requires calling `PrepareNextStep()` and
  `Update()` for each new step.
* The `vtkCONVERGECFDReader` has been added to read CONVERGE CFD (version 3.1)
  files containing meshes, surfaces, and parcels as well as support for time
  series data. Each stream is considered its own block. Cell and point data
  arrays may be selected using the `CellArrayStatus` and `ParcelArrayStatus`
  APIs. Note that parallel support is not yet available.
* `vtkEnSightGoldBinaryReader` now supports reading undefined and partial
  variables from per-node and per-element files.
* VTK's EnSight Gold support can now read asymmetric tensors. This is not
  supported in EnSight6 files yet.
* The `vtkIossReader` has been added which supports reading CGNS and Exodus
  databases and files. The output is provided as a
  `vtkPartitionedDataSetCollection` with `vtkDataAssembly` representing the
  logical structure. Note that not all CGNS files are supported; only the
  subset supported by the backing [IOSS library][ioss]. Eventually, the
  `vtkExodusIIReader` will be deprecated in preference for this reader.
* The `vtkMP4Writer` writer may be used to write H.264-encoded MP4 files on
  Windows using the Microsoft Media Foundation API. The `Rate` property is
  available to set the framerate and the `BitRate` property may be used to set
  the quality of the output.
* `vtkOMFReader` may be used to read [Open Mining Format][open-mining-format]
  files. The output is a `vtkPartitionedDataSetCollection` with each
  `vtkPartitionedDataSet` is one OMF element (point set, line set, surface, or
  volume).
* `vtkOpenVDBWriter` may be used to write [OpenVDB][openvdb] files. MPI is
  supported by writing separate files for each rank. Temporal data is also
  written to a separate file for each timestep.
* `vtkTGAReader` may be used to read TGA images.
* `vtkPDBReader` now supports reading PDB files with multiple models.
* `vtkPDBReader` now generates an array containing the model each atom belongs
  to.
* `vtkVelodyneReader` may be used to read Velodyne AMR files.

![AMR-Detonation](imgs/9.1/AMRDetonationVelodyne.png)

* `vtkNrrdReader` can now read gzip-encoded compressed NRRD files.
* `vtkOpenFOAMReader` now supports reading internal dimensioned fields.
* `vtkOpenFOAMReader` now supports string expansion syntaxes from OpenFOAM
  v1806 (`#include`, `<case>`, `<constant>`, `<system>`).
* `vtkOpenFOAMReader` now handles mixed-precision workflows much more robustly.
* `vtkOpenFOAMReader` now handles multi-region cases without a default region.
* `vtkOpenFOAMReader` now respects the `inGroups` boundary entry for selection
  of multiple patches by group.
* `vtkOpenFOAMReader` now properly handles empty zones and has basic support
  for face zones.
* `vtkOpenFOAMReader` respects point patch value fields suing the correct
  visitation order.
* `vtkOpenFOAMReader` no longer has hard-coded limits on polyhedral size.
* `vtkOpenFOAMReader` now preserves uncollated Lagrangian information.
* `vtkOpenFOAMReader` now avoids naming ambiguities for Lagrangian and region
  names using a `/regionName/` prefix for non-default regions.

[fides]: https://gitlab.kitware.com/vtk/fides
[ioss]: http://gsjaardema.github.io/seacas
[open-mining-format]: https://omf.readthedocs.io/en/stable/index.html
[openvdb]: https://www.openvdb.org

[](#new-features-interaction)
### Interaction

* A new 3D camera orientation widget. The widget's representation is
  synchronized with the camera of the owning renderer. The widget may be used
  to select an axis or using its handles.
* `vtkSelectionNode` now supports `BLOCK_SELECTORS` to select whole blocks from
  a composite dataset using a selector expression for hierarchy or an
  associated `vtkDataAssembly` for `vtkPartitionedDataSetCollection`s.
* Interactive 2D widgets have been added (ported from ParaView). The
  `vtkEqualizerFilter` and `vtkEqualizerContextItem` are now available using
  this feature.
  * Source data: ![Equalizer filter and Interactive 2D](imgs/9.1/interactive_2d_before.png "Equalizer filter")
  * After applying the filter: ![Equalizer filter and Interactive 2D](imgs/9.1/interactive_2d_after.png "Equalizer filter")
* VTK's OpenVR's input model has been updated to be action-based and supports
  binding customization within the OpenVR user interface. This includes
  controller labeling and user configuration.
* `vtkEventData` now understands an "Any" device so that handlers can look for
  all events and do filtering internally. See [merge request 7557][vtk-mr7557]
  for an example of how to update custom 3D event handling.
* `vtkResliceCursorWidget` now refreshes when scrolling.
* Frustum selection of lines and polylines now only considers the line itself,
  not their containing area (i.e., they were treated as polygons during
  selection).
* Selections of `vtkDataAssembly` may be limited to a subset of blocks using a
  collection of xpath selectors for the dataset.
* `vtkChartXYZ` can now be controlled using the arrow keys for rotation.
* `vtkScalarBarActor` now supports custom tick locations via
  `vtkScalarBarActor::SetCustomLabels()` and
  `vtkScalarBarActor::SetUseCustomLabels()`.

[vtk-mr7557]: https://gitlab.kitware.com/vtk/vtk/-/merge_requests/7557#e8d22b8c27ce72ddec1110556087c6bd8d15fbec

[](#new-features-java)
### Java

* Java 1.7 is now required (bumped from 1.6).
* The wrapped Java API now handles strings more efficiently by handling
  encoding in the Java wrappers directly. No APIs are affected.

[](#new-features-python)
### Python

* `vtkPythonInterpreter::SetRedirectOutput` can be used to disable Python
  output to `vtkOutputWindow`.
* VTK now offers two CMake options for deployments that can help to handle
  Python 3.8's DLL loading policy changes on Windows. This allows `import
  vtkmodules` to handle `PATH` manipulations to ensure VTK can be loaded rather
  than relying on `vtkpython` to do this work.
  * `VTK_UNIFIED_INSTALL_TREE`: This option can be set to indicate that VTK
    will share an install tree with its dependencies. This allows VTK to avoid
    doing extra work that doesn't need to be done in such a situation. This is
    ignored if `VTK_RELOCATABLE_INSTALL` is given (there's no difference there
    as VTK assumes that how VTK is used in such a case is handled by other
    means).
  * `VTK_DLL_PATHS`: A list of paths to give to Python to use when loading DLL
    libraries.
* Python wrappers will now generate deprecation warnings when the underlying
  VTK API is deprecated. Since Python silences `DeprecationWarning` by default,
  the warnings must be allowed via:

```python
import warnings
warnings.filterwarnings("default", category=DeprecationWarning)
```

* With Python 3.6 and newer, VTK APIs marked with attributes that indicate that
  paths are expected will now support `pathlike` objects.
* Wrapped Python APIs now contain docstrings with type hints as described in
  [PEP 484][pep-484]. This will help with IDE tab completion and hinting.
* VTK's `vtkmodules` package and `vtk` module now provide `__version__`
  attributes.
* The `vtkmodules.web.render_window_serializer` module may be used to
  additionally serialize `vtkPolyData`, `vtkImageData`, and `mergeToPolyData`
  optionally using the `requested_fields=['*']` argument.

[pep-484]: https://www.python.org/dev/peps/pep-0484/

[](#new-features-qt)
### Qt

* VTK now supports Qt6 using the `VTK_QT_VERSION` variable. This may be set to
  `Auto` in which case the first of Qt6 or Qt5 found will be used.
* The `VTK::GUISupportQtQuick` module has been added which supports the
  necessary integration classes as well as the QML module infrastructure
  required to import VTK into a QtQuick application.

[](#new-features-rendering)
### Rendering

* The `vtkOutlineGlowRenderPass` renders a scene as a glowing outline. Combined
  with layered renderers this creates a very visible highlight without altering
  the highlighted object.
* VisRTX and OptiX now offer trace-level debugging information to determine why
  they may not be available.
* `vtkMultiBlockUnstructuredGridVolumeMapper` has been added to volume render
  the entirety of a multi-block unstructured grid without merging them.
* The physical-based render shader now supports anisotropic materials. This may
  be modified using the `Anisotropy` and `AnisotropyRotation` properties.
  Support for these values from a texture is also available.
* `vtkBlockItem` may now resize itself based on the label specified.
  Additionally, options for the brush, pen, and text, padding, margins are
  available.
* Multi-volume ray-casting now supports shading.
* `vtkMatplotlibMathTextUtilities` now supports multi-line (using `\n`) and
  multi-column (using `|` separators) text. `vtkTextProperty` now has a
  `CellOffset` property to control the spaces between columns (in pixels).
* The GPU-based ray-casting volume mapper now supports rendering non-uniform
  rectilinear grids. Volume streaming via block partitioning is not yet
  supported.

![Rectilinear-Grid-Volume](imgs/9.1/TestGPURayCastMapperRectilinearGrid.png)

* `vtkOpenGLMovieSphere` may be used to display spherical movies using OpenGL.
  Both regular 360° video and stereo 360° video is supported where stereo
  streams are split into left and right eye rendering passes. The video is sent
  to the graphics card as YUV textures which are decoded to RGB in the
  associated shaders.
* VTK's VisRTX support is now compatible with OSPRay 2.0.
* The OpenGL `vtkPolyData` mappers now provide a way to handle jitter
  introduced by rendering with single-precision vertex coordinates far from the
  origin. The `PauseShiftScale` parameter may be used to suspend updates during
  user interactions.
* `vtkResliceCursorRepresentation::BoundPlane()` is now offered to show the
  entire resliced image when rotating.
* `vtkOpenGLPolyDataMapper` now supports a `vtkSelection` object to display
  selected ids or values directly from the mapper itself. Selections are
  rendered in a second pass as a wireframe using the
  `vtkProperty::SelectionColor` color.
* The GPU-based ray-casting volume mapper now supports direct volume rendering
  with the blanking of cells and points defined by individual ghost arrays.
  * Uniform grid with blanking:

![Uniform-Grid-Blanking](imgs/9.1/TestGPURayCastVolumeUniformGridBlanking.png)

  * Image data with ghost cells and points:

![ImageData-Ghost-Arrays](imgs/9.1/TestGPURayCastVolumeGhostArrays.png)

* Volume rendering may now use independent scalar arrays for the `x` and `y`
  dimensions of 2D transfer functions.

[](#new-features-smp)
### SMP

* `vtkSMPTools::For()` can now be used on iterators and ranges. This can be
  especially useful for containers that are not indexed such as `std::map` and
  `std::set`.
* `vtkSMPTools::LocalScope` may be used to call a `vtkSMPTools` method with a
  specific configuration within a scope. The configuration structure takes a
  maximum thread number and/or a backend.
* `vtkSMPTools` now has an `STDThreads` backend which uses C++'s `std::thread`.
* `vtkSMPTools::Transform` and `vtkSMPTools::Fill` may be used as replacements
  for `std::transform` and `std::fill`.
* Multiple backends may now be compiled into VTK at build time rather than a
  separate build per backend. The default may be selected using the
  `VTK_SMP_IMPLEMENTATION_TYPE` CMake variable or the `VTK_SMP_BACKEND_IN_USE`
  environment variable at runtime. Enabling a backend is controlled by the
  `VTK_SMP_ENABLE_<backend>` CMake variable at build time.
* The `VTK_SMP_MAX_THREADS` environment variable is now available to limit the
  number of threads any SMP task will use.
* `vtkSMPTools` now supports nested parallelism using the `NestedParallelism`
  property (defaults to `false`) and the `IsParallelScope` query to detect such
  scoping.

[](#new-features-wrapping)
### Wrapping

* Wrapped classes no longer require a `vtk` prefix.
* Hierarchy files are used exclusively for type checking.
* The wrapping tools now keep an internal cache of which header files exist
  where on the system to avoid repeated lookups when resolving `#include`
  search paths.

[](#new-features-modules)
### Module System

* The `vtk_module_add_module(NOWRAP_HEADERS)` argument may be used to list
  public and installed headers which should not be exposed for wrapping
  purposes.
* The `vtk_module_add_module(NOWRAP_CLASSES)` argument may be used to list
  class names for which the headers are treated as `NOWRAP_HEADERS` arguments.
* The `vtk_module_add_module(HEADER_DIRECTORIES)` argument may be used to
  indicate that the relative path of headers from the current source or binary
  directory should be preserved upon installation.
* The `vtk_module_install_headers(USE_RELATIVE_PATHS)` argument may be used to
  indicate that the relative path of headers from the current source or binary
  directory should be preserved upon installation.
* The `vtk_module_build`, `vtk_module_wrap_python`, and `vtk_module_wrap_java`
  APIs now support a `UTILITY_TARGET` argument. The target named using this
  argument will be privately linked into every library created under these
  APIs. This may be used to provide compile or link options to every target.
  Note that the target given must be installed, but it may be installed with
  the same export set given to any of these APIs.
* The module system now supports target-specific components using the
  `vtk_module_build(TARGET_SPECIFIC_COMPONENTS)` argument.

[](#new-features-infrastructure)
### Infrastructure

* VTK plans to hold to a new minor (or major) release every six months with
  releases in or around April and October each year.
* VTK now uses GitLab-CI for testing.
* OSPRay support now detects Apple's Rosetta translation environment and
  refuses to run due to the environment not supporting instructions used within
  OSPRay.
* `vtkGetEnumMacro` and `vtkSetEnumMacro` are now available to work with `enum
  class` properties.
* VTK now requires CMake 3.12 to build and to consume. This is mainly due to
  the usage of `SHELL:` syntax to properly support some MPI use cases.
* `vtkSOADataArrayTemplate` compilation should use less memory now that its
  template instantiations are split into separate TU compilations.
* The `VTK_TARGET_SPECIFIC_COMPONENTS` option may be specified to provide
  target-specific installation components.

[](#new-features-third-party)
### Third Party

* An external `ioss` library may now be provided to VTK's build.
* An external `pegtl` library may now be provided to VTK's build.
* `exprtk` is now included in VTK (an external copy is supported).
* `fmt` is now included in VTK (an external copy is supported, though VTK
  requires patches which have been [merged upstream][fmt-pr2432] but not yet
  released).
* VTK's embedded third party packages have been updated:
  * `cli11` 2.0.0
  * `eigen` 3.3.9
  * `exodusII` 2021-05-12
  * `expat` 2.4.1
  * `freetype` 2.11.0
  * `glew` 2.2.0
  * `hdf5` 1.12.1
  * `jpeg` 2.1.0
  * `libxml2` 2.9.12
  * `lz4` 1.9.3
  * `lzma` 5.2.5
  * `mpi4py` 3.0.3
  * `netcdf` 4.8.0
  * `ogg` 1.3.5
  * `pugixml` 1.11.4
  * `sqlite` 3.36.0
  * `tiff` 4.3.0

[fmt-pr2432]: https://github.com/fmtlib/fmt/pull/2432.

[](#deprecations)
## Deprecated and Removed Features

[](#deprecations-legacy)
### Legacy

Some APIs had been deprecated for a long time. The following APIs are now
removed.

* `vtkDataArrayTemplate` (deprecated since Dec 2015)
* `vtkObjectBase::PrintRevisions` and `vtkObjectBase::CollectRevisions`
  (deprecated since 2012)
* `VTK___INT64` and `VTK_UNSIGNED___INT64` (deprecated since Mar 2017)
* `vtkArrayCalculator::SetAttributeMode*` and `VTK_ATTRIBUTE_MODE_*` macros
  (deprecated in Jun 2017)
* `vtkContourGrid::ComputeGradients` (deprecated in Dec 2018)
* `vtkSMPContourGridManyPieces`, `vtkSMPTransform`,
  `vtkThreadedSynchronizedTemplates3D`, and
  `vtkThreadedSynchronizedTemplatesCutter3D` (deprecated in Sep 2017)
* `vtkAbstractImageInterpolator::GetWholeExtent` (deprecated in Mar 2016)
* `vtkImageStencilData::InsertLine` (an overload) (deprecated in Nov 2014)
* The `RemoveBlockVisibilites` method from `vtkCompositeDataDisplayAttributes`,
  `vtkCompositeDataDisplayAttributesLegacy`, and `vtkCompositePolyDataMapper2`
  (deprecated in Jul 2017)
* `vtkOpenVRPropPicker` (deprecated in Apr 2018)

[](#deprecations-core)
### Core

* `vtkLegacy.h` and `VTK_LEGACY_REMOVE` are now deprecated and
  `vtkDeprecation.h` and its mechanisms should be used instead.
* Building with kits is no longer supported with static builds. Since the goal
  of a kit build is to reduce the number of runtime libraries needed at
  startup, a static kit build does not make much sense. Additionally, some
  dependency setups could not be resolved in such a build (as witnessed by
  ParaView) and a proper fix is not easy, so disabling the support makes more
  sense at this time.
* The `vtkToolkits.h` header provided preprocessor definitions indicating some
  features within VTK's build. However, these were inaccurate in
  single-configure builds since the information was not available when the
  header was configured.
  * `VTK_USE_VIDEO_FOR_WINDOWS`: now available in `vtkIOMovieConfigure.h`
  * `VTK_USE_VFW_CAPTURE`: now available in `vtkIOVideoConfigure.h` as
    `VTK_USE_VIDEO_FOR_WINDOWS_CAPTURE`, but the old name is given for
    compatibility.
* `vtkUnicodeString` and `vtkUnicodeStringArray` are now deprecated since VTK,
  since 8.2, has assumed UTF-8 for all string APIs. As such,
  `vtkUnicodeString` and `vtkUnicodeStringArray` did not provide any additional
  information. Users which used them to convert UTF-8 to UCS-2 for Windows API
  usages should instead use `VTK::vtksys`'s `SystemTools` APIs for converting
  such strings.
* `vtkAtomic` is removed in favor of `std::atomic`. As such, `vtkAtomic.h` and
  `vtkAtomicTypeConcepts.h` are no longer provided.
* Threading-related classes are now deprecated in favor of C++11 standard
  library mechanisms.
  * `vtkConditionVariable`: `std::condition_variable_any`
  * `vtkCriticalSection`: `std::mutex`
  * `vtkMutexLock`: `std::mutex`
  * `vtkSimpleConditionVariable`: `std::condition_variable_any`
  * `vtkSimpleCriticalSection`: `std::mutex`
  * `vtkSimpleMutexLock`: `std::mutex`
  * `vtkThreadMessanger`: `std::mutex` and `std::condition_variable_any`
* `vtkSetGet.h` no longer includes `<math.h>`.

[](#deprecations-filters)
### Filters

* `vtkDataSetSurfaceFilter` no longer supports generation of triangle strips.
  The `vtkStripper` filter may be used to generate them if needed.
* `vtkConfigure.h` is now deprecated and split into more focused headers. The
  headers which now contain the information:
  * `vtkBuild.h`: `VTK_BUILD_SHARED_LIBS`
  * `vtkCompiler.h`: Compiler detection and compatibility macros.
  * `vtkDebug.h`: `VTK_DEBUG_LEAKS` and `VTK_WARN_ON_DISPATCH_FAILURE`
  * `vtkDebugRangeIterators.h`: `VTK_DEBUG_RANGE_ITERATORS` and
    `VTK_ALWAYS_OPTIMIZE_ARRAY_ITERATORS`
  * `vtkEndian.h`: `VTK_WORDS_BIGENDIAN`
  * `vtkFeatures.h`: `VTK_ALL_NEW_OBJECT_FACTORY` and `VTK_USE_MEMKIND`
  * `vtkLegacy.h`: `VTK_LEGACY_REMOVE`, `VTK_LEGACY_SILENT`, and `VTK_LEGACY`
  * `vtkOptions.h`: `VTK_USE_64BIT_IDS` and `VTK_USE_64BIT_TIMESTAMPS`
  * `vtkPlatform.h`: `VTK_REQUIRE_LARGE_FILE_SUPPORT` and `VTK_MAXPATH`
  * `vtkSMP.h`: `VTK_SMP_${backend}` and `VTK_SMP_BACKEND`
  * `vtkThreads.h`: `VTK_USE_PTHREADS`, `VTK_USE_WIN32_THREADS`,
    `VTK_MAX_THREADS`
    * Also includes `VTK_THREAD_RETURN_VALUE` and `VTK_THREAD_RETURN_TYPE`, but
      `vtkMultiThreader.h` is guaranteed to provide this.
* Old ghost cell filters are deprecated in favor of `vtkGhostCellsGenerator`.
  * `vtkUnstructuredGridGhostCellsGenerator`
  * `vtkPUnstructuredGridGhostDataGenerator`
  * `vtkStructuredGridGhostDataGenerator`
  * `vtkPStructuredGridGhostDataGenerator`
  * `vtkUniformGridGhostDataGenerator`
  * `vtkPUniformGridGhostDataGenerator`
* `vtkThreshold`'s `ThresholdByLower()`, `ThresholdByUpper()`, and
  `ThresholdBetween()` methods are deprecated in favor of
  `vtkThreshold::LowerThreshold`, `vtkThreshold::UpperThreshold`, and
  `vtkThreshold::ThresholdFunction` properties.

[](#deprecations-python)
### Python

* Python 2 support, which reached its end-of-life in January 2020 is
  deprecated.

[](#deprecations-soft)
### Soft deprecations

Some groundwork has been laid down to deprecate existing classes with new
features in this release, but have not been formally deprecated yet. Users are
encouraged to use the new APIs to help ensure that the transition when they are
deprecated is smoother.

* `vtkMultiBlockDataGroupFilter` usage should be replaced by
  `vtkGroupDataSetsFilter`.
* `vtkMultiBlockFromTimeSeriesFilter` usage should be replaced by
  `vtkGroupDataSetsFilter`.
* `vtkExodusIIReader` usage should be replaced by` vtkIossReader`.
* The random number APIs from `vtkMath` should be moved to
  `vtkGaussianRandomSequence` or `vtkMinimalStandardRandomSequence` as needed.

[](#other-changes)
## Other Changes
