#include "vtkParseMain.h"
#include "vtkParseSystem.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void CreateInitFile(const char* libName, FILE* fout)
{
  const char* prefix = "";
  const char* dllexp = "VTK_ABI_EXPORT ";

  fprintf(fout, "// Generated by vtkWrapPythonInit in VTK/Wrapping\n");
  fprintf(fout, "#include \"vtkPython.h\"\n");
  fprintf(fout, "#include \"vtkPythonCompatibility.h\"\n");
  fprintf(fout, "#include \"vtkSystemIncludes.h\"\n");
  fprintf(fout,
    "// Handle compiler warning messages, etc.\n"
    "#if defined( _MSC_VER ) && !defined(VTK_DISPLAY_WIN32_WARNINGS)\n"
    "#pragma warning ( disable : 4706 )\n"
    "#endif // Windows Warnings\n\n");

  fprintf(fout, "extern \"C\" { PyObject *real_init%s(const char * /*unused*/); }\n\n", libName);

  fprintf(fout, "extern  \"C\" { %sPyObject *PyInit_%s%s(); }\n\n", dllexp, prefix, libName);

  fprintf(fout, "PyObject *PyInit_%s()\n", libName);
  fprintf(fout, "{\n");
  fprintf(fout, "  return real_init%s(nullptr);\n", libName);
  fprintf(fout, "}\n");
}

/* this routine creates the init file */
static void CreateImplFile(
  const char* libName, int numDepends, char** depends, int numFiles, char** files, FILE* fout)
{
  int i;

  fprintf(fout, "// Generated by vtkWrapPythonInit in VTK/Wrapping\n");
  fprintf(fout, "#include \"vtkPythonUtil.h\"\n");
  fprintf(fout, "#include \"vtkSystemIncludes.h\"\n");
  fprintf(fout, "#include <cstring>\n");
  fprintf(fout,
    "// Handle compiler warning messages, etc.\n"
    "#if defined( _MSC_VER ) && !defined(VTK_DISPLAY_WIN32_WARNINGS)\n"
    "#pragma warning ( disable : 4706 )\n"
    "#endif // Windows Warnings\n\n");

  for (i = 0; i < numFiles; i++)
  {
    fprintf(fout, "extern \"C\" { void PyVTKAddFile_%s(PyObject *dict); }\n", files[i]);
  }

  fprintf(fout, "\nstatic PyMethodDef Py%s_Methods[] = {\n", libName);
  fprintf(fout, "{nullptr, nullptr, 0, nullptr}};\n\n");

  fprintf(fout, "static PyModuleDef Py%s_Module = {\n", libName);
  fprintf(fout, "  PyModuleDef_HEAD_INIT,\n");
  fprintf(fout, "  \"%s\", // m_name\n", libName);
  fprintf(fout, "  nullptr, // m_doc\n");
  fprintf(fout, "  0, // m_size\n");
  fprintf(fout, "  Py%s_Methods, //m_methods\n", libName);
  fprintf(fout, "  nullptr, // m_reload\n");
  fprintf(fout, "  nullptr, // m_traverse\n");
  fprintf(fout, "  nullptr, // m_clear\n");
  fprintf(fout, "  nullptr  // m_free\n");
  fprintf(fout, "};\n");

  fprintf(fout, "extern  \"C\" {%s PyObject *real_init%s(const char * /*unused*/); }\n\n",
    "VTK_ABI_HIDDEN", libName);

  fprintf(fout, "PyObject *real_init%s(const char * /*unused*/)\n{\n", libName);

  /* module init function */
  fprintf(fout, "  PyObject *m = PyModule_Create(&Py%s_Module);\n", libName);

  fprintf(fout, "  PyObject *d = PyModule_GetDict(m);\n");
  fprintf(fout, "  if (!d)\n");
  fprintf(fout, "  {\n");
  fprintf(fout, "    Py_FatalError(\"can't get dictionary for module %s\");\n", libName);
  fprintf(fout, "  }\n\n");

  /* import all the modules that we depend on */
  if (numDepends > 0)
  {
    fprintf(fout, "  const char *depends[%d] = {\n", numDepends);
    for (i = 0; i < numDepends; i++)
    {
      fprintf(fout, "    \"%s\",\n", depends[i]);
    }
    fprintf(fout, "  };\n\n");
    fprintf(fout, "  for (int i = 0; i < %d; i++)\n", numDepends);
    fprintf(fout, "  {\n");
    fprintf(fout, "    if (!vtkPythonUtil::ImportModule(depends[i], d))\n");
    fprintf(fout, "    {\n");
    fprintf(fout, "      Py_DECREF(m);\n");
    fprintf(fout,
      "      return PyErr_Format(PyExc_ImportError,\n"
      "        \"Failed to load %s: No module named %%s\",\n"
      "        depends[i]);\n",
      libName);
    fprintf(fout, "    }\n");
    fprintf(fout, "  }\n\n");

    /* vtkPythonUtil should have been initialized by one of our dependencies */
    fprintf(fout, "  if (!vtkPythonUtil::IsInitialized())\n");
    fprintf(fout, "  {\n");
    fprintf(fout, "    Py_DECREF(m);\n");
    fprintf(fout,
      "    return PyErr_Format(PyExc_ImportError,\n"
      "      \"Initialization failed for %s, not compatible with %%s\",\n"
      "      depends[0]);\n",
      libName);
    fprintf(fout, "  }\n\n");
  }
  else
  {
    /* if we have no dependencies, ensure wrappers are initialized */
    fprintf(fout, "  vtkPythonUtil::Initialize();\n\n");
  }

  for (i = 0; i < numFiles; i++)
  {
    fprintf(fout, "  PyVTKAddFile_%s(d);\n", files[i]);
  }

  fprintf(fout, "\n");
  fprintf(fout, "  vtkPythonUtil::AddModule(\"%s\");\n\n", libName);
  fprintf(fout, "  return m;\n");
  fprintf(fout, "}\n\n");
}

int VTK_PARSE_MAIN(int argc, const char* argv[])
{
  FILE* file;
  FILE* fout_init;
  FILE* fout_impl;
  int numFiles = 0;
  int numDepends = 0;
  int i;
  char libName[250];
  char tmpVal[250];
  char* files[4000];
  char* depends[400];
  int doDepends = 0;

  if (argc < 4)
  {
    fprintf(stderr, "Usage: %s input_file init_file impl_file\n", argv[0]);
    return 1;
  }

  file = vtkParse_FileOpen(argv[1], "r");
  if (!file)
  {
    fprintf(stderr, "Input file %s could not be opened\n", argv[1]);
    return 1;
  }

  /* read the info from the file */
  if (fscanf(file, "%249s", libName) != 1)
  {
    fprintf(stderr, "Error getting libName\n");
    fclose(file);
    return 1;
  }
  /* read in the classes */
  while (fscanf(file, "%249s", tmpVal) != EOF)
  {
    if (strcmp(tmpVal, "DEPENDS") == 0)
    {
      doDepends = 1;
    }
    else if (doDepends)
    {
      depends[numDepends++] = strdup(tmpVal);
    }
    else
    {
      files[numFiles++] = strdup(tmpVal);
    }
  }
  /* close the file */
  fclose(file);
  file = NULL;

  fout_init = vtkParse_FileOpen(argv[2], "w");
  if (!fout_init)
  {
    return 1;
  }

  fout_impl = vtkParse_FileOpen(argv[3], "w");
  if (!fout_impl)
  {
    fclose(fout_init);
    return 1;
  }

  /* extra functions, types, etc. for the CommonCore module */
  if (strcmp(libName, "vtkCommonCore") == 0 || strcmp(libName, "vtkCommonKit") == 0)
  {
    files[numFiles] = strdup("PyVTKExtras");
    numFiles++;
  }

  CreateInitFile(libName, fout_init);
  CreateImplFile(libName, numDepends, depends, numFiles, files, fout_impl);

  for (i = 0; i < numFiles; i++)
  {
    free(files[i]);
  }
  for (i = 0; i < numDepends; i++)
  {
    free(depends[i]);
  }

  fclose(fout_init);
  fclose(fout_impl);

  return 0;
}
