## vtkDataSet: GetCellTypes updates

`vtkDataSet`'s method `void GetCellTypes(vtkCellTypes* types)`, has been deprecated in favor of
`void GetDistinctCellTypes(vtkCellTypes* types)`.

`vtkCartesianGrid` subclasses (`vtkImageData`, `vtkRectilinearGrid`) and `vtkStructuredGrid`'s method
`vtkConstantArray<int>* GetCellTypesArray()` has been deprecated in favor of `vtkConstantArray<unsigned char>
GetCellTypes()`.

`vtkUnstructuredGrid`'s method `vtkUnsignedCharArray* GetCellTypesArray()` has been deprecated in favor of
`vtkDataArray* GetCellTypes()`, which can be used to get the correct type as follows:

1. `auto cellTypes = vtkConstantArray<unsigned char>::FastDownCast(input->GetCellTypes())`
2. `auto cellTypes = vtkUnsignedCharArray::FastDownCast(input->GetCellTypes())`

This was done to enable storing the cell types of meshes with only 1 cell type as `vtkConstantArray<unsigned char>` instead
of `vtkUnsignedCharArray`, which saves memory.

It should be noted that due to this change, a cell types array generated by a VTKm filter can now also be stored in
`vtkUnstructuredGrid` as `vtkmDataArray` without needing to copy the data to `vtkUnsignedCharArray`.

Additionally, the majority of VTK filters that were generating single cell type cells have been updated to use
`vtkConstantArray<unsigned char>` to save memory.
