/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import mil.navy.nps.dis.ProtocolDataUnit;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.NetworkRoleListener;
import org.web3d.vrml.nodes.VRMLDISManagerNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNetworkInterfaceNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.xmsf.dis.ProtocolDataUnitType;

public abstract class BaseDISEntityManager
extends AbstractNode
implements VRMLNetworkInterfaceNodeType,
VRMLDISManagerNodeType {
    protected static final String PROTOCOL = "DIS";
    protected static final int FIELD_SITE_ID = 1;
    protected static final int FIELD_APPLICATION_ID = 2;
    protected static final int FIELD_ADDRESS = 3;
    protected static final int FIELD_PORT = 4;
    protected static final int FIELD_ADDED_ENTITIES = 5;
    protected static final int FIELD_REMOVED_ENTITIES = 6;
    protected static final int FIELD_MAPPING = 7;
    protected static final int LAST_ENTITY_MANAGER_INDEX = 7;
    protected static final int NUM_FIELDS = 8;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int vfSiteID;
    protected int vfApplicationID;
    protected String vfAddress;
    protected int vfPort;
    protected ArrayList vfMapping;
    protected ArrayList vfAddedEntities;
    protected ArrayList vfRemovedEntities;
    protected VRMLNodeFactory nodeFactory;
    private VRMLNodeType[] nodeTmp;

    public BaseDISEntityManager() {
        super("DISEntityManager");
        this.hasChanged = new boolean[8];
        this.vfSiteID = 0;
        this.vfApplicationID = 0;
        this.vfPort = 0;
        this.vfAddress = "";
        this.vfAddedEntities = new ArrayList();
        this.vfRemovedEntities = new ArrayList();
        this.vfMapping = new ArrayList();
    }

    public BaseDISEntityManager(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("siteID");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSiteID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("applicationID");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfApplicationID = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("address");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAddress = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("port");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPort = vRMLFieldData.intValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
    }

    public int getPrimaryType() {
        return 75;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfMapping.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfMapping.get(i);
            vRMLNodeType.setupFinished();
        }
        this.inSetup = false;
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public int getRole() {
        return 3;
    }

    public void addNetworkRoleListener(NetworkRoleListener networkRoleListener) {
    }

    public void removeNetworkRoleListener(NetworkRoleListener networkRoleListener) {
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        vRMLFieldData.numElements = 1;
        vRMLFieldData.dataType = (short)11;
        switch (n) {
            case 1: {
                vRMLFieldData.intValue = this.vfSiteID;
                break;
            }
            case 2: {
                vRMLFieldData.intValue = this.vfApplicationID;
                break;
            }
            case 4: {
                vRMLFieldData.intValue = this.vfPort;
                break;
            }
            case 3: {
                vRMLFieldData.stringValue = this.vfAddress;
                break;
            }
            case 7: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfMapping.size()];
                this.vfMapping.toArray(vRMLNodeTypeArray);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = vRMLNodeTypeArray;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            case 5: {
                int n2 = this.vfAddedEntities.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n2) {
                    this.nodeTmp = new VRMLNodeType[n2];
                }
                this.vfAddedEntities.toArray(this.nodeTmp);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n2;
                break;
            }
            case 6: {
                int n3 = this.vfRemovedEntities.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                    this.nodeTmp = new VRMLNodeType[n3];
                }
                this.vfRemovedEntities.toArray(this.nodeTmp);
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.nodeTmp;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = n3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfSiteID);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfPort);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfAddress);
                    break;
                }
                case 7: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfMapping.size()];
                    this.vfMapping.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                case 5: {
                    int n3 = this.vfAddedEntities.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n3) {
                        this.nodeTmp = new VRMLNodeType[n3];
                    }
                    this.vfAddedEntities.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n3);
                    break;
                }
                case 6: {
                    int n4 = this.vfRemovedEntities.size();
                    if (this.nodeTmp == null || this.nodeTmp.length < n4) {
                        this.nodeTmp = new VRMLNodeType[n4];
                    }
                    this.vfRemovedEntities.toArray(this.nodeTmp);
                    vRMLNodeType.setValue(n2, this.nodeTmp, n4);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTransform.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    this.vfMapping.clear();
                }
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.vfMapping.add(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    this.vfMapping.clear();
                }
                this.vfMapping.add(vRMLNodeType);
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.vfSiteID = n2;
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            case 2: {
                this.vfApplicationID = n2;
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            case 4: {
                this.vfPort = n2;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.vfAddress = string;
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public int getSiteID() {
        return this.vfSiteID;
    }

    public int getAppID() {
        return this.vfApplicationID;
    }

    public int getEntityID() {
        return 0;
    }

    public String getAddress() {
        return this.vfAddress;
    }

    public int getPort() {
        return this.vfPort;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public String[] getAuthServer() {
        return null;
    }

    public String getMucServer() {
        return null;
    }

    public String getMucRoom() {
        return null;
    }

    public void setIsActive(boolean bl) {
    }

    public boolean valuesToWrite() {
        return false;
    }

    public ProtocolDataUnit getState() {
        return null;
    }

    public ProtocolDataUnitType getStateDX() {
        return null;
    }

    public void packetArrived(ProtocolDataUnit protocolDataUnit) {
    }

    public void packetArrived(ProtocolDataUnitType protocolDataUnitType) {
    }

    static {
        nodeFields = new int[]{0, 7};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(8);
        BaseDISEntityManager.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseDISEntityManager.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFInt32", "siteID");
        BaseDISEntityManager.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFString", "address");
        BaseDISEntityManager.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFInt32", "port");
        BaseDISEntityManager.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFInt32", "applicationID");
        BaseDISEntityManager.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFNode", "mapping");
        BaseDISEntityManager.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFNode", "addedEntities");
        BaseDISEntityManager.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFNode", "removedEntities");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("siteID", n);
        fieldMap.put("set_siteID", n);
        fieldMap.put("siteID_changed", n);
        n = new Integer(2);
        fieldMap.put("applicationID", n);
        fieldMap.put("set_applicationID", n);
        fieldMap.put("applicationID_changed", n);
        n = new Integer(3);
        fieldMap.put("address", n);
        fieldMap.put("set_address", n);
        fieldMap.put("address_changed", n);
        n = new Integer(4);
        fieldMap.put("port", n);
        fieldMap.put("set_port", n);
        fieldMap.put("port_changed", n);
        n = new Integer(7);
        fieldMap.put("mapping", n);
        fieldMap.put("set_mapping", n);
        fieldMap.put("mapping_changed", n);
        n = new Integer(5);
        fieldMap.put("addedEntities", n);
        fieldMap.put("addedEntities_changed", n);
        n = new Integer(6);
        fieldMap.put("removedEntities", n);
        fieldMap.put("removedEntities_changed", n);
    }
}

