// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAnariUnstructuredVolumeMapperNode
 * @brief   Unstructured grid volume renderer.
 *
 * Implements volume rendering that directly samples the unstructured grid using
 * ANARI.
 *
 * @par Thanks:
 * Kevin Griffin kgriffin@nvidia.com for creating and contributing the class
 * and NVIDIA for supporting this work.
 */

#ifndef vtkAnariUnstructuredVolumeMapperNode_h
#define vtkAnariUnstructuredVolumeMapperNode_h

#include "vtkRenderingAnariModule.h" // For export macro
#include "vtkVolumeMapperNode.h"

VTK_ABI_NAMESPACE_BEGIN

class vtkAnariVolumeInternals;

class VTKRENDERINGANARI_EXPORT vtkAnariUnstructuredVolumeMapperNode
  : public vtkVolumeMapperNode
{
public:
  vtkTypeMacro(vtkAnariUnstructuredVolumeMapperNode, vtkVolumeMapperNode);
  static vtkAnariUnstructuredVolumeMapperNode* New();
  void PrintSelf(ostream& os, vtkIndent indent) override;

   //@{
  /**
   * Convenience method to set/get color array size.
   */
  vtkSetMacro(ColorSize, int);
  vtkGetMacro(ColorSize, int);
  //@}

  //@{
  /**
   * Convenience method to set/get opacity array size.
   */
  vtkSetMacro(OpacitySize, int);
  vtkGetMacro(OpacitySize, int);
  //@}

  /**
   * Make ANARI calls to render.
   */
  void Render(bool prepass) override;

protected:
  vtkAnariUnstructuredVolumeMapperNode();
  ~vtkAnariUnstructuredVolumeMapperNode();

  int ColorSize;
  int OpacitySize;
  vtkAnariVolumeInternals* Internal;

private:
  vtkAnariUnstructuredVolumeMapperNode(const vtkAnariUnstructuredVolumeMapperNode&) = delete;
  void operator=(const vtkAnariUnstructuredVolumeMapperNode&) = delete;
};

VTK_ABI_NAMESPACE_END
#endif
