// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAnariAMRVolumeMapperNode
 * @brief   AMR volume renderer.
 *
 * Implements volume rendering that directly samples the VTK AMR data structure.
 *
 * @par Thanks:
 * Kevin Griffin kgriffin@nvidia.com for creating and contributing the class
 * and NVIDIA for supporting this work.
 */

#ifndef vtkAnariAMRVolumeMapperNode_h
#define vtkAnariAMRVolumeMapperNode_h

#include "vtkRenderingAnariModule.h" // For export macro
#include "vtkAnariVolumeMapperNode.h"

VTK_ABI_NAMESPACE_BEGIN

class vtkAnariAMRVolumeInternals;

class VTKRENDERINGANARI_EXPORT vtkAnariAMRVolumeMapperNode : public vtkAnariVolumeMapperNode
{
public:
  vtkTypeMacro(vtkAnariAMRVolumeMapperNode, vtkAnariVolumeMapperNode);
  static vtkAnariAMRVolumeMapperNode* New();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * Make ANARI calls to render.
   */
  void Render(bool prepass) override;

protected:
  vtkAnariAMRVolumeMapperNode();
  ~vtkAnariAMRVolumeMapperNode();

  vtkAnariAMRVolumeInternals* Internal;

private:
  vtkAnariAMRVolumeMapperNode(const vtkAnariAMRVolumeMapperNode&) = delete;
  void operator=(const vtkAnariAMRVolumeMapperNode&) = delete;
};

VTK_ABI_NAMESPACE_END
#endif
