/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkWindowToImageFilter.cxx
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Copyright (c) 1993-1995 Ken Martin, Will Schroeder,ill Lorensen.

This software is copyrighted by Ken Martin, Will Schroeder and Bill Lorensen.
The following terms apply to all files associated with the software unless
explicitly disclaimed in individual files. This copyright specifically does
not apply to the related textbook "The Visualization Toolkit" ISBN
013199837-4 published by Prentice Hall which is covered by its own copyright.

The authors hereby grant permission to use, copy, and distribute this
software and its documentation for any purpose, provided that existing
copyright notices are retained in all copies and that this notice is included
verbatim in any distributions. Additionally, the authors grant permission to
modify this software and its documentation for any purpose, provided that
such modifications are not distributed without the explicit consent of the
authors and that existing copyright notices are retained in all copies. Some
of the algorithms implemented by this software are patented, observe all
applicable patent law.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN
"AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

=========================================================================*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "vtkImageCache.h"
#include "vtkWindowToImageFilter.h"
#include "vtkWindow.h"

//----------------------------------------------------------------------------
vtkWindowToImageFilter::vtkWindowToImageFilter()
{
  this->Input = NULL;
}

//----------------------------------------------------------------------------
void vtkWindowToImageFilter::PrintSelf(ostream& os, vtkIndent indent)
{
  vtkImageSource::PrintSelf(os,indent);
  
  if ( this->Input )
    {
    os << indent << "Input:\n";
    this->Input->PrintSelf(os,indent.GetNextIndent());
    }
  else
    {
    os << indent << "Input: (none)\n";
    }
}


//----------------------------------------------------------------------------
// Description:
// This method returns the largest region that can be generated.
void vtkWindowToImageFilter::UpdateImageInformation()
{
  if (this->Input == NULL )
    {
    vtkErrorMacro(<<"Please specify a renderer as input!");
    return;
    }

  // Make sure we have an output.
  this->CheckCache();
    
  // set the extent, if the VOI has not been set then default to
  this->Output->SetWholeExtent(0, 
			       this->Input->GetSize()[0] - 1,
			       0, 
			       this->Input->GetSize()[1] - 1,
			       0, 0);
  
  // set the spacing
  this->Output->SetSpacing(1.0, 1.0, 1.0);
  
  // set the origin.
  this->Output->SetOrigin(0.0, 0.0, 0.0);
  
  // set the scalar components
  this->Output->SetNumberOfScalarComponents(3);
  this->Output->SetScalarType(VTK_UNSIGNED_CHAR);
}



//----------------------------------------------------------------------------
// Description:
// This function reads a region from a file.  The regions extent/axes
// are assumed to be the same as the file extent/order.
void vtkWindowToImageFilter::Execute(vtkImageData *data)
{
  int outExtent[6];
  int outIncr[3];
  int *size;
  unsigned char *pixels, *outPtr, *pixels1;
  int idxY, rowSize;
  
  if (this->Output->GetScalarType() != VTK_UNSIGNED_CHAR)
    {
    vtkErrorMacro("mismatch in scalar types!");
    return;
    }
  
  // Get the requested extents.
  this->Output->GetUpdateExtent(outExtent);
  data->GetIncrements(outIncr);
  rowSize = (outExtent[1] - outExtent[0] + 1)*3;
  
  // get the size of the render window
  size = this->Input->GetSize();

  pixels = this->Input->GetPixelData(0,0,size[0] - 1, size[1] - 1, 1); 
  pixels1 = pixels;
  
  outPtr = 
    (unsigned char *)data->GetScalarPointer(outExtent[0], outExtent[2],0);
  
  // Loop through ouput pixels
  for (idxY = outExtent[2]; idxY <= outExtent[3]; idxY++)
    {
    memcpy(outPtr,pixels1,rowSize);
    outPtr += outIncr[1];
    pixels1 = pixels1 + size[0]*3;
    }
  
  // free the memory
  delete [] pixels;
}



