/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestTreeLayoutView.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/*-------------------------------------------------------------------------
  Copyright 2008 Sandia Corporation.
  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
  the U.S. Government retains certain rights in this software.
-------------------------------------------------------------------------*/

#include "vtkCollection.h"
#include "vtkCommand.h"
#include "vtkDataRepresentation.h"
#include "vtkGraphLayoutView.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkSelectionLink.h"
#include "vtkStringToNumeric.h"
#include "vtkTestUtilities.h"
#include "vtkTreeLayoutView.h"
#include "vtkTreeMapView.h"
#include "vtkXMLTreeReader.h"

#include <vtksys/stl/vector>
using vtksys_stl::vector;

#include "vtkSmartPointer.h"
#define VTK_CREATE(type, name) \
  vtkSmartPointer<type> name = vtkSmartPointer<type>::New()

const char* xml =
"<a name=\"name a\">"
"  <b name=\"name b\" size=\"1\"/>"
"  <c name=\"name c\" size=\"1\"/>"
"  <d name=\"name d\" size=\"1\"/>"
"  <e name=\"name e\" size=\"1.1\"/>"
"  <f name=\"name f\" size=\"1.234\"/>"
"</a>";

const char* xml2 =
"<node1 name=\"name1\">"
"  <node2 name=\"name2\" size=\"1\">"
"    <node3 name=\"name3\" size=\"1\">"
"       <node4 name=\"name4\" size=\"1\"/>"
"    </node3>"
"  </node2>"
"</node1>";

class TestTreeLayoutViewUpdater : public vtkCommand
{
public:
  static TestTreeLayoutViewUpdater* New()
  { return new TestTreeLayoutViewUpdater; }
  
  void AddView(vtkView* view)
  {
    this->Views.push_back(view);
    view->AddObserver(vtkCommand::SelectionChangedEvent, this);
  }
  
  virtual void Execute(vtkObject*, unsigned long, void*)
  {
    for (unsigned int i = 0; i < this->Views.size(); i++)
      {
      this->Views[i]->Update();
      }
  }
private:
  TestTreeLayoutViewUpdater() { }  
  ~TestTreeLayoutViewUpdater() { }
  vector<vtkView*> Views;
};

char TreeLayoutViewEventLog[] =
"# StreamVersion 1\n"
"RenderEvent 0 0 0 0 0 0 0\n"
"EnterEvent 298 13 0 0 0 0 0\n"
"MouseMoveEvent 298 13 0 0 0 0 0\n"
"MouseMoveEvent 288 22 0 0 0 0 0\n"
"MouseMoveEvent 278 31 0 0 0 0 0\n"
"MouseMoveEvent 269 40 0 0 0 0 0\n"
"MouseMoveEvent 262 47 0 0 0 0 0\n"
"MouseMoveEvent 254 55 0 0 0 0 0\n"
"MouseMoveEvent 247 62 0 0 0 0 0\n"
"MouseMoveEvent 241 68 0 0 0 0 0\n"
"MouseMoveEvent 236 73 0 0 0 0 0\n"
"MouseMoveEvent 229 80 0 0 0 0 0\n"
"MouseMoveEvent 225 84 0 0 0 0 0\n"
"MouseMoveEvent 219 89 0 0 0 0 0\n"
"MouseMoveEvent 214 93 0 0 0 0 0\n"
"MouseMoveEvent 208 97 0 0 0 0 0\n"
"MouseMoveEvent 203 101 0 0 0 0 0\n"
"MouseMoveEvent 198 106 0 0 0 0 0\n"
"MouseMoveEvent 193 109 0 0 0 0 0\n"
"MouseMoveEvent 190 112 0 0 0 0 0\n"
"MouseMoveEvent 187 113 0 0 0 0 0\n"
"MouseMoveEvent 186 115 0 0 0 0 0\n"
"MouseMoveEvent 185 115 0 0 0 0 0\n"
"MouseMoveEvent 185 116 0 0 0 0 0\n"
"MouseMoveEvent 184 116 0 0 0 0 0\n"
"MouseMoveEvent 184 117 0 0 0 0 0\n"
"MouseMoveEvent 184 118 0 0 0 0 0\n"
"MouseMoveEvent 183 119 0 0 0 0 0\n"
"MouseMoveEvent 183 120 0 0 0 0 0\n"
"MouseMoveEvent 182 121 0 0 0 0 0\n"
"MouseMoveEvent 182 122 0 0 0 0 0\n"
"MouseMoveEvent 182 124 0 0 0 0 0\n"
"MouseMoveEvent 181 125 0 0 0 0 0\n"
"MouseMoveEvent 181 127 0 0 0 0 0\n"
"MouseMoveEvent 180 129 0 0 0 0 0\n"
"MouseMoveEvent 179 130 0 0 0 0 0\n"
"MouseMoveEvent 179 131 0 0 0 0 0\n"
"MouseMoveEvent 179 133 0 0 0 0 0\n"
"MouseMoveEvent 179 134 0 0 0 0 0\n"
"MiddleButtonPressEvent 179 134 0 0 0 0 0\n"
"StartInteractionEvent 179 134 0 0 0 0 0\n"
"MouseMoveEvent 178 134 0 0 0 0 0\n"
"RenderEvent 178 134 0 0 0 0 0\n"
"MouseMoveEvent 177 133 0 0 0 0 0\n"
"RenderEvent 177 133 0 0 0 0 0\n"
"MouseMoveEvent 174 130 0 0 0 0 0\n"
"RenderEvent 174 130 0 0 0 0 0\n"
"MouseMoveEvent 171 127 0 0 0 0 0\n"
"RenderEvent 171 127 0 0 0 0 0\n"
"MouseMoveEvent 168 122 0 0 0 0 0\n"
"RenderEvent 168 122 0 0 0 0 0\n"
"MouseMoveEvent 164 118 0 0 0 0 0\n"
"RenderEvent 164 118 0 0 0 0 0\n"
"MouseMoveEvent 162 115 0 0 0 0 0\n"
"RenderEvent 162 115 0 0 0 0 0\n"
"MouseMoveEvent 160 112 0 0 0 0 0\n"
"RenderEvent 160 112 0 0 0 0 0\n"
"MouseMoveEvent 158 110 0 0 0 0 0\n"
"RenderEvent 158 110 0 0 0 0 0\n"
"MouseMoveEvent 157 109 0 0 0 0 0\n"
"RenderEvent 157 109 0 0 0 0 0\n"
"MouseMoveEvent 157 108 0 0 0 0 0\n"
"RenderEvent 157 108 0 0 0 0 0\n"
"MouseMoveEvent 157 107 0 0 0 0 0\n"
"RenderEvent 157 107 0 0 0 0 0\n"
"MouseMoveEvent 156 106 0 0 0 0 0\n"
"RenderEvent 156 106 0 0 0 0 0\n"
"MouseMoveEvent 155 104 0 0 0 0 0\n"
"RenderEvent 155 104 0 0 0 0 0\n"
"MouseMoveEvent 155 102 0 0 0 0 0\n"
"RenderEvent 155 102 0 0 0 0 0\n"
"MouseMoveEvent 152 99 0 0 0 0 0\n"
"RenderEvent 152 99 0 0 0 0 0\n"
"MouseMoveEvent 152 98 0 0 0 0 0\n"
"RenderEvent 152 98 0 0 0 0 0\n"
"MouseMoveEvent 151 97 0 0 0 0 0\n"
"RenderEvent 151 97 0 0 0 0 0\n"
"MouseMoveEvent 150 94 0 0 0 0 0\n"
"RenderEvent 150 94 0 0 0 0 0\n"
"MouseMoveEvent 149 93 0 0 0 0 0\n"
"RenderEvent 149 93 0 0 0 0 0\n"
"MouseMoveEvent 148 92 0 0 0 0 0\n"
"RenderEvent 148 92 0 0 0 0 0\n"
"MouseMoveEvent 147 90 0 0 0 0 0\n"
"RenderEvent 147 90 0 0 0 0 0\n"
"MouseMoveEvent 146 89 0 0 0 0 0\n"
"RenderEvent 146 89 0 0 0 0 0\n"
"MouseMoveEvent 146 88 0 0 0 0 0\n"
"RenderEvent 146 88 0 0 0 0 0\n"
"MouseMoveEvent 145 86 0 0 0 0 0\n"
"RenderEvent 145 86 0 0 0 0 0\n"
"MouseMoveEvent 143 83 0 0 0 0 0\n"
"RenderEvent 143 83 0 0 0 0 0\n"
"MouseMoveEvent 143 82 0 0 0 0 0\n"
"RenderEvent 143 82 0 0 0 0 0\n"
"MouseMoveEvent 142 81 0 0 0 0 0\n"
"RenderEvent 142 81 0 0 0 0 0\n"
"MouseMoveEvent 141 79 0 0 0 0 0\n"
"RenderEvent 141 79 0 0 0 0 0\n"
"MouseMoveEvent 140 78 0 0 0 0 0\n"
"RenderEvent 140 78 0 0 0 0 0\n"
"MouseMoveEvent 141 79 0 0 0 0 0\n"
"RenderEvent 141 79 0 0 0 0 0\n"
"MouseMoveEvent 142 80 0 0 0 0 0\n"
"RenderEvent 142 80 0 0 0 0 0\n"
"MouseMoveEvent 143 82 0 0 0 0 0\n"
"RenderEvent 143 82 0 0 0 0 0\n"
"MouseMoveEvent 147 86 0 0 0 0 0\n"
"RenderEvent 147 86 0 0 0 0 0\n"
"MouseMoveEvent 148 90 0 0 0 0 0\n"
"RenderEvent 148 90 0 0 0 0 0\n"
"MouseMoveEvent 149 93 0 0 0 0 0\n"
"RenderEvent 149 93 0 0 0 0 0\n"
"MouseMoveEvent 150 97 0 0 0 0 0\n"
"RenderEvent 150 97 0 0 0 0 0\n"
"MouseMoveEvent 150 99 0 0 0 0 0\n"
"RenderEvent 150 99 0 0 0 0 0\n"
"MouseMoveEvent 150 101 0 0 0 0 0\n"
"RenderEvent 150 101 0 0 0 0 0\n"
"MouseMoveEvent 150 102 0 0 0 0 0\n"
"RenderEvent 150 102 0 0 0 0 0\n"
"MouseMoveEvent 151 105 0 0 0 0 0\n"
"RenderEvent 151 105 0 0 0 0 0\n"
"MouseMoveEvent 151 107 0 0 0 0 0\n"
"RenderEvent 151 107 0 0 0 0 0\n"
"MouseMoveEvent 151 108 0 0 0 0 0\n"
"RenderEvent 151 108 0 0 0 0 0\n"
"MouseMoveEvent 152 110 0 0 0 0 0\n"
"RenderEvent 152 110 0 0 0 0 0\n"
"MouseMoveEvent 152 112 0 0 0 0 0\n"
"RenderEvent 152 112 0 0 0 0 0\n"
"MouseMoveEvent 153 113 0 0 0 0 0\n"
"RenderEvent 153 113 0 0 0 0 0\n"
"MouseMoveEvent 154 116 0 0 0 0 0\n"
"RenderEvent 154 116 0 0 0 0 0\n"
"MouseMoveEvent 155 118 0 0 0 0 0\n"
"RenderEvent 155 118 0 0 0 0 0\n"
"MouseMoveEvent 157 121 0 0 0 0 0\n"
"RenderEvent 157 121 0 0 0 0 0\n"
"MouseMoveEvent 158 122 0 0 0 0 0\n"
"RenderEvent 158 122 0 0 0 0 0\n"
"MouseMoveEvent 159 123 0 0 0 0 0\n"
"RenderEvent 159 123 0 0 0 0 0\n"
"MouseMoveEvent 159 125 0 0 0 0 0\n"
"RenderEvent 159 125 0 0 0 0 0\n"
"MouseMoveEvent 162 128 0 0 0 0 0\n"
"RenderEvent 162 128 0 0 0 0 0\n"
"MouseMoveEvent 163 129 0 0 0 0 0\n"
"RenderEvent 163 129 0 0 0 0 0\n"
"MouseMoveEvent 165 133 0 0 0 0 0\n"
"RenderEvent 165 133 0 0 0 0 0\n"
"MouseMoveEvent 166 134 0 0 0 0 0\n"
"RenderEvent 166 134 0 0 0 0 0\n"
"MouseMoveEvent 166 135 0 0 0 0 0\n"
"RenderEvent 166 135 0 0 0 0 0\n"
"MouseMoveEvent 168 137 0 0 0 0 0\n"
"RenderEvent 168 137 0 0 0 0 0\n"
"MouseMoveEvent 168 139 0 0 0 0 0\n"
"RenderEvent 168 139 0 0 0 0 0\n"
"MouseMoveEvent 169 139 0 0 0 0 0\n"
"RenderEvent 169 139 0 0 0 0 0\n"
"MouseMoveEvent 169 140 0 0 0 0 0\n"
"RenderEvent 169 140 0 0 0 0 0\n"
"MiddleButtonReleaseEvent 169 140 0 0 0 0 0\n"
"EndInteractionEvent 169 140 0 0 0 0 0\n"
"MouseMoveEvent 169 140 0 0 0 0 0\n"
"RightButtonPressEvent 169 140 0 0 0 0 0\n"
"StartInteractionEvent 169 140 0 0 0 0 0\n"
"MouseMoveEvent 169 142 0 0 0 0 0\n"
"RenderEvent 169 142 0 0 0 0 0\n"
"MouseMoveEvent 169 143 0 0 0 0 0\n"
"RenderEvent 169 143 0 0 0 0 0\n"
"MouseMoveEvent 170 144 0 0 0 0 0\n"
"RenderEvent 170 144 0 0 0 0 0\n"
"MouseMoveEvent 170 148 0 0 0 0 0\n"
"RenderEvent 170 148 0 0 0 0 0\n"
"MouseMoveEvent 170 152 0 0 0 0 0\n"
"RenderEvent 170 152 0 0 0 0 0\n"
"MouseMoveEvent 170 154 0 0 0 0 0\n"
"RenderEvent 170 154 0 0 0 0 0\n"
"MouseMoveEvent 170 158 0 0 0 0 0\n"
"RenderEvent 170 158 0 0 0 0 0\n"
"MouseMoveEvent 170 161 0 0 0 0 0\n"
"RenderEvent 170 161 0 0 0 0 0\n"
"MouseMoveEvent 170 166 0 0 0 0 0\n"
"RenderEvent 170 166 0 0 0 0 0\n"
"MouseMoveEvent 170 168 0 0 0 0 0\n"
"RenderEvent 170 168 0 0 0 0 0\n"
"MouseMoveEvent 169 170 0 0 0 0 0\n"
"RenderEvent 169 170 0 0 0 0 0\n"
"MouseMoveEvent 169 174 0 0 0 0 0\n"
"RenderEvent 169 174 0 0 0 0 0\n"
"MouseMoveEvent 169 176 0 0 0 0 0\n"
"RenderEvent 169 176 0 0 0 0 0\n"
"MouseMoveEvent 169 180 0 0 0 0 0\n"
"RenderEvent 169 180 0 0 0 0 0\n"
"MouseMoveEvent 169 182 0 0 0 0 0\n"
"RenderEvent 169 182 0 0 0 0 0\n"
"MouseMoveEvent 169 183 0 0 0 0 0\n"
"RenderEvent 169 183 0 0 0 0 0\n"
"MouseMoveEvent 169 187 0 0 0 0 0\n"
"RenderEvent 169 187 0 0 0 0 0\n"
"MouseMoveEvent 169 188 0 0 0 0 0\n"
"RenderEvent 169 188 0 0 0 0 0\n"
"MouseMoveEvent 169 189 0 0 0 0 0\n"
"RenderEvent 169 189 0 0 0 0 0\n"
"MouseMoveEvent 169 190 0 0 0 0 0\n"
"RenderEvent 169 190 0 0 0 0 0\n"
"MouseMoveEvent 169 192 0 0 0 0 0\n"
"RenderEvent 169 192 0 0 0 0 0\n"
"MouseMoveEvent 169 193 0 0 0 0 0\n"
"RenderEvent 169 193 0 0 0 0 0\n"
"MouseMoveEvent 169 195 0 0 0 0 0\n"
"RenderEvent 169 195 0 0 0 0 0\n"
"MouseMoveEvent 169 199 0 0 0 0 0\n"
"RenderEvent 169 199 0 0 0 0 0\n"
"MouseMoveEvent 169 202 0 0 0 0 0\n"
"RenderEvent 169 202 0 0 0 0 0\n"
"MouseMoveEvent 169 204 0 0 0 0 0\n"
"RenderEvent 169 204 0 0 0 0 0\n"
"MouseMoveEvent 169 209 0 0 0 0 0\n"
"RenderEvent 169 209 0 0 0 0 0\n"
"MouseMoveEvent 169 211 0 0 0 0 0\n"
"RenderEvent 169 211 0 0 0 0 0\n"
"MouseMoveEvent 168 214 0 0 0 0 0\n"
"RenderEvent 168 214 0 0 0 0 0\n"
"MouseMoveEvent 168 216 0 0 0 0 0\n"
"RenderEvent 168 216 0 0 0 0 0\n"
"MouseMoveEvent 168 219 0 0 0 0 0\n"
"RenderEvent 168 219 0 0 0 0 0\n"
"MouseMoveEvent 168 221 0 0 0 0 0\n"
"RenderEvent 168 221 0 0 0 0 0\n"
"MouseMoveEvent 168 223 0 0 0 0 0\n"
"RenderEvent 168 223 0 0 0 0 0\n"
"MouseMoveEvent 168 225 0 0 0 0 0\n"
"RenderEvent 168 225 0 0 0 0 0\n"
"MouseMoveEvent 168 226 0 0 0 0 0\n"
"RenderEvent 168 226 0 0 0 0 0\n"
"MouseMoveEvent 168 227 0 0 0 0 0\n"
"RenderEvent 168 227 0 0 0 0 0\n"
"MouseMoveEvent 168 229 0 0 0 0 0\n"
"RenderEvent 168 229 0 0 0 0 0\n"
"MouseMoveEvent 168 231 0 0 0 0 0\n"
"RenderEvent 168 231 0 0 0 0 0\n"
"MouseMoveEvent 168 234 0 0 0 0 0\n"
"RenderEvent 168 234 0 0 0 0 0\n"
"MouseMoveEvent 168 236 0 0 0 0 0\n"
"RenderEvent 168 236 0 0 0 0 0\n"
"MouseMoveEvent 168 238 0 0 0 0 0\n"
"RenderEvent 168 238 0 0 0 0 0\n"
"MouseMoveEvent 168 240 0 0 0 0 0\n"
"RenderEvent 168 240 0 0 0 0 0\n"
"MouseMoveEvent 168 242 0 0 0 0 0\n"
"RenderEvent 168 242 0 0 0 0 0\n"
"MouseMoveEvent 168 244 0 0 0 0 0\n"
"RenderEvent 168 244 0 0 0 0 0\n"
"MouseMoveEvent 168 246 0 0 0 0 0\n"
"RenderEvent 168 246 0 0 0 0 0\n"
"MouseMoveEvent 167 247 0 0 0 0 0\n"
"RenderEvent 167 247 0 0 0 0 0\n"
"MouseMoveEvent 167 248 0 0 0 0 0\n"
"RenderEvent 167 248 0 0 0 0 0\n"
"MouseMoveEvent 167 247 0 0 0 0 0\n"
"RenderEvent 167 247 0 0 0 0 0\n"
"MouseMoveEvent 166 247 0 0 0 0 0\n"
"RenderEvent 166 247 0 0 0 0 0\n"
"MouseMoveEvent 166 246 0 0 0 0 0\n"
"RenderEvent 166 246 0 0 0 0 0\n"
"MouseMoveEvent 166 244 0 0 0 0 0\n"
"RenderEvent 166 244 0 0 0 0 0\n"
"MouseMoveEvent 165 244 0 0 0 0 0\n"
"RenderEvent 165 244 0 0 0 0 0\n"
"MouseMoveEvent 165 242 0 0 0 0 0\n"
"RenderEvent 165 242 0 0 0 0 0\n"
"MouseMoveEvent 165 241 0 0 0 0 0\n"
"RenderEvent 165 241 0 0 0 0 0\n"
"MouseMoveEvent 165 240 0 0 0 0 0\n"
"RenderEvent 165 240 0 0 0 0 0\n"
"MouseMoveEvent 165 239 0 0 0 0 0\n"
"RenderEvent 165 239 0 0 0 0 0\n"
"MouseMoveEvent 164 238 0 0 0 0 0\n"
"RenderEvent 164 238 0 0 0 0 0\n"
"MouseMoveEvent 164 237 0 0 0 0 0\n"
"RenderEvent 164 237 0 0 0 0 0\n"
"MouseMoveEvent 164 236 0 0 0 0 0\n"
"RenderEvent 164 236 0 0 0 0 0\n"
"MouseMoveEvent 164 234 0 0 0 0 0\n"
"RenderEvent 164 234 0 0 0 0 0\n"
"MouseMoveEvent 164 233 0 0 0 0 0\n"
"RenderEvent 164 233 0 0 0 0 0\n"
"MouseMoveEvent 163 232 0 0 0 0 0\n"
"RenderEvent 163 232 0 0 0 0 0\n"
"MouseMoveEvent 163 231 0 0 0 0 0\n"
"RenderEvent 163 231 0 0 0 0 0\n"
"MouseMoveEvent 163 230 0 0 0 0 0\n"
"RenderEvent 163 230 0 0 0 0 0\n"
"MouseMoveEvent 163 229 0 0 0 0 0\n"
"RenderEvent 163 229 0 0 0 0 0\n"
"MouseMoveEvent 163 228 0 0 0 0 0\n"
"RenderEvent 163 228 0 0 0 0 0\n"
"MouseMoveEvent 163 227 0 0 0 0 0\n"
"RenderEvent 163 227 0 0 0 0 0\n"
"MouseMoveEvent 162 226 0 0 0 0 0\n"
"RenderEvent 162 226 0 0 0 0 0\n"
"MouseMoveEvent 162 225 0 0 0 0 0\n"
"RenderEvent 162 225 0 0 0 0 0\n"
"MouseMoveEvent 162 224 0 0 0 0 0\n"
"RenderEvent 162 224 0 0 0 0 0\n"
"MouseMoveEvent 162 223 0 0 0 0 0\n"
"RenderEvent 162 223 0 0 0 0 0\n"
"MouseMoveEvent 162 222 0 0 0 0 0\n"
"RenderEvent 162 222 0 0 0 0 0\n"
"MouseMoveEvent 161 221 0 0 0 0 0\n"
"RenderEvent 161 221 0 0 0 0 0\n"
"MouseMoveEvent 161 219 0 0 0 0 0\n"
"RenderEvent 161 219 0 0 0 0 0\n"
"MouseMoveEvent 161 218 0 0 0 0 0\n"
"RenderEvent 161 218 0 0 0 0 0\n"
"MouseMoveEvent 161 217 0 0 0 0 0\n"
"RenderEvent 161 217 0 0 0 0 0\n"
"MouseMoveEvent 161 216 0 0 0 0 0\n"
"RenderEvent 161 216 0 0 0 0 0\n"
"MouseMoveEvent 161 214 0 0 0 0 0\n"
"RenderEvent 161 214 0 0 0 0 0\n"
"MouseMoveEvent 160 212 0 0 0 0 0\n"
"RenderEvent 160 212 0 0 0 0 0\n"
"MouseMoveEvent 160 211 0 0 0 0 0\n"
"RenderEvent 160 211 0 0 0 0 0\n"
"MouseMoveEvent 160 209 0 0 0 0 0\n"
"RenderEvent 160 209 0 0 0 0 0\n"
"MouseMoveEvent 160 206 0 0 0 0 0\n"
"RenderEvent 160 206 0 0 0 0 0\n"
"MouseMoveEvent 159 205 0 0 0 0 0\n"
"RenderEvent 159 205 0 0 0 0 0\n"
"MouseMoveEvent 159 203 0 0 0 0 0\n"
"RenderEvent 159 203 0 0 0 0 0\n"
"MouseMoveEvent 159 199 0 0 0 0 0\n"
"RenderEvent 159 199 0 0 0 0 0\n"
"MouseMoveEvent 158 198 0 0 0 0 0\n"
"RenderEvent 158 198 0 0 0 0 0\n"
"MouseMoveEvent 158 197 0 0 0 0 0\n"
"RenderEvent 158 197 0 0 0 0 0\n"
"MouseMoveEvent 157 194 0 0 0 0 0\n"
"RenderEvent 157 194 0 0 0 0 0\n"
"MouseMoveEvent 157 193 0 0 0 0 0\n"
"RenderEvent 157 193 0 0 0 0 0\n"
"MouseMoveEvent 157 191 0 0 0 0 0\n"
"RenderEvent 157 191 0 0 0 0 0\n"
"MouseMoveEvent 157 188 0 0 0 0 0\n"
"RenderEvent 157 188 0 0 0 0 0\n"
"MouseMoveEvent 156 186 0 0 0 0 0\n"
"RenderEvent 156 186 0 0 0 0 0\n"
"MouseMoveEvent 156 183 0 0 0 0 0\n"
"RenderEvent 156 183 0 0 0 0 0\n"
"MouseMoveEvent 155 179 0 0 0 0 0\n"
"RenderEvent 155 179 0 0 0 0 0\n"
"MouseMoveEvent 154 177 0 0 0 0 0\n"
"RenderEvent 154 177 0 0 0 0 0\n"
"MouseMoveEvent 154 175 0 0 0 0 0\n"
"RenderEvent 154 175 0 0 0 0 0\n"
"MouseMoveEvent 154 173 0 0 0 0 0\n"
"RenderEvent 154 173 0 0 0 0 0\n"
"MouseMoveEvent 154 171 0 0 0 0 0\n"
"RenderEvent 154 171 0 0 0 0 0\n"
"MouseMoveEvent 153 169 0 0 0 0 0\n"
"RenderEvent 153 169 0 0 0 0 0\n"
"MouseMoveEvent 153 167 0 0 0 0 0\n"
"RenderEvent 153 167 0 0 0 0 0\n"
"MouseMoveEvent 153 166 0 0 0 0 0\n"
"RenderEvent 153 166 0 0 0 0 0\n"
"MouseMoveEvent 153 164 0 0 0 0 0\n"
"RenderEvent 153 164 0 0 0 0 0\n"
"MouseMoveEvent 152 164 0 0 0 0 0\n"
"RenderEvent 152 164 0 0 0 0 0\n"
"MouseMoveEvent 152 163 0 0 0 0 0\n"
"RenderEvent 152 163 0 0 0 0 0\n"
"MouseMoveEvent 152 162 0 0 0 0 0\n"
"RenderEvent 152 162 0 0 0 0 0\n"
"MouseMoveEvent 152 161 0 0 0 0 0\n"
"RenderEvent 152 161 0 0 0 0 0\n"
"MouseMoveEvent 151 159 0 0 0 0 0\n"
"RenderEvent 151 159 0 0 0 0 0\n"
"MouseMoveEvent 151 157 0 0 0 0 0\n"
"RenderEvent 151 157 0 0 0 0 0\n"
"MouseMoveEvent 150 155 0 0 0 0 0\n"
"RenderEvent 150 155 0 0 0 0 0\n"
"MouseMoveEvent 150 153 0 0 0 0 0\n"
"RenderEvent 150 153 0 0 0 0 0\n"
"MouseMoveEvent 149 151 0 0 0 0 0\n"
"RenderEvent 149 151 0 0 0 0 0\n"
"MouseMoveEvent 149 150 0 0 0 0 0\n"
"RenderEvent 149 150 0 0 0 0 0\n"
"MouseMoveEvent 149 149 0 0 0 0 0\n"
"RenderEvent 149 149 0 0 0 0 0\n"
"MouseMoveEvent 148 149 0 0 0 0 0\n"
"RenderEvent 148 149 0 0 0 0 0\n"
"MouseMoveEvent 147 148 0 0 0 0 0\n"
"RenderEvent 147 148 0 0 0 0 0\n"
"MouseMoveEvent 147 147 0 0 0 0 0\n"
"RenderEvent 147 147 0 0 0 0 0\n"
"MouseMoveEvent 146 147 0 0 0 0 0\n"
"RenderEvent 146 147 0 0 0 0 0\n"
"RightButtonReleaseEvent 146 147 0 0 0 0 0\n"
"EndInteractionEvent 146 147 0 0 0 0 0\n"
"MouseMoveEvent 146 147 0 0 0 0 0\n"
"MouseMoveEvent 146 149 0 0 0 0 0\n"
"MouseMoveEvent 146 150 0 0 0 0 0\n"
"MouseMoveEvent 146 151 0 0 0 0 0\n"
"MouseMoveEvent 146 152 0 0 0 0 0\n"
"MouseMoveEvent 147 153 0 0 0 0 0\n"
"MouseMoveEvent 147 155 0 0 0 0 0\n"
"MouseMoveEvent 147 156 0 0 0 0 0\n"
"MouseMoveEvent 147 157 0 0 0 0 0\n"
"MouseMoveEvent 147 158 0 0 0 0 0\n"
"MouseMoveEvent 147 160 0 0 0 0 0\n"
"MouseMoveEvent 147 161 0 0 0 0 0\n"
"MouseMoveEvent 147 162 0 0 0 0 0\n"
"MouseMoveEvent 147 163 0 0 0 0 0\n"
"MouseMoveEvent 147 164 0 0 0 0 0\n"
"MouseMoveEvent 147 165 0 0 0 0 0\n"
"MouseMoveEvent 146 167 0 0 0 0 0\n"
"MouseMoveEvent 145 167 0 0 0 0 0\n"
"MouseMoveEvent 144 168 0 0 0 0 0\n"
"MouseMoveEvent 142 170 0 0 0 0 0\n"
"MouseMoveEvent 140 171 0 0 0 0 0\n"
"MouseMoveEvent 138 173 0 0 0 0 0\n"
"MouseMoveEvent 136 174 0 0 0 0 0\n"
"MouseMoveEvent 134 176 0 0 0 0 0\n"
"MouseMoveEvent 132 178 0 0 0 0 0\n"
"MouseMoveEvent 130 180 0 0 0 0 0\n"
"MouseMoveEvent 128 182 0 0 0 0 0\n"
"MouseMoveEvent 127 183 0 0 0 0 0\n"
"MouseMoveEvent 126 185 0 0 0 0 0\n"
"MouseMoveEvent 126 186 0 0 0 0 0\n"
"MouseMoveEvent 126 187 0 0 0 0 0\n"
"MouseMoveEvent 126 188 0 0 0 0 0\n"
"MouseMoveEvent 126 190 0 0 0 0 0\n"
"MouseMoveEvent 126 191 0 0 0 0 0\n"
"MouseMoveEvent 125 192 0 0 0 0 0\n"
"MouseMoveEvent 123 194 0 0 0 0 0\n"
"MouseMoveEvent 123 195 0 0 0 0 0\n"
"MouseMoveEvent 121 196 0 0 0 0 0\n"
"MouseMoveEvent 120 198 0 0 0 0 0\n"
"MouseMoveEvent 120 199 0 0 0 0 0\n"
"MouseMoveEvent 118 201 0 0 0 0 0\n"
"MouseMoveEvent 118 202 0 0 0 0 0\n"
"MouseMoveEvent 117 204 0 0 0 0 0\n"
"MouseMoveEvent 115 206 0 0 0 0 0\n"
"MouseMoveEvent 115 207 0 0 0 0 0\n"
"MouseMoveEvent 114 208 0 0 0 0 0\n"
"MouseMoveEvent 113 210 0 0 0 0 0\n"
"MouseMoveEvent 112 211 0 0 0 0 0\n"
"MouseMoveEvent 110 213 0 0 0 0 0\n"
"MouseMoveEvent 110 215 0 0 0 0 0\n"
"MouseMoveEvent 110 216 0 0 0 0 0\n"
"MouseMoveEvent 109 217 0 0 0 0 0\n"
"MouseMoveEvent 108 220 0 0 0 0 0\n"
"MouseMoveEvent 108 221 0 0 0 0 0\n"
"MouseMoveEvent 107 223 0 0 0 0 0\n"
"MouseMoveEvent 107 224 0 0 0 0 0\n"
"MouseMoveEvent 106 227 0 0 0 0 0\n"
"MouseMoveEvent 104 228 0 0 0 0 0\n"
"MouseMoveEvent 104 230 0 0 0 0 0\n"
"MouseMoveEvent 103 232 0 0 0 0 0\n"
"MouseMoveEvent 101 234 0 0 0 0 0\n"
"MouseMoveEvent 101 236 0 0 0 0 0\n"
"MouseMoveEvent 100 237 0 0 0 0 0\n"
"MouseMoveEvent 99 240 0 0 0 0 0\n"
"MouseMoveEvent 98 242 0 0 0 0 0\n"
"MouseMoveEvent 96 243 0 0 0 0 0\n"
"MouseMoveEvent 96 245 0 0 0 0 0\n"
"MouseMoveEvent 95 248 0 0 0 0 0\n"
"MouseMoveEvent 93 250 0 0 0 0 0\n"
"MouseMoveEvent 93 251 0 0 0 0 0\n"
"MouseMoveEvent 92 253 0 0 0 0 0\n"
"MouseMoveEvent 91 254 0 0 0 0 0\n"
"MouseMoveEvent 90 255 0 0 0 0 0\n"
"MouseMoveEvent 89 256 0 0 0 0 0\n"
"MouseMoveEvent 88 258 0 0 0 0 0\n"
"MouseMoveEvent 88 259 0 0 0 0 0\n"
"MouseMoveEvent 87 260 0 0 0 0 0\n"
"MouseMoveEvent 87 261 0 0 0 0 0\n"
"MouseMoveEvent 87 262 0 0 0 0 0\n"
"MouseMoveEvent 87 263 0 0 0 0 0\n"
"LeftButtonPressEvent 87 263 0 0 0 0 0\n"
"StartInteractionEvent 87 263 0 0 0 0 0\n"
"MouseMoveEvent 88 263 0 0 0 0 0\n"
"MouseMoveEvent 90 261 0 0 0 0 0\n"
"MouseMoveEvent 93 260 0 0 0 0 0\n"
"MouseMoveEvent 96 258 0 0 0 0 0\n"
"MouseMoveEvent 101 256 0 0 0 0 0\n"
"MouseMoveEvent 106 254 0 0 0 0 0\n"
"MouseMoveEvent 113 250 0 0 0 0 0\n"
"MouseMoveEvent 119 249 0 0 0 0 0\n"
"MouseMoveEvent 124 246 0 0 0 0 0\n"
"MouseMoveEvent 130 243 0 0 0 0 0\n"
"MouseMoveEvent 135 241 0 0 0 0 0\n"
"MouseMoveEvent 138 238 0 0 0 0 0\n"
"MouseMoveEvent 143 236 0 0 0 0 0\n"
"MouseMoveEvent 145 236 0 0 0 0 0\n"
"MouseMoveEvent 148 234 0 0 0 0 0\n"
"MouseMoveEvent 151 233 0 0 0 0 0\n"
"MouseMoveEvent 154 231 0 0 0 0 0\n"
"MouseMoveEvent 157 229 0 0 0 0 0\n"
"MouseMoveEvent 159 227 0 0 0 0 0\n"
"MouseMoveEvent 163 225 0 0 0 0 0\n"
"MouseMoveEvent 165 223 0 0 0 0 0\n"
"MouseMoveEvent 167 222 0 0 0 0 0\n"
"MouseMoveEvent 169 220 0 0 0 0 0\n"
"MouseMoveEvent 171 219 0 0 0 0 0\n"
"MouseMoveEvent 173 217 0 0 0 0 0\n"
"MouseMoveEvent 175 216 0 0 0 0 0\n"
"MouseMoveEvent 179 214 0 0 0 0 0\n"
"MouseMoveEvent 182 211 0 0 0 0 0\n"
"MouseMoveEvent 185 209 0 0 0 0 0\n"
"MouseMoveEvent 189 206 0 0 0 0 0\n"
"MouseMoveEvent 194 203 0 0 0 0 0\n"
"MouseMoveEvent 197 202 0 0 0 0 0\n"
"MouseMoveEvent 200 200 0 0 0 0 0\n"
"MouseMoveEvent 202 199 0 0 0 0 0\n"
"MouseMoveEvent 205 197 0 0 0 0 0\n"
"MouseMoveEvent 207 196 0 0 0 0 0\n"
"MouseMoveEvent 208 194 0 0 0 0 0\n"
"MouseMoveEvent 210 194 0 0 0 0 0\n"
"MouseMoveEvent 210 193 0 0 0 0 0\n"
"MouseMoveEvent 211 193 0 0 0 0 0\n"
"MouseMoveEvent 211 192 0 0 0 0 0\n"
"LeftButtonReleaseEvent 211 192 0 0 0 0 0\n"
"EndInteractionEvent 211 192 0 0 0 0 0\n"
"MouseMoveEvent 211 191 0 0 0 0 0\n"
"MouseMoveEvent 210 190 0 0 0 0 0\n"
"MouseMoveEvent 209 189 0 0 0 0 0\n"
"MouseMoveEvent 208 188 0 0 0 0 0\n"
"MouseMoveEvent 208 187 0 0 0 0 0\n"
"MouseMoveEvent 207 186 0 0 0 0 0\n"
"MouseMoveEvent 206 184 0 0 0 0 0\n"
"MouseMoveEvent 205 183 0 0 0 0 0\n"
"MouseMoveEvent 203 182 0 0 0 0 0\n"
"MouseMoveEvent 203 180 0 0 0 0 0\n"
"MouseMoveEvent 201 179 0 0 0 0 0\n"
"MouseMoveEvent 200 176 0 0 0 0 0\n"
"MouseMoveEvent 198 175 0 0 0 0 0\n"
"MouseMoveEvent 196 174 0 0 0 0 0\n"
"MouseMoveEvent 195 172 0 0 0 0 0\n"
"MouseMoveEvent 193 171 0 0 0 0 0\n"
"MouseMoveEvent 191 169 0 0 0 0 0\n"
"MouseMoveEvent 190 168 0 0 0 0 0\n"
"MouseMoveEvent 187 166 0 0 0 0 0\n"
"MouseMoveEvent 185 164 0 0 0 0 0\n"
"MouseMoveEvent 183 163 0 0 0 0 0\n"
"MouseMoveEvent 181 161 0 0 0 0 0\n"
"MouseMoveEvent 178 160 0 0 0 0 0\n"
"MouseMoveEvent 176 159 0 0 0 0 0\n"
"MouseMoveEvent 173 159 0 0 0 0 0\n"
"MouseMoveEvent 171 158 0 0 0 0 0\n"
"MouseMoveEvent 170 158 0 0 0 0 0\n"
"MouseMoveEvent 168 158 0 0 0 0 0\n"
"MouseMoveEvent 167 158 0 0 0 0 0\n"
"MouseMoveEvent 166 158 0 0 0 0 0\n"
"MouseMoveEvent 164 158 0 0 0 0 0\n"
"MouseMoveEvent 163 158 0 0 0 0 0\n"
"MouseMoveEvent 161 158 0 0 0 0 0\n"
"MouseMoveEvent 159 159 0 0 0 0 0\n"
"MouseMoveEvent 157 161 0 0 0 0 0\n"
"MouseMoveEvent 154 162 0 0 0 0 0\n"
"MouseMoveEvent 150 165 0 0 0 0 0\n"
"MouseMoveEvent 147 168 0 0 0 0 0\n"
"MouseMoveEvent 143 170 0 0 0 0 0\n"
"MouseMoveEvent 140 172 0 0 0 0 0\n"
"MouseMoveEvent 137 173 0 0 0 0 0\n"
"MouseMoveEvent 135 174 0 0 0 0 0\n"
"MouseMoveEvent 131 175 0 0 0 0 0\n"
"MouseMoveEvent 129 176 0 0 0 0 0\n"
"MouseMoveEvent 128 176 0 0 0 0 0\n"
"MouseMoveEvent 127 176 0 0 0 0 0\n"
"MouseMoveEvent 126 176 0 0 0 0 0\n"
"MouseMoveEvent 124 176 0 0 0 0 0\n"
"MouseMoveEvent 123 176 0 0 0 0 0\n"
"MouseMoveEvent 123 175 0 0 0 0 0\n"
"MouseMoveEvent 122 175 0 0 0 0 0\n"
"MouseMoveEvent 122 174 0 0 0 0 0\n"
"MouseMoveEvent 121 174 0 0 0 0 0\n"
"MouseMoveEvent 120 172 0 0 0 0 0\n"
"MouseMoveEvent 120 171 0 0 0 0 0\n"
"LeftButtonPressEvent 120 171 0 0 0 0 0\n"
"StartInteractionEvent 120 171 0 0 0 0 0\n"
"MouseMoveEvent 119 170 0 0 0 0 0\n"
"MouseMoveEvent 118 168 0 0 0 0 0\n"
"MouseMoveEvent 118 167 0 0 0 0 0\n"
"MouseMoveEvent 117 166 0 0 0 0 0\n"
"MouseMoveEvent 116 163 0 0 0 0 0\n"
"MouseMoveEvent 116 162 0 0 0 0 0\n"
"MouseMoveEvent 116 160 0 0 0 0 0\n"
"MouseMoveEvent 116 157 0 0 0 0 0\n"
"MouseMoveEvent 116 153 0 0 0 0 0\n"
"MouseMoveEvent 117 147 0 0 0 0 0\n"
"MouseMoveEvent 119 140 0 0 0 0 0\n"
"MouseMoveEvent 121 133 0 0 0 0 0\n"
"MouseMoveEvent 123 125 0 0 0 0 0\n"
"MouseMoveEvent 127 115 0 0 0 0 0\n"
"MouseMoveEvent 131 107 0 0 0 0 0\n"
"MouseMoveEvent 134 100 0 0 0 0 0\n"
"MouseMoveEvent 138 92 0 0 0 0 0\n"
"MouseMoveEvent 142 88 0 0 0 0 0\n"
"MouseMoveEvent 146 83 0 0 0 0 0\n"
"MouseMoveEvent 150 78 0 0 0 0 0\n"
"MouseMoveEvent 154 73 0 0 0 0 0\n"
"MouseMoveEvent 158 69 0 0 0 0 0\n"
"MouseMoveEvent 162 65 0 0 0 0 0\n"
"MouseMoveEvent 167 60 0 0 0 0 0\n"
"MouseMoveEvent 172 55 0 0 0 0 0\n"
"MouseMoveEvent 176 50 0 0 0 0 0\n"
"MouseMoveEvent 180 44 0 0 0 0 0\n"
"MouseMoveEvent 183 39 0 0 0 0 0\n"
"MouseMoveEvent 186 35 0 0 0 0 0\n"
"MouseMoveEvent 189 31 0 0 0 0 0\n"
"MouseMoveEvent 190 29 0 0 0 0 0\n"
"MouseMoveEvent 193 27 0 0 0 0 0\n"
"MouseMoveEvent 193 26 0 0 0 0 0\n"
"MouseMoveEvent 194 25 0 0 0 0 0\n"
"MouseMoveEvent 195 25 0 0 0 0 0\n"
"MouseMoveEvent 196 25 0 0 0 0 0\n"
"MouseMoveEvent 198 25 0 0 0 0 0\n"
"MouseMoveEvent 199 25 0 0 0 0 0\n"
"MouseMoveEvent 201 25 0 0 0 0 0\n"
"MouseMoveEvent 202 25 0 0 0 0 0\n"
"MouseMoveEvent 203 25 0 0 0 0 0\n"
"MouseMoveEvent 204 25 0 0 0 0 0\n"
"LeftButtonReleaseEvent 204 25 0 0 0 0 0\n"
"EndInteractionEvent 204 25 0 0 0 0 0\n"
"MouseMoveEvent 204 25 0 0 0 0 0\n"
"MouseMoveEvent 202 26 0 0 0 0 0\n"
"MouseMoveEvent 201 28 0 0 0 0 0\n"
"MouseMoveEvent 199 28 0 0 0 0 0\n"
"MouseMoveEvent 197 31 0 0 0 0 0\n"
"MouseMoveEvent 194 32 0 0 0 0 0\n"
"MouseMoveEvent 190 36 0 0 0 0 0\n"
"MouseMoveEvent 185 40 0 0 0 0 0\n"
"MouseMoveEvent 179 46 0 0 0 0 0\n"
"MouseMoveEvent 173 52 0 0 0 0 0\n"
"MouseMoveEvent 166 58 0 0 0 0 0\n"
"MouseMoveEvent 159 65 0 0 0 0 0\n"
"MouseMoveEvent 153 70 0 0 0 0 0\n"
"MouseMoveEvent 147 76 0 0 0 0 0\n"
"MouseMoveEvent 142 81 0 0 0 0 0\n"
"MouseMoveEvent 137 87 0 0 0 0 0\n"
"MouseMoveEvent 134 92 0 0 0 0 0\n"
"MouseMoveEvent 131 98 0 0 0 0 0\n"
"MouseMoveEvent 129 102 0 0 0 0 0\n"
"MouseMoveEvent 128 108 0 0 0 0 0\n"
"MouseMoveEvent 126 114 0 0 0 0 0\n"
"MouseMoveEvent 124 119 0 0 0 0 0\n"
"MouseMoveEvent 121 127 0 0 0 0 0\n"
"MouseMoveEvent 117 135 0 0 0 0 0\n"
"MouseMoveEvent 113 143 0 0 0 0 0\n"
"MouseMoveEvent 108 152 0 0 0 0 0\n"
"MouseMoveEvent 101 162 0 0 0 0 0\n"
"MouseMoveEvent 92 171 0 0 0 0 0\n"
"MouseMoveEvent 85 178 0 0 0 0 0\n"
"MouseMoveEvent 78 184 0 0 0 0 0\n"
"MouseMoveEvent 73 187 0 0 0 0 0\n"
"MouseMoveEvent 68 190 0 0 0 0 0\n"
"MouseMoveEvent 63 194 0 0 0 0 0\n"
"MouseMoveEvent 59 197 0 0 0 0 0\n"
"MouseMoveEvent 54 201 0 0 0 0 0\n"
"MouseMoveEvent 49 205 0 0 0 0 0\n"
"MouseMoveEvent 46 207 0 0 0 0 0\n"
"MouseMoveEvent 43 209 0 0 0 0 0\n"
"MouseMoveEvent 42 212 0 0 0 0 0\n"
"MouseMoveEvent 42 215 0 0 0 0 0\n"
"MouseMoveEvent 41 217 0 0 0 0 0\n"
"MouseMoveEvent 40 220 0 0 0 0 0\n"
"MouseMoveEvent 40 222 0 0 0 0 0\n"
"MouseMoveEvent 40 225 0 0 0 0 0\n"
"MouseMoveEvent 40 227 0 0 0 0 0\n"
"MouseMoveEvent 40 230 0 0 0 0 0\n"
"MouseMoveEvent 40 232 0 0 0 0 0\n"
"MouseMoveEvent 40 235 0 0 0 0 0\n"
"MouseMoveEvent 40 238 0 0 0 0 0\n"
"MouseMoveEvent 40 239 0 0 0 0 0\n"
"MouseMoveEvent 39 240 0 0 0 0 0\n"
"MouseMoveEvent 38 242 0 0 0 0 0\n"
"MouseMoveEvent 37 243 0 0 0 0 0\n"
"MouseMoveEvent 36 243 0 0 0 0 0\n"
"MouseMoveEvent 36 244 0 0 0 0 0\n"
"MouseMoveEvent 35 244 0 0 0 0 0\n"
"MouseMoveEvent 35 246 0 0 0 0 0\n"
"MouseMoveEvent 34 247 0 0 0 0 0\n"
"MouseMoveEvent 34 248 0 0 0 0 0\n"
"MouseMoveEvent 33 249 0 0 0 0 0\n"
"MouseMoveEvent 33 250 0 0 0 0 0\n"
"MouseMoveEvent 33 251 0 0 0 0 0\n"
"LeftButtonPressEvent 33 251 0 0 0 0 0\n"
"StartInteractionEvent 33 251 0 0 0 0 0\n"
"MouseMoveEvent 32 251 0 0 0 0 0\n"
"MouseMoveEvent 31 251 0 0 0 0 0\n"
"MouseMoveEvent 30 250 0 0 0 0 0\n"
"MouseMoveEvent 30 248 0 0 0 0 0\n"
"MouseMoveEvent 30 245 0 0 0 0 0\n"
"MouseMoveEvent 30 241 0 0 0 0 0\n"
"MouseMoveEvent 30 238 0 0 0 0 0\n"
"MouseMoveEvent 31 233 0 0 0 0 0\n"
"MouseMoveEvent 33 227 0 0 0 0 0\n"
"MouseMoveEvent 36 220 0 0 0 0 0\n"
"MouseMoveEvent 40 213 0 0 0 0 0\n"
"MouseMoveEvent 44 205 0 0 0 0 0\n"
"MouseMoveEvent 50 198 0 0 0 0 0\n"
"MouseMoveEvent 55 192 0 0 0 0 0\n"
"MouseMoveEvent 60 186 0 0 0 0 0\n"
"MouseMoveEvent 66 181 0 0 0 0 0\n"
"MouseMoveEvent 71 174 0 0 0 0 0\n"
"MouseMoveEvent 77 169 0 0 0 0 0\n"
"MouseMoveEvent 83 164 0 0 0 0 0\n"
"MouseMoveEvent 91 159 0 0 0 0 0\n"
"MouseMoveEvent 97 154 0 0 0 0 0\n"
"MouseMoveEvent 104 148 0 0 0 0 0\n"
"MouseMoveEvent 110 142 0 0 0 0 0\n"
"MouseMoveEvent 117 136 0 0 0 0 0\n"
"MouseMoveEvent 122 130 0 0 0 0 0\n"
"MouseMoveEvent 127 125 0 0 0 0 0\n"
"MouseMoveEvent 133 120 0 0 0 0 0\n"
"MouseMoveEvent 138 115 0 0 0 0 0\n"
"MouseMoveEvent 144 110 0 0 0 0 0\n"
"MouseMoveEvent 147 106 0 0 0 0 0\n"
"MouseMoveEvent 151 105 0 0 0 0 0\n"
"MouseMoveEvent 154 103 0 0 0 0 0\n"
"MouseMoveEvent 156 102 0 0 0 0 0\n"
"MouseMoveEvent 158 102 0 0 0 0 0\n"
"MouseMoveEvent 161 101 0 0 0 0 0\n"
"MouseMoveEvent 163 101 0 0 0 0 0\n"
"MouseMoveEvent 167 101 0 0 0 0 0\n"
"MouseMoveEvent 170 101 0 0 0 0 0\n"
"MouseMoveEvent 173 101 0 0 0 0 0\n"
"MouseMoveEvent 175 101 0 0 0 0 0\n"
"MouseMoveEvent 176 101 0 0 0 0 0\n"
"MouseMoveEvent 178 101 0 0 0 0 0\n"
"MouseMoveEvent 179 101 0 0 0 0 0\n"
"MouseMoveEvent 180 101 0 0 0 0 0\n"
"MouseMoveEvent 181 101 0 0 0 0 0\n"
"LeftButtonReleaseEvent 181 101 0 0 0 0 0\n"
"EndInteractionEvent 181 101 0 0 0 0 0\n"
"MouseMoveEvent 181 101 0 0 0 0 0\n"
"MouseMoveEvent 181 102 0 0 0 0 0\n"
"MouseMoveEvent 181 103 0 0 0 0 0\n"
"MouseMoveEvent 181 104 0 0 0 0 0\n"
"MouseMoveEvent 181 106 0 0 0 0 0\n"
"MouseMoveEvent 181 107 0 0 0 0 0\n"
"MouseMoveEvent 181 108 0 0 0 0 0\n"
"MouseMoveEvent 181 109 0 0 0 0 0\n"
"MouseMoveEvent 181 110 0 0 0 0 0\n"
"MiddleButtonPressEvent 181 110 0 0 0 0 0\n"
"StartInteractionEvent 181 110 0 0 0 0 0\n"
"MouseMoveEvent 181 111 0 0 0 0 0\n"
"RenderEvent 181 111 0 0 0 0 0\n"
"MouseMoveEvent 181 112 0 0 0 0 0\n"
"RenderEvent 181 112 0 0 0 0 0\n"
"MouseMoveEvent 182 114 0 0 0 0 0\n"
"RenderEvent 182 114 0 0 0 0 0\n"
"MouseMoveEvent 182 115 0 0 0 0 0\n"
"RenderEvent 182 115 0 0 0 0 0\n"
"MouseMoveEvent 182 117 0 0 0 0 0\n"
"RenderEvent 182 117 0 0 0 0 0\n"
"MouseMoveEvent 182 119 0 0 0 0 0\n"
"RenderEvent 182 119 0 0 0 0 0\n"
"MouseMoveEvent 182 121 0 0 0 0 0\n"
"RenderEvent 182 121 0 0 0 0 0\n"
"MouseMoveEvent 182 122 0 0 0 0 0\n"
"RenderEvent 182 122 0 0 0 0 0\n"
"MouseMoveEvent 181 122 0 0 0 0 0\n"
"RenderEvent 181 122 0 0 0 0 0\n"
"MouseMoveEvent 180 123 0 0 0 0 0\n"
"RenderEvent 180 123 0 0 0 0 0\n"
"MouseMoveEvent 179 124 0 0 0 0 0\n"
"RenderEvent 179 124 0 0 0 0 0\n"
"MouseMoveEvent 178 124 0 0 0 0 0\n"
"RenderEvent 178 124 0 0 0 0 0\n"
"MouseMoveEvent 177 124 0 0 0 0 0\n"
"RenderEvent 177 124 0 0 0 0 0\n"
"MouseMoveEvent 176 124 0 0 0 0 0\n"
"RenderEvent 176 124 0 0 0 0 0\n"
"MouseMoveEvent 175 123 0 0 0 0 0\n"
"RenderEvent 175 123 0 0 0 0 0\n"
"MouseMoveEvent 174 122 0 0 0 0 0\n"
"RenderEvent 174 122 0 0 0 0 0\n"
"MiddleButtonReleaseEvent 174 122 0 0 0 0 0\n"
"EndInteractionEvent 174 122 0 0 0 0 0\n"
"MouseMoveEvent 174 122 0 0 0 0 0\n"
"RightButtonPressEvent 174 122 0 0 0 0 0\n"
"StartInteractionEvent 174 122 0 0 0 0 0\n"
"MouseMoveEvent 174 124 0 0 0 0 0\n"
"RenderEvent 174 124 0 0 0 0 0\n"
"MouseMoveEvent 175 125 0 0 0 0 0\n"
"RenderEvent 175 125 0 0 0 0 0\n"
"MouseMoveEvent 175 126 0 0 0 0 0\n"
"RenderEvent 175 126 0 0 0 0 0\n"
"MouseMoveEvent 176 129 0 0 0 0 0\n"
"RenderEvent 176 129 0 0 0 0 0\n"
"MouseMoveEvent 176 132 0 0 0 0 0\n"
"RenderEvent 176 132 0 0 0 0 0\n"
"MouseMoveEvent 177 134 0 0 0 0 0\n"
"RenderEvent 177 134 0 0 0 0 0\n"
"MouseMoveEvent 177 135 0 0 0 0 0\n"
"RenderEvent 177 135 0 0 0 0 0\n"
"MouseMoveEvent 177 136 0 0 0 0 0\n"
"RenderEvent 177 136 0 0 0 0 0\n"
"MouseMoveEvent 177 137 0 0 0 0 0\n"
"RenderEvent 177 137 0 0 0 0 0\n"
"RightButtonReleaseEvent 177 137 0 0 0 0 0\n"
"EndInteractionEvent 177 137 0 0 0 0 0\n"
"MouseMoveEvent 177 137 0 0 0 0 0\n"
"MouseMoveEvent 177 138 0 0 0 0 0\n"
"MouseMoveEvent 178 139 0 0 0 0 0\n"
"MouseMoveEvent 178 140 0 0 0 0 0\n"
"MouseMoveEvent 179 141 0 0 0 0 0\n"
"MouseMoveEvent 180 143 0 0 0 0 0\n"
"MouseMoveEvent 180 144 0 0 0 0 0\n"
"MouseMoveEvent 181 146 0 0 0 0 0\n"
"MouseMoveEvent 183 150 0 0 0 0 0\n"
"MouseMoveEvent 185 153 0 0 0 0 0\n"
"MouseMoveEvent 189 158 0 0 0 0 0\n"
"MouseMoveEvent 194 164 0 0 0 0 0\n"
"MouseMoveEvent 198 170 0 0 0 0 0\n"
"MouseMoveEvent 203 176 0 0 0 0 0\n"
"MouseMoveEvent 210 184 0 0 0 0 0\n"
"MouseMoveEvent 214 191 0 0 0 0 0\n"
"MouseMoveEvent 218 197 0 0 0 0 0\n"
"MouseMoveEvent 221 203 0 0 0 0 0\n"
"MouseMoveEvent 225 210 0 0 0 0 0\n"
"MouseMoveEvent 227 215 0 0 0 0 0\n"
"MouseMoveEvent 229 218 0 0 0 0 0\n"
"MouseMoveEvent 232 221 0 0 0 0 0\n"
"MouseMoveEvent 234 225 0 0 0 0 0\n"
"MouseMoveEvent 236 227 0 0 0 0 0\n"
"MouseMoveEvent 238 230 0 0 0 0 0\n"
"MouseMoveEvent 239 232 0 0 0 0 0\n"
"MouseMoveEvent 240 234 0 0 0 0 0\n"
"MouseMoveEvent 242 236 0 0 0 0 0\n"
"MouseMoveEvent 243 238 0 0 0 0 0\n"
"MouseMoveEvent 244 240 0 0 0 0 0\n"
"MouseMoveEvent 245 242 0 0 0 0 0\n"
"MouseMoveEvent 246 244 0 0 0 0 0\n"
"MouseMoveEvent 247 247 0 0 0 0 0\n"
"MouseMoveEvent 248 249 0 0 0 0 0\n"
"MouseMoveEvent 249 252 0 0 0 0 0\n"
"MouseMoveEvent 250 254 0 0 0 0 0\n"
"MouseMoveEvent 251 257 0 0 0 0 0\n"
"MouseMoveEvent 252 260 0 0 0 0 0\n"
"MouseMoveEvent 253 263 0 0 0 0 0\n"
"MouseMoveEvent 255 267 0 0 0 0 0\n"
"MouseMoveEvent 256 269 0 0 0 0 0\n"
"MouseMoveEvent 257 273 0 0 0 0 0\n"
"MouseMoveEvent 260 277 0 0 0 0 0\n"
"MouseMoveEvent 262 280 0 0 0 0 0\n"
"MouseMoveEvent 263 282 0 0 0 0 0\n"
"MouseMoveEvent 265 285 0 0 0 0 0\n"
"MouseMoveEvent 267 288 0 0 0 0 0\n"
"MouseMoveEvent 268 290 0 0 0 0 0\n"
"MouseMoveEvent 269 293 0 0 0 0 0\n"
"MouseMoveEvent 270 295 0 0 0 0 0\n"
"MouseMoveEvent 272 299 0 0 0 0 0\n"
"LeaveEvent 272 299 0 0 0 0 0\n"
"ExitEvent 272 299 0 0 0 0 0\n"
;

//#define RECORD

int TestTreeLayoutView(int argc, char* argv[])
{
  char* file = vtkTestUtilities::ExpandDataFileName(argc, argv,
                                                    "Data/treetest.xml");

  VTK_CREATE(vtkXMLTreeReader, reader);
  reader->SetFileName(file);
  reader->SetMaskArrays(true);

  delete [] file;

  VTK_CREATE(vtkXMLTreeReader, reader2);
  reader2->SetXMLString(xml);
  reader2->SetMaskArrays(true);
  
  VTK_CREATE(vtkStringToNumeric, numeric);
  numeric->SetInputConnection(reader->GetOutputPort());
  
  VTK_CREATE(vtkSelectionLink, link);
  
  VTK_CREATE(TestTreeLayoutViewUpdater, updater);
  
  // Tree layout view
  VTK_CREATE(vtkRenderWindow, win);
  VTK_CREATE(vtkRenderWindowInteractor, iren);
  iren->SetRenderWindow(win);
  VTK_CREATE(vtkTreeLayoutView, view);
  view->SetLabelArrayName("name");
  view->LabelVisibilityOn();
  view->SetVertexColorArrayName("size");
  view->ColorVerticesOn();
  view->SetLeafSpacing(0.9);
  view->SetRadial(true);
  view->SetAngle(360);
  view->SetLogSpacingValue(1.0);
  view->SetupRenderWindow(win);
  view->SetRepresentationFromInputConnection(numeric->GetOutputPort());
  view->GetRepresentation()->SetSelectionLink(link);
  view->Update();
  updater->AddView(view);
  
  // record events
  VTK_CREATE(vtkInteractorEventRecorder, recorder);
  recorder->SetInteractor(iren);
#ifdef RECORD
  recorder->SetFileName("record.log");
  recorder->SetEnabled(true);
  recorder->Record();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(TreeLayoutViewEventLog);
#endif

  // interact with data
  // render the image
  //
  iren->Initialize();
  win->Render();
#ifdef RECORD
#else
  recorder->Play();

  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.
  recorder->Off();
#endif
  
  int retVal = vtkRegressionTestImage(win);
  if (retVal == vtkRegressionTester::DO_INTERACTOR)
    {
#if 0
    // Make more views to play with if it is interactive :)

    // Tree map view
    VTK_CREATE(vtkRenderWindow, win2);
    VTK_CREATE(vtkRenderWindowInteractor, iren2);
    iren2->SetRenderWindow(win2);
    VTK_CREATE(vtkTreeMapView, view2);
    view2->SetSizeArrayName("size");
    view2->SetColorArrayName("level");
    view2->SetLabelArrayName("name");
    view2->SetHoverArrayName("name");
    view2->SetupRenderWindow(win2);
    view2->SetRepresentationFromInputConnection(reader->GetOutputPort());
    view2->GetRepresentation()->SetSelectionLink(link);
    view2->Update();
    updater->AddView(view2);

    // Graph layout view
    VTK_CREATE(vtkRenderWindow, win4);
    VTK_CREATE(vtkRenderWindowInteractor, iren4);
    iren4->SetRenderWindow(win4);
    VTK_CREATE(vtkGraphLayoutView, view4);
    view4->SetVertexLabelArrayName("name");
    view4->VertexLabelVisibilityOn();
    view4->SetupRenderWindow(win4);
    view4->SetRepresentationFromInputConnection(reader->GetOutputPort());
    view4->GetRepresentation()->SetSelectionLink(link);
    view4->Update();
    updater->AddView(view4);
#endif
    
#if 0
    // Test changing the input connection.
    view->GetRepresentation()->SetInputConnection(reader2->GetOutputPort());
    view2->GetRepresentation()->SetInputConnection(reader2->GetOutputPort());
    view4->GetRepresentation()->SetInputConnection(reader2->GetOutputPort());

    view->Update();
    view2->Update();
    view4->Update();
    
    // Test changing the pipeline.
    reader2->SetXMLString(xml2);
    
    view->Update();
    view2->Update();
    view4->Update();
#endif

    iren->Initialize();
    iren->Start();
    
    retVal = vtkRegressionTester::PASSED;
    }
  
  return !retVal;
}
