# Generate implicit model of a sphere
#
source vtkInt.tcl
source "colors.tcl"

# Create renderer stuff
#
vtkRenderMaster rm;
set renWin [rm MakeRenderWindow];
set ren1   [$renWin MakeRenderer];
set iren [$renWin MakeRenderWindowInteractor];

# create pipeline
#
vtkSphere sphere;
    sphere SetRadius 1;
vtkSampleFunction sample;
    sample SetImplicitFunction sphere;
vtkContourFilter iso;
    iso SetInput [sample GetOutput];
    iso SetValue 0 0.0;
vtkPolyMapper isoMapper;
    isoMapper SetInput [iso GetOutput];
    isoMapper ScalarsVisibleOff;
vtkActor isoActor;
    isoActor SetMapper isoMapper;
    eval [isoActor GetProperty] SetColor $peacock;

vtkOutlineFilter outline;
    outline SetInput [sample GetOutput];
vtkPolyMapper outlineMapper;
    outlineMapper SetInput [outline GetOutput];
vtkActor outlineActor;
    outlineActor SetMapper outlineMapper;
    [outlineActor GetProperty] SetColor 0 0 0;

# Add the actors to the renderer, set the background and size
#
$ren1 AddActors outlineActor;
$ren1 AddActors isoActor;
$ren1 SetBackground 1 1 1;
$renWin SetSize 500 500;
$iren Initialize;

# render the image
#
$iren SetUserMethod {wm deiconify .vtkInteract};

#$renWin SetFilename "sphere.tcl.ppm";
#$renWin SaveImageAsPPM;

# prevent the tk window from showing up then start the event loop
wm withdraw .


