/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmFileTimeComparison_h
#define cmFileTimeComparison_h

#include "cmConfigure.h" // IWYU pragma: keep

#include <string>

class cmFileTimeComparisonInternal;

/** \class cmFileTimeComparison
 * \brief Helper class for comparing file modification times.
 *
 * Compare file modification times or test if file modification times differ.
 */
class cmFileTimeComparison
{
public:
  cmFileTimeComparison();
  ~cmFileTimeComparison();

  cmFileTimeComparison(const cmFileTimeComparison&) = delete;
  cmFileTimeComparison& operator=(const cmFileTimeComparison&) = delete;

  /**
   *  Compare file modification times.
   *  Return true for successful comparison and false for error.
   *  When true is returned, result has -1, 0, +1 for
   *  f1 older, same, or newer than f2.
   */
  bool FileTimeCompare(const std::string& f1, const std::string& f2,
                       int* result);

  /**
   *  Compare file modification times.  Return true unless both files
   *  exist and have modification times less than 1 second apart.
   */
  bool FileTimesDiffer(const std::string& f1, const std::string& f2);

protected:
  cmFileTimeComparisonInternal* Internals;
};

#endif
