/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmComputeTargetOrder_h
#define cmComputeTargetOrder_h

#include "cmConfigure.h" // IWYU pragma: keep

#include "cmGraphAdjacencyList.h"
#include "cmListFileCache.h"

#include <map>
#include <set>
#include <string>
#include <vector>

class cmComputeComponentGraph;
class cmGeneratorTarget;
class cmTargetDependSet;

/** \class cmComputeTargetOrder
 * \brief Compute interdependencies among targets in a target set.
 */
class cmComputeTargetOrder
{
public:
  cmComputeTargetOrder(std::vector<cmGeneratorTarget const*>* targets,
                       bool no_cycles, bool missing_deps_error);
  ~cmComputeTargetOrder();

  bool Compute();

  std::vector<cmGeneratorTarget const*> const& GetTargetBuildOrder() const
  {
    return this->TargetsBuildOrder;
  }

private:
  void CollectTargets();
  void CollectDepends();
  void CollectTargetDepends(int depender_index);
  void AddTargetDepend(int depender_index, cmGeneratorTarget const* dependee);

  bool DebugMode;
  bool NoCycles;
  bool MissingDepsError;
  bool StatusOK;

  // Collect all sources.
  std::vector<cmGeneratorTarget const*> Targets;
  std::vector<cmGeneratorTarget const*> TargetsBuildOrder;
  std::map<cmGeneratorTarget const*, int> TargetIndex;

  // Represent the target dependency graph.  The entry at each
  // top-level index corresponds to a depender whose dependencies are
  // listed.
  typedef cmGraphNodeList NodeList;
  typedef cmGraphEdgeList EdgeList;
  typedef cmGraphAdjacencyList Graph;
  Graph InitialGraph;
  void DisplayGraph(Graph const& graph, const std::string& name);

  // Deal with connected components.
  void DisplayComponents(cmComputeComponentGraph const& ccg);
  void CheckComponents(cmComputeComponentGraph const& ccg);
  void ComplainAboutBadComponent(cmComputeComponentGraph const& ccg, int c);

  std::vector<cmGeneratorTarget const*>* TargetList;
};

#endif
