/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmComputeCustomCommandOrder_h
#define cmComputeCustomCommandOrder_h

#include "cmConfigure.h" // IWYU pragma: keep

#include "cmGraphAdjacencyList.h"
#include "cmListFileCache.h"

#include <map>
#include <set>
#include <string>
#include <vector>

class cmComputeComponentGraph;
class cmGeneratorTarget;
class cmSourceFile;

/** \class cmComputeCustomCommandOrder
 * \brief Compute interdependencies among custom commands sources in a target.
 */
class cmComputeCustomCommandOrder
{
public:
  cmComputeCustomCommandOrder(cmGeneratorTarget* gt, std::string config,
                              bool no_cycles, bool missing_deps_error);
  ~cmComputeCustomCommandOrder();

  bool Compute();

  std::vector<cmSourceFile const*> const& GetSourcesBuildOrder() const
  {
    return this->SourcesBuildOrder;
  }

private:
  void CollectSources();
  void CollectDepends();
  void CollectSourceDepends(int depender_index);
  void AddSourceDepend(int depender_index, std::string const& dependee_name);

  bool DebugMode;
  bool NoCycles;
  bool MissingDepsError;
  bool StatusOK;

  // Collect all sources.
  std::vector<cmSourceFile const*> Sources;
  std::vector<cmSourceFile const*> SourcesBuildOrder;
  std::map<cmSourceFile const*, int> SourceIndex;

  // Represent the source dependency graph.  The entry at each
  // top-level index corresponds to a depender whose dependencies are
  // listed.
  typedef cmGraphNodeList NodeList;
  typedef cmGraphEdgeList EdgeList;
  typedef cmGraphAdjacencyList Graph;
  Graph InitialGraph;
  void DisplayGraph(Graph const& graph, const std::string& name);

  // Deal with connected components.
  void DisplayComponents(cmComputeComponentGraph const& ccg);
  void CheckComponents(cmComputeComponentGraph const& ccg);
  void ComplainAboutBadComponent(cmComputeComponentGraph const& ccg, int c);

  cmGeneratorTarget* GeneratorTarget;
  std::string Config;
};

#endif
