/*******************************************************************************
 * This file is part of SWIFT.
 * Copyright (c) 2016 Matthieu Schaller (matthieu.schaller@durham.ac.uk)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#ifndef SWIFT_CHEMISTRY_STRUCT_GEAR_H
#define SWIFT_CHEMISTRY_STRUCT_GEAR_H

/**
 * @brief Global chemical abundance information.
 */
struct chemistry_global_data {

  /* Initial metallicity Z */
  double initial_metallicities[GEAR_CHEMISTRY_ELEMENT_COUNT];
};

/**
 * @brief Properties of the chemistry function for #part.
 */
struct chemistry_part_data {

  union {
    /*! Fraction of the particle mass in a given element.
      This field is available only during the density hydro loop. */
    double metal_mass_fraction[GEAR_CHEMISTRY_ELEMENT_COUNT];

    /*! Total mass of element in a particle.
      This field is available only outside the density hydro loop. */
    double metal_mass[GEAR_CHEMISTRY_ELEMENT_COUNT];
  };

  /*! Smoothed fraction of the particle mass in a given element */
  double smoothed_metal_mass_fraction[GEAR_CHEMISTRY_ELEMENT_COUNT];
};

/**
 * @brief Properties of the chemistry function for #spart.
 */
struct chemistry_spart_data {

  /*! Fraction of the particle mass in a given element */
  double metal_mass_fraction[GEAR_CHEMISTRY_ELEMENT_COUNT];
};

/**
 * @brief Chemical abundances traced by the #bpart in the GEAR model.
 */
struct chemistry_bpart_data {};

#endif /* SWIFT_CHEMISTRY_STRUCT_GEAR_H */
