#!/bin/bash

# make run.sh fail if a subcommand fails
set -e
set -o pipefail

if [ ! -f ./heating_test.hdf5 ]; then
    echo "creating ICs"
    python3 makeIC.py
fi

# Run SWIFT with RT
../../../swift \
    --hydro \
    --threads=4 \
    --verbose=0  \
    --radiation \
    --external-gravity \
    --stars \
    --feedback \
    ./rt_heating_test.yml 2>&1 | tee output.log

python3 plotSolution.py
