include(RunCMake)

function(run_cmake_build name target)
  if(NOT BUILD_CONFIG)
    set(BUILD_CONFIG Debug)
  endif()
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  set(RunCMake_TEST_NO_CLEAN 1)
  run_cmake_command(${name}-${target}-${BUILD_CONFIG}-build ${CMAKE_COMMAND} --build . --config ${BUILD_CONFIG} --target ${target})
endfunction()

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_INTERFACE_HEADER_SETS=ON)
if(NOT RunCMake_GENERATOR_IS_MULTI_CONFIG)
  list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=Debug)
endif()
run_cmake(VerifyHeaderSets)
unset(RunCMake_TEST_OPTIONS)

run_cmake_build(VerifyHeaderSets static_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets shared_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets object_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets interface_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets exe_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets export_exe_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets none_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets property_off_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets private_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets a_h_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets dir_c_h_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets dir_cxx_h_verify_interface_header_sets)

if(NOT RunCMake_GENERATOR STREQUAL "Xcode")
  run_cmake_build(VerifyHeaderSets config_verify_interface_header_sets)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    set(BUILD_CONFIG Release)
    run_cmake_build(VerifyHeaderSets config_verify_interface_header_sets)
    unset(BUILD_CONFIG)
  endif()
endif()

run_cmake_build(VerifyHeaderSets lang_test_c_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets lang_test_cxx_verify_interface_header_sets)
run_cmake_build(VerifyHeaderSets list_verify_interface_header_sets)

set(RunCMake_TEST_OPTIONS -DCMAKE_VERIFY_INTERFACE_HEADER_SETS=ON)
run_cmake(VerifyHeaderSetsNonexistent)
unset(RunCMake_TEST_OPTIONS)
