include(RunCMake)

run_cmake_command(set_directory_properties ${CMAKE_COMMAND} -P ${RunCMake_SOURCE_DIR}/set_directory_properties.cmake)

run_cmake_command(BadPModeArg ${CMAKE_COMMAND} -P -DCMAKE_BUILD_TYPE=Debug)

# The remaining tests will all run with the same file as stdin, until unset
set(RunCMake-stdin-file P_stdin.txt)

run_cmake_command(ScriptFromStdin ${CMAKE_COMMAND} -P -)
run_cmake_command(StdinTraceMode ${CMAKE_COMMAND} -P - --trace)
run_cmake_command(VariableBeforeStdin ${CMAKE_COMMAND}
  -DSTDIN_TEST_ARG=blue -P -)

# The variable assignment after the -P command is expected to be
# ignored, as it's passed as an argument to the -P script itself.
# Therefore, the expected output contains STDIN_TEST_ARG=blue
run_cmake_command(VariableAfterStdin ${CMAKE_COMMAND}
  -DSTDIN_TEST_ARG=blue -P - -DSTDIN_TEST_ARG=red)
