///////////////////////////////////////////////////////////////////////////////
//
/// \file       private.h
/// \brief      Common includes, definions, and prototypes
//
//  Author:     Lasse Collin
//
//  This file has been put into the public domain.
//  You can do whatever you want with this file.
//
///////////////////////////////////////////////////////////////////////////////

#include "sysdefs.h"
#include "mythread.h"
#include "lzma.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <locale.h>
#include <stdio.h>
#include <unistd.h>

#ifdef ENABLE_NLS
#	include <libintl.h>
#	define _(msgid) gettext(msgid)
#	define N_(msgid1, msgid2, n) ngettext(msgid1, msgid2, n)
#else
#	define _(msgid) (msgid)
#	define N_(msgid1, msgid2, n) ((n) == 1 ? (msgid1) : (msgid2))
#endif

#ifndef STDIN_FILENO
#	define STDIN_FILENO (fileno(stdin))
#endif

#ifndef STDOUT_FILENO
#	define STDOUT_FILENO (fileno(stdout))
#endif

#ifndef STDERR_FILENO
#	define STDERR_FILENO (fileno(stderr))
#endif

#include "main.h"
#include "process.h"
#include "message.h"
#include "args.h"
#include "hardware.h"
#include "io.h"
#include "options.h"
#include "signals.h"
#include "suffix.h"
#include "util.h"
