/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/

#pragma once
#include "patient/conditions/SEPatientCondition.h"
CDM_BIND_DECL(MitralValveInsufficiencyData)

class CDM_DECL SEMitralValveInsufficiency : public SEPatientCondition
{
public:

	SEMitralValveInsufficiency();
	virtual ~SEMitralValveInsufficiency();

	virtual void Clear(); //clear memory

	virtual bool IsValid() const;

	static void Load(const cdm::MitralValveInsufficiencyData& src, SEMitralValveInsufficiency& dst);
	static cdm::MitralValveInsufficiencyData* Unload(const SEMitralValveInsufficiency& src);
protected:
	static void Serialize(const cdm::MitralValveInsufficiencyData& src, SEMitralValveInsufficiency& dst);
	static void Serialize(const SEMitralValveInsufficiency& src, cdm::MitralValveInsufficiencyData& dst);

public:
	virtual std::string GetName() const { return "MitralValveInsufficiency"; }

	virtual bool HasSeverity() const;
	virtual SEScalar0To1& GetSeverity();

	virtual void ToString(std::ostream &str) const;

protected:
	SEScalar0To1*           m_Severity;
};
