/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.picking;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public abstract class BasePickingNode
extends BaseSensorNode
implements VRMLPickingSensorNodeType {
    protected static final int FIELD_PICKING_GEOMETRY = 3;
    protected static final int FIELD_PICK_TARGET = 4;
    protected static final int FIELD_INTERSECTION_TYPE = 5;
    protected static final int FIELD_PICKED_GEOMETRY = 6;
    protected static final int FIELD_SORT_ORDER = 7;
    protected static final int FIELD_OBJECT_TYPE = 8;
    protected static final int LAST_PICK_INDEX = 8;
    protected static final String GEOMETRY_PROTO_MSG = "Proto does not describe a Geometry object";
    protected static final String GEOMETRY_NODE_MSG = "Node does not describe a Geometry object";
    private static final String ALL_OBJECT_TYPE = "ALL";
    protected static HashMap sortTypeMap = new HashMap();
    protected static HashMap intersectTypeMap;
    private final String PICK_GEOM_TYPE_MSG;
    protected String[] vfObjectType;
    protected VRMLGeometryNodeType vfPickingGeometry;
    protected VRMLProtoInstance pPickingGeometry;
    protected VRMLNodeType[] vfPickTarget;
    protected VRMLNodeType[] vfPickedGeometry;
    protected String vfIntersectionType;
    protected String vfSortOrder;
    protected int intersectionType;
    protected int sortType;
    private ArrayList targetList;
    protected int numPickTarget;
    protected int numPickedGeometry;
    protected HashSet validGeometryNodeNames;

    public BasePickingNode(String string, String string2) {
        super(string);
        this.PICK_GEOM_TYPE_MSG = string2;
        this.init();
    }

    protected void copy(VRMLPickingSensorNodeType vRMLPickingSensorNodeType) {
        super.copy(vRMLPickingSensorNodeType);
        try {
            int n = vRMLPickingSensorNodeType.getFieldIndex("sortOrder");
            VRMLFieldData vRMLFieldData = vRMLPickingSensorNodeType.getFieldValue(n);
            this.vfSortOrder = vRMLFieldData.stringValue;
            Integer n2 = (Integer)sortTypeMap.get(this.vfSortOrder);
            this.sortType = n2;
            n = vRMLPickingSensorNodeType.getFieldIndex("sortOrder");
            vRMLFieldData = vRMLPickingSensorNodeType.getFieldValue(n);
            this.vfIntersectionType = vRMLFieldData.stringValue;
            n2 = (Integer)sortTypeMap.get(this.vfIntersectionType);
            this.intersectionType = n2;
            n = vRMLPickingSensorNodeType.getFieldIndex("objectType");
            vRMLFieldData = vRMLPickingSensorNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfObjectType = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfObjectType, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setObjectType(String[] stringArray, int n) {
        if (this.vfObjectType.length != n) {
            this.vfObjectType = new String[n];
        }
        System.arraycopy(stringArray, 0, this.vfObjectType, 0, n);
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public int numObjectType() {
        return this.vfObjectType.length;
    }

    public void getObjectType(String[] stringArray) {
        System.arraycopy(this.vfObjectType, 0, stringArray, 0, this.vfObjectType.length);
    }

    public int getSortOrder() {
        return this.sortType;
    }

    public int getIntersectionType() {
        return this.intersectionType;
    }

    public void setPickingGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLGeometryNodeType vRMLGeometryNodeType;
        VRMLNodeType vRMLNodeType2 = this.pPickingGeometry != null ? this.pPickingGeometry : this.vfPickingGeometry;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pPickingGeometry = (VRMLProtoInstance)vRMLNodeType;
            while (vRMLNodeType3 != null && vRMLNodeType3 instanceof VRMLProtoInstance) {
                vRMLNodeType3 = ((VRMLProtoInstance)vRMLNodeType3).getImplementationNode();
            }
            if (vRMLNodeType3 != null && !(vRMLNodeType3 instanceof VRMLGeometryNodeType)) {
                throw new InvalidFieldValueException(GEOMETRY_PROTO_MSG);
            }
            String string = vRMLNodeType3.getVRMLNodeName();
            if (!this.validGeometryNodeNames.contains(string)) {
                throw new InvalidFieldValueException(this.PICK_GEOM_TYPE_MSG);
            }
            vRMLGeometryNodeType = (VRMLGeometryNodeType)vRMLNodeType3;
        } else if (vRMLNodeType instanceof VRMLGeometryNodeType) {
            String string = vRMLNodeType.getVRMLNodeName();
            if (!this.validGeometryNodeNames.contains(string)) {
                throw new InvalidFieldValueException(this.PICK_GEOM_TYPE_MSG);
            }
            this.pPickingGeometry = null;
            vRMLGeometryNodeType = (VRMLGeometryNodeType)vRMLNodeType;
        } else {
            throw new InvalidFieldValueException(GEOMETRY_NODE_MSG);
        }
        this.vfPickingGeometry = vRMLGeometryNodeType;
        if (vRMLNodeType != null) {
            this.updateRefs(vRMLNodeType, true);
        }
        if (vRMLNodeType2 != null) {
            this.updateRefs(vRMLNodeType2, false);
        }
        if (!this.inSetup) {
            if (vRMLNodeType2 != null) {
                this.stateManager.registerRemovedNode(vRMLNodeType2);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode(vRMLNodeType);
            }
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public VRMLNodeType getPickingGeometry() {
        return this.vfPickingGeometry;
    }

    public VRMLNodeType[] getPickingTargets() {
        return this.vfPickTarget;
    }

    public void notifyPickStart(int n, VRMLNodeType[] vRMLNodeTypeArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.processPickedGeometry(n, vRMLNodeTypeArray);
        this.vfIsActive = true;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public void notifyPickChange(int n, VRMLNodeType[] vRMLNodeTypeArray, float[] fArray, float[] fArray2, float[] fArray3) {
        this.processPickedGeometry(n, vRMLNodeTypeArray);
    }

    public void notifyPickEnd() {
        this.vfIsActive = false;
        this.numPickedGeometry = 0;
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public int getPrimaryType() {
        return 73;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pPickingGeometry != null) {
            this.pPickingGeometry.setupFinished();
        }
        if (this.vfPickingGeometry != null) {
            this.vfPickingGeometry.setupFinished();
        }
        this.numPickTarget = this.targetList.size();
        this.vfPickTarget = new VRMLNodeType[this.numPickTarget];
        for (int i = 0; i < this.numPickTarget; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.targetList.get(i);
            vRMLNodeType.setupFinished();
            this.vfPickTarget[i] = vRMLNodeType;
        }
        this.targetList = null;
        this.updateChildren(this.vfPickTarget, this.numPickTarget);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.pPickingGeometry != null ? this.pPickingGeometry : this.vfPickingGeometry;
                vRMLFieldData.dataType = (short)7;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfPickTarget;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = this.numPickTarget;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeArrayValue = this.vfPickedGeometry;
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = this.numPickedGeometry;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfIntersectionType;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfSortOrder;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.numElements = this.vfObjectType.length;
                vRMLFieldData.stringArrayValue = this.vfObjectType;
                vRMLFieldData.dataType = (short)14;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfPickingGeometry);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfPickTarget, this.vfPickTarget.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfPickedGeometry, this.numPickedGeometry);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfObjectType, this.vfObjectType.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BasePickingNode.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BasePickingNode.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("intersectionType can only be set at runtime");
                }
                Integer n2 = (Integer)intersectTypeMap.get(string);
                if (n2 == null) {
                    throw new InvalidFieldValueException("Unknown intersection type " + string);
                }
                this.vfIntersectionType = string;
                this.intersectionType = n2;
                break;
            }
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("sortOrder can only be set at runtime");
                }
                Integer n3 = (Integer)sortTypeMap.get(string);
                if (n3 == null) {
                    throw new InvalidFieldValueException("Unknown sort type " + string);
                }
                this.vfSortOrder = string;
                this.sortType = n3;
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setObjectType(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                this.setPickingGeometry(vRMLNodeType);
                break;
            }
            case 4: {
                this.checkPickTargetType(vRMLNodeType);
                if (this.inSetup) {
                    this.targetList.add(vRMLNodeType);
                    break;
                }
                for (int i = 0; i < this.numPickTarget; ++i) {
                    this.stateManager.registerRemovedNode(this.vfPickTarget[i]);
                    this.vfPickTarget[i] = null;
                }
                this.vfPickTarget[0] = vRMLNodeType;
                this.numPickTarget = 1;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 6: {
                throw new InvalidFieldAccessException("pickedGeometry is outputOnly");
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 4: {
                int n3;
                for (n3 = 0; n3 < this.numPickTarget; ++n3) {
                    this.stateManager.registerRemovedNode(this.vfPickTarget[n3]);
                    this.vfPickTarget[n3] = null;
                }
                if (vRMLNodeTypeArray == null) {
                    this.numPickTarget = 0;
                } else {
                    this.numPickTarget = vRMLNodeTypeArray.length;
                    if (this.inSetup) {
                        for (n3 = 0; n3 < this.numPickTarget; ++n3) {
                            this.checkPickTargetType(vRMLNodeTypeArray[n3]);
                            this.targetList.add(vRMLNodeTypeArray[n3]);
                        }
                    } else {
                        if (this.vfPickTarget.length < this.numPickTarget) {
                            this.vfPickTarget = new VRMLNodeType[this.numPickTarget];
                        }
                        for (n3 = 0; n3 < this.numPickTarget; ++n3) {
                            this.checkPickTargetType(vRMLNodeTypeArray[n3]);
                            this.vfPickTarget[n3] = vRMLNodeTypeArray[n3];
                            this.stateManager.registerAddedNode(this.vfPickTarget[n3]);
                        }
                    }
                }
                this.updateChildren(vRMLNodeTypeArray, n2);
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 6: {
                throw new InvalidFieldAccessException("pickedGeometry is outputOnly");
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.vfIsActive && !bl) {
            this.vfIsActive = false;
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void init() {
        this.targetList = new ArrayList();
        this.intersectionType = 1;
        this.vfIntersectionType = "BOUNDS";
        this.sortType = 1;
        this.vfSortOrder = "CLOSEST";
        this.numPickedGeometry = 0;
        this.numPickTarget = 0;
        this.vfObjectType = new String[]{ALL_OBJECT_TYPE};
        this.validGeometryNodeNames = new HashSet();
    }

    protected void checkPickTargetType(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLGroupingNodeType || vRMLNodeType instanceof VRMLShapeNodeType) {
            return;
        }
        if (!(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException("pickTarget node not a group or shape node type: " + vRMLNodeType.getVRMLNodeName());
        }
        VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
        VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
        while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
        }
        if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLGroupingNodeType) && !(vRMLNodeType2 instanceof VRMLShapeNodeType)) {
            throw new InvalidFieldValueException("pickTarget proto instance not a group or shape node type: " + vRMLNodeType.getVRMLNodeName());
        }
    }

    protected void updateChildren(VRMLNodeType[] vRMLNodeTypeArray, int n) {
    }

    private void processPickedGeometry(int n, VRMLNodeType[] vRMLNodeTypeArray) {
        if (this.vfPickedGeometry == null || this.vfPickedGeometry.length < n) {
            this.vfPickedGeometry = new VRMLNodeType[n];
        }
        System.arraycopy(vRMLNodeTypeArray, 0, this.vfPickedGeometry, 0, n);
        this.numPickedGeometry = n;
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    static {
        sortTypeMap.put("CLOSEST", new Integer(1));
        sortTypeMap.put(ALL_OBJECT_TYPE, new Integer(2));
        sortTypeMap.put("ALL_SORTED", new Integer(3));
        sortTypeMap.put("ANY", new Integer(4));
        intersectTypeMap = new HashMap();
        intersectTypeMap.put("BOUNDS", new Integer(1));
        intersectTypeMap.put("GEOMETRY", new Integer(2));
    }
}

