/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.scripting.ScriptEngine;
import org.xj3d.core.loading.ContentLoadQueue;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoadRequest;
import org.xj3d.core.loading.LoaderThreadPool;
import org.xj3d.core.loading.ScriptLoadStatusListener;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.impl.core.loading.ScriptLoadDetails;
import org.xj3d.impl.core.loading.ScriptLoadHandler;
import org.xj3d.impl.core.loading.WeakRefFileCache;

public class DefaultScriptLoader
implements ScriptLoader {
    private static FileCache cache = new WeakRefFileCache();
    private LoaderThreadPool loaderPool;
    private ContentLoadQueue pending;
    private Map inProgress;
    private IntHashMap engineMap = new IntHashMap();
    private ScriptLoadStatusListener statusListener;

    public DefaultScriptLoader() {
        this.loaderPool = LoaderThreadPool.getLoaderThreadPool();
        this.pending = this.loaderPool.getWaitingList();
        this.inProgress = this.loaderPool.getProgressMap();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.loaderPool.setErrorReporter(errorReporter);
    }

    public void registerScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = scriptEngine.getSupportedSpecificationVersion();
        HashMap<String, ScriptEngine> hashMap = (HashMap<String, ScriptEngine>)this.engineMap.get(n);
        if (hashMap == null) {
            hashMap = new HashMap<String, ScriptEngine>();
            this.engineMap.put(n, hashMap);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], scriptEngine);
        }
    }

    public void unregisterScriptingEngine(ScriptEngine scriptEngine) {
        String[] stringArray = scriptEngine.getSupportedContentTypes();
        int n = scriptEngine.getSupportedSpecificationVersion();
        HashMap hashMap = (HashMap)this.engineMap.get(n);
        for (int i = 0; i < stringArray.length; ++i) {
            Object v = hashMap.get(stringArray[i]);
            if (v != scriptEngine) continue;
            hashMap.remove(stringArray[i]);
        }
    }

    public void setStatusListener(ScriptLoadStatusListener scriptLoadStatusListener) {
        this.statusListener = scriptLoadStatusListener;
    }

    public void loadScript(VRMLScriptNodeType vRMLScriptNodeType) {
        if (vRMLScriptNodeType.getLoadState() != 1) {
            return;
        }
        String[] stringArray = vRMLScriptNodeType.getUrl();
        if (stringArray == null || stringArray.length == 0) {
            vRMLScriptNodeType.setLoadState(3);
            this.statusListener.loadCompleted(vRMLScriptNodeType);
        } else {
            this.loaderPool.restartThreads();
            ScriptLoadDetails scriptLoadDetails = new ScriptLoadDetails();
            scriptLoadDetails.fieldIndex = -1;
            scriptLoadDetails.node = vRMLScriptNodeType;
            scriptLoadDetails.engineMap = this.engineMap;
            scriptLoadDetails.statusListener = this.statusListener;
            String[] stringArray2 = vRMLScriptNodeType.getUrl();
            if (this.inProgress.containsKey(stringArray2)) {
                LoadRequest loadRequest = (LoadRequest)this.inProgress.get(stringArray2);
                loadRequest.loadList.add(scriptLoadDetails);
            } else {
                ScriptLoadHandler scriptLoadHandler = new ScriptLoadHandler(cache);
                this.pending.add("scripts", stringArray2, scriptLoadHandler, scriptLoadDetails);
            }
        }
    }

    public int getNumberInProgress() {
        int n = this.pending.size() + this.inProgress.size();
        return n;
    }

    public void shutdown() {
        this.loaderPool.shutdown();
    }
}

