/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.cadgeometry;

import java.util.HashMap;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProductStructureChildNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;

public class BaseCADPart
extends BaseGroupingNode
implements VRMLProductStructureChildNodeType {
    protected static final int FIELD_CENTER = 6;
    protected static final int FIELD_ROTATION = 7;
    protected static final int FIELD_SCALE = 8;
    protected static final int FIELD_SCALE_ORIENTATION = 9;
    protected static final int FIELD_TRANSLATION = 10;
    protected static final int FIELD_NAME = 11;
    protected static final int LAST_CADPART_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    protected static VRMLFieldDeclaration[] fieldDecl;
    private static final float ZEROEPS = 1.0E-4f;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected String vfName;
    protected float[] vfCenter;
    protected float[] vfRotation;
    protected float[] vfScale;
    protected float[] vfScaleOrientation;
    protected float[] vfTranslation;
    private Vector3f tempVec;
    private AxisAngle4f tempAxis;
    private Matrix4f tempMtx1;
    private Matrix4f tempMtx2;
    protected Matrix4f tmatrix;

    public BaseCADPart() {
        super("CADPart");
        this.hasChanged = new boolean[12];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfScale = new float[]{1.0f, 1.0f, 1.0f};
        this.vfScaleOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfTranslation = new float[]{0.0f, 0.0f, 0.0f};
        this.tmatrix = new Matrix4f();
        this.tempVec = new Vector3f();
        this.tempAxis = new AxisAngle4f();
        this.tempMtx1 = new Matrix4f();
        this.tempMtx2 = new Matrix4f();
    }

    public BaseCADPart(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("name");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfName = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("center");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfRotation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfRotation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scaleOrientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScaleOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScaleOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScaleOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfScaleOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        this.updateMatrix();
    }

    public void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    public void setScale(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale value null");
        }
        this.vfScale[0] = fArray[0];
        this.vfScale[1] = fArray[1];
        this.vfScale[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public void setScaleOrientation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Scale Orientation value null");
        }
        this.vfScaleOrientation[0] = fArray[0];
        this.vfScaleOrientation[1] = fArray[1];
        this.vfScaleOrientation[2] = fArray[2];
        this.vfScaleOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public void setName(String string) {
        this.vfName = string;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    public String getName() {
        return this.vfName;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        vRMLFieldData.clear();
        vRMLFieldData.numElements = 1;
        switch (n) {
            case 11: {
                vRMLFieldData.dataType = (short)6;
                vRMLFieldData.stringValue = this.vfName;
                break;
            }
            case 6: {
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfCenter;
                break;
            }
            case 7: {
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfRotation;
                break;
            }
            case 8: {
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScale;
                break;
            }
            case 9: {
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfScaleOrientation;
                break;
            }
            case 10: {
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfName);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfScaleOrientation, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 11: {
                this.setName(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRotation(fArray);
                break;
            }
            case 8: {
                this.setScale(fArray);
                break;
            }
            case 9: {
                this.setScaleOrientation(fArray);
                break;
            }
            case 10: {
                this.setTranslation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!(vRMLNodeType instanceof VRMLProductStructureChildNodeType)) {
            throw new InvalidFieldValueException("Child not a X3DProductStructureChildNode in CADPart");
        }
        super.addChildNode(vRMLNodeType);
    }

    private boolean floatEq(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 *= -1.0f;
        }
        return f3 < 1.0E-4f;
    }

    protected void updateMatrix() {
        this.tempVec.x = -this.vfCenter[0];
        this.tempVec.y = -this.vfCenter[1];
        this.tempVec.z = -this.vfCenter[2];
        this.tmatrix.setIdentity();
        this.tmatrix.setTranslation(this.tempVec);
        float f = 1.0f;
        if (this.floatEq(this.vfScale[0], this.vfScale[1]) && this.floatEq(this.vfScale[0], this.vfScale[2])) {
            f = this.vfScale[0];
            this.tempMtx1.set(f);
        } else {
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = -this.vfScaleOrientation[3];
            double d = 1.0 / Math.sqrt(this.tempAxis.x * this.tempAxis.x + this.tempAxis.y * this.tempAxis.y + this.tempAxis.z * this.tempAxis.z);
            this.tempAxis.x = (float)((double)this.tempAxis.x * d);
            this.tempAxis.y = (float)((double)this.tempAxis.y * d);
            this.tempAxis.z = (float)((double)this.tempAxis.z * d);
            this.tempMtx1.set(this.tempAxis);
            this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
            this.tempMtx1.setIdentity();
            this.tempMtx1.m00 = this.vfScale[0];
            this.tempMtx1.m11 = this.vfScale[1];
            this.tempMtx1.m22 = this.vfScale[2];
            this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = this.vfScaleOrientation[3];
            this.tempMtx1.set(this.tempAxis);
        }
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        float f2 = this.vfRotation[0] * this.vfRotation[0] + this.vfRotation[1] * this.vfRotation[1] + this.vfRotation[2] * this.vfRotation[2];
        if (f2 < 1.0E-4f) {
            this.tempAxis.x = 0.0f;
            this.tempAxis.y = 0.0f;
            this.tempAxis.z = 1.0f;
            this.tempAxis.angle = 0.0f;
        } else {
            if ((double)f2 > 1.01 || (double)f2 < 0.99) {
                float f3 = (float)(1.0 / Math.sqrt(f2));
                this.tempAxis.x = this.vfRotation[0] * f3;
                this.tempAxis.y = this.vfRotation[1] * f3;
                this.tempAxis.z = this.vfRotation[2] * f3;
            } else {
                this.tempAxis.x = this.vfRotation[0];
                this.tempAxis.y = this.vfRotation[1];
                this.tempAxis.z = this.vfRotation[2];
            }
            this.tempAxis.angle = this.vfRotation[3];
        }
        this.tempMtx1.set(this.tempAxis);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
        this.tempVec.x = this.vfCenter[0];
        this.tempVec.y = this.vfCenter[1];
        this.tempVec.z = this.vfCenter[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tempMtx2.mul(this.tempMtx1, this.tmatrix);
        this.tempVec.x = this.vfTranslation[0];
        this.tempVec.y = this.vfTranslation[1];
        this.tempVec.z = this.vfTranslation[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tmatrix.mul(this.tempMtx1, this.tempMtx2);
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(12);
        BaseCADPart.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCADPart.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseCADPart.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseCADPart.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseCADPart.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCADPart.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCADPart.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseCADPart.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseCADPart.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseCADPart.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFRotation", "scaleOrientation");
        BaseCADPart.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseCADPart.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFString", "name");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(7);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        n = new Integer(8);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(9);
        fieldMap.put("scaleOrientation", n);
        fieldMap.put("set_scaleOrientation", n);
        fieldMap.put("scaleOrientation_changed", n);
        n = new Integer(10);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(11);
        fieldMap.put("name", n);
        fieldMap.put("set_name", n);
        fieldMap.put("name_changed", n);
    }
}

